/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.CellFormatter;
import mondrian.olap.DimensionType;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.HierarchyBase;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.Role;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

class RolapHierarchy
extends HierarchyBase {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapHierarchy == null ? (class$mondrian$rolap$RolapHierarchy = RolapHierarchy.class$("mondrian.rolap.RolapHierarchy")) : class$mondrian$rolap$RolapHierarchy));
    private MemberReader memberReader;
    MondrianDef.Hierarchy xmlHierarchy;
    private String memberReaderClass;
    private MondrianDef.Relation relation;
    private Member defaultMember;
    private String defaultMemberName;
    private RolapNullMember nullMember;
    private String sharedHierarchyName;
    private Exp aggregateChildrenExpression;
    private String primaryKey;
    final Type memberType = MemberType.forHierarchy(this);
    private final RolapLevel nullLevel;
    private RolapMember allMember;
    private static final String ALL_LEVEL_CARDINALITY = "1";
    private static final /* synthetic */ Class class$mondrian$rolap$RolapHierarchy;

    RolapHierarchy(RolapDimension dimension, String subName, boolean hasAll) {
        super(dimension, subName, hasAll);
        this.levels = new RolapLevel[0];
        this.setCaption(dimension.getCaption());
        this.allLevelName = "(All)";
        this.allMemberName = "All " + this.name + "s";
        if (hasAll) {
            Util.discard((Object)this.newLevel(this.allLevelName, 6));
        }
        this.nullLevel = new RolapLevel(this, 0, this.allLevelName, null, null, null, null, null, null, null, RolapProperty.emptyArray, 6, RolapLevel.HideMemberCondition.Never, LevelType.Null, "");
    }

    RolapHierarchy(RolapCube cube, RolapDimension dimension, MondrianDef.Hierarchy xmlHierarchy, MondrianDef.CubeDimension xmlCubeDimension) {
        this(dimension, xmlHierarchy.name, (boolean)xmlHierarchy.hasAll);
        int i;
        if (xmlHierarchy.relation == null && xmlHierarchy.memberReaderClass == null && cube != null) {
            xmlHierarchy.relation = cube.fact;
        }
        this.xmlHierarchy = xmlHierarchy;
        this.relation = xmlHierarchy.relation;
        if (xmlHierarchy.relation instanceof MondrianDef.InlineTable) {
            this.relation = this.convertInlineTableToRelation((MondrianDef.InlineTable)xmlHierarchy.relation);
        }
        this.memberReaderClass = xmlHierarchy.memberReaderClass;
        if (xmlHierarchy.allMemberName != null) {
            this.allMemberName = xmlHierarchy.allMemberName;
        }
        if (xmlHierarchy.allLevelName != null) {
            this.allLevelName = xmlHierarchy.allLevelName;
        }
        RolapLevel allLevel = new RolapLevel(this, 0, this.allLevelName, null, null, null, null, null, null, null, RolapProperty.emptyArray, 6, RolapLevel.HideMemberCondition.Never, LevelType.Regular, ALL_LEVEL_CARDINALITY);
        this.allMember = new RolapMember(null, allLevel, null, this.allMemberName, 2);
        if (xmlHierarchy.allMemberCaption != null && xmlHierarchy.allMemberCaption.length() > 0) {
            this.allMember.setCaption(xmlHierarchy.allMemberCaption);
        }
        this.allMember.setOrdinal(0);
        if (this.hasAll) {
            this.levels = new RolapLevel[xmlHierarchy.levels.length + 1];
            this.levels[0] = allLevel;
            for (i = 0; i < xmlHierarchy.levels.length; ++i) {
                MondrianDef.Level xmlLevel = xmlHierarchy.levels[i];
                if (xmlLevel.getKeyExp() == null && xmlHierarchy.memberReaderClass == null) {
                    throw MondrianResource.instance().LevelMustHaveNameExpression.ex(xmlLevel.name);
                }
                this.levels[i + 1] = new RolapLevel(this, i + 1, xmlLevel);
            }
        } else {
            this.levels = new RolapLevel[xmlHierarchy.levels.length];
            for (i = 0; i < xmlHierarchy.levels.length; ++i) {
                this.levels[i] = new RolapLevel(this, i, xmlHierarchy.levels[i]);
            }
        }
        if (xmlCubeDimension instanceof MondrianDef.DimensionUsage) {
            String sharedDimensionName;
            this.sharedHierarchyName = sharedDimensionName = ((MondrianDef.DimensionUsage)xmlCubeDimension).source;
            if (this.subName != null) {
                this.sharedHierarchyName = this.sharedHierarchyName + "." + this.subName;
            }
        } else {
            this.sharedHierarchyName = null;
        }
        if (xmlHierarchy.relation != null && xmlHierarchy.memberReaderClass != null) {
            throw MondrianResource.instance().HierarchyMustNotHaveMoreThanOneSource.ex(this.getUniqueName());
        }
        this.primaryKey = xmlHierarchy.primaryKey;
        if (!Util.isEmpty(xmlHierarchy.caption)) {
            this.setCaption(xmlHierarchy.caption);
        }
        this.defaultMemberName = xmlHierarchy.defaultMember;
    }

    private MondrianDef.Relation convertInlineTableToRelation(MondrianDef.InlineTable inlineTable) {
        MondrianDef.View view = new MondrianDef.View();
        view.alias = inlineTable.alias;
        view.selects = new MondrianDef.SQL[1];
        MondrianDef.SQL select = view.selects[0] = new MondrianDef.SQL();
        select.dialect = "generic";
        SqlQuery.Dialect dialect = this.getRolapSchema().getDialect();
        int columnCount = inlineTable.columnDefs.array.length;
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> columnTypes = new ArrayList<String>();
        for (int i = 0; i < columnCount; ++i) {
            columnNames.add(inlineTable.columnDefs.array[i].name);
            columnTypes.add(inlineTable.columnDefs.array[i].type);
        }
        ArrayList<String[]> valueList = new ArrayList<String[]>();
        for (int i = 0; i < inlineTable.rows.array.length; ++i) {
            MondrianDef.Row row = inlineTable.rows.array[i];
            String[] values = new String[columnCount];
            for (int j = 0; j < row.values.length; ++j) {
                MondrianDef.Value value = row.values[j];
                int columnOrdinal = columnNames.indexOf(value.column);
                if (columnOrdinal < 0) {
                    throw Util.newError("Unknown column '" + value.column + "'");
                }
                values[columnOrdinal] = value.cdata;
            }
            valueList.add(values);
        }
        select.cdata = dialect.generateInline(columnNames, columnTypes, valueList);
        return view;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RolapHierarchy)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        RolapHierarchy that = (RolapHierarchy)o;
        if (this.sharedHierarchyName == null || that.sharedHierarchyName == null) {
            return false;
        }
        return this.sharedHierarchyName.equals(that.sharedHierarchyName) && this.getUniqueName().equals(that.getUniqueName());
    }

    public int hashCode() {
        return super.hashCode() ^ (this.sharedHierarchyName == null ? 0 : this.sharedHierarchyName.hashCode());
    }

    void init(RolapCube cube, MondrianDef.CubeDimension xmlDimension) {
        if (this.memberReader == null) {
            this.memberReader = this.getRolapSchema().createMemberReader(this.sharedHierarchyName, this, this.memberReaderClass);
        }
        for (int i = 0; i < this.levels.length; ++i) {
            ((RolapLevel)this.levels[i]).init(cube, xmlDimension);
        }
        if (this.defaultMemberName != null) {
            String[] uniqueNameParts = Util.explode(this.defaultMemberName);
            if (this.name.equals(uniqueNameParts[0])) {
                String[] tmp = new String[uniqueNameParts.length - 1];
                System.arraycopy(uniqueNameParts, 1, tmp, 0, uniqueNameParts.length - 1);
                uniqueNameParts = tmp;
            }
            this.defaultMember = this.memberReader.lookupMember(uniqueNameParts, false);
            if (this.defaultMember == null) {
                throw Util.newInternal("Can not find Default Member with name \"" + this.defaultMemberName + "\" in Hierarchy \"" + this.getName() + "\"");
            }
        }
    }

    void setMemberReader(MemberReader memberReader) {
        this.memberReader = memberReader;
    }

    MemberReader getMemberReader() {
        return this.memberReader;
    }

    RolapLevel newLevel(String name, int flags) {
        RolapLevel level = new RolapLevel(this, this.levels.length, name, null, null, null, null, null, null, null, RolapProperty.emptyArray, flags, RolapLevel.HideMemberCondition.Never, LevelType.Regular, "");
        this.levels = (RolapLevel[])RolapUtil.addElement(this.levels, level);
        return level;
    }

    MondrianDef.Relation getUniqueTable() {
        if (this.relation instanceof MondrianDef.Table || this.relation instanceof MondrianDef.View) {
            return this.relation;
        }
        if (this.relation instanceof MondrianDef.Join) {
            return null;
        }
        throw Util.newInternal("hierarchy's relation is a " + ((Object)((Object)this.relation)).getClass());
    }

    boolean tableExists(String tableName) {
        return this.relation != null && RolapHierarchy.tableExists(tableName, this.relation);
    }

    private static boolean tableExists(String tableName, MondrianDef.Relation relation) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return table.name.equals(tableName) || table.alias != null && table.alias.equals(tableName);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            return RolapHierarchy.tableExists(tableName, join.left) || RolapHierarchy.tableExists(tableName, join.right);
        }
        return false;
    }

    RolapSchema getRolapSchema() {
        return (RolapSchema)this.dimension.getSchema();
    }

    MondrianDef.Relation getRelation() {
        return this.relation;
    }

    public Member getDefaultMember() {
        if (this.defaultMember == null) {
            List rootMembers = this.memberReader.getRootMembers();
            if (rootMembers.size() == 0) {
                throw MondrianResource.instance().InvalidHierarchyCondition.ex(this.getUniqueName());
            }
            this.defaultMember = (RolapMember)rootMembers.get(0);
        }
        return this.defaultMember;
    }

    public Member getNullMember() {
        if (this.nullMember == null) {
            this.nullMember = new RolapNullMember(this.nullLevel);
        }
        return this.nullMember;
    }

    public RolapMember getAllMember() {
        return this.allMember;
    }

    public Member createMember(Member parent, Level level, String name, Formula formula) {
        if (formula == null) {
            return new RolapMember((RolapMember)parent, (RolapLevel)level, name);
        }
        if (level.getDimension().isMeasures()) {
            return new RolapCalculatedMeasure((RolapMember)parent, (RolapLevel)level, name, formula);
        }
        return new RolapCalculatedMember((RolapMember)parent, (RolapLevel)level, name, formula);
    }

    String getAlias() {
        return this.getName();
    }

    void addToFrom(SqlQuery query, MondrianDef.Expression expression) {
        if (this.relation == null) {
            throw Util.newError("cannot add hierarchy " + this.getUniqueName() + " to query: it does not have a <Table>, <View> or <Join>");
        }
        boolean failIfExists = false;
        MondrianDef.Relation subRelation = this.relation;
        if (this.relation instanceof MondrianDef.Join && expression != null) {
            subRelation = RolapHierarchy.relationSubset(this.relation, expression.getTableAlias());
        }
        query.addFrom(subRelation, null, false);
    }

    private static MondrianDef.Relation relationSubset(MondrianDef.Relation relation, String alias) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return table.getAlias().equals(alias) ? relation : (table.name.equals(alias) ? relation : null);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.Relation rightRelation = RolapHierarchy.relationSubset(join.right, alias);
            return rightRelation == null ? RolapHierarchy.relationSubset(join.left, alias) : join;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    MemberReader getMemberReader(Role role) {
        int access = role.getAccess(this);
        switch (access) {
            case 1: {
                throw Util.newInternal("Illegal access to members of hierarchy " + this);
            }
            case 4: {
                return this.isRagged() ? new RestrictedMemberReader(this.memberReader, role) : this.memberReader;
            }
            case 2: {
                return new RestrictedMemberReader(this.memberReader, role);
            }
        }
        throw Access.instance().badValue(access);
    }

    public boolean isRagged() {
        for (int i = 0; i < this.levels.length; ++i) {
            RolapLevel level = (RolapLevel)this.levels[i];
            if (level.getHideMemberCondition() == RolapLevel.HideMemberCondition.Never) continue;
            return true;
        }
        return false;
    }

    synchronized Exp getAggregateChildrenExpression() {
        if (this.aggregateChildrenExpression == null) {
            UnresolvedFunCall fc = new UnresolvedFunCall("$AggregateChildren", Syntax.Internal, new Exp[]{new HierarchyExpr(this)});
            Validator validator = Util.createSimpleValidator(BuiltinFunTable.instance());
            this.aggregateChildrenExpression = fc.accept(validator);
        }
        return this.aggregateChildrenExpression;
    }

    RolapDimension createClosedPeerDimension(RolapLevel src, MondrianDef.Closure clos, RolapCube cube, MondrianDef.CubeDimension xmlDimension) {
        RolapDimension peerDimension = new RolapDimension(this.dimension.getSchema(), this.dimension.getName() + "$Closure", ((RolapDimension)this.dimension).getNextOrdinal(), DimensionType.StandardDimension);
        RolapHierarchy peerHier = peerDimension.newHierarchy(this.subName, true);
        peerHier.allMemberName = this.allMemberName;
        peerHier.allMember = this.allMember;
        peerHier.allLevelName = this.allLevelName;
        peerHier.sharedHierarchyName = this.sharedHierarchyName;
        peerHier.primaryKey = this.primaryKey;
        MondrianDef.Join join = new MondrianDef.Join();
        peerHier.relation = join;
        join.left = clos.table;
        join.leftKey = clos.parentColumn;
        join.right = this.relation;
        join.rightKey = clos.childColumn;
        int index = peerHier.levels.length;
        int flags = src.getFlags() & 0xFFFFFFFB;
        MondrianDef.Column keyExp = new MondrianDef.Column(clos.table.name, clos.parentColumn);
        RolapLevel level = new RolapLevel(peerHier, index++, "Closure", keyExp, null, null, null, null, null, null, RolapProperty.emptyArray, flags, src.getHideMemberCondition(), src.getLevelType(), "");
        peerHier.levels = (RolapLevel[])RolapUtil.addElement(peerHier.levels, level);
        flags = src.getFlags() | 4;
        keyExp = new MondrianDef.Column(clos.table.name, clos.childColumn);
        RolapLevel sublevel = new RolapLevel(peerHier, index++, "Item", keyExp, null, null, null, null, null, null, RolapProperty.emptyArray, flags, src.getHideMemberCondition(), src.getLevelType(), "");
        peerHier.levels = (RolapLevel[])RolapUtil.addElement(peerHier.levels, sublevel);
        cube.createUsage(peerHier, xmlDimension);
        return peerDimension;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class RolapCalculatedMeasure
    extends RolapCalculatedMember
    implements RolapMeasure {
        public RolapCalculatedMeasure(RolapMember parent, RolapLevel level, String name, Formula formula) {
            super(parent, level, name, formula);
        }

        public CellFormatter getFormatter() {
            return null;
        }
    }

    class RolapNullMember
    extends RolapMember {
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapHierarchy;

        RolapNullMember(RolapLevel level) {
            super(null, level, null, "#Null", 5);
            if (!$assertionsDisabled && level == null) {
                throw new AssertionError();
            }
        }

        public boolean isNull() {
            return true;
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$RolapHierarchy == null ? (class$mondrian$rolap$RolapHierarchy = RolapNullMember.class$("mondrian.rolap.RolapHierarchy")) : class$mondrian$rolap$RolapHierarchy).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

