/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.LevelBase;
import mondrian.olap.LevelType;
import mondrian.olap.Member;
import mondrian.olap.MemberFormatter;
import mondrian.olap.MondrianDef;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.MemberColumnConstraint;
import org.apache.log4j.Logger;

public class RolapLevel
extends LevelBase {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapEvaluator == null ? (class$mondrian$rolap$RolapEvaluator = RolapLevel.class$("mondrian.rolap.RolapEvaluator")) : class$mondrian$rolap$RolapEvaluator));
    static final int NUMERIC = 1;
    static final int ALL = 2;
    static final int UNIQUE = 4;
    private final MondrianDef.Expression keyExp;
    private final MondrianDef.Expression ordinalExp;
    private final MondrianDef.Expression captionExp;
    private final boolean unique;
    private final boolean numeric;
    private final int flags;
    private final RolapProperty[] properties;
    private final RolapProperty[] inheritedProperties;
    private final MondrianDef.Expression nameExp;
    private final MondrianDef.Expression parentExp;
    private final String nullParentValue;
    private final HideMemberCondition hideMemberCondition;
    private final MondrianDef.Closure xmlClosure;
    private LevelReader levelReader;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapEvaluator;

    public static RolapLevel lookupLevel(RolapLevel[] levels, String levelName) {
        for (int i = 0; i < levels.length; ++i) {
            RolapLevel level = levels[i];
            if (!level.getName().equals(levelName)) continue;
            return level;
        }
        return null;
    }

    RolapLevel(RolapHierarchy hierarchy, int depth, String name, MondrianDef.Expression keyExp, MondrianDef.Expression nameExp, MondrianDef.Expression captionExp, MondrianDef.Expression ordinalExp, MondrianDef.Expression parentExp, String nullParentValue, MondrianDef.Closure xmlClosure, RolapProperty[] properties, int flags, HideMemberCondition hideMemberCondition, LevelType levelType, String approxRowCount) {
        super(hierarchy, name, depth, levelType);
        Util.assertPrecondition(properties != null, "properties != null");
        Util.assertPrecondition(hideMemberCondition != null, "hideMemberCondition != null");
        Util.assertPrecondition(levelType != null, "levelType != null");
        if (keyExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)keyExp);
        }
        this.approxRowCount = this.loadApproxRowCount(approxRowCount);
        this.flags = flags;
        boolean isAll = (flags & 2) == 2;
        this.unique = (flags & 4) == 4;
        this.numeric = (flags & 1) == 1;
        this.keyExp = keyExp;
        if (nameExp != null && nameExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)nameExp);
        }
        this.nameExp = nameExp;
        if (captionExp != null && captionExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)captionExp);
        }
        this.captionExp = captionExp;
        if (ordinalExp != null) {
            if (ordinalExp instanceof MondrianDef.Column) {
                this.checkColumn((MondrianDef.Column)ordinalExp);
            }
            this.ordinalExp = ordinalExp;
        } else {
            this.ordinalExp = this.keyExp;
        }
        this.parentExp = parentExp;
        if (parentExp != null) {
            Util.assertTrue(!isAll, "'All' level '" + this + "' must not be parent-child");
            Util.assertTrue(this.unique, "Parent-child level '" + this + "' must have uniqueMembers=\"true\"");
        }
        this.nullParentValue = nullParentValue;
        Util.assertPrecondition(parentExp != null || nullParentValue == null, "parentExp != null || nullParentValue == null");
        this.xmlClosure = xmlClosure;
        for (int i = 0; i < properties.length; ++i) {
            RolapProperty property = properties[i];
            if (!(property.getExp() instanceof MondrianDef.Column)) continue;
            this.checkColumn((MondrianDef.Column)property.getExp());
        }
        this.properties = properties;
        ArrayList<Property> list = new ArrayList<Property>();
        for (Level level = this; level != null; level = level.getParentLevel()) {
            Property[] levelProperties = level.getProperties();
            for (int i = 0; i < levelProperties.length; ++i) {
                Property levelProperty = levelProperties[i];
                Property existingProperty = this.lookupProperty(list, levelProperty.getName());
                if (existingProperty == null) {
                    list.add(levelProperty);
                    continue;
                }
                if (existingProperty.getType() == levelProperty.getType()) continue;
                throw Util.newError("Property " + this.getName() + "." + levelProperty.getName() + " overrides a " + "property with the same name but different type");
            }
        }
        this.inheritedProperties = list.toArray(RolapProperty.emptyArray);
        Dimension dim = hierarchy.getDimension();
        if (dim.getDimensionType() == DimensionType.TimeDimension) {
            if (!levelType.isTime() && !isAll) {
                throw MondrianResource.instance().NonTimeLevelInTimeHierarchy.ex(this.getUniqueName());
            }
        } else if (dim.getDimensionType() != null && levelType.isTime()) {
            throw MondrianResource.instance().TimeLevelInNonTimeHierarchy.ex(this.getUniqueName());
        }
        this.hideMemberCondition = hideMemberCondition;
    }

    private int loadApproxRowCount(String approxRowCount) {
        boolean notNullAndNumeric;
        boolean bl = notNullAndNumeric = approxRowCount != null && approxRowCount.matches("^\\d+$");
        if (notNullAndNumeric) {
            return Integer.parseInt(approxRowCount);
        }
        return Integer.MIN_VALUE;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    String getTableName() {
        String tableName = null;
        MondrianDef.Expression expr = this.getKeyExp();
        if (expr instanceof MondrianDef.Column) {
            MondrianDef.Column mc = (MondrianDef.Column)expr;
            tableName = mc.getTableAlias();
        }
        return tableName;
    }

    LevelReader getLevelReader() {
        return this.levelReader;
    }

    public MondrianDef.Expression getKeyExp() {
        return this.keyExp;
    }

    MondrianDef.Expression getOrdinalExp() {
        return this.ordinalExp;
    }

    public MondrianDef.Expression getCaptionExp() {
        return this.captionExp;
    }

    public boolean hasCaptionColumn() {
        return this.captionExp != null;
    }

    int getFlags() {
        return this.flags;
    }

    HideMemberCondition getHideMemberCondition() {
        return this.hideMemberCondition;
    }

    public boolean isUnique() {
        return this.unique;
    }

    boolean isNumeric() {
        return this.numeric;
    }

    RolapProperty[] getRolapProperties() {
        return this.properties;
    }

    String getNullParentValue() {
        return this.nullParentValue;
    }

    public boolean isParentChild() {
        return this.parentExp != null;
    }

    MondrianDef.Expression getParentExp() {
        return this.parentExp;
    }

    MondrianDef.Expression getNameExp() {
        return this.nameExp;
    }

    private Property lookupProperty(List list, String propertyName) {
        Property existingProperty = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals(propertyName)) continue;
            existingProperty = property;
            break;
        }
        return existingProperty;
    }

    RolapLevel(RolapHierarchy hierarchy, int depth, MondrianDef.Level xmlLevel) {
        this(hierarchy, depth, xmlLevel.name, xmlLevel.getKeyExp(), xmlLevel.getNameExp(), xmlLevel.getCaptionExp(), xmlLevel.getOrdinalExp(), xmlLevel.getParentExp(), xmlLevel.nullParentValue, xmlLevel.closure, RolapLevel.createProperties(xmlLevel), (xmlLevel.type.equals("Numeric") ? 1 : 0) | (xmlLevel.uniqueMembers != false ? 4 : 0), HideMemberCondition.lookup(xmlLevel.hideMemberIf), LevelType.lookup(xmlLevel.levelType), xmlLevel.approxRowCount);
        if (!Util.isEmpty(xmlLevel.caption)) {
            this.setCaption(xmlLevel.caption);
        }
        if (!Util.isEmpty(xmlLevel.formatter)) {
            try {
                Class<?> clazz = Class.forName(xmlLevel.formatter);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                this.memberFormatter = (MemberFormatter)ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw MondrianResource.instance().MemberFormatterLoadFailed.ex(xmlLevel.formatter, this.getUniqueName(), e);
            }
        }
    }

    private static RolapProperty[] createProperties(MondrianDef.Level xmlLevel) {
        ArrayList<RolapProperty> list = new ArrayList<RolapProperty>();
        MondrianDef.Expression nameExp = xmlLevel.getNameExp();
        if (nameExp != null) {
            list.add(new RolapProperty(Property.NAME.name, 0, nameExp, null, null));
        }
        for (int i = 0; i < xmlLevel.properties.length; ++i) {
            MondrianDef.Property property = xmlLevel.properties[i];
            list.add(new RolapProperty(property.name, RolapLevel.convertPropertyTypeNameToCode(property.type), xmlLevel.getPropertyExp(i), property.formatter, property.caption));
        }
        return list.toArray(RolapProperty.emptyArray);
    }

    private static int convertPropertyTypeNameToCode(String type) {
        if (type.equals("String")) {
            return 0;
        }
        if (type.equals("Numeric")) {
            return 1;
        }
        if (type.equals("Boolean")) {
            return 2;
        }
        throw Util.newError("Unknown property type '" + type + "'");
    }

    private void checkColumn(MondrianDef.Column nameColumn) {
        RolapHierarchy rolapHierarchy = (RolapHierarchy)this.hierarchy;
        if (nameColumn.table == null) {
            MondrianDef.Relation table = rolapHierarchy.getUniqueTable();
            if (table == null) {
                throw Util.newError("must specify a table for level " + this.getUniqueName() + " because hierarchy has more than one table");
            }
            nameColumn.table = table.getAlias();
        } else {
            Util.assertTrue(rolapHierarchy.tableExists(nameColumn.table));
        }
    }

    void init(RolapCube cube, MondrianDef.CubeDimension xmlDimension) {
        if (this.isAll()) {
            this.levelReader = new AllLevelReaderImpl();
        } else if (this.levelType == LevelType.Null) {
            this.levelReader = new NullLevelReader();
        } else if (this.xmlClosure != null) {
            RolapDimension dimension = ((RolapHierarchy)this.hierarchy).createClosedPeerDimension(this, this.xmlClosure, cube, xmlDimension);
            dimension.init(cube, xmlDimension);
            cube.registerDimension(dimension);
            RolapLevel closedPeer = (RolapLevel)dimension.getHierarchies()[0].getLevels()[1];
            this.levelReader = new ParentChildLevelReaderImpl(closedPeer);
        } else {
            this.levelReader = new RegularLevelReader();
        }
    }

    public boolean isAll() {
        return this.hierarchy.hasAll() && this.depth == 0;
    }

    public boolean areMembersUnique() {
        return this.depth == 0 || this.depth == 1 && this.hierarchy.hasAll();
    }

    public String getTableAlias() {
        return this.keyExp.getTableAlias();
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public Property[] getInheritedProperties() {
        return this.inheritedProperties;
    }

    public int getApproxRowCount() {
        return this.approxRowCount;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String name) {
        return this.lookupChild(schemaReader, name, 1);
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String name, int matchType) {
        Member[] levelMembers = schemaReader.getLevelMembers((Level)this, true);
        if (levelMembers.length > 0) {
            Member parent = levelMembers[0].getParentMember();
            return RolapUtil.findBestMemberMatch(levelMembers, (RolapMember)parent, this, name, matchType, false);
        }
        return null;
    }

    boolean hasClosedPeer() {
        return this.levelReader instanceof ParentChildLevelReaderImpl;
    }

    static Hierarchy access$000(RolapLevel x0) {
        return x0.hierarchy;
    }

    static Hierarchy access$100(RolapLevel x0) {
        return x0.hierarchy;
    }

    static boolean access$200(RolapLevel x0) {
        return x0.unique;
    }

    static LevelReader access$300(RolapLevel x0) {
        return x0.levelReader;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    class NullLevelReader
    implements LevelReader {
        NullLevelReader() {
        }

        public boolean constrainRequest(RolapMember member, Map mapLevelToColumn, CellRequest request) {
            return true;
        }
    }

    class AllLevelReaderImpl
    implements LevelReader {
        AllLevelReaderImpl() {
        }

        public boolean constrainRequest(RolapMember member, Map mapLevelToColumn, CellRequest request) {
            return false;
        }
    }

    class ParentChildLevelReaderImpl
    extends RegularLevelReader {
        private final RolapLevel closedPeer;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapLevel;

        ParentChildLevelReaderImpl(RolapLevel closedPeer) {
            this.closedPeer = closedPeer;
        }

        public boolean constrainRequest(RolapMember member, Map mapLevelToColumn, CellRequest request) {
            if (member.getDataMember() == null) {
                return super.constrainRequest(member, mapLevelToColumn, request);
            }
            if (request.drillThrough) {
                member = (RolapMember)member.getDataMember();
                return super.constrainRequest(member, mapLevelToColumn, request);
            }
            RolapLevel level = this.closedPeer;
            RolapMember allMember = (RolapMember)level.getHierarchy().getDefaultMember();
            if (!$assertionsDisabled && !allMember.isAll()) {
                throw new AssertionError();
            }
            member = new RolapMember(allMember, level, member.getKey());
            return level.getLevelReader().constrainRequest(member, mapLevelToColumn, request);
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$RolapLevel == null ? (class$mondrian$rolap$RolapLevel = ParentChildLevelReaderImpl.class$("mondrian.rolap.RolapLevel")) : class$mondrian$rolap$RolapLevel).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    class RegularLevelReader
    implements LevelReader {
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapLevel;

        RegularLevelReader() {
        }

        public boolean constrainRequest(RolapMember member, Map mapLevelToColumn, CellRequest request) {
            LevelReader levelReader;
            if (!$assertionsDisabled && member.getLevel() != RolapLevel.this) {
                throw new AssertionError();
            }
            if (member.getKey() == null) {
                if (member == member.getHierarchy().getNullMember()) {
                    return true;
                }
                throw Util.newInternal("why is key null?");
            }
            RolapStar.Column column = (RolapStar.Column)mapLevelToColumn.get(RolapLevel.this);
            if (column == null) {
                return member != RolapLevel.access$000(RolapLevel.this).getDefaultMember() || RolapLevel.access$100(RolapLevel.this).hasAll();
            }
            MemberColumnConstraint constraint = member.isCalculated() ? null : new MemberColumnConstraint(member);
            request.addConstrainedColumn(column, constraint);
            if (request.extendedContext && RolapLevel.this.getNameExp() != null) {
                RolapStar.Column nameColumn = column.getNameColumn();
                Util.assertTrue(nameColumn != null);
                request.addConstrainedColumn(nameColumn, null);
            }
            if (member.isCalculated()) {
                return false;
            }
            if (RolapLevel.access$200(RolapLevel.this)) {
                return false;
            }
            RolapMember parent = (RolapMember)member.getParentMember();
            while (true) {
                if (parent == null) {
                    return false;
                }
                RolapLevel level = (RolapLevel)parent.getLevel();
                levelReader = RolapLevel.access$300(level);
                if (levelReader != this) break;
                parent = (RolapMember)parent.getParentMember();
            }
            return levelReader.constrainRequest(parent, mapLevelToColumn, request);
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$RolapLevel == null ? (class$mondrian$rolap$RolapLevel = RegularLevelReader.class$("mondrian.rolap.RolapLevel")) : class$mondrian$rolap$RolapLevel).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    static interface LevelReader {
        public boolean constrainRequest(RolapMember var1, Map var2, CellRequest var3);
    }

    public static class HideMemberCondition
    extends EnumeratedValues.BasicValue {
        public static final int NeverORDINAL = 0;
        public static final HideMemberCondition Never = new HideMemberCondition("Never", 0);
        public static final int IfBlankNameORDINAL = 1;
        public static final HideMemberCondition IfBlankName = new HideMemberCondition("IfBlankName", 1);
        public static final int IfParentsNameORDINAL = 2;
        public static final HideMemberCondition IfParentsName = new HideMemberCondition("IfParentsName", 2);
        public static final EnumeratedValues enumeration = new EnumeratedValues(new HideMemberCondition[]{Never, IfBlankName, IfParentsName});

        private HideMemberCondition(String name, int ordinal) {
            super(name, ordinal, null);
        }

        public static HideMemberCondition lookup(String s) {
            return (HideMemberCondition)enumeration.getValue(s, true);
        }
    }
}

