/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.cache.HardSmartCache;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;

public abstract class RolapNativeSet
extends RolapNative {
    protected static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapNativeSet == null ? (class$mondrian$rolap$RolapNativeSet = RolapNativeSet.class$("mondrian.rolap.RolapNativeSet")) : class$mondrian$rolap$RolapNativeSet));
    private SmartCache cache = new SoftSmartCache();
    private static final /* synthetic */ Class class$mondrian$rolap$RolapNativeSet;

    protected abstract boolean isStrict();

    protected CrossJoinArg checkDescendants(FunDef fun, Exp[] args) {
        if (!"Descendants".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        if (!(args[0] instanceof MemberExpr)) {
            return null;
        }
        RolapMember member = (RolapMember)((MemberExpr)args[0]).getMember();
        if (member.isCalculated()) {
            return null;
        }
        if (!(args[1] instanceof LevelExpr)) {
            return null;
        }
        RolapLevel level = (RolapLevel)((LevelExpr)args[1]).getLevel();
        if (!RolapNativeSet.isSimpleLevel(level)) {
            return null;
        }
        return new DescendantsCrossJoinArg(level, member);
    }

    protected CrossJoinArg checkLevelMembers(FunDef fun, Exp[] args) {
        if (!"Members".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 1) {
            return null;
        }
        if (!(args[0] instanceof LevelExpr)) {
            return null;
        }
        RolapLevel level = (RolapLevel)((LevelExpr)args[0]).getLevel();
        if (!RolapNativeSet.isSimpleLevel(level)) {
            return null;
        }
        return new DescendantsCrossJoinArg(level, null);
    }

    protected CrossJoinArg checkMemberChildren(FunDef fun, Exp[] args) {
        if (!"Children".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 1) {
            return null;
        }
        if (!(args[0] instanceof MemberExpr)) {
            return null;
        }
        RolapMember member = (RolapMember)((MemberExpr)args[0]).getMember();
        if (member.isCalculated()) {
            return null;
        }
        RolapLevel level = member.getRolapLevel();
        if ((level = (RolapLevel)level.getChildLevel()) == null || !RolapNativeSet.isSimpleLevel(level)) {
            return null;
        }
        return new DescendantsCrossJoinArg(level, member);
    }

    protected CrossJoinArg checkEnumeration(FunDef fun, Exp[] args) {
        if (!"{}".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        return MemberListCrossJoinArg.create(args, this.isStrict());
    }

    protected CrossJoinArg[] checkCrossJoin(FunDef fun, Exp[] args) {
        if (!"Crossjoin".equalsIgnoreCase(fun.getName()) && !"NonEmptyCrossJoin".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        CrossJoinArg[] arg0 = this.checkCrossJoinArg(args[0]);
        if (arg0 == null) {
            return null;
        }
        CrossJoinArg[] arg1 = this.checkCrossJoinArg(args[1]);
        if (arg1 == null) {
            return null;
        }
        CrossJoinArg[] ret = new CrossJoinArg[arg0.length + arg1.length];
        System.arraycopy(arg0, 0, ret, 0, arg0.length);
        System.arraycopy(arg1, 0, ret, arg0.length, arg1.length);
        return ret;
    }

    protected CrossJoinArg[] checkCrossJoinArg(Exp exp) {
        Exp[] args;
        if (!(exp instanceof ResolvedFunCall)) {
            return null;
        }
        ResolvedFunCall funCall = (ResolvedFunCall)exp;
        FunDef fun = funCall.getFunDef();
        CrossJoinArg arg = this.checkMemberChildren(fun, args = funCall.getArgs());
        if (arg != null) {
            return new CrossJoinArg[]{arg};
        }
        arg = this.checkLevelMembers(fun, args);
        if (arg != null) {
            return new CrossJoinArg[]{arg};
        }
        arg = this.checkDescendants(fun, args);
        if (arg != null) {
            return new CrossJoinArg[]{arg};
        }
        arg = this.checkEnumeration(fun, args);
        if (arg != null) {
            return new CrossJoinArg[]{arg};
        }
        return this.checkCrossJoin(fun, args);
    }

    protected static boolean isSimpleLevel(RolapLevel level) {
        RolapHierarchy hier = (RolapHierarchy)level.getHierarchy();
        if (hier.isRagged()) {
            return false;
        }
        if (level.isParentChild()) {
            return false;
        }
        return !level.isMeasure();
    }

    protected boolean isPreferInterpreter(CrossJoinArg[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isPreferInterpreter()) continue;
            return false;
        }
        return true;
    }

    void useHardCache(boolean hard) {
        this.cache = hard ? new HardSmartCache() : new SoftSmartCache();
    }

    protected RolapEvaluator overrideContext(RolapEvaluator evaluator, CrossJoinArg[] cargs, RolapStoredMeasure storedMeasure) {
        SchemaReader schemaReader = evaluator.getSchemaReader();
        RolapEvaluator newEvaluator = (RolapEvaluator)evaluator.push();
        for (int i = 0; i < cargs.length; ++i) {
            Hierarchy hierarchy = cargs[i].getLevel().getHierarchy();
            Member defaultMember = schemaReader.getHierarchyDefaultMember(hierarchy);
            newEvaluator.setContext(defaultMember);
        }
        if (storedMeasure != null) {
            newEvaluator.setContext(storedMeasure);
        }
        return newEvaluator;
    }

    static SmartCache access$000(RolapNativeSet x0) {
        return x0.cache;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    protected static class MemberListCrossJoinArg
    implements CrossJoinArg {
        private RolapMember[] members;
        private RolapLevel level = null;
        private boolean strict;
        private boolean hasCalcMembers;

        private MemberListCrossJoinArg(RolapLevel level, RolapMember[] members, boolean strict, boolean hasCalcMembers) {
            this.level = level;
            this.members = members;
            this.strict = strict;
            this.hasCalcMembers = hasCalcMembers;
        }

        static CrossJoinArg create(Exp[] args, boolean strict) {
            if (args.length == 0) {
                return null;
            }
            RolapLevel level = null;
            boolean hasCalcMembers = false;
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof MemberExpr)) {
                    return null;
                }
                RolapMember m = (RolapMember)((MemberExpr)args[i]).getMember();
                if (m.isCalculated()) {
                    if (strict) {
                        return null;
                    }
                    hasCalcMembers = true;
                }
                if (i == 0) {
                    level = m.getRolapLevel();
                    continue;
                }
                if (level.equals(m.getLevel())) continue;
                return null;
            }
            if (!RolapNativeSet.isSimpleLevel(level)) {
                return null;
            }
            RolapMember[] members = new RolapMember[args.length];
            for (int i = 0; i < members.length; ++i) {
                members[i] = (RolapMember)((MemberExpr)args[i]).getMember();
            }
            return new MemberListCrossJoinArg(level, members, strict, hasCalcMembers);
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public RolapMember[] getMembers() {
            return this.members;
        }

        public boolean isPreferInterpreter() {
            return true;
        }

        public boolean hasCalcMembers() {
            return this.hasCalcMembers;
        }

        public int hashCode() {
            int c = 12;
            for (int i = 0; i < this.members.length; ++i) {
                c = 31 * c + this.members[i].hashCode();
            }
            if (this.strict) {
                ++c;
            }
            return c;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MemberListCrossJoinArg)) {
                return false;
            }
            MemberListCrossJoinArg that = (MemberListCrossJoinArg)obj;
            if (this.strict != that.strict) {
                return false;
            }
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] == that.members[i]) continue;
                return false;
            }
            return true;
        }

        public void addConstraint(SqlQuery sqlQuery) {
            SqlConstraintUtils.addMemberConstraint(sqlQuery, null, Arrays.asList((Object[])this.members), this.strict);
        }
    }

    protected static class DescendantsCrossJoinArg
    implements CrossJoinArg {
        RolapMember member;
        RolapLevel level;

        public DescendantsCrossJoinArg(RolapLevel level, RolapMember member) {
            this.level = level;
            this.member = member;
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public RolapMember[] getMembers() {
            if (this.member == null) {
                return null;
            }
            RolapMember[] members = new RolapMember[]{this.member};
            return members;
        }

        public boolean isPreferInterpreter() {
            return false;
        }

        private boolean equals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescendantsCrossJoinArg)) {
                return false;
            }
            DescendantsCrossJoinArg that = (DescendantsCrossJoinArg)obj;
            if (!this.equals(this.level, that.level)) {
                return false;
            }
            return this.equals(this.member, that.member);
        }

        public int hashCode() {
            int c = 1;
            if (this.level != null) {
                c = this.level.hashCode();
            }
            if (this.member != null) {
                c = 31 * c + this.member.hashCode();
            }
            return c;
        }

        public void addConstraint(SqlQuery sqlQuery) {
            if (this.member != null) {
                SqlConstraintUtils.addMemberConstraint(sqlQuery, null, this.member, true);
            }
        }
    }

    protected static interface CrossJoinArg {
        public RolapLevel getLevel();

        public RolapMember[] getMembers();

        public void addConstraint(SqlQuery var1);

        public boolean isPreferInterpreter();
    }

    protected class SetEvaluator
    implements NativeEvaluator {
        private CrossJoinArg[] args;
        private SchemaReader schemaReader;
        private TupleConstraint constraint;
        private int maxRows = 0;

        public SetEvaluator(CrossJoinArg[] args, SchemaReader schemaReader, TupleConstraint constraint) {
            this.args = args;
            this.schemaReader = schemaReader;
            this.constraint = constraint;
        }

        public Object execute() {
            boolean hasEnumTargets;
            SqlTupleReader tr = new SqlTupleReader(this.constraint);
            tr.setMaxRows(this.maxRows);
            for (int i = 0; i < this.args.length; ++i) {
                this.addLevel(tr, this.args[i]);
            }
            Object key = tr.getCacheKey();
            List result = (List)RolapNativeSet.access$000(RolapNativeSet.this).get(key);
            boolean bl = hasEnumTargets = tr.getEnumTargetCount() > 0;
            if (result != null && !hasEnumTargets) {
                if (RolapNativeSet.this.listener != null) {
                    RolapNative.TupleEvent e = new RolapNative.TupleEvent(this, tr);
                    RolapNativeSet.this.listener.foundInCache(e);
                }
                return this.copy(result);
            }
            if (result == null && RolapNativeSet.this.listener != null) {
                RolapNative.TupleEvent e = new RolapNative.TupleEvent(this, tr);
                RolapNativeSet.this.listener.excutingSql(e);
            }
            List partialResult = result;
            result = null;
            ArrayList newPartialResult = null;
            if (hasEnumTargets && partialResult == null) {
                newPartialResult = new ArrayList();
            }
            result = tr.readTuples(this.schemaReader.getDataSource(), partialResult, newPartialResult);
            if (hasEnumTargets) {
                if (newPartialResult != null) {
                    RolapNativeSet.access$000(RolapNativeSet.this).put(key, newPartialResult);
                }
            } else {
                RolapNativeSet.access$000(RolapNativeSet.this).put(key, result);
            }
            return this.copy(result);
        }

        private List copy(List list) {
            ArrayList copy = new ArrayList();
            copy.addAll(list);
            return copy;
        }

        private void addLevel(TupleReader tr, CrossJoinArg arg) {
            RolapLevel level = arg.getLevel();
            RolapHierarchy hierarchy = (RolapHierarchy)level.getHierarchy();
            MemberReader mr = hierarchy.getMemberReader(this.schemaReader.getRole());
            TupleReader.MemberBuilder mb = mr.getMemberBuilder();
            Util.assertTrue(mb != null, "MemberBuilder not found");
            if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) {
                tr.addLevelMembers(level, mb, arg.getMembers());
            } else {
                tr.addLevelMembers(level, mb, null);
            }
        }

        int getMaxRows() {
            return this.maxRows;
        }

        void setMaxRows(int maxRows) {
            this.maxRows = maxRows;
        }
    }

    protected static abstract class SetConstraint
    extends SqlContextConstraint {
        CrossJoinArg[] args;

        SetConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, boolean strict) {
            super(evaluator, strict);
            this.args = args;
        }

        protected boolean isJoinRequired() {
            return this.args.length > 1 || super.isJoinRequired();
        }

        public void addConstraint(SqlQuery sqlQuery) {
            super.addConstraint(sqlQuery);
            for (int i = 0; i < this.args.length; ++i) {
                CrossJoinArg arg = this.args[i];
                if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) continue;
                arg.addConstraint(sqlQuery);
            }
        }

        public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
            return null;
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i] instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)this.args[i]).hasCalcMembers()) continue;
                key.add(this.args[i]);
            }
            return key;
        }
    }
}

