/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.ParameterSlot;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Parameter;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.ResultBase;
import mondrian.olap.Util;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CellKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.FastBatchingCellReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDependencyTestingEvaluator;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapPosition;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.util.Bug;
import org.apache.log4j.Logger;

class RolapResult
extends ResultBase {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$olap$ResultBase == null ? (class$mondrian$olap$ResultBase = RolapResult.class$("mondrian.olap.ResultBase")) : class$mondrian$olap$ResultBase));
    private final RolapEvaluator evaluator;
    private final CellKey point;
    private final Map cellValues;
    private final Map formatStrings;
    private final FastBatchingCellReader batchingReader;
    AggregatingCellReader aggregatingReader = new AggregatingCellReader(null);
    private final int[] modulos;
    private final int maxEvalDepth;
    private static final /* synthetic */ Class class$mondrian$olap$ResultBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RolapResult(Query query, boolean execute) {
        super(query, new RolapAxis[query.axes.length]);
        this.maxEvalDepth = MondrianProperties.instance().MaxEvalDepth.get();
        this.point = new CellKey(new int[query.axes.length]);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            this.evaluator = new RolapDependencyTestingEvaluator(this, expDeps);
        } else {
            RolapResultEvaluatorRoot root = new RolapResultEvaluatorRoot(this);
            this.evaluator = new RolapEvaluator(root);
        }
        RolapCube rcube = (RolapCube)query.getCube();
        this.batchingReader = new FastBatchingCellReader(rcube);
        this.cellValues = new HashMap();
        this.formatStrings = new HashMap();
        this.modulos = new int[this.axes.length + 1];
        if (!execute) {
            return;
        }
        Util.discard((boolean)Bug.Checkin7634DoOld);
        try {
            int limit;
            ArrayList axisMembers = new ArrayList();
            ArrayList<Member> slicerMembers = new ArrayList<Member>();
            for (int i = -1; i < this.axes.length; ++i) {
                RolapAxis axisResult;
                Calc calc;
                QueryAxis axis;
                block26: {
                    if (i == -1) {
                        axis = query.slicerAxis;
                        calc = query.slicerCalc;
                    } else {
                        axis = query.axes[i];
                        calc = query.axisCalcs[i];
                    }
                    int attempt = 0;
                    do {
                        this.evaluator.setCellReader(this.batchingReader);
                        axisResult = this.executeAxis(this.evaluator.push(), axis, calc, false, axisMembers);
                        Util.discard((Object)axisResult);
                        this.evaluator.clearExpResultCache();
                        if (!this.batchingReader.loadAggregations(query)) break block26;
                    } while (attempt++ <= this.maxEvalDepth);
                    throw Util.newInternal("Failed to load all aggregations after " + this.maxEvalDepth + "passes; there's probably a cycle");
                }
                this.evaluator.setCellReader(this.aggregatingReader);
                axisResult = this.executeAxis(this.evaluator.push(), axis, calc, true, null);
                this.evaluator.clearExpResultCache();
                if (i == -1) {
                    this.slicerAxis = axisResult;
                    switch (this.slicerAxis.positions.length) {
                        case 0: {
                            throw MondrianResource.instance().EmptySlicer.ex();
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            throw MondrianResource.instance().CompoundSlicer.ex();
                        }
                    }
                    Position position = this.slicerAxis.positions[0];
                    for (int j = 0; j < position.members.length; ++j) {
                        Member member = position.members[j];
                        if (member == null) {
                            throw MondrianResource.instance().EmptySlicer.ex();
                        }
                        this.evaluator.setContext(member);
                        slicerMembers.add(member);
                    }
                    continue;
                }
                this.axes[i] = axisResult;
            }
            if (Bug.Checkin7641UseOptimizer) {
                this.purge(axisMembers, slicerMembers);
                boolean didEvaluatorReplacementMember = false;
                RolapEvaluator rolapEval = this.evaluator;
                Iterator it = axisMembers.iterator();
                while (it.hasNext()) {
                    Member m = (Member)it.next();
                    if (rolapEval.setContextConditional(m) == null) continue;
                    didEvaluatorReplacementMember = true;
                }
                if (didEvaluatorReplacementMember) {
                    for (int i = 0; i < this.axes.length; ++i) {
                        QueryAxis axis = query.axes[i];
                        Calc calc = query.axisCalcs[i];
                        this.evaluator.setCellReader(this.aggregatingReader);
                        RolapAxis axisResult = this.executeAxis(this.evaluator.push(), axis, calc, true, null);
                        this.evaluator.clearExpResultCache();
                        this.axes[i] = axisResult;
                    }
                }
            }
            if ((limit = MondrianProperties.instance().ResultLimit.get()) > 0) {
                long n = 1L;
                for (int i = 0; i < this.axes.length; ++i) {
                    n *= (long)this.axes[i].positions.length;
                }
                if (n > (long)limit) {
                    throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(new Long(n), new Long(limit));
                }
            }
            this.modulos[0] = 1;
            int modulo = 1;
            for (int i = 0; i < this.axes.length; ++i) {
                this.modulos[i + 1] = modulo *= this.axes[i].positions.length;
            }
            this.executeBody(query);
        }
        finally {
            this.evaluator.clearExpResultCache();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("RolapResult<init>: " + Util.printMemory()));
            }
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public Axis[] getAxes() {
        return this.axes;
    }

    public Cell getCell(int[] pos) {
        String formatString;
        if (pos.length != this.point.ordinals.length) {
            throw Util.newError("coordinates should have dimension " + this.point.ordinals.length);
        }
        Object value = this.cellValues.get(new CellKey(pos));
        if (value == null) {
            value = Util.nullValue;
        }
        if ((formatString = (String)this.formatStrings.get(new CellKey(pos))) == null) {
            formatString = "Standard";
        }
        return new RolapCell(this, this.getCellOrdinal(pos), value, formatString);
    }

    private Cell getCellNoDefaultFormatString(int[] pos) {
        if (pos.length != this.point.ordinals.length) {
            throw Util.newError("coordinates should have dimension " + this.point.ordinals.length);
        }
        Object value = this.cellValues.get(new CellKey(pos));
        if (value == null) {
            value = Util.nullValue;
        }
        String formatString = (String)this.formatStrings.get(new CellKey(pos));
        return new RolapCell(this, this.getCellOrdinal(pos), value, formatString);
    }

    private RolapAxis executeAxis(Evaluator evaluator, QueryAxis axis, Calc axisCalc, boolean construct, List axisMembers) {
        Position[] positions;
        if (axis == null) {
            if (construct) {
                Member[] members = new Member[]{};
                RolapPosition position = new RolapPosition(members);
                positions = new Position[]{position};
            } else {
                positions = null;
            }
        } else {
            evaluator.setNonEmpty(axis.isNonEmpty());
            Object value = axisCalc.evaluate(evaluator);
            evaluator.setNonEmpty(false);
            if (value == null) {
                value = Collections.EMPTY_LIST;
            }
            Util.assertTrue(value instanceof List);
            List list = (List)value;
            if (construct) {
                positions = new Position[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    Member[] memberArray;
                    Object o = list.get(i);
                    if (o instanceof Member[]) {
                        memberArray = (Member[])o;
                    } else {
                        Member[] memberArray2 = new Member[1];
                        memberArray = memberArray2;
                        memberArray2[0] = (Member)o;
                    }
                    Member[] members = memberArray;
                    RolapPosition position = new RolapPosition(members);
                    positions[i] = position;
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    Object o = list.get(i);
                    if (o instanceof Member[]) {
                        this.merge(axisMembers, (Member[])o);
                        continue;
                    }
                    this.merge(axisMembers, (Member)o);
                }
                positions = null;
            }
        }
        return construct ? new RolapAxis(positions) : null;
    }

    private void executeBody(Query query) {
        try {
            int count;
            block6: {
                count = 0;
                while (true) {
                    this.cellValues.clear();
                    this.formatStrings.clear();
                    this.evaluator.setCellReader(this.batchingReader);
                    this.executeStripe(query.axes.length - 1, (RolapEvaluator)this.evaluator.push());
                    this.evaluator.clearExpResultCache();
                    if (!this.batchingReader.loadAggregations(query)) {
                        return;
                    }
                    if (count++ <= this.maxEvalDepth) continue;
                    if (!(this.evaluator instanceof RolapDependencyTestingEvaluator)) break block6;
                    ((RolapDependencyTestingEvaluator.DteRoot)this.evaluator.root).disabled = true;
                    if (count > this.maxEvalDepth * 2) break;
                }
                throw Util.newInternal("Query required more than " + count + " iterations");
            }
            throw Util.newInternal("Query required more than " + count + " iterations");
        }
        finally {
            RolapCube cube = (RolapCube)query.getCube();
            cube.clearCachedAggregations();
        }
    }

    boolean isDirty() {
        return this.batchingReader.isDirty();
    }

    private Object evaluateExp(Calc calc, Evaluator evaluator) {
        RolapEvaluator ev;
        boolean dirty;
        block2: {
            int attempt = 0;
            dirty = this.batchingReader.isDirty();
            do {
                ev = (RolapEvaluator)evaluator.push();
                ev.setCellReader(this.batchingReader);
                Object preliminaryValue = calc.evaluate(ev);
                Util.discard((Object)preliminaryValue);
                if (!this.batchingReader.loadAggregations(evaluator.getQuery())) break block2;
            } while (attempt++ <= this.maxEvalDepth);
            throw Util.newInternal("Failed to load all aggregations after " + this.maxEvalDepth + "passes; there's probably a cycle");
        }
        if (dirty) {
            this.batchingReader.setDirty(true);
        }
        ev = (RolapEvaluator)evaluator.push();
        ev.setCellReader(this.aggregatingReader);
        Object value = calc.evaluate(ev);
        return value;
    }

    private void executeStripe(int axisOrdinal, RolapEvaluator evaluator) {
        if (axisOrdinal < 0) {
            RolapAxis axis = (RolapAxis)this.slicerAxis;
            int count = axis.positions.length;
            for (int i = 0; i < count; ++i) {
                Object o;
                evaluator.getQuery().checkCancelOrTimeout();
                RolapPosition position = (RolapPosition)axis.positions[i];
                for (int j = 0; j < position.members.length; ++j) {
                    evaluator.setContext(position.members[j]);
                }
                try {
                    o = evaluator.evaluateCurrent();
                }
                catch (MondrianEvaluationException e) {
                    o = e;
                }
                CellKey key = this.point.copy();
                try {
                    Cell cell = this.getCellNoDefaultFormatString(this.point.ordinals);
                    Util.discard((Object)cell.getFormattedValue());
                    String cachedFormatString = cell.getCachedFormatString();
                    this.formatStrings.put(key, cachedFormatString);
                }
                catch (MondrianEvaluationException e) {
                }
                catch (Throwable e) {
                    Util.discard((Object)e);
                }
                if (o == null || o == Util.nullValue || o == RolapUtil.valueNotReadyException) continue;
                this.cellValues.put(key, o);
            }
        } else {
            RolapAxis axis = (RolapAxis)this.axes[axisOrdinal];
            int count = axis.positions.length;
            for (int i = 0; i < count; ++i) {
                this.point.ordinals[axisOrdinal] = i;
                RolapPosition position = (RolapPosition)axis.positions[i];
                for (int j = 0; j < position.members.length; ++j) {
                    evaluator.setContext(position.members[j]);
                }
                evaluator.getQuery().checkCancelOrTimeout();
                this.executeStripe(axisOrdinal - 1, evaluator);
            }
        }
    }

    public int[] getCellPos(int cellOrdinal) {
        int[] pos = new int[this.axes.length];
        for (int j = 0; j < this.axes.length; ++j) {
            pos[j] = cellOrdinal % this.modulos[j + 1] / this.modulos[j];
        }
        return pos;
    }

    int getCellOrdinal(int[] pos) {
        int ordinal = 0;
        for (int j = 0; j < this.axes.length; ++j) {
            ordinal += pos[j] * this.modulos[j];
        }
        return ordinal;
    }

    RolapEvaluator getCellEvaluator(int[] pos) {
        RolapEvaluator cellEvaluator = (RolapEvaluator)this.evaluator.push();
        for (int i = 0; i < pos.length; ++i) {
            Position position = this.axes[i].positions[pos[i]];
            for (int j = 0; j < position.members.length; ++j) {
                cellEvaluator.setContext(position.members[j]);
            }
        }
        return cellEvaluator;
    }

    Evaluator getRootEvaluator() {
        return this.evaluator;
    }

    Evaluator getEvaluator(int[] pos) {
        Evaluator cellEvaluator = this.evaluator.push();
        for (int i = -1; i < this.axes.length; ++i) {
            int index;
            Axis axis;
            if (i < 0) {
                axis = this.slicerAxis;
                index = 0;
            } else {
                axis = this.axes[i];
                index = pos[i];
            }
            Position position = axis.positions[index];
            for (int j = 0; j < position.members.length; ++j) {
                Member member = position.members[j];
                cellEvaluator.setContext(member);
            }
        }
        return cellEvaluator;
    }

    private Member getTopParent(Member m) {
        Member parent = m.getParentMember();
        return parent == null ? m : this.getTopParent(parent);
    }

    private void merge(List axisMembers, Axis axis) {
        for (int i = 0; i < axis.positions.length; ++i) {
            Position position = axis.positions[i];
            Member[] members = position.getMembers();
            this.merge(axisMembers, members);
        }
    }

    private void merge(List axisMembers, Member[] members) {
        for (int j = 0; j < members.length; ++j) {
            Member member = members[j];
            this.merge(axisMembers, member);
        }
    }

    private void merge(List axisMembers, Member member) {
        Member topParent = this.getTopParent(member);
        if (topParent.isNull()) {
            return;
        }
        if (topParent.isMeasure()) {
            return;
        }
        if (topParent.isCalculated()) {
            return;
        }
        if (topParent.isAll()) {
            return;
        }
        axisMembers.add(topParent);
    }

    private void purge(List axisMembers, List slicerMembers) {
        Iterator it = slicerMembers.iterator();
        while (it.hasNext()) {
            Member slicerMember = (Member)it.next();
            this.purge(axisMembers, slicerMember);
        }
    }

    private void purge(List axisMembers, Member slicerMember) {
        Hierarchy hier = slicerMember.getHierarchy();
        Iterator it = axisMembers.iterator();
        while (it.hasNext()) {
            Member member = (Member)it.next();
            if (!member.getHierarchy().equals(hier)) continue;
            it.remove();
            break;
        }
    }

    static Query access$100(RolapResult x0) {
        return x0.query;
    }

    static Object access$200(RolapResult x0, Calc x1, Evaluator x2) {
        return x0.evaluateExp(x1, x2);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class 1 {
    }

    protected static class RolapResultEvaluatorRoot
    extends RolapEvaluator.RolapEvaluatorRoot {
        private final Map namedSetValues = new HashMap();
        private RolapEvaluator slicerEvaluator;
        private final RolapResult result;
        private static final Object Sentinel = new Object();

        public RolapResultEvaluatorRoot(RolapResult result) {
            super(RolapResult.access$100(result));
            this.result = result;
        }

        protected void init(Evaluator evaluator) {
            this.slicerEvaluator = (RolapEvaluator)evaluator;
        }

        protected Object evaluateNamedSet(String name, Exp exp) {
            Object value = this.namedSetValues.get(name);
            if (value == null) {
                RolapEvaluator.RolapEvaluatorRoot root = this.slicerEvaluator.root;
                Calc calc = root.getCompiled(exp, false);
                List list = (List)RolapResult.access$200(this.result, calc, this.slicerEvaluator.push());
                value = com.rc.retroweaver.runtime.Collections.unmodifiableList((List)list);
                this.namedSetValues.put(name, value);
            }
            return value;
        }

        public Object getParameterValue(ParameterSlot slot) {
            Object value = slot.getParameterValue();
            if (value != null) {
                return value;
            }
            Parameter.Scope scope = slot.getParameter().getScope();
            switch (scope.getOrdinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw scope.unexpected();
                }
            }
            value = slot.getCachedDefaultValue();
            if (value != null) {
                if (value == Sentinel) {
                    throw MondrianResource.instance().CycleDuringParameterEvaluation.ex(slot.getParameter().getName());
                }
                return value;
            }
            slot.setCachedDefaultValue(Sentinel);
            value = RolapResult.access$200(this.result, slot.getDefaultValueCalc(), this.slicerEvaluator.push());
            slot.setCachedDefaultValue(value);
            return value;
        }
    }

    private static class AggregatingCellReader
    implements CellReader {
        private final RolapAggregationManager aggMan = AggregationManager.instance();

        private AggregatingCellReader() {
        }

        public Object get(Evaluator evaluator) {
            RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
            return this.aggMan.getCellFromCache(rolapEvaluator.getCurrentMembers());
        }

        public int getMissCount() {
            return this.aggMan.getMissCount();
        }

        AggregatingCellReader(1 x0) {
            this();
        }
    }
}

