/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Collections;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.Parameter;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.GlobalFunTable;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.UdfResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CacheMemberReader;
import mondrian.rolap.DynamicSchemaProcessor;
import mondrian.rolap.MemberReader;
import mondrian.rolap.MemberSource;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapNativeRegistry;
import mondrian.rolap.RolapSchemaParameter;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.aggmatcher.AggTableManager;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.UserDefinedFunction;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public class RolapSchema
implements Schema {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$RolapSchema == null ? (class$mondrian$rolap$RolapSchema = RolapSchema.class$("mondrian.rolap.RolapSchema")) : class$mondrian$rolap$RolapSchema));
    private static final int[] schemaAllowed = new int[]{1, 4, 3};
    private static final int[] cubeAllowed = new int[]{1, 4};
    private static final int[] dimensionAllowed = new int[]{1, 4};
    private static final int[] hierarchyAllowed = new int[]{1, 4, 2};
    private static final int[] memberAllowed = new int[]{1, 4};
    private String name;
    private final RolapConnection internalConnection;
    private final Map mapNameToCube;
    private final Map mapSharedHierarchyToReader;
    private final Map mapSharedHierarchyNameToHierarchy;
    private Role defaultRole;
    private final String md5Bytes;
    private AggTableManager aggTableManager;
    private String key;
    private final Map mapNameToRole;
    private final Map mapNameToSet = new HashMap();
    private FunTable funTable;
    private MondrianDef.Schema xmlSchema;
    final List parameterList = new ArrayList();
    private Date schemaLoadDate;
    private RolapStarRegistry rolapStarRegistry = new RolapStarRegistry();
    final RolapNativeRegistry nativeRegistry = new RolapNativeRegistry();
    private int nextDimensionOrdinal = 1;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapSchema;
    private static final /* synthetic */ Class class$java$lang$String;
    private static final /* synthetic */ Class class$mondrian$rolap$MemberSource;
    private static final /* synthetic */ Class class$mondrian$rolap$RolapHierarchy;
    private static final /* synthetic */ Class class$mondrian$spi$UserDefinedFunction;
    private static final /* synthetic */ Class class$java$util$Properties;

    private RolapSchema(String key, Util.PropertyList connectInfo, DataSource dataSource, String md5Bytes) {
        this.key = key;
        this.md5Bytes = md5Bytes;
        this.defaultRole = this.createDefaultRole();
        this.internalConnection = new RolapConnection(connectInfo, this, dataSource);
        this.mapSharedHierarchyNameToHierarchy = new HashMap();
        this.mapSharedHierarchyToReader = new HashMap();
        this.mapNameToCube = new HashMap();
        this.mapNameToRole = new HashMap();
        this.aggTableManager = new AggTableManager(this);
    }

    private RolapSchema(String key, String md5Bytes, String catalogName, String catalogStr, Util.PropertyList connectInfo, DataSource dataSource) {
        this(key, connectInfo, dataSource, md5Bytes);
        this.load(catalogName, catalogStr);
    }

    private RolapSchema(String key, String catalogName, Util.PropertyList connectInfo, DataSource dataSource) {
        this(key, connectInfo, dataSource, null);
        this.load(catalogName, null);
    }

    protected void finalCleanUp() {
        if (this.aggTableManager != null) {
            this.aggTableManager.finalCleanUp();
            this.aggTableManager = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finalCleanUp();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RolapSchema)) {
            return false;
        }
        RolapSchema other = (RolapSchema)o;
        return other.key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected void load(String catalogName, String catalogStr) {
        try {
            DOMWrapper def;
            Parser xmlParser = XOMUtil.createDefaultParser();
            if (catalogStr == null) {
                URL url = new URL(catalogName);
                def = xmlParser.parse(url);
            } else {
                def = xmlParser.parse(catalogStr);
            }
            this.xmlSchema = new MondrianDef.Schema(def);
            if (this.getLogger().isDebugEnabled()) {
                StringWriter sw = new StringWriter(4096);
                PrintWriter pw = new PrintWriter(sw);
                pw.println("RolapSchema.load: dump xmlschema");
                this.xmlSchema.display(pw, 2);
                pw.flush();
                this.getLogger().debug((Object)sw.toString());
            }
            this.load(this.xmlSchema);
        }
        catch (MalformedURLException e) {
            throw Util.newError(e, "while parsing catalog " + catalogName);
        }
        catch (XOMException e) {
            throw Util.newError(e, "while parsing catalog " + catalogName);
        }
        this.aggTableManager.initialize();
        this.setSchemaLoadDate();
    }

    private void setSchemaLoadDate() {
        this.schemaLoadDate = new Date();
    }

    public Date getSchemaLoadDate() {
        return this.schemaLoadDate;
    }

    Role getDefaultRole() {
        return this.defaultRole;
    }

    MondrianDef.Schema getXMLSchema() {
        return this.xmlSchema;
    }

    public String getName() {
        Util.assertPostcondition(this.name != null, "return != null");
        Util.assertPostcondition(this.name.length() > 0, "return.length() > 0");
        return this.name;
    }

    public SqlQuery.Dialect getDialect() {
        Connection conn = null;
        try {
            conn = this.getInternalConnection().getDataSource().getConnection();
            SqlQuery.Dialect dialect = SqlQuery.Dialect.create(conn.getMetaData());
            return dialect;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "Error while creating SQL dialect");
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    private void load(MondrianDef.Schema xmlSchema) {
        RolapCube cube;
        int i;
        this.name = xmlSchema.name;
        if (this.name == null || this.name.equals("")) {
            throw Util.newError("<Schema> name must be set");
        }
        HashMap mapNameToUdf = new HashMap();
        for (int i2 = 0; i2 < xmlSchema.userDefinedFunctions.length; ++i2) {
            MondrianDef.UserDefinedFunction udf = xmlSchema.userDefinedFunctions[i2];
            this.defineFunction(mapNameToUdf, udf.name, udf.className);
        }
        RolapSchemaFunctionTable funTable = new RolapSchemaFunctionTable(mapNameToUdf.values());
        funTable.init();
        this.funTable = funTable;
        for (int i3 = 0; i3 < xmlSchema.dimensions.length; ++i3) {
            MondrianDef.Dimension xmlDimension = xmlSchema.dimensions[i3];
            if (xmlDimension.foreignKey == null) continue;
            throw MondrianResource.instance().PublicDimensionMustNotHaveForeignKey.ex(xmlDimension.name);
        }
        HashSet<String> parameterNames = new HashSet<String>();
        for (i = 0; i < xmlSchema.parameters.length; ++i) {
            MondrianDef.Parameter xmlParameter = xmlSchema.parameters[i];
            String name = xmlParameter.name;
            if (!parameterNames.add(name)) {
                throw MondrianResource.instance().DuplicateSchemaParameter.ex(name);
            }
            Type type = xmlParameter.type.equals("String") ? new StringType() : (xmlParameter.type.equals("Numeric") ? new NumericType() : new MemberType(null, null, null, null));
            String description = xmlParameter.description;
            boolean modifiable = xmlParameter.modifiable;
            String defaultValue = xmlParameter.defaultValue;
            RolapSchemaParameter param = new RolapSchemaParameter(this, name, defaultValue, description, type, modifiable);
            Util.discard((Object)param);
        }
        for (i = 0; i < xmlSchema.cubes.length; ++i) {
            MondrianDef.Cube xmlCube = xmlSchema.cubes[i];
            if (!xmlCube.isEnabled()) continue;
            cube = new RolapCube(this, xmlSchema, xmlCube, true);
            cube.validate();
        }
        for (i = 0; i < xmlSchema.virtualCubes.length; ++i) {
            MondrianDef.VirtualCube xmlVirtualCube = xmlSchema.virtualCubes[i];
            if (!xmlVirtualCube.isEnabled()) continue;
            cube = new RolapCube(this, xmlSchema, xmlVirtualCube, true);
            Util.discard((Object)cube);
        }
        for (i = 0; i < xmlSchema.namedSets.length; ++i) {
            MondrianDef.NamedSet xmlNamedSet = xmlSchema.namedSets[i];
            this.mapNameToSet.put(xmlNamedSet.name, this.createNamedSet(xmlNamedSet));
        }
        for (i = 0; i < xmlSchema.roles.length; ++i) {
            MondrianDef.Role xmlRole = xmlSchema.roles[i];
            Role role = this.createRole(xmlRole);
            this.mapNameToRole.put(xmlRole.name, role);
        }
        if (xmlSchema.defaultRole != null) {
            Role role = this.lookupRole(xmlSchema.defaultRole);
            if (role == null) {
                throw Util.newError("Role '" + xmlSchema.defaultRole + "' not found");
            }
            this.defaultRole = role;
        }
    }

    private NamedSet createNamedSet(MondrianDef.NamedSet xmlNamedSet) {
        Exp exp;
        String formulaString = xmlNamedSet.getFormula();
        try {
            exp = this.getInternalConnection().parseExpression(formulaString);
        }
        catch (Exception e) {
            throw MondrianResource.instance().NamedSetHasBadFormula.ex(xmlNamedSet.name, e);
        }
        Formula formula = new Formula(new String[]{xmlNamedSet.name}, exp);
        return formula.getNamedSet();
    }

    private Role createRole(MondrianDef.Role xmlRole) {
        Role role = new Role();
        for (int i = 0; i < xmlRole.schemaGrants.length; ++i) {
            MondrianDef.SchemaGrant schemaGrant = xmlRole.schemaGrants[i];
            role.grant(this, this.getAccess(schemaGrant.access, schemaAllowed));
            for (int j = 0; j < schemaGrant.cubeGrants.length; ++j) {
                int k;
                MondrianDef.CubeGrant cubeGrant = schemaGrant.cubeGrants[j];
                Cube cube = this.lookupCube(cubeGrant.cube);
                if (cube == null) {
                    throw Util.newError("Unknown cube '" + cube + "'");
                }
                role.grant(cube, this.getAccess(cubeGrant.access, cubeAllowed));
                SchemaReader schemaReader = cube.getSchemaReader(null);
                for (k = 0; k < cubeGrant.dimensionGrants.length; ++k) {
                    MondrianDef.DimensionGrant dimensionGrant = cubeGrant.dimensionGrants[k];
                    Dimension dimension = (Dimension)schemaReader.lookupCompound(cube, Util.explode(dimensionGrant.dimension), true, 2);
                    role.grant(dimension, this.getAccess(dimensionGrant.access, dimensionAllowed));
                }
                for (k = 0; k < cubeGrant.hierarchyGrants.length; ++k) {
                    MondrianDef.HierarchyGrant hierarchyGrant = cubeGrant.hierarchyGrants[k];
                    Hierarchy hierarchy = (Hierarchy)schemaReader.lookupCompound(cube, Util.explode(hierarchyGrant.hierarchy), true, 3);
                    int hierarchyAccess = this.getAccess(hierarchyGrant.access, hierarchyAllowed);
                    Level topLevel = null;
                    if (hierarchyGrant.topLevel != null) {
                        if (hierarchyAccess != 2) {
                            throw Util.newError("You may only specify 'topLevel' if access='custom'");
                        }
                        topLevel = (Level)schemaReader.lookupCompound(cube, Util.explode(hierarchyGrant.topLevel), true, 4);
                    }
                    Level bottomLevel = null;
                    if (hierarchyGrant.bottomLevel != null) {
                        if (hierarchyAccess != 2) {
                            throw Util.newError("You may only specify 'bottomLevel' if access='custom'");
                        }
                        bottomLevel = (Level)schemaReader.lookupCompound(cube, Util.explode(hierarchyGrant.bottomLevel), true, 4);
                    }
                    role.grant(hierarchy, hierarchyAccess, topLevel, bottomLevel);
                    for (int m = 0; m < hierarchyGrant.memberGrants.length; ++m) {
                        if (hierarchyAccess != 2) {
                            throw Util.newError("You may only specify <MemberGrant> if <Hierarchy> has access='custom'");
                        }
                        MondrianDef.MemberGrant memberGrant = hierarchyGrant.memberGrants[m];
                        Member member = schemaReader.getMemberByUniqueName(Util.explode(memberGrant.member), true);
                        if (member.getHierarchy() != hierarchy) {
                            throw Util.newError("Member '" + member + "' is not in hierarchy '" + hierarchy + "'");
                        }
                        role.grant(member, this.getAccess(memberGrant.access, memberAllowed));
                    }
                }
            }
        }
        role.makeImmutable();
        return role;
    }

    private int getAccess(String accessString, int[] allowed) {
        int access = Access.instance().getOrdinal(accessString);
        for (int i = 0; i < allowed.length; ++i) {
            if (access != allowed[i]) continue;
            return access;
        }
        throw Util.newError("Bad value access='" + accessString + "'");
    }

    public Dimension createDimension(Cube cube, String xml) {
        MondrianDef.CubeDimension xmlDimension;
        block4: {
            xmlDimension = null;
            try {
                Parser xmlParser = XOMUtil.createDefaultParser();
                DOMWrapper def = xmlParser.parse(xml);
                String tagName = def.getTagName();
                if (tagName.equals("Dimension")) {
                    xmlDimension = new MondrianDef.Dimension(def);
                    break block4;
                }
                if (tagName.equals("DimensionUsage")) {
                    xmlDimension = new MondrianDef.DimensionUsage(def);
                    break block4;
                }
                throw new XOMException("Got <" + tagName + "> when expecting <Dimension> or <DimensionUsage>");
            }
            catch (XOMException e) {
                throw Util.newError(e, "Error while adding dimension to cube '" + cube + "' from XML [" + xml + "]");
            }
        }
        return ((RolapCube)cube).createDimension(xmlDimension);
    }

    public Cube createCube(String xml) {
        RolapCube cube;
        block4: {
            cube = null;
            try {
                Parser xmlParser = XOMUtil.createDefaultParser();
                DOMWrapper def = xmlParser.parse(xml);
                String tagName = def.getTagName();
                if (tagName.equals("Cube")) {
                    MondrianDef.Schema xmlSchema = new MondrianDef.Schema();
                    MondrianDef.Cube xmlDimension = new MondrianDef.Cube(def);
                    cube = new RolapCube(this, xmlSchema, xmlDimension, false);
                    break block4;
                }
                if (tagName.equals("VirtualCube")) {
                    MondrianDef.Schema xmlSchema = this.getXMLSchema();
                    MondrianDef.VirtualCube xmlDimension = new MondrianDef.VirtualCube(def);
                    cube = new RolapCube(this, xmlSchema, xmlDimension, false);
                    break block4;
                }
                throw new XOMException("Got <" + tagName + "> when expecting <Cube>");
            }
            catch (XOMException e) {
                throw Util.newError(e, "Error while creating cube from XML [" + xml + "]");
            }
        }
        return cube;
    }

    public static void flushSchema(String catalogName, String connectionKey, String jdbcUser, String dataSourceStr) {
        Pool.instance().remove(catalogName, connectionKey, jdbcUser, dataSourceStr);
    }

    public static void flushSchema(String catalogName, DataSource dataSource) {
        Pool.instance().remove(catalogName, dataSource);
    }

    public static void clearCache() {
        Pool.instance().clear();
    }

    public static Iterator getRolapSchemas() {
        return Pool.instance().getRolapSchemas();
    }

    public static boolean cacheContains(RolapSchema rolapSchema) {
        return Pool.instance().contains(rolapSchema);
    }

    public Cube lookupCube(String cube, boolean failIfNotFound) {
        Cube mdxCube = this.lookupCube(cube);
        if (mdxCube == null && failIfNotFound) {
            throw MondrianResource.instance().MdxCubeNotFound.ex(cube);
        }
        return mdxCube;
    }

    protected Cube lookupCube(String cubeName) {
        return (Cube)this.mapNameToCube.get(Util.normalizeName(cubeName));
    }

    protected MondrianDef.CalculatedMember lookupXmlCalculatedMember(String calcMemberName, String cubeName) {
        String[] nameParts = Util.explode(calcMemberName);
        for (int c = 0; c < this.xmlSchema.cubes.length; ++c) {
            MondrianDef.Cube cube = this.xmlSchema.cubes[c];
            if (!Util.equalName(cube.name, cubeName)) continue;
            for (int m = 0; m < cube.calculatedMembers.length; ++m) {
                MondrianDef.CalculatedMember calculatedMember = cube.calculatedMembers[m];
                if (!Util.equalName(calculatedMember.dimension, nameParts[0]) || !Util.equalName(calculatedMember.name, nameParts[nameParts.length - 1])) continue;
                return calculatedMember;
            }
        }
        return null;
    }

    public List getCubesWithStar(RolapStar star) {
        ArrayList<RolapCube> list = new ArrayList<RolapCube>();
        Iterator it = this.mapNameToCube.values().iterator();
        while (it.hasNext()) {
            RolapCube cube = (RolapCube)it.next();
            if (star != cube.getStar()) continue;
            list.add(cube);
        }
        return list;
    }

    protected void addCube(Cube cube) {
        this.mapNameToCube.put(Util.normalizeName(cube.getName()), cube);
    }

    public boolean removeCube(String cubeName) {
        Cube cube = (Cube)this.mapNameToCube.remove(Util.normalizeName(cubeName));
        return cube != null;
    }

    public Cube[] getCubes() {
        return this.mapNameToCube.values().toArray(new RolapCube[0]);
    }

    public Iterator getCubeIterator() {
        return this.mapNameToCube.values().iterator();
    }

    public Hierarchy[] getSharedHierarchies() {
        return this.mapSharedHierarchyNameToHierarchy.values().toArray(new RolapHierarchy[0]);
    }

    RolapHierarchy getSharedHierarchy(String name) {
        return (RolapHierarchy)this.mapSharedHierarchyNameToHierarchy.get(name);
    }

    public NamedSet getNamedSet(String name) {
        return (NamedSet)this.mapNameToSet.get(name);
    }

    public Role lookupRole(String role) {
        return (Role)this.mapNameToRole.get(role);
    }

    public Set roleNames() {
        return this.mapNameToRole.keySet();
    }

    public FunTable getFunTable() {
        return this.funTable;
    }

    public Parameter[] getParameters() {
        return this.parameterList.toArray(new Parameter[this.parameterList.size()]);
    }

    private void defineFunction(Map mapNameToUdf, String name, String className) {
        UserDefinedFunction udf;
        Constructor<?> constructor;
        Class<?> klass;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw MondrianResource.instance().UdfClassNotFound.ex(name, className);
        }
        Object[] args = new Object[]{};
        try {
            constructor = klass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = RolapSchema.class$("java.lang.String")) : class$java$lang$String);
            if (Modifier.isPublic(constructor.getModifiers())) {
                args = new Object[]{name};
            } else {
                constructor = null;
            }
        }
        catch (NoSuchMethodException e) {
            constructor = null;
        }
        if (constructor == null) {
            try {
                constructor = klass.getConstructor(new Class[0]);
                if (Modifier.isPublic(constructor.getModifiers())) {
                    args = new Object[]{};
                } else {
                    constructor = null;
                }
            }
            catch (NoSuchMethodException e) {
                constructor = null;
            }
        }
        if (constructor == null) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, (class$mondrian$spi$UserDefinedFunction == null ? (class$mondrian$spi$UserDefinedFunction = RolapSchema.class$("mondrian.spi.UserDefinedFunction")) : class$mondrian$spi$UserDefinedFunction).getName());
        }
        try {
            udf = (UserDefinedFunction)constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, (class$mondrian$spi$UserDefinedFunction == null ? (class$mondrian$spi$UserDefinedFunction = RolapSchema.class$("mondrian.spi.UserDefinedFunction")) : class$mondrian$spi$UserDefinedFunction).getName());
        }
        catch (IllegalAccessException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, (class$mondrian$spi$UserDefinedFunction == null ? (class$mondrian$spi$UserDefinedFunction = RolapSchema.class$("mondrian.spi.UserDefinedFunction")) : class$mondrian$spi$UserDefinedFunction).getName());
        }
        catch (ClassCastException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, (class$mondrian$spi$UserDefinedFunction == null ? (class$mondrian$spi$UserDefinedFunction = RolapSchema.class$("mondrian.spi.UserDefinedFunction")) : class$mondrian$spi$UserDefinedFunction).getName());
        }
        catch (InvocationTargetException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, (class$mondrian$spi$UserDefinedFunction == null ? (class$mondrian$spi$UserDefinedFunction = RolapSchema.class$("mondrian.spi.UserDefinedFunction")) : class$mondrian$spi$UserDefinedFunction).getName());
        }
        this.validateFunction(udf);
        UserDefinedFunction existingUdf = (UserDefinedFunction)mapNameToUdf.get(name);
        if (existingUdf != null) {
            throw MondrianResource.instance().UdfDuplicateName.ex(name);
        }
        mapNameToUdf.put(name, udf);
    }

    private void validateFunction(UserDefinedFunction udf) {
        String udfName = udf.getName();
        if (udfName == null || udfName.equals("")) {
            throw Util.newInternal("User-defined function defined by class '" + udf.getClass() + "' has empty name");
        }
        String description = udf.getDescription();
        Util.discard((Object)description);
        Type[] parameterTypes = udf.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            if (parameterType != null) continue;
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': parameter type #" + i + " is null");
        }
        String[] reservedWords = udf.getReservedWords();
        Util.discard((Object)reservedWords);
        Type returnType = udf.getReturnType(parameterTypes);
        if (returnType == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': return type is null");
        }
        Syntax syntax = udf.getSyntax();
        if (syntax == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': syntax is null");
        }
    }

    synchronized MemberReader createMemberReader(String sharedName, RolapHierarchy hierarchy, String memberReaderClass) {
        MemberReader reader;
        if (sharedName != null) {
            reader = (MemberReader)this.mapSharedHierarchyToReader.get(sharedName);
            if (reader == null) {
                reader = this.createMemberReader(hierarchy, memberReaderClass);
                if (!this.mapSharedHierarchyNameToHierarchy.containsKey(sharedName)) {
                    this.mapSharedHierarchyNameToHierarchy.put(sharedName, hierarchy);
                }
            }
        } else {
            reader = this.createMemberReader(hierarchy, memberReaderClass);
        }
        return reader;
    }

    private MemberReader createMemberReader(RolapHierarchy hierarchy, String memberReaderClass) {
        if (memberReaderClass != null) {
            ReflectiveOperationException e2 = null;
            try {
                Object properties = null;
                Class<?> clazz = Class.forName(memberReaderClass);
                Constructor<?> constructor = clazz.getConstructor(class$mondrian$rolap$RolapHierarchy == null ? (class$mondrian$rolap$RolapHierarchy = RolapSchema.class$("mondrian.rolap.RolapHierarchy")) : class$mondrian$rolap$RolapHierarchy, class$java$util$Properties == null ? (class$java$util$Properties = RolapSchema.class$("java.util.Properties")) : class$java$util$Properties);
                Object o = constructor.newInstance(hierarchy, properties);
                if (o instanceof MemberReader) {
                    return (MemberReader)o;
                }
                if (o instanceof MemberSource) {
                    return new CacheMemberReader((MemberSource)o);
                }
                throw Util.newInternal("member reader class " + clazz + " does not implement " + (class$mondrian$rolap$MemberSource == null ? (class$mondrian$rolap$MemberSource = RolapSchema.class$("mondrian.rolap.MemberSource")) : class$mondrian$rolap$MemberSource));
            }
            catch (ClassNotFoundException e) {
                e2 = e;
            }
            catch (NoSuchMethodException e) {
                e2 = e;
            }
            catch (InstantiationException e) {
                e2 = e;
            }
            catch (IllegalAccessException e) {
                e2 = e;
            }
            catch (InvocationTargetException e) {
                e2 = e;
            }
            throw Util.newInternal(e2, "while instantiating member reader '" + memberReaderClass);
        }
        SqlMemberSource source = new SqlMemberSource(hierarchy);
        int memberCount = Integer.MAX_VALUE;
        int largeDimensionThreshold = MondrianProperties.instance().LargeDimensionThreshold.get();
        return memberCount > largeDimensionThreshold ? new SmartMemberReader(source) : new CacheMemberReader(source);
    }

    public SchemaReader getSchemaReader() {
        return new RolapSchemaReader(this.defaultRole, this){

            public Cube getCube() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public RolapConnection getInternalConnection() {
        return this.internalConnection;
    }

    private Role createDefaultRole() {
        Role role = new Role();
        role.grant(this, 4);
        role.makeImmutable();
        return role;
    }

    private RolapStar makeRolapStar(MondrianDef.Relation fact) {
        DataSource dataSource = this.getInternalConnection().getDataSource();
        RolapStar star = new RolapStar(this, dataSource, fact);
        return star;
    }

    public RolapStarRegistry getRolapStarRegistry() {
        return this.rolapStarRegistry;
    }

    public RolapStar getStar(String factTableName) {
        return this.getRolapStarRegistry().getStar(factTableName);
    }

    public Iterator getStars() {
        return this.getRolapStarRegistry().getStars();
    }

    public void flushRolapStarCaches(boolean forced) {
        Iterator itStars = this.getStars();
        while (itStars.hasNext()) {
            RolapStar star = (RolapStar)itStars.next();
            star.clearCachedAggregations(forced);
        }
    }

    public static void flushAllRolapStarCachedAggregations() {
        Iterator itSchemas = RolapSchema.getRolapSchemas();
        while (itSchemas.hasNext()) {
            RolapSchema schema = (RolapSchema)itSchemas.next();
            schema.flushRolapStarCaches(true);
        }
    }

    RolapNativeRegistry getNativeRegistry() {
        return this.nativeRegistry;
    }

    public synchronized int getNextDimensionOrdinal() {
        return this.nextDimensionOrdinal++;
    }

    static Logger access$000() {
        return LOGGER;
    }

    static String access$100(RolapSchema x0) {
        return x0.md5Bytes;
    }

    RolapSchema(String x0, String x1, String x2, String x3, Util.PropertyList x4, DataSource x5, 1 x6) {
        this(x0, x1, x2, x3, x4, x5);
    }

    RolapSchema(String x0, String x1, Util.PropertyList x2, DataSource x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    static String access$400(RolapSchema x0) {
        return x0.key;
    }

    static RolapStar access$500(RolapSchema x0, MondrianDef.Relation x1) {
        return x0.makeRolapStar(x1);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    class RolapSchemaFunctionTable
    extends FunTableImpl {
        private final List udfList;

        RolapSchemaFunctionTable(Collection udfs) {
            this.udfList = new ArrayList(udfs);
        }

        protected void defineFunctions() {
            int i;
            GlobalFunTable globalFunTable = GlobalFunTable.instance();
            List reservedWords = globalFunTable.getReservedWords();
            for (int i2 = 0; i2 < reservedWords.size(); ++i2) {
                String reservedWord = (String)reservedWords.get(i2);
                this.defineReserved(reservedWord);
            }
            List resolvers = globalFunTable.getResolvers();
            for (i = 0; i < resolvers.size(); ++i) {
                Resolver resolver = (Resolver)resolvers.get(i);
                this.define(resolver);
            }
            for (i = 0; i < this.udfList.size(); ++i) {
                UserDefinedFunction udf = (UserDefinedFunction)this.udfList.get(i);
                this.define(new UdfResolver(udf));
            }
        }

        public List getFunInfoList() {
            return Collections.unmodifiableList((List)this.funInfoList);
        }
    }

    class RolapStarRegistry {
        private final Map stars = new HashMap();

        RolapStarRegistry() {
        }

        synchronized RolapStar getOrCreateStar(MondrianDef.Relation fact) {
            String factTableName = fact.toString();
            RolapStar star = (RolapStar)this.stars.get(factTableName);
            if (star == null) {
                star = RolapSchema.access$500(RolapSchema.this, fact);
                this.stars.put(factTableName, star);
            }
            return star;
        }

        synchronized RolapStar getStar(String factTableName) {
            return (RolapStar)this.stars.get(factTableName);
        }

        synchronized Iterator getStars() {
            return this.stars.values().iterator();
        }
    }

    static class Pool {
        private final MessageDigest md;
        private static Pool pool;
        private Map mapUrlToSchema = new HashMap();
        private static final String MD5_PROP = "mondrian.catalog.content.cache.enabled";
        private static final boolean USE_MD5;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$mondrian$rolap$RolapSchema;

        private Pool() {
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        static Pool instance() {
            return pool;
        }

        private synchronized String encodeMD5(String value) {
            this.md.reset();
            byte[] bytes = this.md.digest(value.getBytes());
            return bytes != null ? new String(bytes) : null;
        }

        synchronized RolapSchema get(String catalogName, String connectionKey, String jdbcUser, String dataSourceStr, Util.PropertyList connectInfo) {
            return this.get(catalogName, connectionKey, jdbcUser, dataSourceStr, null, connectInfo);
        }

        synchronized RolapSchema get(String catalogName, DataSource dataSource, Util.PropertyList connectInfo) {
            return this.get(catalogName, null, null, null, dataSource, connectInfo);
        }

        private RolapSchema get(String catalogName, String connectionKey, String jdbcUser, String dataSourceStr, DataSource dataSource, Util.PropertyList connectInfo) {
            String msg;
            String key = dataSource == null ? Pool.makeKey(catalogName, connectionKey, jdbcUser, dataSourceStr) : Pool.makeKey(catalogName, dataSource);
            RolapSchema schema = null;
            boolean hadDynProc = false;
            String dynProcName = connectInfo.get("DynamicSchemaProcessor");
            String catalogStr = connectInfo.get("CatalogContent");
            if (catalogStr != null) {
                dynProcName = null;
                key = catalogStr;
            }
            if (!Util.isEmpty(dynProcName)) {
                if (!$assertionsDisabled && catalogStr != null) {
                    throw new AssertionError();
                }
                try {
                    URL url = new URL(catalogName);
                    Class<?> clazz = Class.forName(dynProcName);
                    Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                    DynamicSchemaProcessor dynProc = (DynamicSchemaProcessor)ctor.newInstance(new Object[0]);
                    catalogStr = dynProc.processSchema(url, connectInfo);
                    hadDynProc = true;
                }
                catch (Exception e) {
                    throw Util.newError(e, "loading DynamicSchemaProcessor " + dynProcName);
                }
                if (RolapSchema.access$000().isDebugEnabled()) {
                    String msg2 = "Pool.get: create schema \"" + catalogName + "\" using dynamic processor";
                    RolapSchema.access$000().debug((Object)msg2);
                }
            }
            if (USE_MD5) {
                SoftReference<RolapSchema> ref;
                String md5Bytes = null;
                try {
                    if (catalogStr == null) {
                        catalogStr = Util.readURL(catalogName);
                    }
                    md5Bytes = this.encodeMD5(catalogStr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (md5Bytes != null && (ref = (SoftReference<RolapSchema>)this.mapUrlToSchema.get(md5Bytes)) != null && (schema = (RolapSchema)ref.get()) == null) {
                    this.mapUrlToSchema.remove(key);
                    this.mapUrlToSchema.remove(md5Bytes);
                }
                if (schema == null || md5Bytes == null || RolapSchema.access$100(schema) == null || !RolapSchema.access$100(schema).equals(md5Bytes)) {
                    schema = new RolapSchema(key, md5Bytes, catalogName, catalogStr, connectInfo, dataSource, null);
                    ref = new SoftReference<RolapSchema>(schema);
                    if (md5Bytes != null) {
                        this.mapUrlToSchema.put(md5Bytes, ref);
                    }
                    this.mapUrlToSchema.put(key, ref);
                    if (RolapSchema.access$000().isDebugEnabled()) {
                        String msg3 = "Pool.get: create schema \"" + catalogName + "\" with MD5";
                        RolapSchema.access$000().debug((Object)msg3);
                    }
                } else if (RolapSchema.access$000().isDebugEnabled()) {
                    msg = "Pool.get: schema \"" + catalogName + "\" exists already with MD5";
                    RolapSchema.access$000().debug((Object)msg);
                }
            } else if (hadDynProc) {
                schema = new RolapSchema(key, null, catalogName, catalogStr, connectInfo, dataSource, null);
            } else {
                SoftReference ref = (SoftReference)this.mapUrlToSchema.get(key);
                if (ref != null && (schema = (RolapSchema)ref.get()) == null) {
                    this.mapUrlToSchema.remove(key);
                }
                if (schema == null) {
                    schema = catalogStr == null ? new RolapSchema(key, catalogName, connectInfo, dataSource, null) : new RolapSchema(key, null, catalogName, catalogStr, connectInfo, dataSource, null);
                    this.mapUrlToSchema.put(key, new SoftReference<RolapSchema>(schema));
                    if (RolapSchema.access$000().isDebugEnabled()) {
                        msg = "Pool.get: create schema \"" + catalogName + "\"";
                        RolapSchema.access$000().debug((Object)msg);
                    }
                } else if (RolapSchema.access$000().isDebugEnabled()) {
                    msg = "Pool.get: schema \"" + catalogName + "\" exists already ";
                    RolapSchema.access$000().debug((Object)msg);
                }
            }
            return schema;
        }

        synchronized void remove(String catalogName, String connectionKey, String jdbcUser, String dataSourceStr) {
            String key = Pool.makeKey(catalogName, connectionKey, jdbcUser, dataSourceStr);
            if (RolapSchema.access$000().isDebugEnabled()) {
                String msg = "Pool.remove: schema \"" + catalogName + "\" and datasource string \"" + dataSourceStr + "\"";
                RolapSchema.access$000().debug((Object)msg);
            }
            this.remove(key);
        }

        synchronized void remove(String catalogName, DataSource dataSource) {
            String key = Pool.makeKey(catalogName, dataSource);
            if (RolapSchema.access$000().isDebugEnabled()) {
                String msg = "Pool.remove: schema \"" + catalogName + "\" and datasource object";
                RolapSchema.access$000().debug((Object)msg);
            }
            this.remove(key);
        }

        private void remove(String key) {
            RolapSchema schema;
            SoftReference ref = (SoftReference)this.mapUrlToSchema.get(key);
            if (ref != null && (schema = (RolapSchema)ref.get()) != null) {
                if (RolapSchema.access$100(schema) != null) {
                    this.mapUrlToSchema.remove(RolapSchema.access$100(schema));
                }
                schema.finalCleanUp();
            }
            this.mapUrlToSchema.remove(key);
        }

        synchronized void clear() {
            if (RolapSchema.access$000().isDebugEnabled()) {
                String msg = "Pool.clear: clearing all RolapSchemas";
                RolapSchema.access$000().debug((Object)msg);
            }
            Iterator it = this.mapUrlToSchema.values().iterator();
            while (it.hasNext()) {
                RolapSchema schema;
                SoftReference ref = (SoftReference)it.next();
                if (ref == null || (schema = (RolapSchema)ref.get()) == null) continue;
                schema.finalCleanUp();
            }
            this.mapUrlToSchema.clear();
            JdbcSchema.clearAllDBs();
        }

        synchronized Iterator getRolapSchemas() {
            ArrayList<RolapSchema> list = new ArrayList<RolapSchema>();
            Iterator it = this.mapUrlToSchema.values().iterator();
            while (it.hasNext()) {
                SoftReference ref = (SoftReference)it.next();
                RolapSchema schema = (RolapSchema)ref.get();
                if (schema != null) {
                    list.add(schema);
                    continue;
                }
                try {
                    it.remove();
                }
                catch (Exception ex) {
                    RolapSchema.access$000().warn((Object)ex);
                }
            }
            return list.iterator();
        }

        synchronized boolean contains(RolapSchema rolapSchema) {
            return this.mapUrlToSchema.containsKey(RolapSchema.access$400(rolapSchema));
        }

        private static String makeKey(String catalogName, String connectionKey, String jdbcUser, String dataSourceStr) {
            StringBuffer buf = new StringBuffer(100);
            Pool.appendIfNotNull(buf, catalogName);
            Pool.appendIfNotNull(buf, connectionKey);
            Pool.appendIfNotNull(buf, jdbcUser);
            Pool.appendIfNotNull(buf, dataSourceStr);
            String key = buf.toString();
            return key;
        }

        private static String makeKey(String catalogName, DataSource dataSource) {
            StringBuffer buf = new StringBuffer(100);
            Pool.appendIfNotNull(buf, catalogName);
            buf.append('.');
            buf.append("external#");
            buf.append(System.identityHashCode(dataSource));
            String key = buf.toString();
            return key;
        }

        private static void appendIfNotNull(StringBuffer buf, String s) {
            if (s != null) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(s);
            }
        }

        static {
            $assertionsDisabled = !(class$mondrian$rolap$RolapSchema == null ? (class$mondrian$rolap$RolapSchema = Pool.class$("mondrian.rolap.RolapSchema")) : class$mondrian$rolap$RolapSchema).desiredAssertionStatus();
            pool = new Pool();
            USE_MD5 = Boolean.getBoolean(MD5_PROP);
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

