/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.agg.MemberColumnConstraint;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;

public class SqlConstraintUtils {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$SqlConstraintUtils;

    private SqlConstraintUtils() {
    }

    public static void addContextConstraint(SqlQuery sqlQuery, AggStar aggStar, Evaluator e, boolean strict) {
        CellRequest request;
        Member[] members = e.getMembers();
        if (strict) {
            if (SqlConstraintUtils.containsCalculatedMember(members)) {
                throw Util.newInternal("can not restrict SQL to calculated Members");
            }
        } else {
            members = SqlConstraintUtils.removeCalculatedMembers(members);
            members = SqlConstraintUtils.removeDefaultMembers(members);
        }
        if ((request = RolapAggregationManager.makeRequest(members, false, false)) == null) {
            if (strict) {
                throw Util.newInternal("CellRequest is null - why?");
            }
            return;
        }
        RolapStar.Column[] columns = request.getConstrainedColumns();
        Object[] values = request.getSingleValues();
        int arity = columns.length;
        for (int i = 0; i < arity; ++i) {
            String expr;
            RolapStar.Column column = columns[i];
            if (aggStar != null) {
                int bitPos = column.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                AggStar.Table table = aggColumn.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = aggColumn.generateExprString(sqlQuery);
            } else {
                RolapStar.Table table = column.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = column.generateExprString(sqlQuery);
            }
            String value = sqlQuery.quote(column.isNumeric(), values[i]);
            sqlQuery.addWhere(expr, "null".equals(value) ? " is " : " = ", value);
        }
    }

    private static Member[] removeDefaultMembers(Member[] members) {
        ArrayList<Member> result = new ArrayList<Member>();
        result.add(members[0]);
        for (int i = 1; i < members.length; ++i) {
            Member m = members[i];
            if (m.getHierarchy().getDefaultMember().equals(m)) continue;
            result.add(m);
        }
        return result.toArray(new Member[result.size()]);
    }

    private static Member[] removeCalculatedMembers(Member[] members) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isCalculated()) continue;
            result.add(members[i]);
        }
        return result.toArray(new Member[result.size()]);
    }

    private static boolean containsCalculatedMember(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isCalculated()) continue;
            return true;
        }
        return false;
    }

    public static void joinLevelTableToFactTable(SqlQuery sqlQuery, AggStar aggStar, Evaluator e, RolapLevel level, Map levelToColumnMap) {
        Map mapLevelToColumnMap;
        RolapCube cube = (RolapCube)e.getCube();
        if (cube.isVirtual()) {
            mapLevelToColumnMap = levelToColumnMap;
        } else {
            RolapStar star = cube.getStar();
            mapLevelToColumnMap = star.getMapLevelToColumn(cube);
        }
        RolapStar.Column starColumn = (RolapStar.Column)mapLevelToColumnMap.get(level);
        if (!$assertionsDisabled && starColumn == null) {
            throw new AssertionError();
        }
        if (aggStar != null) {
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            AggStar.Table table = aggColumn.getTable();
            table.addToFrom(sqlQuery, false, true);
        } else {
            RolapStar.Table table = starColumn.getTable();
            if (!$assertionsDisabled && table == null) {
                throw new AssertionError();
            }
            table.addToFrom(sqlQuery, false, true);
        }
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, AggStar aggStar, RolapMember parent, boolean strict) {
        List list = Collections.singletonList((Object)parent);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, aggStar, list, strict);
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, AggStar aggStar, List parents, boolean strict) {
        if (parents.size() == 0) {
            return;
        }
        Collection c = parents;
        while (!c.isEmpty()) {
            RolapMember m = (RolapMember)c.iterator().next();
            if (!m.isAll()) {
                if (m.isCalculated()) {
                    if (strict) {
                        throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
                    }
                } else {
                    RolapLevel level = m.getRolapLevel();
                    RolapHierarchy hierarchy = (RolapHierarchy)level.getHierarchy();
                    hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                    String q = level.getKeyExp().getExpression(sqlQuery);
                    ColumnConstraint[] cc = SqlConstraintUtils.getColumnConstraints(c);
                    if (strict || cc.length < MondrianProperties.instance().MaxConstraints.get()) {
                        String cond = RolapStar.Column.createInExpr(q, cc, level.isNumeric());
                        sqlQuery.addWhere(cond);
                    }
                    if (level.isUnique()) break;
                }
            }
            c = SqlConstraintUtils.getUniqueParentMembers(c);
        }
    }

    private static ColumnConstraint[] getColumnConstraints(Collection members) {
        ColumnConstraint[] constraints = new ColumnConstraint[members.size()];
        Iterator it = members.iterator();
        for (int i = 0; i < constraints.length; ++i) {
            RolapMember m = (RolapMember)it.next();
            constraints[i] = new MemberColumnConstraint(m);
        }
        return constraints;
    }

    private static Collection getUniqueParentMembers(Collection members) {
        HashSet<RolapMember> set = new HashSet<RolapMember>();
        Iterator it = members.iterator();
        while (it.hasNext()) {
            RolapMember m = (RolapMember)it.next();
            if ((m = (RolapMember)m.getParentMember()) == null) continue;
            set.add(m);
        }
        return set;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$SqlConstraintUtils == null ? (class$mondrian$rolap$SqlConstraintUtils = SqlConstraintUtils.class$("mondrian.rolap.SqlConstraintUtils")) : class$mondrian$rolap$SqlConstraintUtils).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

