/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import com.rc.retroweaver.runtime.Arrays;
import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

public class SqlContextConstraint
implements MemberChildrenConstraint,
TupleConstraint {
    List cacheKey;
    private Evaluator evaluator;
    private boolean strict;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$SqlContextConstraint;

    public static boolean isValidContext(Evaluator context) {
        return SqlContextConstraint.isValidContext(context, true, null);
    }

    public static boolean isValidContext(Evaluator context, boolean disallowVirtualCube, Level[] levels) {
        if (context == null) {
            return false;
        }
        RolapCube cube = (RolapCube)context.getCube();
        if (disallowVirtualCube && cube.isVirtual()) {
            return false;
        }
        if (cube.isVirtual()) {
            HashMap measureMap;
            HashSet baseCubesLevelToColumnMaps;
            Query query = context.getQuery();
            if (!SqlContextConstraint.findVirtualCubeJoinLevels(query, baseCubesLevelToColumnMaps = new HashSet(), measureMap = new HashMap())) {
                return false;
            }
            if (!$assertionsDisabled && levels == null) {
                throw new AssertionError();
            }
            Iterator it = baseCubesLevelToColumnMaps.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                for (int i = 0; i < levels.length; ++i) {
                    if (map.get(levels[i]) != null) continue;
                    return false;
                }
            }
            query.setVirtualCubeBaseCubeMaps(baseCubesLevelToColumnMaps);
            query.setLevelMapToMeasureMap(measureMap);
        }
        return true;
    }

    private static boolean findVirtualCubeJoinLevels(Query query, Set baseCubesLevelToColumnMaps, Map measureMap) {
        Set measureMembers = query.getMeasuresMembers();
        if (measureMembers.isEmpty()) {
            Cube cube = query.getCube();
            Dimension dimension = cube.getDimensions()[0];
            query.addMeasuresMembers(dimension.getHierarchy().getDefaultMember());
        }
        Iterator it = query.getMeasuresMembers().iterator();
        while (it.hasNext()) {
            Member member = (Member)it.next();
            if (member instanceof RolapStoredMeasure) {
                SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubesLevelToColumnMaps, measureMap);
                continue;
            }
            if (!(member instanceof RolapCalculatedMember)) continue;
            SqlContextConstraint.findMeasures(((RolapCalculatedMember)member).getExpression(), baseCubesLevelToColumnMaps, measureMap);
        }
        return !measureMap.isEmpty();
    }

    private static void addMeasure(RolapStoredMeasure measure, Set baseCubesLevelToColumnMaps, Map measureMap) {
        RolapCube baseCube;
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        RolapStar star = starMeasure.getStar();
        Map levelToColumnMap = star.getMapLevelToColumn(baseCube = measure.getCube());
        if (baseCubesLevelToColumnMaps.add(levelToColumnMap)) {
            measureMap.put(levelToColumnMap, measure);
        }
    }

    private static void findMeasures(Exp exp, Set baseCubesLevelToColumnMaps, Map measureMap) {
        block4: {
            block2: {
                Member member;
                block3: {
                    if (!(exp instanceof MemberExpr)) break block2;
                    MemberExpr memberExpr = (MemberExpr)exp;
                    member = memberExpr.getMember();
                    if (!(member instanceof RolapStoredMeasure)) break block3;
                    SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubesLevelToColumnMaps, measureMap);
                    break block4;
                }
                if (!(member instanceof RolapCalculatedMember)) break block4;
                SqlContextConstraint.findMeasures(((RolapCalculatedMember)member).getExpression(), baseCubesLevelToColumnMaps, measureMap);
                break block4;
            }
            if (exp instanceof ResolvedFunCall) {
                ResolvedFunCall funCall = (ResolvedFunCall)exp;
                Exp[] args = funCall.getArgs();
                for (int i = 0; i < args.length; ++i) {
                    SqlContextConstraint.findMeasures(args[i], baseCubesLevelToColumnMaps, measureMap);
                }
            }
        }
    }

    SqlContextConstraint(RolapEvaluator evaluator, boolean strict) {
        this.evaluator = evaluator;
        this.strict = strict;
        this.cacheKey = new ArrayList();
        this.cacheKey.add(this.getClass());
        this.cacheKey.add(Autobox.valueOf((boolean)strict));
        this.cacheKey.addAll(Arrays.asList((Object[])evaluator.getMembers()));
    }

    public void addMemberConstraint(SqlQuery sqlQuery, AggStar aggStar, RolapMember parent) {
        if (parent.isCalculated()) {
            throw Util.newInternal("cannot restrict SQL to calculated member");
        }
        Evaluator e = this.evaluator.push(parent);
        SqlConstraintUtils.addContextConstraint(sqlQuery, aggStar, e, this.strict);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, aggStar, parent, true);
    }

    public void addMemberConstraint(SqlQuery sqlQuery, AggStar aggStar, List parents) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, aggStar, this.evaluator, this.strict);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, aggStar, parents, true);
    }

    public void addConstraint(SqlQuery sqlQuery) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, null, this.evaluator, this.strict);
    }

    protected boolean isJoinRequired() {
        Member[] members = this.evaluator.getMembers();
        for (int i = 1; i < members.length; ++i) {
            if (members[i].isAll()) continue;
            return true;
        }
        return false;
    }

    public void addLevelConstraint(SqlQuery sqlQuery, AggStar aggStar, RolapLevel level, Map levelToColumnMap) {
        if (!this.isJoinRequired()) {
            return;
        }
        SqlConstraintUtils.joinLevelTableToFactTable(sqlQuery, aggStar, this.evaluator, level, levelToColumnMap);
    }

    public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
        return this;
    }

    public Object getCacheKey() {
        return this.cacheKey;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$SqlContextConstraint == null ? (class$mondrian$rolap$SqlContextConstraint = SqlContextConstraint.class$("mondrian.rolap.SqlContextConstraint")) : class$mondrian$rolap$SqlContextConstraint).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

