/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.agg.DenseSegmentDataset;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SparseSegmentDataset;

class Segment {
    private static int nextId;
    private final int id = nextId++;
    private String desc;
    final Aggregation aggregation;
    final RolapStar.Measure measure;
    final Aggregation.Axis[] axes;
    private SegmentDataset data;
    private final CellKey cellKey;
    private int state;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$rolap$agg$Segment;

    Segment(Aggregation aggregation, RolapStar.Measure measure, ColumnConstraint[][] constraintses, Aggregation.Axis[] axes) {
        this.aggregation = aggregation;
        this.measure = measure;
        this.axes = axes;
        this.cellKey = new CellKey(new int[axes.length]);
        this.state = 1;
    }

    synchronized void setData(SegmentDataset data, Collection pinnedSegments) {
        Util.assertTrue(this.data == null);
        Util.assertTrue(this.state == 1);
        this.data = data;
        this.state = 2;
        this.notifyAll();
    }

    synchronized void setFailed() {
        switch (this.state) {
            case 1: {
                Util.assertTrue(this.data == null);
                this.state = 3;
                this.notifyAll();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw State.instance.badValue(this.state);
            }
        }
    }

    public boolean isReady() {
        return this.state == 2;
    }

    private String makeDescription() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("Segment #");
        buf.append(this.id);
        buf.append(" {measure=");
        buf.append(this.measure.getAggregator().getExpression(this.measure.getExpression().getGenericExpression()));
        RolapStar.Column[] columns = this.aggregation.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            buf.append(", ");
            buf.append(columns[i].getExpression().getGenericExpression());
            ColumnConstraint[] constraints = this.axes[i].getConstraints();
            if (constraints == null) {
                buf.append("=any");
                continue;
            }
            buf.append("={");
            for (int j = 0; j < constraints.length; ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(constraints[j].getValue().toString());
            }
            buf.append('}');
        }
        buf.append('}');
        return buf.toString();
    }

    public String toString() {
        if (this.desc == null) {
            this.desc = this.makeDescription();
        }
        return this.desc;
    }

    Object get(Object[] keys) {
        Util.assertTrue(keys.length == this.axes.length);
        int missed = 0;
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Integer integer = this.axes[i].getOffset(key);
            if (integer == null) {
                if (this.axes[i].contains(key)) {
                    ++missed;
                    continue;
                }
                return null;
            }
            this.cellKey.ordinals[i] = integer;
        }
        if (missed > 0) {
            return Util.nullValue;
        }
        Object o = this.data.get(this.cellKey);
        if (o == null) {
            o = Util.nullValue;
        }
        return o;
    }

    boolean wouldContain(Object[] keys) {
        Util.assertTrue(keys.length == this.axes.length);
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            if (this.axes[i].contains(key)) continue;
            return false;
        }
        return true;
    }

    static void load(Segment[] segments, BitKey levelBitKey, BitKey measureBitKey, Collection pinnedSegments, Aggregation.Axis[] axes) {
        String sql = AggregationManager.instance().generateSql(segments, levelBitKey, measureBitKey);
        Segment segment0 = segments[0];
        RolapStar star = segment0.aggregation.getStar();
        RolapStar.Column[] columns = segment0.aggregation.getColumns();
        int arity = columns.length;
        ResultSet resultSet = null;
        int measureCount = segments.length;
        Connection jdbcConnection = star.getJdbcConnection();
        try {
            int i;
            int i2;
            DenseSegmentDataset[] denseDatasets;
            SegmentDataset[] dataSets;
            SparseSegmentDataset[] sparseDatasets;
            int i3;
            resultSet = RolapUtil.executeQuery(jdbcConnection, sql, "Segment.load");
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (resultSet.next()) {
                Object o;
                Object[] row = new Object[arity + measureCount];
                int k = 1;
                for (i3 = 0; i3 < arity; ++i3) {
                    Integer offsetInteger;
                    if ((o = resultSet.getObject(k++)) == null) {
                        o = RolapUtil.sqlNullValue;
                    }
                    if ((offsetInteger = axes[i3].getOffset(o)) == null) {
                        axes[i3].addNextOffset(o);
                    }
                    row[i3] = o;
                }
                for (i3 = 0; i3 < measureCount; ++i3) {
                    if ((o = resultSet.getObject(k++)) == null) {
                        o = Util.nullValue;
                    } else if (segments[i3].measure.isNumeric() && !(o instanceof Double)) {
                        double d;
                        if (o instanceof Number) {
                            o = new Double(((Number)o).doubleValue());
                        } else if (o instanceof byte[]) {
                            d = Double.parseDouble(new String((byte[])o));
                            o = new Double(d);
                        } else {
                            d = Double.parseDouble(o.toString());
                            o = new Double(d);
                        }
                    }
                    row[arity + i3] = o;
                }
                rows.add(row);
            }
            boolean sparse = false;
            int n = 1;
            for (i3 = 0; i3 < arity; ++i3) {
                int previous;
                Aggregation.Axis axis = axes[i3];
                int size = axis.loadKeys();
                if ((n *= size) >= (previous = n) && n >= size) continue;
                n = Integer.MAX_VALUE;
                sparse = true;
            }
            boolean bl = sparse = sparse || Segment.useSparse(n, rows.size());
            if (sparse) {
                sparseDatasets = new SparseSegmentDataset[segments.length];
                dataSets = sparseDatasets;
                denseDatasets = null;
            } else {
                denseDatasets = new DenseSegmentDataset[segments.length];
                dataSets = denseDatasets;
                sparseDatasets = null;
            }
            if (sparse) {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    sparseDatasets[i2] = new SparseSegmentDataset(segments[i2]);
                }
            } else {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    denseDatasets[i2] = new DenseSegmentDataset(segments[i2], new Object[n]);
                }
            }
            int[] pos = new int[arity];
            int count = rows.size();
            for (i = 0; i < count; ++i) {
                Object o;
                int j;
                Object[] row = (Object[])rows.get(i);
                int k = 0;
                for (int j2 = 0; j2 < arity; ++j2) {
                    int offset;
                    k *= axes[j2].getKeys().length;
                    Object o2 = row[j2];
                    Aggregation.Axis axis = axes[j2];
                    Integer offsetInteger = axis.getOffset(o2);
                    pos[j2] = offset = offsetInteger.intValue();
                    k += offset;
                }
                CellKey key = null;
                if (sparse) {
                    key = new CellKey((int[])pos.clone());
                    for (j = 0; j < segments.length; ++j) {
                        o = row[arity + j];
                        sparseDatasets[j].put(key, o);
                    }
                    continue;
                }
                for (j = 0; j < segments.length; ++j) {
                    o = row[arity + j];
                    denseDatasets[j].set(k, o);
                }
            }
            for (i = 0; i < segments.length; ++i) {
                segments[i].setData(dataSets[i], pinnedSegments);
            }
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "Error while loading segment; sql=[" + sql + "]");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
            try {
                jdbcConnection.close();
            }
            catch (SQLException e) {}
            for (int i = 0; i < segments.length; ++i) {
                segments[i].setFailed();
            }
        }
    }

    private static boolean useSparse(double possibleCount, double actualCount) {
        boolean sparse;
        int countThreshold;
        MondrianProperties properties = MondrianProperties.instance();
        double densityThreshold = properties.SparseSegmentDensityThreshold.get();
        if (densityThreshold < 0.0) {
            densityThreshold = 0.0;
        }
        if (densityThreshold > 1.0) {
            densityThreshold = 1.0;
        }
        if ((countThreshold = properties.SparseSegmentCountThreshold.get()) < 0) {
            countThreshold = 0;
        }
        boolean bl = sparse = (possibleCount - (double)countThreshold) * densityThreshold > actualCount;
        if (possibleCount < (double)countThreshold && !$assertionsDisabled && sparse) {
            throw new AssertionError((Object)("Should never use sparse if count is less than threshold, possibleCount=" + possibleCount + ", actualCount=" + actualCount + ", countThreshold=" + countThreshold + ", densityThreshold=" + densityThreshold));
        }
        if (possibleCount == actualCount && !$assertionsDisabled && sparse) {
            throw new AssertionError((Object)("Should never use sparse if result is 100% dense: possibleCount=" + possibleCount + ", actualCount=" + actualCount + ", countThreshold=" + countThreshold + ", densityThreshold=" + densityThreshold));
        }
        return sparse;
    }

    public synchronized void waitUntilLoaded() {
        if (!this.isReady()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            switch (this.state) {
                case 2: {
                    return;
                }
                case 3: {
                    throw Util.newError("Pending segment failed to load: " + this.toString());
                }
            }
            throw State.instance.badValue(this.state);
        }
    }

    static {
        $assertionsDisabled = !(class$mondrian$rolap$agg$Segment == null ? (class$mondrian$rolap$agg$Segment = Segment.class$("mondrian.rolap.agg.Segment")) : class$mondrian$rolap$agg$Segment).desiredAssertionStatus();
        nextId = 0;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class State
    extends EnumeratedValues {
        public static final State instance = new State();
        public static final int Initial = 0;
        public static final int Loading = 1;
        public static final int Ready = 2;
        public static final int Failed = 3;

        private State() {
            super(new String[]{"init", "loading", "ready", "failed"});
        }
    }
}

