/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.recorder.ListRecorder;
import mondrian.recorder.MessageRecorder;
import mondrian.recorder.RecorderException;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.aggmatcher.DefaultRules;
import mondrian.rolap.aggmatcher.ExplicitRules;
import mondrian.rolap.aggmatcher.JdbcSchema;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;

public class AggTableManager {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$rolap$aggmatcher$AggTableManager == null ? (class$mondrian$rolap$aggmatcher$AggTableManager = AggTableManager.class$("mondrian.rolap.aggmatcher.AggTableManager")) : class$mondrian$rolap$aggmatcher$AggTableManager));
    private final RolapSchema schema;
    private static final MondrianResource mres = MondrianResource.instance();
    private Trigger[] triggers;
    private static final /* synthetic */ Class class$mondrian$rolap$aggmatcher$AggTableManager;

    public AggTableManager(RolapSchema schema) {
        this.schema = schema;
    }

    public void finalCleanUp() {
        this.removeJdbcSchema();
        this.deregisterTriggers(MondrianProperties.instance());
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("AggTableManager.finalCleanUp: schema=");
            buf.append(this.schema.getName());
            this.getLogger().debug((Object)buf.toString());
        }
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public void initialize() {
        if (MondrianProperties.instance().ReadAggregates.get()) {
            try {
                this.loadRolapStarAggregates();
            }
            catch (SQLException ex) {
                throw AggTableManager.mres.AggLoadingError.ex(ex);
            }
        }
        this.registerTriggers();
        this.printResults();
    }

    private void printResults() {
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(4096);
            buf.append(Util.nl);
            Iterator it = this.getStars();
            while (it.hasNext()) {
                RolapStar star = (RolapStar)it.next();
                buf.append(star.toString());
                buf.append(Util.nl);
            }
            this.getLogger().debug((Object)buf.toString());
        }
    }

    private void reLoadRolapStarAggregates() {
        if (MondrianProperties.instance().ReadAggregates.get()) {
            try {
                this.clearJdbcSchema();
                this.loadRolapStarAggregates();
                this.printResults();
            }
            catch (SQLException ex) {
                throw AggTableManager.mres.AggLoadingError.ex(ex);
            }
        }
    }

    private JdbcSchema getJdbcSchema() {
        DataSource dataSource = this.schema.getInternalConnection().getDataSource();
        JdbcSchema db = JdbcSchema.makeDB(dataSource);
        return db;
    }

    private void clearJdbcSchema() {
        DataSource dataSource = this.schema.getInternalConnection().getDataSource();
        JdbcSchema.clearDB(dataSource);
    }

    private void removeJdbcSchema() {
        DataSource dataSource = this.schema.getInternalConnection().getDataSource();
        JdbcSchema.removeDB(dataSource);
    }

    private void loadRolapStarAggregates() throws SQLException {
        ListRecorder msgRecorder = new ListRecorder();
        try {
            DefaultRules rules = DefaultRules.getInstance();
            JdbcSchema db = this.getJdbcSchema();
            db.load();
            Iterator it = this.getStars();
            while (it.hasNext()) {
                RolapStar star = (RolapStar)it.next();
                star.prepareToLoadAggregates();
                List aggGroups = this.getAggGroups(star);
                Iterator git = aggGroups.iterator();
                while (git.hasNext()) {
                    ExplicitRules.Group group = (ExplicitRules.Group)git.next();
                    group.validate(msgRecorder);
                }
                String factTableName = star.getFactTable().getAlias();
                JdbcSchema.Table dbFactTable = db.getTable(factTableName);
                if (dbFactTable == null) {
                    msgRecorder.reportWarning("No Table found for fact name=" + factTableName);
                    continue;
                }
                this.bindToStar(dbFactTable, star, msgRecorder);
                String schema = dbFactTable.table.schema;
                Iterator tit = db.getTables();
                while (tit.hasNext()) {
                    JdbcSchema.Table dbTable = (JdbcSchema.Table)tit.next();
                    String name = dbTable.getName();
                    if (ExplicitRules.excludeTable(name, aggGroups)) continue;
                    ExplicitRules.TableDef tableDef = ExplicitRules.getIncludeByTableDef(name, aggGroups);
                    boolean makeAggStar = false;
                    if (tableDef != null) {
                        dbTable.load();
                        makeAggStar = tableDef.columnsOK(star, dbFactTable, dbTable, msgRecorder);
                    }
                    if (!makeAggStar && rules.matchesTableName(factTableName, name)) {
                        dbTable.load();
                        makeAggStar = rules.columnsOK(star, dbFactTable, dbTable, msgRecorder);
                    }
                    if (!makeAggStar) continue;
                    dbTable.setTableUsage(12);
                    String alias = null;
                    dbTable.table = new MondrianDef.Table(schema, name, alias);
                    AggStar aggStar = AggStar.makeAggStar(star, dbTable, msgRecorder);
                    if (aggStar.getSize() > 0) {
                        star.addAggStar(aggStar);
                        continue;
                    }
                    String msg = AggTableManager.mres.AggTableZeroSize.str(aggStar.getFactTable().getName(), factTableName);
                    this.getLogger().warn((Object)msg);
                }
            }
        }
        catch (RecorderException ex) {
            throw new MondrianException(ex);
        }
        finally {
            msgRecorder.logInfoMessage(this.getLogger());
            msgRecorder.logWarningMessage(this.getLogger());
            msgRecorder.logErrorMessage(this.getLogger());
            if (msgRecorder.hasErrors()) {
                throw AggTableManager.mres.AggLoadingExceededErrorCount.ex(new Integer(msgRecorder.getErrorCount()));
            }
        }
    }

    private boolean runTrigger() {
        if (RolapSchema.cacheContains(this.schema)) {
            return true;
        }
        this.deregisterTriggers(MondrianProperties.instance());
        return false;
    }

    private void registerTriggers() {
        MondrianProperties properties = MondrianProperties.instance();
        this.triggers = new Trigger[]{new Trigger(){

            public boolean isPersistent() {
                return false;
            }

            public int phase() {
                return 2;
            }

            public void execute(Property property, String value) {
                if (AggTableManager.access$000(AggTableManager.this)) {
                    AggTableManager.access$100(AggTableManager.this);
                }
            }
        }, new Trigger(){

            public boolean isPersistent() {
                return false;
            }

            public int phase() {
                return 2;
            }

            public void execute(Property property, String value) {
                if (AggTableManager.access$000(AggTableManager.this)) {
                    AggTableManager.access$200(AggTableManager.this);
                }
            }
        }, new Trigger(){

            public boolean isPersistent() {
                return false;
            }

            public int phase() {
                return 2;
            }

            public void execute(Property property, String value) {
                if (AggTableManager.access$000(AggTableManager.this)) {
                    AggTableManager.access$200(AggTableManager.this);
                }
            }
        }};
        properties.ChooseAggregateByVolume.addTrigger(this.triggers[0]);
        properties.AggregateRules.addTrigger(this.triggers[1]);
        properties.AggregateRuleTag.addTrigger(this.triggers[1]);
        properties.ReadAggregates.addTrigger(this.triggers[2]);
    }

    private void deregisterTriggers(MondrianProperties properties) {
        properties.ChooseAggregateByVolume.removeTrigger(this.triggers[0]);
        properties.AggregateRules.removeTrigger(this.triggers[1]);
        properties.AggregateRuleTag.removeTrigger(this.triggers[1]);
        properties.ReadAggregates.removeTrigger(this.triggers[2]);
    }

    private Iterator getStars() {
        return this.schema.getStars();
    }

    private void reOrderAggStarList() {
        Iterator it = this.getStars();
        while (it.hasNext()) {
            RolapStar star = (RolapStar)it.next();
            star.reOrderAggStarList();
        }
    }

    protected List getAggGroups(RolapStar star) {
        List list = this.schema.getCubesWithStar(star);
        ArrayList<ExplicitRules.Group> aggGroups = Collections.EMPTY_LIST;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            RolapCube cube = (RolapCube)it.next();
            if (!cube.hasAggGroup() || !cube.getAggGroup().hasRules()) continue;
            if (aggGroups == Collections.EMPTY_LIST) {
                aggGroups = new ArrayList<ExplicitRules.Group>();
            }
            aggGroups.add(cube.getAggGroup());
        }
        return aggGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindToStar(JdbcSchema.Table dbFactTable, RolapStar star, MessageRecorder msgRecorder) throws SQLException {
        msgRecorder.pushContextName("AggTableManager.bindToStar");
        try {
            dbFactTable.load();
            dbFactTable.setTableUsage(11);
            MondrianDef.Relation relation = star.getFactTable().getRelation();
            String schema = null;
            if (relation instanceof MondrianDef.Table) {
                schema = ((MondrianDef.Table)relation).schema;
            }
            String tableName = dbFactTable.getName();
            String alias = null;
            dbFactTable.table = new MondrianDef.Table(schema, tableName, alias);
            Iterator it = dbFactTable.getColumns();
            while (it.hasNext()) {
                JdbcSchema.Table.Column factColumn = (JdbcSchema.Table.Column)it.next();
                String cname = factColumn.getName();
                RolapStar.Column[] rcs = star.getFactTable().lookupColumns(cname);
                for (int i = 0; i < rcs.length; ++i) {
                    RolapStar.Column rc = rcs[i];
                    if (!(rc instanceof RolapStar.Measure)) continue;
                    RolapStar.Measure rm = (RolapStar.Measure)rc;
                    JdbcSchema.Table.Column.Usage usage = factColumn.newUsage(4);
                    usage.setSymbolicName(rm.getName());
                    usage.setAggregator(rm.getAggregator());
                    usage.rMeasure = rm;
                }
                RolapStar.Table rTable = star.getFactTable().findTableWithLeftJoinCondition(cname);
                if (rTable != null) {
                    JdbcSchema.Table.Column.Usage usage = factColumn.newUsage(2);
                    usage.setSymbolicName("FOREIGN_KEY");
                    usage.rTable = rTable;
                } else {
                    RolapStar.Column rColumn = star.getFactTable().lookupColumn(cname);
                    if (rColumn != null && !(rColumn instanceof RolapStar.Measure)) {
                        JdbcSchema.Table.Column.Usage usage = factColumn.newUsage(2);
                        usage.setSymbolicName("FOREIGN_KEY");
                        usage.rColumn = rColumn;
                    }
                }
                if (factColumn.hasUsage() || !this.getLogger().isDebugEnabled()) continue;
                String msg = AggTableManager.mres.UnknownFactTableColumn.str(msgRecorder.getContext(), dbFactTable.getName(), factColumn.getName());
                this.getLogger().debug((Object)msg);
            }
        }
        finally {
            msgRecorder.popContextName();
        }
    }

    static boolean access$000(AggTableManager x0) {
        return x0.runTrigger();
    }

    static void access$100(AggTableManager x0) {
        x0.reOrderAggStarList();
    }

    static void access$200(AggTableManager x0) {
        x0.reLoadRolapStarAggregates();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

