/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.loader;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import mondrian.olap.Schema;
import mondrian.rolap.RolapConnection;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;
import mondrian.test.loader.CsvDBLoader;
import mondrian.test.loader.DBLoader;

public abstract class CsvDBTestCase
extends FoodMartTestCase {
    private CsvDBLoader loader;
    private DBLoader.Table[] tables;
    private TestContext testContext;

    public CsvDBTestCase() {
    }

    public CsvDBTestCase(String name) {
        super(name);
    }

    protected final boolean isApplicable() {
        return this.getTestContext().getDialect().allowsDdl();
    }

    protected void setUp() throws Exception {
        if (!this.isApplicable()) {
            return;
        }
        super.setUp();
        Connection connection = this.getSqlConnection();
        String dirName = this.getDirectoryName();
        String fileName = this.getFileName();
        File inputFile = new File(dirName, fileName);
        this.loader = new CsvDBLoader();
        this.loader.setConnection(connection);
        this.loader.initialize();
        this.loader.setInputFile(inputFile);
        this.tables = this.loader.getTables();
        this.loader.generateStatements(this.tables);
        this.loader.executeStatements(this.tables);
        String cubeDescription = this.getCubeDescription();
        this.testContext = TestContext.create(null, (String)cubeDescription, null, null, null);
    }

    protected void tearDown() throws Exception {
        if (!this.isApplicable()) {
            return;
        }
        try {
            this.loader.dropTables(this.tables);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    protected Connection getSqlConnection() throws SQLException {
        return ((RolapConnection)this.getConnection()).getDataSource().getConnection();
    }

    protected Schema getSchema() {
        return this.getConnection().getSchema();
    }

    protected TestContext getCubeTestContext() {
        return this.testContext;
    }

    protected abstract String getDirectoryName();

    protected abstract String getFileName();

    protected abstract String getCubeDescription();
}

