/*
 * Decompiled with CFR 0.152.
 */
package mondrian.tui;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import mondrian.olap.Util;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.CatalogLocatorImpl;
import mondrian.tui.MockHttpServletRequest;
import mondrian.tui.MockHttpServletResponse;
import mondrian.tui.MockServletConfig;
import mondrian.tui.MockServletContext;
import mondrian.tui.XmlUtil;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.impl.DefaultXmlaRequest;
import mondrian.xmla.impl.DefaultXmlaResponse;
import mondrian.xmla.impl.DefaultXmlaServlet;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class XmlaSupport {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$tui$XmlaSupport == null ? (class$mondrian$tui$XmlaSupport = XmlaSupport.class$("mondrian.tui.XmlaSupport")) : class$mondrian$tui$XmlaSupport));
    public static final String nl = Util.nl;
    public static final String SOAP_PREFIX = "SOAP-ENV";
    public static final String CATALOG_NAME = "FoodMart";
    public static final String DATASOURCE_NAME = "MondrianFoodMart";
    public static final String DATASOURCE_DESCRIPTION = "Mondrian FoodMart data source";
    public static final String DATASOURCE_INFO = "Provider=Mondrian;DataSource=MondrianFoodMart;";
    public static final Map ENV = new HashMap();
    public static String XMLA_TRANSFORM;
    public static final String ROW_SET_PREFIX = "ROW";
    private static CatalogLocator CATALOG_LOCATOR;
    private static String soapFaultXPath;
    private static String soapHeaderAndBodyXPath;
    private static String soapBodyXPath;
    private static String soapXmlaRootXPath;
    private static String xmlaRootXPath;
    private static final /* synthetic */ Class class$mondrian$tui$XmlaSupport;

    public static CatalogLocator getCatalogLocator() {
        if (CATALOG_LOCATOR == null) {
            CATALOG_LOCATOR = new CatalogLocatorImpl();
        }
        return CATALOG_LOCATOR;
    }

    public static DataSourcesConfig.DataSources getDataSources(String connectString, String[][] catalogNameUrls) throws XOMException {
        String str = XmlaSupport.getDataSourcesText(connectString, catalogNameUrls);
        StringReader dsConfigReader = new StringReader(str);
        Parser xmlParser = XOMUtil.createDefaultParser();
        DOMWrapper def = xmlParser.parse((Reader)dsConfigReader);
        DataSourcesConfig.DataSources datasources = new DataSourcesConfig.DataSources(def);
        return datasources;
    }

    public static String getDataSourcesText(String connectString, String[][] catalogNameUrls) {
        StringBuffer buf = new StringBuffer(500);
        buf.append("<?xml version=\"1.0\"?>");
        buf.append(nl);
        buf.append("<DataSources>");
        buf.append(nl);
        buf.append("   <DataSource>");
        buf.append(nl);
        buf.append("       <DataSourceName>");
        buf.append(DATASOURCE_NAME);
        buf.append("</DataSourceName>");
        buf.append(nl);
        buf.append("       <DataSourceDescription>");
        buf.append(DATASOURCE_DESCRIPTION);
        buf.append("</DataSourceDescription>");
        buf.append(nl);
        buf.append("       <URL>http://localhost:8080/mondrian/xmla</URL>");
        buf.append(nl);
        buf.append("       <DataSourceInfo><![CDATA[");
        buf.append(connectString);
        buf.append("]]></DataSourceInfo>");
        buf.append(nl);
        buf.append("       <ProviderName>Mondrian</ProviderName>");
        buf.append(nl);
        buf.append("       <ProviderType>MDP</ProviderType>");
        buf.append(nl);
        buf.append("       <AuthenticationMode>Unauthenticated</AuthenticationMode>");
        buf.append(nl);
        buf.append("       <Catalogs>");
        buf.append(nl);
        for (int i = 0; i < catalogNameUrls.length; ++i) {
            String[] catalogNameUrl = catalogNameUrls[i];
            String name = catalogNameUrl[0];
            String url = catalogNameUrl[1];
            buf.append("           <Catalog name='");
            buf.append(name);
            buf.append("'><Definition>");
            buf.append(url);
            buf.append("</Definition></Catalog>");
        }
        buf.append("       </Catalogs>");
        buf.append(nl);
        buf.append("   </DataSource>");
        buf.append(nl);
        buf.append("</DataSources>");
        buf.append(nl);
        String datasources = buf.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaSupport.getDataSources: datasources=" + datasources));
        }
        return datasources;
    }

    public static String getSoapFaultXPath() {
        if (soapFaultXPath == null) {
            String xpath;
            StringBuffer buf = new StringBuffer(100);
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Envelope");
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Body");
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Fault");
            buf.append("/*");
            soapFaultXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getSoapFaultXPath: xpath=" + xpath));
            }
        }
        return soapFaultXPath;
    }

    public static String getSoapHeaderAndBodyXPath() {
        if (soapHeaderAndBodyXPath == null) {
            String xpath;
            StringBuffer buf = new StringBuffer(100);
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Envelope");
            buf.append("/*");
            soapHeaderAndBodyXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getSoapHeaderAndBodyXPath: xpath=" + xpath));
            }
        }
        return soapHeaderAndBodyXPath;
    }

    public static String getSoapBodyXPath() {
        if (soapBodyXPath == null) {
            String xpath;
            StringBuffer buf = new StringBuffer(100);
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Envelope");
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Body");
            buf.append("/*");
            soapBodyXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getSoapBodyXPath: xpath=" + xpath));
            }
        }
        return soapBodyXPath;
    }

    public static String getSoapXmlaRootXPath() {
        if (soapXmlaRootXPath == null) {
            String xpath;
            StringBuffer buf = new StringBuffer(20);
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Envelope");
            buf.append('/');
            buf.append(SOAP_PREFIX);
            buf.append(":Body");
            buf.append("/xmla:DiscoverResponse");
            buf.append("/xmla:return");
            buf.append('/');
            buf.append(ROW_SET_PREFIX);
            buf.append(":root");
            buf.append("/*");
            soapXmlaRootXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getSoapXmlaRootXPath: xpath=" + xpath));
            }
        }
        return soapXmlaRootXPath;
    }

    public static String getXmlaRootXPath() {
        if (xmlaRootXPath == null) {
            String xpath;
            StringBuffer buf = new StringBuffer(20);
            buf.append("/xmla:DiscoverResponse");
            buf.append("/xmla:return");
            buf.append('/');
            buf.append(ROW_SET_PREFIX);
            buf.append(":root");
            buf.append("/*");
            xmlaRootXPath = xpath = buf.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaSupport.getXmlaRootXPath: xpath=" + xpath));
            }
        }
        return xmlaRootXPath;
    }

    public static Node[] extractNodesFromSoapXmla(byte[] bytes) throws SAXException, IOException {
        Document doc = XmlUtil.parse(bytes);
        return XmlaSupport.extractNodesFromSoapXmla(doc);
    }

    public static Node[] extractNodesFromSoapXmla(Document doc) throws SAXException, IOException {
        String xpath = XmlaSupport.getSoapXmlaRootXPath();
        String[][] nsArray = new String[][]{{SOAP_PREFIX, "http://schemas.xmlsoap.org/soap/envelope/"}, {"xmla", "urn:schemas-microsoft-com:xml-analysis"}, {ROW_SET_PREFIX, "urn:schemas-microsoft-com:xml-analysis:rowset"}};
        return XmlaSupport.extractNodes(doc, xpath, nsArray);
    }

    public static Node[] extractNodesFromXmla(byte[] bytes) throws SAXException, IOException {
        Document doc = XmlUtil.parse(bytes);
        return XmlaSupport.extractNodesFromXmla(doc);
    }

    public static Node[] extractNodesFromXmla(Document doc) throws SAXException, IOException {
        String xpath = XmlaSupport.getXmlaRootXPath();
        String[][] nsArray = new String[][]{{"xmla", "urn:schemas-microsoft-com:xml-analysis"}, {ROW_SET_PREFIX, "urn:schemas-microsoft-com:xml-analysis:rowset"}};
        return XmlaSupport.extractNodes(doc, xpath, nsArray);
    }

    public static Node[] extractFaultNodesFromSoap(byte[] bytes) throws SAXException, IOException {
        Document doc = XmlUtil.parse(bytes);
        return XmlaSupport.extractFaultNodesFromSoap(doc);
    }

    public static Node[] extractFaultNodesFromSoap(Document doc) throws SAXException, IOException {
        String xpath = XmlaSupport.getSoapFaultXPath();
        String[][] nsArray = new String[][]{{SOAP_PREFIX, "http://schemas.xmlsoap.org/soap/envelope/"}};
        Node[] nodes = XmlaSupport.extractNodes(doc, xpath, nsArray);
        return nodes;
    }

    public static Node[] extractHeaderAndBodyFromSoap(byte[] bytes) throws SAXException, IOException {
        Document doc = XmlUtil.parse(bytes);
        return XmlaSupport.extractHeaderAndBodyFromSoap(doc);
    }

    public static Node[] extractHeaderAndBodyFromSoap(Document doc) throws SAXException, IOException {
        String xpath = XmlaSupport.getSoapHeaderAndBodyXPath();
        String[][] nsArray = new String[][]{{SOAP_PREFIX, "http://schemas.xmlsoap.org/soap/envelope/"}};
        Node[] nodes = XmlaSupport.extractNodes(doc, xpath, nsArray);
        return nodes;
    }

    public static Document extractBodyFromSoap(Document doc) throws SAXException, IOException {
        String xpath = XmlaSupport.getSoapBodyXPath();
        String[][] nsArray = new String[][]{{SOAP_PREFIX, "http://schemas.xmlsoap.org/soap/envelope/"}};
        Node[] nodes = XmlaSupport.extractNodes(doc, xpath, nsArray);
        return nodes.length == 1 ? XmlUtil.newDocument(nodes[0], true) : null;
    }

    public static Node[] extractNodes(Node node, String xpath, String[][] nsArray) throws SAXException, IOException {
        Document contextDoc = XmlUtil.createContextDocument(nsArray);
        Node[] nodes = XmlUtil.selectAsNodes(node, xpath, contextDoc);
        if (LOGGER.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(1024);
            buf.append("XmlaSupport.extractNodes: ");
            buf.append("nodes.length=");
            buf.append(nodes.length);
            buf.append(nl);
            for (int i = 0; i < nodes.length; ++i) {
                Node n = nodes[i];
                String str = XmlUtil.toString(n, false);
                buf.append(str);
                buf.append(nl);
            }
            LOGGER.debug((Object)buf.toString());
        }
        return nodes;
    }

    public static byte[] processSoapXmla(File file, String connectString, String[][] catalogNameUrls, String cbClassName) throws IOException, ServletException, SAXException {
        String requestText = XmlaSupport.readFile(file);
        return XmlaSupport.processSoapXmla(requestText, connectString, catalogNameUrls, cbClassName);
    }

    public static byte[] processSoapXmla(Document doc, String connectString, String[][] catalogNameUrls, String cbClassName) throws IOException, ServletException, SAXException {
        String requestText = XmlUtil.toString(doc, false);
        return XmlaSupport.processSoapXmla(requestText, connectString, catalogNameUrls, cbClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] processSoapXmla(String requestText, String connectString, String[][] catalogNameUrls, String cbClassName) throws IOException, ServletException, SAXException {
        File dsFile = null;
        try {
            String dataSourceText = XmlaSupport.getDataSourcesText(connectString, catalogNameUrls);
            dsFile = File.createTempFile("datasources.xml", null);
            FileOutputStream out = new FileOutputStream(dsFile);
            ((OutputStream)out).write(dataSourceText.getBytes());
            out.flush();
            byte[] reqBytes = requestText.getBytes();
            MockHttpServletRequest req = new MockHttpServletRequest(reqBytes);
            req.setMethod("POST");
            req.setContentType("text/xml");
            MockHttpServletResponse res = new MockHttpServletResponse();
            res.setCharacterEncoding("UTF-8");
            MockServletContext servletContext = new MockServletContext();
            MockServletConfig servletConfig = new MockServletConfig(servletContext);
            servletConfig.addInitParameter("Callbacks", cbClassName);
            servletConfig.addInitParameter("CharacterEncoding", "UTF-8");
            servletConfig.addInitParameter("DataSourcesConfig", dsFile.toURL().toString());
            DefaultXmlaServlet servlet = new DefaultXmlaServlet();
            servlet.init(servletConfig);
            servlet.service((ServletRequest)req, (ServletResponse)res);
            byte[] byArray = res.toByteArray();
            return byArray;
        }
        finally {
            if (dsFile != null) {
                dsFile.delete();
            }
        }
    }

    public static Servlet makeServlet(String connectString, String[][] catalogNameUrls, String cbClassName) throws IOException, ServletException, SAXException {
        String dataSourceText = XmlaSupport.getDataSourcesText(connectString, catalogNameUrls);
        File dsFile = File.createTempFile("datasources.xml", null);
        dsFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(dsFile);
        ((OutputStream)out).write(dataSourceText.getBytes());
        out.flush();
        MockServletContext servletContext = new MockServletContext();
        MockServletConfig servletConfig = new MockServletConfig(servletContext);
        servletConfig.addInitParameter("Callbacks", cbClassName);
        servletConfig.addInitParameter("CharacterEncoding", "UTF-8");
        servletConfig.addInitParameter("DataSourcesConfig", dsFile.toURL().toString());
        DefaultXmlaServlet servlet = new DefaultXmlaServlet();
        servlet.init(servletConfig);
        return servlet;
    }

    public static byte[] processSoapXmla(File file, Servlet servlet) throws IOException, ServletException, SAXException {
        String requestText = XmlaSupport.readFile(file);
        return XmlaSupport.processSoapXmla(requestText, servlet);
    }

    public static byte[] processSoapXmla(Document doc, Servlet servlet) throws IOException, ServletException, SAXException {
        String requestText = XmlUtil.toString(doc, false);
        return XmlaSupport.processSoapXmla(requestText, servlet);
    }

    public static byte[] processSoapXmla(String requestText, Servlet servlet) throws IOException, ServletException, SAXException {
        byte[] reqBytes = requestText.getBytes();
        MockHttpServletRequest req = new MockHttpServletRequest(reqBytes);
        req.setMethod("POST");
        req.setContentType("text/xml");
        MockHttpServletResponse res = new MockHttpServletResponse();
        res.setCharacterEncoding("UTF-8");
        servlet.service((ServletRequest)req, (ServletResponse)res);
        return res.toByteArray();
    }

    public static boolean validateSchemaSoapXmla(byte[] bytes) throws SAXException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        return XmlaSupport.validateEmbeddedSchema(bytes, XmlUtil.SOAP_XMLA_XDS2XS, XmlUtil.SOAP_XMLA_XDS2XD);
    }

    public static byte[] processXmla(File file, String connectString, String[][] catalogNameUrls) throws IOException, SAXException, XOMException {
        String requestText = XmlaSupport.readFile(file);
        return XmlaSupport.processXmla(requestText, connectString, catalogNameUrls);
    }

    public static byte[] processXmla(String requestText, String connectString, String[][] catalogNameUrls) throws IOException, SAXException, XOMException {
        Document requestDoc = XmlUtil.parseString(requestText);
        return XmlaSupport.processXmla(requestDoc, connectString, catalogNameUrls);
    }

    public static byte[] processXmla(Document requestDoc, String connectString, String[][] catalogNameUrls) throws IOException, XOMException {
        Element requestElem = requestDoc.getDocumentElement();
        return XmlaSupport.processXmla(requestElem, connectString, catalogNameUrls);
    }

    public static byte[] processXmla(Element requestElem, String connectString, String[][] catalogNameUrls) throws IOException, XOMException {
        CatalogLocator cl = XmlaSupport.getCatalogLocator();
        DataSourcesConfig.DataSources dataSources = XmlaSupport.getDataSources(connectString, catalogNameUrls);
        XmlaHandler handler = new XmlaHandler(dataSources, cl);
        DefaultXmlaRequest request = new DefaultXmlaRequest(requestElem, null);
        ByteArrayOutputStream resBuf = new ByteArrayOutputStream();
        DefaultXmlaResponse response = new DefaultXmlaResponse(resBuf, "UTF-8");
        handler.process(request, response);
        return resBuf.toByteArray();
    }

    public static boolean validateSchemaXmla(byte[] bytes) throws SAXException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        return XmlaSupport.validateEmbeddedSchema(bytes, XmlUtil.XMLA_XDS2XS, XmlUtil.XMLA_XDS2XD);
    }

    public static boolean validateSoapXmlaUsingXpath(byte[] bytes) throws SAXException, IOException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        Node[] nodes = XmlaSupport.extractNodesFromSoapXmla(bytes);
        return XmlaSupport.validateNodes(nodes);
    }

    public static boolean validateXmlaUsingXpath(byte[] bytes) throws SAXException, IOException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        Node[] nodes = XmlaSupport.extractNodesFromXmla(bytes);
        return XmlaSupport.validateNodes(nodes);
    }

    public static boolean validateNodes(Node[] nodes) throws SAXException, IOException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        if (nodes.length == 0) {
            return false;
        }
        if (nodes.length == 1) {
            return false;
        }
        if (nodes.length > 2) {
            return false;
        }
        Node schemaNode = nodes[0];
        Node rowNode = nodes[1];
        Node rootNode = rowNode.getParentNode();
        rootNode.removeChild(schemaNode);
        Document schemaDoc = XmlUtil.newDocument(schemaNode, true);
        Document dataDoc = XmlUtil.newDocument(rootNode, true);
        String xmlns = XmlUtil.getNamespaceAttributeValue(dataDoc);
        String schemaLocationPropertyValue = xmlns + ' ' + "xmlschema";
        XmlUtil.Resolver resolver = new XmlUtil.Resolver(schemaDoc);
        XmlUtil.validate(dataDoc, schemaLocationPropertyValue, (EntityResolver)resolver);
        return true;
    }

    public static boolean validateEmbeddedSchema(byte[] bytes, String schemaTransform, String dataTransform) throws SAXException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        Document doc = XmlUtil.parse(bytes);
        return XmlaSupport.validateEmbeddedSchema(doc, schemaTransform, dataTransform);
    }

    public static boolean validateEmbeddedSchema(Document doc, String schemaTransform, String dataTransform) throws SAXException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        if (!XmlUtil.supportsValidation()) {
            return false;
        }
        Node dataDoc = XmlUtil.transform(doc, new BufferedReader(new StringReader(dataTransform)));
        if (dataDoc == null) {
            LOGGER.debug((Object)"XmlaSupport.validateEmbeddedSchema: dataDoc is null");
            return false;
        }
        if (!dataDoc.hasChildNodes()) {
            LOGGER.debug((Object)"XmlaSupport.validateEmbeddedSchema: dataDoc has no children");
            return false;
        }
        String dataStr = XmlUtil.toString(dataDoc, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaSupport.validateEmbeddedSchema: dataDoc:\n=" + dataStr));
        }
        if (!(dataDoc instanceof Document)) {
            LOGGER.warn((Object)"XmlaSupport.validateEmbeddedSchema: dataDoc not Document");
            return false;
        }
        Node schemaDoc = XmlUtil.transform(doc, new BufferedReader(new StringReader(schemaTransform)));
        if (schemaDoc == null) {
            LOGGER.debug((Object)"XmlaSupport.validateEmbeddedSchema: schemaDoc is null");
            return false;
        }
        if (!schemaDoc.hasChildNodes()) {
            LOGGER.debug((Object)"XmlaSupport.validateEmbeddedSchema: schemaDoc has no children");
            return false;
        }
        String schemaStr = XmlUtil.toString(schemaDoc, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaSupport.validateEmbeddedSchema: schemaDoc:\n=" + schemaStr));
        }
        if (!(schemaDoc instanceof Document)) {
            LOGGER.warn((Object)"XmlaSupport.validateEmbeddedSchema: schemaDoc not Document");
            return false;
        }
        String xmlns = XmlUtil.getNamespaceAttributeValue((Document)dataDoc);
        String schemaLocationPropertyValue = xmlns + ' ' + "xmlschema";
        XmlUtil.Resolver resolver = new XmlUtil.Resolver(schemaStr);
        XmlUtil.validate(dataStr, schemaLocationPropertyValue, (EntityResolver)resolver);
        return true;
    }

    public static Document transformSoapXmla(Document doc, String[][] namevalueParameters) throws SAXException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        Node node = XmlUtil.transform(doc, new BufferedReader(new StringReader(XMLA_TRANSFORM)), namevalueParameters);
        return node instanceof Document ? (Document)node : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        StringBuffer buf = new StringBuffer(1024);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return buf.toString();
    }

    private XmlaSupport() {
    }

    static {
        ENV.put("catalog", CATALOG_NAME);
        ENV.put("datasource", DATASOURCE_INFO);
        XMLA_TRANSFORM = "<?xml version='1.0'?><xsl:stylesheet   xmlns:xsl='http://www.w3.org/1999/XSL/Transform'   xmlns:xalan='http://xml.apache.org/xslt'  xmlns:xsd='http://www.w3.org/2001/XMLSchema'  xmlns:ROW='urn:schemas-microsoft-com:xml-analysis:rowset'  xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'   xmlns:xmla='urn:schemas-microsoft-com:xml-analysis'  version='1.0'><xsl:output method='xml'   encoding='UTF-8'  indent='yes'   xalan:indent-amount='2'/><xsl:param name='content'/><xsl:param name='soap'/><!-- consume '/' and apply --><xsl:template match='/'>  <xsl:apply-templates/></xsl:template><!-- copy 'Envelope' unless soap==none --> <xsl:template match='SOAP-ENV:Envelope'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'Header' unless soap==none --> <xsl:template match='SOAP-ENV:Header'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>        <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'Body' unless soap==none --> <xsl:template match='SOAP-ENV:Body'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>        <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'DiscoverResponse' unless soap==none --> <xsl:template match='xmla:DiscoverResponse'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'return' unless soap==none --> <xsl:template match='xmla:return'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise>    </xsl:choose> </xsl:template> <!-- copy 'root' unless soap==none --> <xsl:template match='ROW:root'>   <xsl:choose>     <xsl:when test=\"$soap='none'\">       <xsl:apply-templates/>     </xsl:when>     <xsl:otherwise>       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:otherwise >   </xsl:choose> </xsl:template> <!-- copy 'schema' if content==schema or schemadata --> <xsl:template match='xsd:schema'>   <xsl:choose>     <xsl:when test=\"$content='schemadata'\">       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:when>     <xsl:when test=\"$content='schema'\">       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:when>   <xsl:otherwise/>    </xsl:choose> </xsl:template> <!-- copy 'row' if content==data or schemadata --> <xsl:template match='ROW:row'>   <xsl:choose>     <xsl:when test=\"$content='schemadata'\">       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:when>     <xsl:when test=\"$content='data'\">       <xsl:copy>         <xsl:apply-templates select='@*|node()'/>       </xsl:copy>     </xsl:when>     <xsl:otherwise/>    </xsl:choose> </xsl:template> <!-- copy everything else --> <xsl:template match='*|@*'>   <xsl:copy>     <xsl:apply-templates select='@*|node()'/>   </xsl:copy> </xsl:template> </xsl:stylesheet>";
        CATALOG_LOCATOR = null;
        soapFaultXPath = null;
        soapHeaderAndBodyXPath = null;
        soapBodyXPath = null;
        soapXmlaRootXPath = null;
        xmlaRootXPath = null;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

