/*
 * Decompiled with CFR 0.152.
 */
package mondrian.udf;

import java.util.Date;
import java.util.Locale;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.Type;
import mondrian.spi.UserDefinedFunction;
import mondrian.util.Format;

public class CurrentDateMemberUdf
implements UserDefinedFunction {
    public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
        int matchType;
        Object formatArg = arguments[1].evaluateScalar(evaluator);
        Locale locale = Locale.getDefault();
        Format format = new Format((String)formatArg, locale);
        Date currDate = new Date();
        String currDateStr = format.format(currDate);
        if (arguments.length == 3) {
            String matchStr = ((String)arguments[2].evaluateScalar(evaluator)).toString();
            matchType = this.mapMatchStrToType(matchStr);
        } else {
            matchType = 1;
        }
        String[] uniqueNames = Util.explode(currDateStr);
        Member retDate = evaluator.getSchemaReader().getMemberByUniqueName(uniqueNames, false, matchType);
        if (retDate != null) {
            return retDate;
        }
        Object arg0 = arguments[0].evaluate(evaluator);
        if (arg0 instanceof Hierarchy) {
            return ((Hierarchy)arg0).getNullMember();
        }
        return ((Dimension)arg0).getHierarchy().getNullMember();
    }

    public String getDescription() {
        return "Returns the closest or exact member within the specified dimension corresponding to the current date, in the format specified by the format parameter.";
    }

    public String getName() {
        return "CurrentDateMember";
    }

    public Type[] getParameterTypes() {
        return new Type[]{new HierarchyType(null, null), new StringType(), new SymbolType()};
    }

    public String[] getReservedWords() {
        return new String[]{"EXACT", "BEFORE", "AFTER"};
    }

    public Type getReturnType(Type[] parameterTypes) {
        return MemberType.Unknown;
    }

    public Syntax getSyntax() {
        return Syntax.Function;
    }

    private int mapMatchStrToType(String matchStr) {
        if (matchStr.equals("EXACT")) {
            return 1;
        }
        if (matchStr.equals("BEFORE")) {
            return 2;
        }
        return 3;
    }
}

