/*
 * Decompiled with CFR 0.152.
 */
package mondrian.web.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.web.taglib.ResultCache;
import org.eigenbase.xom.StringEscaper;

public class MDXQueryServlet
extends HttpServlet {
    private String connectString;
    private CatalogLocator locator;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.connectString = config.getInitParameter("connectString");
        Enumeration initParameterNames = config.getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String name = (String)initParameterNames.nextElement();
            String value = config.getInitParameter(name);
            MondrianProperties.instance().setProperty(name, value);
        }
        this.locator = new ServletContextCatalogLocator(config.getServletContext());
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryName = request.getParameter("query");
        request.setAttribute("query", (Object)queryName);
        if (queryName != null) {
            this.processTransform(request, response);
            return;
        }
        String queryString = request.getParameter("queryString");
        request.setAttribute("queryString", (Object)queryString);
        Connection mdxConnection = null;
        StringBuffer html = new StringBuffer();
        try {
            int i;
            mdxConnection = DriverManager.getConnection(this.connectString, this.locator, false);
            Query q = mdxConnection.parseQuery(queryString);
            Result result = mdxConnection.execute(q);
            Position[] slicers = result.getSlicerAxis().positions;
            html.append("<table class='resulttable' cellspacing=1 border=0>");
            html.append(Util.nl);
            Position[] columns = result.getAxes()[0].positions;
            Position[] rows = null;
            if (result.getAxes().length == 2) {
                rows = result.getAxes()[1].positions;
            }
            int columnWidth = columns[0].members.length;
            int rowWidth = 0;
            if (result.getAxes().length == 2) {
                rowWidth = result.getAxes()[1].positions[0].members.length;
            }
            for (int j = 0; j < columnWidth; ++j) {
                int i2;
                html.append("<tr>");
                if (j == 0 && result.getAxes().length > 1) {
                    html.append("<td nowrap class='slicer' rowspan='" + columnWidth + "' colspan='" + rowWidth + "'>");
                    for (i2 = 0; i2 < slicers.length; ++i2) {
                        Position position = slicers[i2];
                        for (int k = 0; k < position.members.length; ++k) {
                            if (k > 0) {
                                html.append("<br/>");
                            }
                            Member member = position.members[k];
                            html.append(member.getUniqueName());
                        }
                    }
                    html.append("&nbsp;</td>" + Util.nl);
                }
                for (i2 = 0; i2 < columns.length; ++i2) {
                    Member member = columns[i2].members[j];
                    int width = 1;
                    while (i2 + 1 < columns.length && columns[i2 + 1].members[j] == member) {
                        ++i2;
                        ++width;
                    }
                    html.append("<td nowrap class='columnheading' colspan='" + width + "'>" + member.getUniqueName() + "</td>");
                }
                html.append("</tr>" + Util.nl);
            }
            if (result.getAxes().length > 1) {
                for (i = 0; i < rows.length; ++i) {
                    int j;
                    html.append("<tr>");
                    Position row = rows[i];
                    for (j = 0; j < row.members.length; ++j) {
                        Member member = row.members[j];
                        html.append("<td nowrap class='rowheading'>" + member.getUniqueName() + "</td>");
                    }
                    j = 0;
                    while (j < columns.length) {
                        this.showCell(html, result.getCell(new int[]{j++, i}));
                    }
                    html.append("</tr>");
                }
            } else {
                html.append("<tr>");
                i = 0;
                while (i < columns.length) {
                    this.showCell(html, result.getCell(new int[]{i++}));
                }
                html.append("</tr>");
            }
            html.append("</table>");
        }
        catch (Throwable e) {
            String[] strings = Util.convertStackToString(e);
            html.append("Error:<pre><blockquote>");
            for (int i = 0; i < strings.length; ++i) {
                StringEscaper.htmlEscaper.appendEscapedString(strings[i], html);
            }
            html.append("</blockquote></pre>");
        }
        finally {
            if (mdxConnection != null) {
                mdxConnection.close();
            }
        }
        request.setAttribute("result", (Object)html.toString());
        response.setHeader("Content-Type", "text/html");
        this.getServletContext().getRequestDispatcher("/adhoc.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    private void showCell(StringBuffer out, Cell cell) {
        out.append("<td class='cell'>" + cell.getFormattedValue() + "</td>");
    }

    private void processTransform(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryName = request.getParameter("query");
        ResultCache rc = ResultCache.getInstance(request.getSession(), this.getServletContext(), queryName);
        Query query = rc.getQuery();
        query = query.safeClone();
        rc.setDirty();
        String operation = request.getParameter("operation");
        if (operation.equals("expand")) {
            String memberName = request.getParameter("member");
            boolean fail = true;
            Member member = query.getSchemaReader(true).getMemberByUniqueName(Util.explode(memberName), fail);
            throw new UnsupportedOperationException("query.toggleDrillState(member) has been de-supported");
        }
        throw Util.newInternal("unkown operation '" + operation + "'");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Process an MDX query and return the result formatted as an HTML table";
    }
}

