/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import com.rc.retroweaver.runtime.Arrays;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Category;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.HierarchyBase;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.Member;
import mondrian.olap.MemberBase;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunInfo;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;

abstract class RowsetDefinition
extends EnumeratedValues.BasicValue {
    final Column[] columnDefinitions;
    final Column[] sortColumnDefinitions;
    private static final String dateModified = "2005-01-25T17:35:32";
    public static final int DISCOVER_DATASOURCES = 0;
    public static final int DISCOVER_PROPERTIES = 1;
    public static final int DISCOVER_SCHEMA_ROWSETS = 2;
    public static final int DISCOVER_ENUMERATORS = 3;
    public static final int DISCOVER_KEYWORDS = 4;
    public static final int DISCOVER_LITERALS = 5;
    public static final int DBSCHEMA_CATALOGS = 6;
    public static final int DBSCHEMA_COLUMNS = 7;
    public static final int DBSCHEMA_PROVIDER_TYPES = 8;
    public static final int DBSCHEMA_TABLES = 9;
    public static final int DBSCHEMA_TABLES_INFO = 10;
    public static final int MDSCHEMA_ACTIONS = 11;
    public static final int MDSCHEMA_CUBES = 12;
    public static final int MDSCHEMA_DIMENSIONS = 13;
    public static final int MDSCHEMA_FUNCTIONS = 14;
    public static final int MDSCHEMA_HIERARCHIES = 15;
    public static final int MDSCHEMA_LEVELS = 16;
    public static final int MDSCHEMA_MEASURES = 17;
    public static final int MDSCHEMA_MEMBERS = 18;
    public static final int MDSCHEMA_PROPERTIES = 19;
    public static final int MDSCHEMA_SETS = 20;
    public static final int OTHER = 21;
    public static final EnumeratedValues enumeration = new EnumeratedValues(new RowsetDefinition[]{DiscoverDatasourcesRowset.definition, DiscoverEnumeratorsRowset.definition, DiscoverPropertiesRowset.definition, DiscoverSchemaRowsetsRowset.access$000(), DiscoverKeywordsRowset.definition, DiscoverLiteralsRowset.definition, DbschemaCatalogsRowset.definition, DbschemaColumnsRowset.definition, DbschemaProviderTypesRowset.definition, DbschemaTablesRowset.definition, DbschemaTablesInfoRowset.definition, MdschemaActionsRowset.definition, MdschemaCubesRowset.definition, MdschemaDimensionsRowset.definition, MdschemaFunctionsRowset.definition, MdschemaHierarchiesRowset.definition, MdschemaLevelsRowset.definition, MdschemaMeasuresRowset.definition, MdschemaMembersRowset.definition, MdschemaPropertiesRowset.definition, MdschemaSetsRowset.definition});

    RowsetDefinition(String name, int ordinal, String description, Column[] columnDefinitions, Column[] sortColumnDefinitions) {
        super(name, ordinal, description);
        this.columnDefinitions = columnDefinitions;
        this.sortColumnDefinitions = sortColumnDefinitions;
    }

    public static RowsetDefinition getValue(String name) {
        return (RowsetDefinition)enumeration.getValue(name, true);
    }

    public abstract Rowset getRowset(XmlaRequest var1, XmlaHandler var2);

    public Column lookupColumn(String name) {
        for (int i = 0; i < this.columnDefinitions.length; ++i) {
            Column columnDefinition = this.columnDefinitions[i];
            if (!columnDefinition.name.equals(name)) continue;
            return columnDefinition;
        }
        return null;
    }

    Comparator getComparator() {
        if (this.sortColumnDefinitions == null) {
            return null;
        }
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.compare((Rowset.Row)o1, (Rowset.Row)o2);
            }

            int compare(Rowset.Row row1, Rowset.Row row2) {
                for (int i = 0; i < RowsetDefinition.this.sortColumnDefinitions.length; ++i) {
                    int v;
                    Column sortColumn = RowsetDefinition.this.sortColumnDefinitions[i];
                    Comparable val1 = (Comparable)row1.get(sortColumn.name);
                    Comparable val2 = (Comparable)row2.get(sortColumn.name);
                    if (val1 == null && val2 == null) continue;
                    if (val1 == null) {
                        return -1;
                    }
                    if (val2 == null) {
                        return 1;
                    }
                    if (!(val1 instanceof String && val2 instanceof String ? (v = ((String)((Object)val1)).compareToIgnoreCase((String)((Object)val2))) != 0 : (v = val1.compareTo(val2)) != 0)) continue;
                    return v;
                }
                return 0;
            }
        };
    }

    void writeRowsetXmlSchema(SaxWriter writer) {
        this.writeRowsetXmlSchemaTop(writer);
        this.writeRowsetXmlSchemaRowDef(writer);
        this.writeRowsetXmlSchemaBottom(writer);
    }

    protected void writeRowsetXmlSchemaTop(SaxWriter writer) {
        writer.startElement("xsd:schema", new String[]{"xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", "urn:schemas-microsoft-com:xml-sql", "targetNamespace", "urn:schemas-microsoft-com:xml-analysis:rowset", "elementFormDefault", "qualified"});
        writer.startElement("xsd:element", new String[]{"name", "root"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", new String[]{"name", "row", "type", "row", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:simpleType", new String[]{"name", "uuid"});
        writer.startElement("xsd:restriction", new String[]{"base", "xsd:string"});
        writer.element("xsd:pattern", new String[]{"value", "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"});
        writer.endElement();
        writer.endElement();
    }

    protected void writeRowsetXmlSchemaRowDef(SaxWriter writer) {
        writer.startElement("xsd:complexType", new String[]{"name", "row"});
        writer.startElement("xsd:sequence");
        for (int i = 0; i < this.columnDefinitions.length; ++i) {
            Column column = this.columnDefinitions[i];
            String name = XmlaUtil.encodeElementName(column.name);
            String xsdType = column.type.columnType;
            String[] attrs = null;
            attrs = column.nullable ? (column.unbounded ? new String[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", "0", "maxOccurs", "unbounded"} : new String[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", "0"}) : (column.unbounded ? new String[]{"sql:field", column.name, "name", name, "type", xsdType, "maxOccurs", "unbounded"} : new String[]{"sql:field", column.name, "name", name, "type", xsdType});
            writer.element("xsd:element", attrs);
        }
        writer.endElement();
        writer.endElement();
    }

    protected void writeRowsetXmlSchemaBottom(SaxWriter writer) {
        writer.endElement();
    }

    private static DBType getDBTypeFromProperty(Property prop) {
        DBType dbType = DBType.WSTR;
        switch (prop.getType()) {
            case 0: {
                dbType = DBType.WSTR;
                break;
            }
            case 1: {
                dbType = DBType.R8;
                break;
            }
            case 2: {
                dbType = DBType.BOOL;
                break;
            }
        }
        return dbType;
    }

    static int getDimensionType(Dimension dim) {
        if (dim.isMeasures()) {
            return 2;
        }
        if (DimensionType.TimeDimension.equals(dim.getDimensionType())) {
            return 1;
        }
        return 3;
    }

    private static boolean canAccess(SchemaReader schemaReader, OlapElement elem) {
        Role role = schemaReader.getRole();
        return role.canAccess(elem);
    }

    static boolean access$200(SchemaReader x0, OlapElement x1) {
        return RowsetDefinition.canAccess(x0, x1);
    }

    static DBType access$300(Property x0) {
        return RowsetDefinition.getDBTypeFromProperty(x0);
    }

    static class MdschemaPropertiesRowset
    extends Rowset {
        private final Rowset.RistrictionTest schemaNameRT = this.getRistrictionTest(SchemaName);
        private final Rowset.RistrictionTest cubeNameRT = this.getRistrictionTest(CubeName);
        private final Rowset.RistrictionTest dimensionUniqueNameRT = this.getRistrictionTest(DimensionUniqueName);
        private final Rowset.RistrictionTest hierarchyUniqueNameRT = this.getRistrictionTest(HierarchyUniqueName);
        private final Rowset.RistrictionTest propertyNameRT = this.getRistrictionTest(PropertyName);
        private static final int MDPROP_MEMBER = 1;
        private static final int MDPROP_CELL = 2;
        private static final int MDPROP_SYSTEM = 4;
        private static final int MDPROP_BLOB = 8;
        private static final int MD_PROPTYPE_REGULAR = 0;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the database.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this property belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the level to which this property belongs.");
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the member to which the property belongs.");
        private static final Column PropertyName = new Column("PROPERTY_NAME", Type.String, null, true, false, "Name of the property.");
        private static final Column PropertyType = new Column("PROPERTY_TYPE", Type.Short, null, true, false, "A bitmap that specifies the type of the property");
        private static final Column PropertyCaption = new Column("PROPERTY_CAPTION", Type.String, null, false, false, "A label or caption associated with the property, used primarily for display purposes.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "Data type of the property.");
        private static final Column PropertyContentType = new Column("PROPERTY_CONTENT_TYPE", Type.Short, null, true, true, "The type of the property. ");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure. ");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_PROPERTIES", 19, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyUniqueName, LevelUniqueName, MemberUniqueName, PropertyName, PropertyCaption, PropertyType, DataType, PropertyContentType, Description}, null){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaPropertiesRowset(request, handler);
            }
        };

        MdschemaPropertiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            for (int i = 0; i < catalogs.length; ++i) {
                String catalogName;
                Connection connection;
                DataSourcesConfig.Catalog dsCatalog = catalogs[i];
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name)) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List rows) throws XmlaException {
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List rows) throws XmlaException {
            if (this.isRestricted(LevelUniqueName)) {
                String levelUniqueName = this.getRestrictionValueAsString(LevelUniqueName);
                if (levelUniqueName == null) {
                    return;
                }
                String[] nameParts = Util.explode(levelUniqueName);
                Hierarchy hier = cube.lookupHierarchy(nameParts[0], false);
                if (hier == null) {
                    return;
                }
                Level[] levels = hier.getLevels();
                for (int i = 0; i < levels.length; ++i) {
                    Level level = levels[i];
                    if (!level.getUniqueName().equals(levelUniqueName)) continue;
                    this.populateLevel(schemaReader, catalogName, cube, level, rows);
                    break;
                }
                return;
            }
            Dimension[] dimensions = cube.getDimensions();
            for (int j = 0; j < dimensions.length; ++j) {
                Dimension dimension = dimensions[j];
                String uniqueName = dimension.getUniqueName();
                if (!this.dimensionUniqueNameRT.passes(uniqueName)) continue;
                this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
            }
        }

        private void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List rows) {
            Hierarchy[] hierarchies = dimension.getHierarchies();
            for (int i = 0; i < hierarchies.length; ++i) {
                Hierarchy hierarchy = hierarchies[i];
                String unique = hierarchy.getUniqueName();
                if (!this.hierarchyUniqueNameRT.passes(unique)) continue;
                this.populateHierarchy(schemaReader, catalogName, cube, hierarchy, rows);
            }
        }

        private void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, List rows) {
            Level[] levels = hierarchy.getLevels();
            for (int i = 0; i < levels.length; ++i) {
                Level level = levels[i];
                this.populateLevel(schemaReader, catalogName, cube, level, rows);
            }
        }

        private void populateLevel(SchemaReader schemaReader, String catalogName, Cube cube, Level level, List rows) {
            Property[] properties = level.getProperties();
            for (int i = 0; i < properties.length; ++i) {
                Property property = properties[i];
                if (!this.propertyNameRT.passes(property.getName())) continue;
                this.outputProperty(schemaReader, property, catalogName, cube, level, rows);
            }
        }

        private void outputProperty(SchemaReader schemaReader, Property property, String catalogName, Cube cube, Level level, List rows) {
            Hierarchy hierarchy = level.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            String propertyName = property.getName();
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaPropertiesRowset.CatalogName.name, catalogName);
            row.set(MdschemaPropertiesRowset.SchemaName.name, catalogName);
            row.set(MdschemaPropertiesRowset.CubeName.name, cube.getName());
            row.set(MdschemaPropertiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaPropertiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaPropertiesRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaPropertiesRowset.PropertyName.name, propertyName);
            row.set(MdschemaPropertiesRowset.PropertyType.name, 1);
            row.set(MdschemaPropertiesRowset.PropertyContentType.name, 0);
            row.set(MdschemaPropertiesRowset.PropertyCaption.name, property.getCaption());
            DBType dbType = RowsetDefinition.access$300(property);
            row.set(MdschemaPropertiesRowset.DataType.name, dbType.getOrdinal());
            String desc = cube.getName() + " Cube - " + hierarchy.getName() + " Hierarchy - " + level.getName() + " Level - " + property.getName() + " Property";
            row.set(MdschemaPropertiesRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class MdschemaSetsRowset
    extends Rowset {
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column SetName = new Column("SET_NAME", Type.String, null, true, false, null);
        private static final Column SetCaption = new Column("SET_CAPTION", Type.String, null, true, true, null);
        private static final Column Scope = new Column("SCOPE", Type.Integer, null, true, false, null);
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure. ");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_SETS", 20, null, new Column[]{CatalogName, SchemaName, CubeName, SetName, Scope}, new Column[]{CatalogName, SchemaName, CubeName}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaSetsRowset(request, handler);
            }
        };

        MdschemaSetsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            throw new XmlaException("Client", "00HSBG01", "XMLA unsupported operation", new UnsupportedOperationException("MDSCHEMA_SETS"));
        }
    }

    static class MdschemaMembersRowset
    extends Rowset {
        private final Rowset.RistrictionTest schemaNameRT = this.getRistrictionTest(SchemaName);
        private final Rowset.RistrictionTest cubeNameRT = this.getRistrictionTest(CubeName);
        private final Rowset.RistrictionTest dimensionUniqueNameRT = this.getRistrictionTest(DimensionUniqueName);
        private final Rowset.RistrictionTest hierarchyUniqueNameRT = this.getRistrictionTest(HierarchyUniqueName);
        private final Rowset.RistrictionTest memberNameRT = this.getRistrictionTest(MemberName);
        private final Rowset.RistrictionTest memberUniqueNameRT = this.getRistrictionTest(MemberUniqueName);
        private final Rowset.RistrictionTest memberTypeRT = this.getRistrictionTest(MemberType);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this member belongs. ");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this member belongs. ");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "Name of the cube to which this member belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "Unique name of the dimension to which this member belongs. ");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "Unique name of the hierarchy. If the member belongs to more than one hierarchy, there is one row for each hierarchy to which it belongs.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, " Unique name of the level to which the member belongs.");
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.UnsignedInteger, null, true, false, "The distance of the member from the root of the hierarchy.");
        private static final Column MemberOrdinal = new Column("MEMBER_ORDINAL", Type.UnsignedInteger, null, false, false, "Ordinal number of the member. Sort rank of the member when members of this dimension are sorted in their natural sort order. If providers do not have the concept of natural ordering, this should be the rank when sorted by MEMBER_NAME.");
        private static final Column MemberName = new Column("MEMBER_NAME", Type.String, null, true, false, "Name of the member.");
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.String, null, true, false, " Unique name of the member.");
        private static final Column MemberType = new Column("MEMBER_TYPE", Type.Integer, null, true, false, "Type of the member.");
        private static final Column MemberGuid = new Column("MEMBER_GUID", Type.UUID, null, false, true, "Memeber GUID.");
        private static final Column MemberCaption = new Column("MEMBER_CAPTION", Type.String, null, true, false, "A label or caption associated with the member.");
        private static final Column ChildrenCardinality = new Column("CHILDREN_CARDINALITY", Type.UnsignedInteger, null, false, false, "Number of children that the member has.");
        private static final Column ParentLevel = new Column("PARENT_LEVEL", Type.UnsignedInteger, null, false, false, "The distance of the member's parent from the root level of the hierarchy. ");
        private static final Column ParentUniqueName = new Column("PARENT_UNIQUE_NAME", Type.String, null, false, true, "Unique name of the member's parent.");
        private static final Column ParentCount = new Column("PARENT_COUNT", Type.UnsignedInteger, null, false, false, "Number of parents that this member has.");
        private static final Column TreeOp = new Column("TREE_OP", Type.Enumeration, Enumeration.TreeOp.enumeration, true, true, "Tree Operation");
        private static final Column Depth = new Column("DEPTH", Type.Integer, null, false, true, "depth");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_MEMBERS", 18, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyUniqueName, LevelUniqueName, LevelNumber, MemberOrdinal, MemberName, MemberUniqueName, MemberType, MemberGuid, MemberCaption, ChildrenCardinality, ParentLevel, ParentUniqueName, ParentCount, TreeOp, Depth}, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyUniqueName, LevelUniqueName, LevelNumber, MemberOrdinal}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaMembersRowset(request, handler);
            }
        };

        MdschemaMembersRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            for (int i = 0; i < catalogs.length; ++i) {
                String catalogName;
                Connection connection;
                DataSourcesConfig.Catalog dsCatalog = catalogs[i];
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name)) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List rows) throws XmlaException {
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List rows) throws XmlaException {
            if (this.isRestricted(MemberUniqueName)) {
                this.outputUniqueMemberName(schemaReader, catalogName, cube, rows);
            } else {
                if (this.isRestricted(LevelUniqueName)) {
                    String levelUniqueName = this.getRestrictionValueAsString(LevelUniqueName);
                    if (levelUniqueName == null) {
                        return;
                    }
                    String[] nameParts = Util.explode(levelUniqueName);
                    Hierarchy hier = cube.lookupHierarchy(nameParts[0], false);
                    if (hier == null) {
                        return;
                    }
                    Level[] levels = hier.getLevels();
                    for (int i = 0; i < levels.length; ++i) {
                        Level level = levels[i];
                        if (!level.getUniqueName().equals(levelUniqueName)) continue;
                        Member[] members = cube.getSchemaReader(null).getLevelMembers(level, false);
                        this.outputMembers(schemaReader, members, catalogName, cube, rows);
                    }
                    return;
                }
                Dimension[] dimensions = cube.getDimensions();
                for (int j = 0; j < dimensions.length; ++j) {
                    Dimension dimension = dimensions[j];
                    String uniqueName = dimension.getUniqueName();
                    if (!this.dimensionUniqueNameRT.passes(uniqueName)) continue;
                    this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
                }
            }
        }

        protected void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List rows) throws XmlaException {
            Hierarchy[] hierarchies = dimension.getHierarchies();
            for (int i = 0; i < hierarchies.length; ++i) {
                Hierarchy hierarchy = hierarchies[i];
                String uniqueName = hierarchy.getUniqueName();
                if (!this.hierarchyUniqueNameRT.passes(uniqueName)) continue;
                this.populateHierarchy(schemaReader, catalogName, cube, hierarchy, rows);
            }
        }

        protected void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, List rows) throws XmlaException {
            if (this.isRestricted(LevelNumber)) {
                int levelNumber = this.getRestrictionValueAsInt(LevelNumber);
                if (levelNumber == -1) {
                    LOGGER.warn((Object)"RowsetDefinition.populateHierarchy: LevelNumber invalid");
                    return;
                }
                Level[] levels = hierarchy.getLevels();
                if (levelNumber >= levels.length) {
                    LOGGER.warn((Object)("RowsetDefinition.populateHierarchy: LevelNumber (" + levelNumber + ") is greater than number of levels (" + levels.length + ") for hierarchy \"" + hierarchy.getUniqueName() + "\""));
                    return;
                }
                Level level = levels[levelNumber];
                Member[] members = schemaReader.getLevelMembers(level, false);
                this.outputMembers(schemaReader, members, catalogName, cube, rows);
            } else {
                Member[][] membersArray = RolapMember.getAllMembers(schemaReader, hierarchy);
                for (int i = 0; i < membersArray.length; ++i) {
                    Member[] members = membersArray[i];
                    this.outputMembers(schemaReader, members, catalogName, cube, rows);
                }
            }
        }

        private static boolean mask(int value, int mask) {
            return (value & mask) == mask;
        }

        private void populateMember(SchemaReader schemaReader, String catalogName, Cube cube, Member member, int treeOp, List rows) {
            Member[] children;
            Member parent;
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Self.ordinal)) {
                this.outputMember(schemaReader, member, catalogName, cube, rows);
            }
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Siblings.ordinal)) {
                parent = schemaReader.getMemberParent(member);
                Member[] siblings = parent == null ? schemaReader.getHierarchyRootMembers(member.getHierarchy()) : schemaReader.getMemberChildren(parent);
                for (int i = 0; i < siblings.length; ++i) {
                    Member sibling = siblings[i];
                    if (sibling == member) continue;
                    this.populateMember(schemaReader, catalogName, cube, sibling, Enumeration.TreeOp.Self.ordinal, rows);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Descendants.ordinal)) {
                children = schemaReader.getMemberChildren(member);
                for (int i = 0; i < children.length; ++i) {
                    Member child = children[i];
                    this.populateMember(schemaReader, catalogName, cube, child, Enumeration.TreeOp.Self.ordinal | Enumeration.TreeOp.Descendants.ordinal, rows);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Children.ordinal)) {
                children = schemaReader.getMemberChildren(member);
                for (int i = 0; i < children.length; ++i) {
                    Member child = children[i];
                    this.populateMember(schemaReader, catalogName, cube, child, Enumeration.TreeOp.Self.ordinal, rows);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Ancestors.ordinal)) {
                parent = schemaReader.getMemberParent(member);
                if (parent != null) {
                    this.populateMember(schemaReader, catalogName, cube, parent, Enumeration.TreeOp.Self.ordinal | Enumeration.TreeOp.Ancestors.ordinal, rows);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Parent.ordinal) && (parent = schemaReader.getMemberParent(member)) != null) {
                this.populateMember(schemaReader, catalogName, cube, parent, Enumeration.TreeOp.Self.ordinal, rows);
            }
        }

        protected ArrayList pruneRestrictions(ArrayList list) {
            if (list.contains(TreeOp)) {
                list.remove(TreeOp);
                list.remove(MemberUniqueName);
            }
            return list;
        }

        private void outputMembers(SchemaReader schemaReader, Member[] members, String catalogName, Cube cube, List rows) {
            for (int i = 0; i < members.length; ++i) {
                Member member = members[i];
                this.outputMember(schemaReader, member, catalogName, cube, rows);
            }
        }

        private void outputUniqueMemberName(SchemaReader schemaReader, String catalogName, Cube cube, List rows) {
            String memberUniqueName = this.getRestrictionValueAsString(MemberUniqueName);
            if (memberUniqueName == null) {
                return;
            }
            String[] nameParts = Util.explode(memberUniqueName);
            Member member = schemaReader.getMemberByUniqueName(nameParts, false);
            if (member == null) {
                return;
            }
            if (this.isRestricted(TreeOp)) {
                int treeOp = this.getRestrictionValueAsInt(TreeOp);
                if (treeOp == -1) {
                    return;
                }
                this.populateMember(schemaReader, catalogName, cube, member, treeOp, rows);
            } else {
                this.outputMember(schemaReader, member, catalogName, cube, rows);
            }
        }

        private void outputMember(SchemaReader schemaReader, Member member, String catalogName, Cube cube, List rows) {
            if (!RowsetDefinition.access$200(schemaReader, member)) {
                return;
            }
            if (!this.memberNameRT.passes(member.getName())) {
                return;
            }
            if (!this.memberTypeRT.passes(member.getMemberType())) {
                return;
            }
            if (member.getOrdinal() == -1) {
                RolapMember.setOrdinals(schemaReader, member);
            }
            Level level = member.getLevel();
            Hierarchy hierarchy = level.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMembersRowset.CatalogName.name, catalogName);
            row.set(MdschemaMembersRowset.SchemaName.name, catalogName);
            row.set(MdschemaMembersRowset.CubeName.name, cube.getName());
            row.set(MdschemaMembersRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaMembersRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaMembersRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaMembersRowset.LevelNumber.name, level.getDepth());
            row.set(MdschemaMembersRowset.MemberOrdinal.name, member.getOrdinal());
            row.set(MdschemaMembersRowset.MemberName.name, member.getName());
            row.set(MdschemaMembersRowset.MemberUniqueName.name, member.getUniqueName());
            row.set(MdschemaMembersRowset.MemberType.name, member.getMemberType());
            row.set(MdschemaMembersRowset.MemberCaption.name, member.getCaption());
            row.set(MdschemaMembersRowset.ChildrenCardinality.name, member.getPropertyValue(Property.CHILDREN_CARDINALITY.name));
            row.set(MdschemaMembersRowset.ChildrenCardinality.name, 100);
            row.set(MdschemaMembersRowset.ParentLevel.name, member.getParentMember() == null ? 0 : member.getParentMember().getDepth());
            String parentUniqueName = member.getParentUniqueName();
            if (parentUniqueName != null) {
                row.set(MdschemaMembersRowset.ParentUniqueName.name, parentUniqueName);
            }
            row.set(MdschemaMembersRowset.ParentCount.name, member.getParentMember() == null ? 0 : 1);
            row.set(MdschemaMembersRowset.Depth.name, member.getDepth());
            this.addRow(row, rows);
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class MdschemaMeasuresRowset
    extends Rowset {
        public static final int MDMEASURE_AGGR_UNKNOWN = 0;
        public static final int MDMEASURE_AGGR_SUM = 1;
        public static final int MDMEASURE_AGGR_COUNT = 2;
        public static final int MDMEASURE_AGGR_MIN = 3;
        public static final int MDMEASURE_AGGR_MAX = 4;
        public static final int MDMEASURE_AGGR_AVG = 5;
        public static final int MDMEASURE_AGGR_VAR = 6;
        public static final int MDMEASURE_AGGR_STD = 7;
        public static final int MDMEASURE_AGGR_CALCULATED = 127;
        private final Rowset.RistrictionTest schemaNameRT = this.getRistrictionTest(SchemaName);
        private final Rowset.RistrictionTest cubeNameRT = this.getRistrictionTest(CubeName);
        private final Rowset.RistrictionTest measureUniqueNameRT;
        private final Rowset.RistrictionTest measureNameRT = this.getRistrictionTest(MeasureName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this measure belongs. ");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this measure belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this measure belongs.");
        private static final Column MeasureName = new Column("MEASURE_NAME", Type.String, null, true, false, "The name of the measure.");
        private static final Column MeasureUniqueName = new Column("MEASURE_UNIQUE_NAME", Type.String, null, true, false, "The Unique name of the measure.");
        private static final Column MeasureCaption = new Column("MEASURE_CAPTION", Type.String, null, false, false, "A label or caption associated with the measure. ");
        private static final Column MeasureGuid = new Column("MEASURE_GUID", Type.UUID, null, false, true, "Measure GUID.");
        private static final Column MeasureAggregator = new Column("MEASURE_AGGREGATOR", Type.Integer, null, false, false, "How a measure was derived. ");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "Data type of the measure.");
        private static final Column MeasureIsVisible = new Column("MEASURE_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that always returns True. If the measure is not visible, it will not be included in the schema rowset.");
        private static final Column LevelsList = new Column("LEVELS_LIST", Type.String, null, false, true, "A string that always returns NULL. EXCEPT that SQL Server returns non-null values!!!");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure. ");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_MEASURES", 17, null, new Column[]{CatalogName, SchemaName, CubeName, MeasureName, MeasureUniqueName, MeasureCaption, MeasureGuid, MeasureAggregator, DataType, MeasureIsVisible, LevelsList, Description}, new Column[]{CatalogName, SchemaName, CubeName, MeasureName}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaMeasuresRowset(request, handler);
            }
        };

        MdschemaMeasuresRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
            this.measureUniqueNameRT = this.getRistrictionTest(MeasureUniqueName);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            for (int i = 0; i < catalogs.length; ++i) {
                String catalogName;
                Connection connection;
                DataSourcesConfig.Catalog dsCatalog = catalogs[i];
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name)) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List rows) throws XmlaException {
            StringBuffer buf = new StringBuffer(100);
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                Dimension measuresDimension = cube.getDimensions()[0];
                Hierarchy measuresHierarchy = measuresDimension.getHierarchies()[0];
                Level measuresLevel = measuresHierarchy.getLevels()[0];
                buf.setLength(0);
                Dimension[] dims = cube.getDimensions();
                for (int j = 1; j < dims.length; ++j) {
                    Hierarchy[] hierarchies = dims[j].getHierarchies();
                    for (int k = 0; k < hierarchies.length; ++k) {
                        Level[] levels = hierarchies[k].getLevels();
                        Level lastLevel = levels[levels.length - 1];
                        buf.append(lastLevel.getUniqueName());
                        if (k + 1 >= hierarchies.length) continue;
                        buf.append(',');
                    }
                    if (j + 1 >= dims.length) continue;
                    buf.append(',');
                }
                String levelListStr = buf.toString();
                Member[] storedMembers = schemaReader.getLevelMembers(measuresLevel, false);
                for (int j = 0; j < storedMembers.length; ++j) {
                    Member member = storedMembers[j];
                    String name = member.getName();
                    String unique = member.getUniqueName();
                    if (!this.measureNameRT.passes(name) || !this.measureUniqueNameRT.passes(unique)) continue;
                    this.populateMember(schemaReader, catalogName, member, cube, levelListStr, rows);
                }
                List calcMembers = schemaReader.getCalculatedMembers(measuresHierarchy);
                Iterator it = calcMembers.iterator();
                while (it.hasNext()) {
                    Member member = (Member)it.next();
                    String name = member.getName();
                    String unique = member.getUniqueName();
                    if (!this.measureNameRT.passes(name) || !this.measureUniqueNameRT.passes(unique)) continue;
                    this.populateMember(schemaReader, catalogName, member, cube, null, rows);
                }
            }
        }

        private void populateMember(SchemaReader schemaReader, String catalogName, Member member, Cube cube, String levelListStr, List rows) {
            MemberBase mb;
            Boolean isVisible;
            if (!RowsetDefinition.access$200(schemaReader, member)) {
                return;
            }
            if (member instanceof MemberBase && (isVisible = (Boolean)(mb = (MemberBase)member).getPropertyValue(Property.VISIBLE.name)) != null && !isVisible.booleanValue()) {
                return;
            }
            String desc = member.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + member.getName() + " Member";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMeasuresRowset.CatalogName.name, catalogName);
            row.set(MdschemaMeasuresRowset.CubeName.name, cube.getName());
            row.set(MdschemaMeasuresRowset.MeasureName.name, member.getName());
            row.set(MdschemaMeasuresRowset.MeasureUniqueName.name, member.getUniqueName());
            row.set(MdschemaMeasuresRowset.MeasureCaption.name, member.getCaption());
            Object aggProp = member.getPropertyValue(Property.AGGREGATION_TYPE.getName());
            int aggNumber = 0;
            if (aggProp != null) {
                RolapAggregator agg = (RolapAggregator)aggProp;
                if (agg == RolapAggregator.Sum) {
                    aggNumber = 1;
                } else if (agg == RolapAggregator.Count) {
                    aggNumber = 2;
                } else if (agg == RolapAggregator.Min) {
                    aggNumber = 3;
                } else if (agg == RolapAggregator.Max) {
                    aggNumber = 4;
                } else if (agg == RolapAggregator.Avg) {
                    aggNumber = 5;
                }
            } else {
                aggNumber = 127;
            }
            row.set(MdschemaMeasuresRowset.MeasureAggregator.name, aggNumber);
            int dbType = 130;
            String datatype = (String)member.getPropertyValue(Property.DATATYPE.getName());
            if (datatype != null) {
                dbType = datatype.equals("Integer") ? 3 : (datatype.equals("Numeric") ? 5 : 130);
            }
            row.set(MdschemaMeasuresRowset.DataType.name, dbType);
            row.set(MdschemaMeasuresRowset.MeasureIsVisible.name, true);
            if (levelListStr != null) {
                row.set(MdschemaMeasuresRowset.LevelsList.name, levelListStr);
            }
            row.set(MdschemaMeasuresRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class MdschemaLevelsRowset
    extends Rowset {
        private final Rowset.RistrictionTest schemaNameRT = this.getRistrictionTest(SchemaName);
        private final Rowset.RistrictionTest cubeNameRT = this.getRistrictionTest(CubeName);
        private final Rowset.RistrictionTest dimensionUniqueNameRT = this.getRistrictionTest(DimensionUniqueName);
        private final Rowset.RistrictionTest hierarchyUniqueNameRT = this.getRistrictionTest(HierarchyUniqueName);
        private final Rowset.RistrictionTest levelUniqueNameRT = this.getRistrictionTest(LevelUniqueName);
        private final Rowset.RistrictionTest levelNameRT = this.getRistrictionTest(LevelName);
        public static final int MDLEVEL_TYPE_UNKNOWN = 0;
        public static final int MDLEVEL_TYPE_REGULAR = 0;
        public static final int MDLEVEL_TYPE_ALL = 1;
        public static final int MDLEVEL_TYPE_CALCULATED = 2;
        public static final int MDLEVEL_TYPE_TIME = 4;
        public static final int MDLEVEL_TYPE_RESERVED1 = 8;
        public static final int MDLEVEL_TYPE_TIME_YEARS = 20;
        public static final int MDLEVEL_TYPE_TIME_HALF_YEAR = 36;
        public static final int MDLEVEL_TYPE_TIME_QUARTERS = 68;
        public static final int MDLEVEL_TYPE_TIME_MONTHS = 132;
        public static final int MDLEVEL_TYPE_TIME_WEEKS = 260;
        public static final int MDLEVEL_TYPE_TIME_DAYS = 516;
        public static final int MDLEVEL_TYPE_TIME_HOURS = 772;
        public static final int MDLEVEL_TYPE_TIME_MINUTES = 1028;
        public static final int MDLEVEL_TYPE_TIME_SECONDS = 2052;
        public static final int MDLEVEL_TYPE_TIME_UNDEFINED = 4100;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this level belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this level belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this level belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension to which this level belongs.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column LevelName = new Column("LEVEL_NAME", Type.String, null, true, false, "The name of the level.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, "The properly escaped unique name of the level.");
        private static final Column LevelGuid = new Column("LEVEL_GUID", Type.UUID, null, false, true, "Level GUID.");
        private static final Column LevelCaption = new Column("LEVEL_CAPTION", Type.String, null, false, false, "A label or caption associated with the hierarchy.");
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.UnsignedInteger, null, false, false, "The distance of the level from the root of the hierarchy. Root level is zero (0).");
        private static final Column LevelCardinality = new Column("LEVEL_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the level. This value can be an approximation of the real cardinality.");
        private static final Column LevelType = new Column("LEVEL_TYPE", Type.Integer, null, false, false, "Type of the level");
        private static final Column CustomRollupSettings = new Column("CUSTOM_ROLLUP_SETTINGS", Type.Integer, null, false, false, "A bitmap that specifies the custom rollup options.");
        private static final Column LevelUniqueSettings = new Column("LEVEL_UNIQUE_SETTINGS", Type.Integer, null, false, false, "A bitmap that specifies which columns contain unique values, if the level only has members with unique names or keys.");
        private static final Column LevelIsVisible = new Column("LEVEL_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that indicates whether the level is visible.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the level. NULL if no description exists.");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_LEVELS", 16, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyUniqueName, LevelName, LevelUniqueName, LevelGuid, LevelCaption, LevelNumber, LevelCardinality, LevelType, CustomRollupSettings, LevelUniqueSettings, LevelIsVisible, Description}, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyUniqueName, LevelNumber}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaLevelsRowset(request, handler);
            }
        };

        MdschemaLevelsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            for (int i = 0; i < catalogs.length; ++i) {
                Connection connection;
                String catalogName;
                DataSourcesConfig.Catalog dsCatalog = catalogs[i];
                if (dsCatalog == null || dsCatalog.definition == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name) || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List rows) throws XmlaException {
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List rows) throws XmlaException {
            Dimension[] dimensions = cube.getDimensions();
            for (int j = 0; j < dimensions.length; ++j) {
                Dimension dimension = dimensions[j];
                String uniqueName = dimension.getUniqueName();
                if (!this.dimensionUniqueNameRT.passes(uniqueName)) continue;
                this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List rows) throws XmlaException {
            Hierarchy[] hierarchies = dimension.getHierarchies();
            for (int i = 0; i < hierarchies.length; ++i) {
                Hierarchy hierarchy = hierarchies[i];
                String uniqueName = hierarchy.getUniqueName();
                if (!this.hierarchyUniqueNameRT.passes(uniqueName)) continue;
                this.populateHierarchy(schemaReader, catalogName, cube, hierarchy, rows);
            }
        }

        protected void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, List rows) throws XmlaException {
            Level[] levels = hierarchy.getLevels();
            for (int i = 0; i < levels.length; ++i) {
                Level level = levels[i];
                String uniqueName = level.getUniqueName();
                String name = level.getName();
                if (!this.levelUniqueNameRT.passes(uniqueName) || !this.levelNameRT.passes(name)) continue;
                this.outputLevel(schemaReader, catalogName, cube, hierarchy, level, rows);
            }
        }

        protected void outputLevel(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, Level level, List rows) throws XmlaException {
            if (!RowsetDefinition.access$200(schemaReader, level)) {
                return;
            }
            String desc = level.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + hierarchy.getName() + " Hierarchy" + level.getName() + " Level";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaLevelsRowset.CatalogName.name, catalogName);
            row.set(MdschemaLevelsRowset.SchemaName.name, catalogName);
            row.set(MdschemaLevelsRowset.CubeName.name, cube.getName());
            row.set(MdschemaLevelsRowset.DimensionUniqueName.name, hierarchy.getDimension().getUniqueName());
            row.set(MdschemaLevelsRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaLevelsRowset.LevelName.name, level.getName());
            row.set(MdschemaLevelsRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaLevelsRowset.LevelCaption.name, level.getCaption());
            row.set(MdschemaLevelsRowset.LevelNumber.name, new Integer(level.getDepth()));
            int n = schemaReader.getLevelCardinality(level, true, true);
            row.set(MdschemaLevelsRowset.LevelCardinality.name, n);
            row.set(MdschemaLevelsRowset.LevelType.name, this.getLevelType(level));
            row.set(MdschemaLevelsRowset.CustomRollupSettings.name, 0);
            if (level instanceof RolapLevel) {
                RolapLevel rl = (RolapLevel)level;
                row.set(MdschemaLevelsRowset.LevelUniqueSettings.name, (rl.isUnique() ? 1 : 0) + (rl.isAll() ? 2 : 0));
            } else {
                row.set(MdschemaLevelsRowset.LevelUniqueSettings.name, level.isAll() ? 2 : 0);
            }
            row.set(MdschemaLevelsRowset.LevelIsVisible.name, true);
            row.set(MdschemaLevelsRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        private int getLevelType(Level lev) {
            int ret = 0;
            if (lev.isAll()) {
                ret |= 1;
            }
            LevelType type = lev.getLevelType();
            switch (type.getOrdinal()) {
                case 0: {
                    ret |= 0;
                    break;
                }
                case 5: {
                    ret |= 0x204;
                    break;
                }
                case 3: {
                    ret |= 0x84;
                    break;
                }
                case 2: {
                    ret |= 0x44;
                    break;
                }
                case 4: {
                    ret |= 0x104;
                    break;
                }
                case 1: {
                    ret |= 0x14;
                    break;
                }
                default: {
                    ret |= 0;
                }
            }
            return ret;
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class MdschemaHierarchiesRowset
    extends Rowset {
        private final Rowset.RistrictionTest schemaNameRT = this.getRistrictionTest(SchemaName);
        private final Rowset.RistrictionTest cubeNameRT = this.getRistrictionTest(CubeName);
        private final Rowset.RistrictionTest dimensionUniqueNameRT = this.getRistrictionTest(DimensionUniqueName);
        private final Rowset.RistrictionTest hierarchyUniqueNameRT = this.getRistrictionTest(HierarchyUniqueName);
        private final Rowset.RistrictionTest hierarchyNameRT = this.getRistrictionTest(HierarchyName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this hierarchy belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "Not supported");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this hierarchy belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension to which this hierarchy belongs. ");
        private static final Column HierarchyName = new Column("HIERARCHY_NAME", Type.String, null, true, false, "The name of the hierarchy. Blank if there is only a single hierarchy in the dimension.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column HierarchyGuid = new Column("HIERARCHY_GUID", Type.UUID, null, false, true, "Hierarchy GUID.");
        private static final Column HierarchyCaption = new Column("HIERARCHY_CAPTION", Type.String, null, false, false, "A label or a caption associated with the hierarchy.");
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Short, null, false, false, "The type of the dimension. ");
        private static final Column HierarchyCardinality = new Column("HIERARCHY_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the hierarchy.");
        private static final Column DefaultMember = new Column("DEFAULT_MEMBER", Type.String, null, false, true, "The default member for this hierarchy. ");
        private static final Column AllMember = new Column("ALL_MEMBER", Type.String, null, false, true, "The member at the highest level of rollup in the hierarchy.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the hierarchy. NULL if no description exists.");
        private static final Column Structure = new Column("STRUCTURE", Type.Short, null, false, false, "The structure of the hierarchy.");
        private static final Column IsVirtual = new Column("IS_VIRTUAL", Type.Boolean, null, false, false, "Always returns False.");
        private static final Column IsReadWrite = new Column("IS_READWRITE", Type.Boolean, null, false, false, "A Boolean that indicates whether the Write Back to dimension column is enabled.");
        private static final Column DimensionUniqueSettings = new Column("DIMENSION_UNIQUE_SETTINGS", Type.Integer, null, false, false, "Always returns MDDIMENSIONS_MEMBER_KEY_UNIQUE (1).");
        private static final Column DimensionIsVisible = new Column("DIMENSION_IS_VISIBLE", Type.Boolean, null, false, false, "Always returns true.");
        private static final Column HierarchyOrdinal = new Column("HIERARCHY_ORDINAL", Type.UnsignedInteger, null, false, false, "The ordinal number of the hierarchy across all hierarchies of the cube.");
        private static final Column DimensionIsShared = new Column("DIMENSION_IS_SHARED", Type.Boolean, null, false, false, "Always returns true.");
        private static final Column ParentChild = new Column("PARENT_CHILD", Type.Boolean, null, false, true, "Is hierarcy a parent.");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_HIERARCHIES", 15, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyName, HierarchyUniqueName, HierarchyGuid, HierarchyCaption, DimensionType, HierarchyCardinality, DefaultMember, AllMember, Description, Structure, IsVirtual, IsReadWrite, DimensionUniqueSettings, DimensionIsVisible, HierarchyOrdinal, DimensionIsShared, ParentChild}, new Column[]{CatalogName, SchemaName, CubeName, DimensionUniqueName, HierarchyName}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaHierarchiesRowset(request, handler);
            }
        };

        MdschemaHierarchiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            for (int i = 0; i < catalogs.length; ++i) {
                Connection connection;
                String catalogName;
                DataSourcesConfig.Catalog dsCatalog = catalogs[i];
                if (dsCatalog == null || dsCatalog.definition == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name) || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateCatalog(Connection connection, Role role, String catalogName, List rows) throws XmlaException {
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List rows) throws XmlaException {
            int ordinal = 0;
            Dimension[] dimensions = cube.getDimensions();
            for (int j = 0; j < dimensions.length; ++j) {
                Dimension dimension = dimensions[j];
                String unique = dimension.getUniqueName();
                boolean genOutput = this.dimensionUniqueNameRT.passes(unique);
                ordinal = this.populateDimension(genOutput, schemaReader, catalogName, cube, dimension, ordinal, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int populateDimension(boolean genOutput, SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, int ordinal, List rows) throws XmlaException {
            Hierarchy[] hierarchies = dimension.getHierarchies();
            for (int i = 0; i < hierarchies.length; ++i) {
                Hierarchy hierarchy = hierarchies[i];
                if (genOutput) {
                    String name = hierarchy.getName();
                    String unique = hierarchy.getUniqueName();
                    if (this.hierarchyNameRT.passes(hierarchy.getName()) && this.hierarchyUniqueNameRT.passes(unique)) {
                        this.populateHierarchy(schemaReader, catalogName, cube, dimension, (HierarchyBase)hierarchy, ordinal++, rows);
                        continue;
                    }
                    ++ordinal;
                    continue;
                }
                ++ordinal;
            }
            int n = ordinal;
            return n;
        }

        protected void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, HierarchyBase hierarchy, int ordinal, List rows) throws XmlaException {
            if (!RowsetDefinition.access$200(schemaReader, hierarchy)) {
                return;
            }
            String desc = hierarchy.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + hierarchy.getName() + " Hierarchy";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaHierarchiesRowset.CatalogName.name, catalogName);
            row.set(MdschemaHierarchiesRowset.CubeName.name, cube.getName());
            row.set(MdschemaHierarchiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaHierarchiesRowset.HierarchyName.name, hierarchy.getName());
            row.set(MdschemaHierarchiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaHierarchiesRowset.HierarchyCaption.name, hierarchy.getCaption());
            row.set(MdschemaHierarchiesRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
            int cardinality = RolapMember.getHierarchyCardinality(schemaReader, hierarchy);
            row.set(MdschemaHierarchiesRowset.HierarchyCardinality.name, cardinality);
            row.set(MdschemaHierarchiesRowset.DefaultMember.name, hierarchy.getDefaultMember());
            if (hierarchy.hasAll()) {
                row.set(MdschemaHierarchiesRowset.AllMember.name, Util.makeFqName(hierarchy, hierarchy.getAllMemberName()));
            }
            row.set(MdschemaHierarchiesRowset.Description.name, desc);
            row.set(MdschemaHierarchiesRowset.Structure.name, hierarchy.isRagged() ? 1 : 0);
            row.set(MdschemaHierarchiesRowset.IsVirtual.name, false);
            row.set(MdschemaHierarchiesRowset.IsReadWrite.name, false);
            row.set(MdschemaHierarchiesRowset.DimensionUniqueSettings.name, 0);
            row.set(MdschemaHierarchiesRowset.DimensionIsVisible.name, true);
            row.set(MdschemaHierarchiesRowset.HierarchyOrdinal.name, ordinal);
            row.set(MdschemaHierarchiesRowset.DimensionIsShared.name, true);
            RolapLevel nonAllFirstLevel = (RolapLevel)hierarchy.getLevels()[hierarchy.hasAll() ? 1 : 0];
            row.set(MdschemaHierarchiesRowset.ParentChild.name, nonAllFirstLevel.isParentChild());
            this.addRow(row, rows);
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class MdschemaFunctionsRowset
    extends Rowset {
        private final Rowset.RistrictionTest functionNameRT = this.getRistrictionTest(FunctionName);
        private static final Column FunctionName = new Column("FUNCTION_NAME", Type.String, null, true, false, "The name of the function.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A description of the function.");
        private static final Column ParameterList = new Column("PARAMETER_LIST", Type.String, null, false, true, "A comma delimited list of parameters.");
        private static final Column ReturnType = new Column("RETURN_TYPE", Type.Integer, null, false, false, "The VARTYPE of the return data type of the function.");
        private static final Column Origin = new Column("ORIGIN", Type.Integer, null, true, false, "The origin of the function:  1 for MDX functions.  2 for user-defined functions.");
        private static final Column InterfaceName = new Column("INTERFACE_NAME", Type.String, null, true, false, "The name of the interface for user-defined functions");
        private static final Column LibraryName = new Column("LIBRARY_NAME", Type.String, null, true, true, "The name of the type library for user-defined functions. NULL for MDX functions.");
        private static final Column Caption = new Column("CAPTION", Type.String, null, false, true, "The display caption for the function.");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_FUNCTIONS", 14, null, new Column[]{FunctionName, Description, ParameterList, ReturnType, Origin, InterfaceName, LibraryName, Caption}, new Column[]{LibraryName, InterfaceName, FunctionName, Origin}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaFunctionsRowset(request, handler);
            }
        };

        MdschemaFunctionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String role = this.request.getRole();
            for (int h = 0; h < catalogs.length; ++h) {
                Connection connection;
                DataSourcesConfig.Catalog dsCatalog = catalogs[h];
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role)) == null) continue;
                RolapSchema schema = (RolapSchema)connection.getSchema();
                FunTable funTable = schema.getFunTable();
                StringBuffer buf = new StringBuffer(50);
                List functions = funTable.getFunInfoList();
                Iterator it = functions.iterator();
                while (it.hasNext()) {
                    FunInfo fi = (FunInfo)it.next();
                    if (!this.functionNameRT.passes(fi.getName())) continue;
                    int[][] paramCategories = fi.getParameterCategories();
                    int[] returnCategories = fi.getReturnCategories();
                    String description = fi.getDescription();
                    if (description != null) {
                        description = Util.replace(fi.getDescription(), "\r", "");
                    }
                    if (paramCategories == null || paramCategories.length == 0) {
                        Rowset.Row row = new Rowset.Row();
                        row.set(MdschemaFunctionsRowset.FunctionName.name, fi.getName());
                        row.set(MdschemaFunctionsRowset.Description.name, description);
                        row.set(MdschemaFunctionsRowset.ParameterList.name, "(none)");
                        row.set(MdschemaFunctionsRowset.ReturnType.name, 1);
                        row.set(MdschemaFunctionsRowset.Origin.name, 1);
                        row.set(MdschemaFunctionsRowset.InterfaceName.name, "");
                        row.set(MdschemaFunctionsRowset.Caption.name, fi.getName());
                        this.addRow(row, rows);
                        continue;
                    }
                    for (int i = 0; i < paramCategories.length; ++i) {
                        int[] pc = paramCategories[i];
                        int returnCategory = returnCategories[i];
                        Rowset.Row row = new Rowset.Row();
                        row.set(MdschemaFunctionsRowset.FunctionName.name, fi.getName());
                        row.set(MdschemaFunctionsRowset.Description.name, description);
                        buf.setLength(0);
                        for (int j = 0; j < pc.length; ++j) {
                            int v = pc[j];
                            if (j > 0) {
                                buf.append(", ");
                            }
                            buf.append(Category.instance.getDescription(v & 0x1F));
                        }
                        row.set(MdschemaFunctionsRowset.ParameterList.name, buf.toString());
                        int varType = VarType.convertCategory(returnCategory);
                        row.set(MdschemaFunctionsRowset.ReturnType.name, varType);
                        row.set(MdschemaFunctionsRowset.Origin.name, 1);
                        row.set(MdschemaFunctionsRowset.InterfaceName.name, "");
                        row.set(MdschemaFunctionsRowset.Caption.name, fi.getName());
                        this.addRow(row, rows);
                    }
                }
            }
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static class VarType
        extends EnumeratedValues.BasicValue {
            public static final int EMPTY_ORDINAL = 0;
            public static final VarType Empty = new VarType("Empty", 0, "Uninitialized (default)");
            public static final int NULL_ORDINAL = 1;
            public static final VarType Null = new VarType("Null", 1, "Contains no valid data");
            public static final int INTEGERL_ORDINAL = 2;
            public static final VarType Integer = new VarType("Integer", 2, "Integer subtype");
            public static final int LONG_ORDINAL = 3;
            public static final VarType Long = new VarType("Long", 3, "Long subtype");
            public static final int SINGLE_ORDINAL = 4;
            public static final VarType Single = new VarType("Single", 4, "Single subtype");
            public static final int DOUBLE_ORDINAL = 5;
            public static final VarType Double = new VarType("Double", 5, "Double subtype");
            public static final int CURRENCY_ORDINAL = 6;
            public static final VarType Currency = new VarType("Currency", 6, "Currency subtype");
            public static final int DATE_ORDINAL = 7;
            public static final VarType Date = new VarType("Date", 7, "Date subtype");
            public static final int STRING_ORDINAL = 8;
            public static final VarType String = new VarType("String", 8, "String subtype");
            public static final int OBJECT_ORDINAL = 9;
            public static final VarType Object = new VarType("Object", 9, "Object subtype");
            public static final int ERROR_ORDINAL = 10;
            public static final VarType Error = new VarType("Error", 10, "Error subtype");
            public static final int BOOLEAN_ORDINAL = 11;
            public static final VarType Boolean = new VarType("Boolean", 11, "Boolean subtype");
            public static final int VARIANT_ORDINAL = 12;
            public static final VarType Variant = new VarType("Variant", 12, "Variant subtype");
            public static final int DATA_OBJECT_ORDINAL = 13;
            public static final VarType DataObject = new VarType("DataObject", 13, "DataObject subtype");
            public static final int DECIMAL_ORDINAL = 14;
            public static final VarType Decimal = new VarType("Decimal", 14, "Decimal subtype");
            public static final int BYTE_ORDINAL = 17;
            public static final VarType Byte = new VarType("Byte", 17, "Byte subtype");
            public static final int ARRAY_ORDINAL = 17;
            public static final VarType Array = new VarType("Array", 17, "Array subtype");

            static int convertCategory(int category) {
                switch (category) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 17;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 13: {
                        return 12;
                    }
                    case 5: {
                        return 11;
                    }
                    case 7: {
                        return 5;
                    }
                    case 9: 
                    case 11: 
                    case 64: {
                        return 8;
                    }
                    case 15: 
                    case 31: {
                        return 2;
                    }
                }
                return 0;
            }

            public VarType(String name, int ordinal, String description) {
                super(name, ordinal, description);
            }
        }
    }

    static class MdschemaDimensionsRowset
    extends Rowset {
        private final Rowset.RistrictionTest schemaNameRT = this.getRistrictionTest(SchemaName);
        private final Rowset.RistrictionTest cubeNameRT = this.getRistrictionTest(CubeName);
        private final Rowset.RistrictionTest dimensionUniqueNameRT = this.getRistrictionTest(DimensionUniqueName);
        private final Rowset.RistrictionTest dimensionNameRT = this.getRistrictionTest(DimensionName);
        public static final int MD_DIMTYPE_OTHER = 3;
        public static final int MD_DIMTYPE_MEASURE = 2;
        public static final int MD_DIMTYPE_TIME = 1;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the database.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "Not supported.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column DimensionName = new Column("DIMENSION_NAME", Type.String, null, true, false, "The name of the dimension. ");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension.");
        private static final Column DimensionGuid = new Column("DIMENSION_GUID", Type.UUID, null, false, true, "Not supported.");
        private static final Column DimensionCaption = new Column("DIMENSION_CAPTION", Type.String, null, false, false, "The caption of the dimension.");
        private static final Column DimensionOrdinal = new Column("DIMENSION_ORDINAL", Type.UnsignedInteger, null, false, false, "The position of the dimension within the cube.");
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Short, null, false, false, "The type of the dimension.");
        private static final Column DimensionCardinality = new Column("DIMENSION_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the key attribute.");
        private static final Column DefaultHierarchy = new Column("DEFAULT_HIERARCHY", Type.String, null, false, false, "A hierarchy from the dimension. Preserved for backwards compatibility.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A user-friendly description of the dimension.");
        private static final Column IsVirtual = new Column("IS_VIRTUAL", Type.Boolean, null, false, true, "Always FALSE.");
        private static final Column IsReadWrite = new Column("IS_READWRITE", Type.Boolean, null, false, true, "A Boolean that indicates whether the dimension is write-enabled.");
        private static final Column DimensionUniqueSettings = new Column("DIMENSION_UNIQUE_SETTINGS", Type.Integer, null, false, true, "A bitmap that specifies which columns contain unique values if the dimension contains only members with unique names.");
        private static final Column DimensionMasterUniqueName = new Column("DIMENSION_MASTER_UNIQUE_NAME", Type.String, null, false, true, "Always NULL.");
        private static final Column DimensionIsVisible = new Column("DIMENSION_IS_VISIBLE", Type.Boolean, null, false, true, "Always TRUE.");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_DIMENSIONS", 13, null, new Column[]{CatalogName, SchemaName, CubeName, DimensionName, DimensionUniqueName, DimensionGuid, DimensionCaption, DimensionOrdinal, DimensionType, DimensionCardinality, DefaultHierarchy, Description, IsVirtual, IsReadWrite, DimensionUniqueSettings, DimensionMasterUniqueName, DimensionIsVisible}, new Column[]{CatalogName, SchemaName, CubeName, DimensionName}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaDimensionsRowset(request, handler);
            }
        };

        MdschemaDimensionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            for (int i = 0; i < catalogs.length; ++i) {
                Connection connection;
                String catalogName;
                DataSourcesConfig.Catalog dsCatalog = catalogs[i];
                if (dsCatalog == null || dsCatalog.definition == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name) || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List rows) throws XmlaException {
            Cube[] cubes = connection.getSchema().getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                Cube cube = cubes[i];
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List rows) throws XmlaException {
            Dimension[] dimensions = cube.getDimensions();
            for (int j = 0; j < dimensions.length; ++j) {
                Dimension dimension = dimensions[j];
                String name = dimension.getName();
                String unique = dimension.getUniqueName();
                if (!this.dimensionNameRT.passes(name) || !this.dimensionUniqueNameRT.passes(unique)) continue;
                this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
            }
        }

        protected void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List rows) throws XmlaException {
            if (!RowsetDefinition.access$200(schemaReader, dimension)) {
                return;
            }
            String desc = dimension.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + dimension.getName() + " Dimension";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaDimensionsRowset.CatalogName.name, catalogName);
            row.set(MdschemaDimensionsRowset.CubeName.name, cube.getName());
            row.set(MdschemaDimensionsRowset.DimensionName.name, dimension.getName());
            row.set(MdschemaDimensionsRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaDimensionsRowset.DimensionCaption.name, dimension.getCaption());
            row.set(MdschemaDimensionsRowset.DimensionOrdinal.name, dimension.getOrdinal(cube));
            row.set(MdschemaDimensionsRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
            Hierarchy firstHierarchy = dimension.getHierarchies()[0];
            Level[] levels = firstHierarchy.getLevels();
            Level lastLevel = levels[levels.length - 1];
            int n = schemaReader.getLevelCardinality(lastLevel, true, true);
            row.set(MdschemaDimensionsRowset.DimensionCardinality.name, n + 1);
            row.set(MdschemaDimensionsRowset.DefaultHierarchy.name, dimension.getUniqueName());
            row.set(MdschemaDimensionsRowset.Description.name, desc);
            row.set(MdschemaDimensionsRowset.IsVirtual.name, false);
            row.set(MdschemaDimensionsRowset.IsReadWrite.name, false);
            row.set(MdschemaDimensionsRowset.DimensionUniqueSettings.name, 0);
            row.set(MdschemaDimensionsRowset.DimensionIsVisible.name, true);
            this.addRow(row, rows);
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class MdschemaCubesRowset
    extends Rowset {
        private final Rowset.RistrictionTest catalogNameRT = this.getRistrictionTest(CatalogName);
        private final Rowset.RistrictionTest cubeNameRT = this.getRistrictionTest(CubeName);
        private static final String MD_CUBTYPE_CUBE = "CUBE";
        private static final String MD_CUBTYPE_VIRTUAL_CUBE = "VIRTUAL CUBE";
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this cube belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this cube belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "Name of the cube.");
        private static final Column CubeType = new Column("CUBE_TYPE", Type.String, null, true, false, "Cube type.");
        private static final Column CubeGuid = new Column("CUBE_GUID", Type.UUID, null, false, true, "Cube type.");
        private static final Column CreatedOn = new Column("CREATED_ON", Type.DateTime, null, false, true, "Date and time of cube creation.");
        private static final Column LastSchemaUpdate = new Column("LAST_SCHEMA_UPDATE", Type.DateTime, null, false, true, "Date and time of last schema update.");
        private static final Column SchemaUpdatedBy = new Column("SCHEMA_UPDATED_BY", Type.String, null, false, true, "User ID of the person who last updated the schema.");
        private static final Column LastDataUpdate = new Column("LAST_DATA_UPDATE", Type.DateTime, null, false, true, "Date and time of last data update.");
        private static final Column DataUpdatedBy = new Column("DATA_UPDATED_BY", Type.String, null, false, true, "User ID of the person who last updated the data. ");
        private static final Column IsDrillthroughEnabled = new Column("IS_DRILLTHROUGH_ENABLED", Type.Boolean, null, false, false, "Describes whether DRILLTHROUGH can be performed on the members of a cube");
        private static final Column IsWriteEnabled = new Column("IS_WRITE_ENABLED", Type.Boolean, null, false, false, "Describes whether a cube is write-enabled");
        private static final Column IsLinkable = new Column("IS_LINKABLE", Type.Boolean, null, false, false, "Describes whether a cube can be used in a linked cube");
        private static final Column IsSqlEnabled = new Column("IS_SQL_ENABLED", Type.Boolean, null, false, false, "Describes whether or not SQL can be used on the cube");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A user-friendly description of the dimension.");
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_CUBES", 12, null, new Column[]{CatalogName, SchemaName, CubeName, CubeType, CubeGuid, CreatedOn, LastSchemaUpdate, SchemaUpdatedBy, LastDataUpdate, DataUpdatedBy, IsDrillthroughEnabled, IsWriteEnabled, IsLinkable, IsSqlEnabled, Description}, new Column[]{CatalogName, SchemaName, CubeName}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaCubesRowset(request, handler);
            }
        };

        MdschemaCubesRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleStr = this.request.getRole();
            for (int h = 0; h < catalogs.length; ++h) {
                Connection connection;
                DataSourcesConfig.Catalog dsCatalog = catalogs[h];
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                String catalogName = dsCatalog.name;
                if (!this.catalogNameRT.passes(catalogName)) continue;
                RolapSchema schema = (RolapSchema)connection.getSchema();
                Cube[] cubes = schema.getCubes();
                for (int i = 0; i < cubes.length; ++i) {
                    Cube cube = cubes[i];
                    SchemaReader schemaReader = cube.getSchemaReader(role);
                    if (!RowsetDefinition.access$200(schemaReader, cube) || !this.cubeNameRT.passes(cube.getName())) continue;
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = catalogName + " Schema - " + cube.getName() + " Cube";
                    }
                    Rowset.Row row = new Rowset.Row();
                    row.set(MdschemaCubesRowset.CatalogName.name, catalogName);
                    row.set(MdschemaCubesRowset.CubeName.name, cube.getName());
                    row.set(MdschemaCubesRowset.CubeType.name, ((RolapCube)cube).isVirtual() ? MD_CUBTYPE_VIRTUAL_CUBE : MD_CUBTYPE_CUBE);
                    row.set(MdschemaCubesRowset.IsDrillthroughEnabled.name, true);
                    row.set(MdschemaCubesRowset.IsWriteEnabled.name, false);
                    row.set(MdschemaCubesRowset.IsLinkable.name, false);
                    row.set(MdschemaCubesRowset.IsSqlEnabled.name, false);
                    row.set(MdschemaCubesRowset.Description.name, desc);
                    row.set(MdschemaCubesRowset.LastSchemaUpdate.name, this.lastUpdateDate(schema));
                    this.addRow(row, rows);
                }
            }
        }

        private String lastUpdateDate(RolapSchema schema) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String formattedDate = formatter.format((Object)schema.getSchemaLoadDate());
            return formattedDate;
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class MdschemaActionsRowset
    extends Rowset {
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column Coordinate = new Column("COORDINATE", Type.String, null, true, false, null);
        private static final Column CoordinateType = new Column("COORDINATE_TYPE", Type.Integer, null, true, false, null);
        public static final RowsetDefinition definition = new RowsetDefinition("MDSCHEMA_ACTIONS", 11, null, new Column[]{CubeName, Coordinate, CoordinateType}, new Column[]{CubeName}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new MdschemaActionsRowset(request, handler);
            }
        };

        MdschemaActionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            throw new XmlaException("Client", "00HSBG01", "XMLA unsupported operation", new UnsupportedOperationException("MDSCHEMA_ACTIONS"));
        }
    }

    static class DbschemaTablesInfoRowset
    extends Rowset {
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, true, "Catalog name. NULL if the provider does not support catalogs.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, "Unqualified schema name. NULL if the provider does not support schemas.");
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "Table name.");
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, "Table type. One of the following or a provider-specific value: ALIAS, TABLE, SYNONYM, SYSTEM TABLE, VIEW, GLOBAL TEMPORARY, LOCAL TEMPORARY, EXTERNAL TABLE, SYSTEM VIEW");
        private static final Column TableGuid = new Column("TABLE_GUID", Type.UUID, null, false, true, "GUID that uniquely identifies the table. Providers that do not use GUIDs to identify tables should return NULL in this column.");
        private static final Column Bookmarks = new Column("BOOKMARKS", Type.Boolean, null, false, false, "Whether this table supports bookmarks. Allways is false.");
        private static final Column BookmarkType = new Column("BOOKMARK_TYPE", Type.Integer, null, false, true, "Default bookmark type supported on this table.");
        private static final Column BookmarkDataType = new Column("BOOKMARK_DATATYPE", Type.UnsignedShort, null, false, true, "The indicator of the bookmark's native data type.");
        private static final Column BookmarkMaximumLength = new Column("BOOKMARK_MAXIMUM_LENGTH", Type.UnsignedInteger, null, false, true, "Maximum length of the bookmark in bytes.");
        private static final Column BookmarkInformation = new Column("BOOKMARK_INFORMATION", Type.UnsignedInteger, null, false, true, "A bitmask specifying additional information about bookmarks over the rowset. ");
        private static final Column TableVersion = new Column("TABLE_VERSION", Type.Long, null, false, true, "Version number for this table or NULL if the provider does not support returning table version information.");
        private static final Column Cardinality = new Column("CARDINALITY", Type.UnsignedLong, null, false, false, "Cardinality (number of rows) of the table.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "Human-readable description of the table.");
        private static final Column TablePropId = new Column("TABLE_PROPID", Type.UnsignedInteger, null, false, true, "Property ID of the table. Return null.");
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_TABLES_INFO", 10, null, new Column[]{TableCatalog, TableSchema, TableName, TableType, TableGuid, Bookmarks, BookmarkType, BookmarkDataType, BookmarkMaximumLength, BookmarkInformation, TableVersion, Cardinality, Description, TablePropId}, null){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DbschemaTablesInfoRowset(request, handler);
            }
        };

        DbschemaTablesInfoRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String role = this.request.getRole();
            for (int h = 0; h < catalogs.length; ++h) {
                Connection connection;
                DataSourcesConfig.Catalog dsCatalog = catalogs[h];
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role)) == null) continue;
                RolapSchema schema = (RolapSchema)connection.getSchema();
                String catalogName = dsCatalog.name;
                Cube[] cubes = schema.getCubes();
                for (int i = 0; i < cubes.length; ++i) {
                    RolapCube cube = (RolapCube)cubes[i];
                    String cubeName = cube.getName();
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = catalogName + " - " + cubeName + " Cube";
                    }
                    int cardinality = 1000000;
                    String version = "null";
                    Rowset.Row row = new Rowset.Row();
                    row.set(DbschemaTablesInfoRowset.TableCatalog.name, catalogName);
                    row.set(DbschemaTablesInfoRowset.TableName.name, cubeName);
                    row.set(DbschemaTablesInfoRowset.TableType.name, "TABLE");
                    row.set(DbschemaTablesInfoRowset.Bookmarks.name, false);
                    row.set(DbschemaTablesInfoRowset.TableVersion.name, version);
                    row.set(DbschemaTablesInfoRowset.Cardinality.name, cardinality);
                    row.set(DbschemaTablesInfoRowset.Description.name, desc);
                    this.addRow(row, rows);
                }
            }
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class DbschemaTablesRowset
    extends Rowset {
        private final Rowset.RistrictionTest tableCatalogRT = this.getRistrictionTest(TableCatalog);
        private final Rowset.RistrictionTest tableNameRT = this.getRistrictionTest(TableName);
        private final Rowset.RistrictionTest tableTypeRT = this.getRistrictionTest(TableType);
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, "The name of the catalog to which this object belongs.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, "The name of the cube to which this object belongs.");
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "The name of the object, if TABLE_TYPE is TABLE.");
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, "The type of the table. TABLE indicates the object is a measure group. SYSTEM TABLE indicates the object is a dimension.");
        private static final Column TableGuid = new Column("TABLE_GUID", Type.UUID, null, false, true, "Not supported.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the object.");
        private static final Column TablePropId = new Column("TABLE_PROPID", Type.UnsignedInteger, null, false, true, "Not supported.");
        private static final Column DateCreated = new Column("DATE_CREATED", Type.DateTime, null, false, true, "Not supported.");
        private static final Column DateModified = new Column("DATE_MODIFIED", Type.DateTime, null, false, true, "The date the object was last modified.");
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_TABLES", 9, null, new Column[]{TableCatalog, TableSchema, TableName, TableType, TableGuid, Description, TablePropId, DateCreated, DateModified}, new Column[]{TableType, TableCatalog, TableSchema, TableName}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DbschemaTablesRowset(request, handler);
            }
        };

        DbschemaTablesRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleStr = this.request.getRole();
            for (int i = 0; i < catalogs.length; ++i) {
                Connection connection;
                DataSourcesConfig.Catalog dsCatalog = catalogs[i];
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                RolapSchema schema = (RolapSchema)connection.getSchema();
                String catalogName = dsCatalog.name;
                if (!this.tableCatalogRT.passes(catalogName)) continue;
                Cube[] cubes = schema.getCubes();
                Rowset.Row row = null;
                for (int j = 0; j < cubes.length; ++j) {
                    RolapCube cube = (RolapCube)cubes[j];
                    String cubeName = cube.getName();
                    String tableName = cubeName;
                    if (!this.tableNameRT.passes(tableName)) continue;
                    SchemaReader schemaReader = cube.getSchemaReader(role);
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = catalogName + " - " + cubeName + " Cube";
                    }
                    if (this.tableTypeRT.passes("TABLE")) {
                        row = new Rowset.Row();
                        row.set(DbschemaTablesRowset.TableCatalog.name, catalogName);
                        row.set(DbschemaTablesRowset.TableName.name, tableName);
                        row.set(DbschemaTablesRowset.TableType.name, "TABLE");
                        row.set(DbschemaTablesRowset.Description.name, desc);
                        this.addRow(row, rows);
                    }
                    if (!this.tableTypeRT.passes("SYSTEM TABLE")) continue;
                    Dimension[] dims = cube.getDimensions();
                    for (int k = 1; k < dims.length; ++k) {
                        Dimension dimension = dims[k];
                        Hierarchy[] hierarchies = dimension.getHierarchies();
                        for (int h = 0; h < hierarchies.length; ++h) {
                            HierarchyBase hierarchy = (HierarchyBase)hierarchies[h];
                            this.populateHierarchy(schemaReader, cube, hierarchy, rows);
                        }
                    }
                }
            }
        }

        private void populateHierarchy(SchemaReader schemaReader, RolapCube cube, HierarchyBase hierarchy, List rows) {
            if (!RowsetDefinition.access$200(schemaReader, hierarchy)) {
                return;
            }
            Level[] levels = hierarchy.getLevels();
            for (int k = 0; k < levels.length; ++k) {
                Level level = levels[k];
                this.populateLevel(cube, hierarchy, level, rows);
            }
        }

        private void populateLevel(RolapCube cube, HierarchyBase hierarchy, Level level, List rows) {
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            String levelName = level.getName();
            String tableName = cubeName + ':' + hierarchyName + ':' + levelName;
            String desc = level.getDescription();
            if (desc == null) {
                desc = schemaName + " - " + cubeName + " Cube - " + hierarchyName + " Hierarchy - " + levelName + " Level";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(DbschemaTablesRowset.TableCatalog.name, schemaName);
            row.set(DbschemaTablesRowset.TableName.name, tableName);
            row.set(DbschemaTablesRowset.TableType.name, "SYSTEM TABLE");
            row.set(DbschemaTablesRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class DbschemaProviderTypesRowset
    extends Rowset {
        private final Rowset.RistrictionTest dataTypeRT = this.getRistrictionTest(DataType);
        private static final Column TypeName = new Column("TYPE_NAME", Type.String, null, false, false, "The provider-specific data type name.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, true, false, "The indicator of the data type.");
        private static final Column ColumnSize = new Column("COLUMN_SIZE", Type.UnsignedInteger, null, false, false, "The length of a non-numeric column. If the data type is numeric, this is the upper bound on the maximum precision of the data type.");
        private static final Column LiteralPrefix = new Column("LITERAL_PREFIX", Type.String, null, false, true, "The character or characters used to prefix a literal of this type in a text command.");
        private static final Column LiteralSuffix = new Column("LITERAL_SUFFIX", Type.String, null, false, true, "The character or characters used to suffix a literal of this type in a text command.");
        private static final Column IsNullable = new Column("IS_NULLABLE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is nullable. NULL-- indicates that it is not known whether the data type is nullable.");
        private static final Column CaseSensitive = new Column("CASE_SENSITIVE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is a characters type and case-sensitive.");
        private static final Column Searchable = new Column("SEARCHABLE", Type.UnsignedInteger, null, false, true, "An integer indicating how the data type can be used in searches if the provider supports ICommandText; otherwise, NULL.");
        private static final Column UnsignedAttribute = new Column("UNSIGNED_ATTRIBUTE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is unsigned.");
        private static final Column FixedPrecScale = new Column("FIXED_PREC_SCALE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type has a fixed precision and scale.");
        private static final Column AutoUniqueValue = new Column("AUTO_UNIQUE_VALUE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is autoincrementing.");
        private static final Column IsLong = new Column("IS_LONG", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is a binary large object (BLOB) and has very long data.");
        private static final Column BestMatch = new Column("BEST_MATCH", Type.Boolean, null, true, true, "A Boolean that indicates whether the data type is a best match.");
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_PROVIDER_TYPES", 8, null, new Column[]{TypeName, DataType, ColumnSize, LiteralPrefix, LiteralSuffix, IsNullable, CaseSensitive, Searchable, UnsignedAttribute, FixedPrecScale, AutoUniqueValue, IsLong, BestMatch}, new Column[]{DataType}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DbschemaProviderTypesRowset(request, handler);
            }
        };

        DbschemaProviderTypesRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            Rowset.Row row = null;
            Integer dt = new Integer(3);
            if (this.dataTypeRT.passes(dt)) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.I4.name);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 8);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = new Integer(5))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.R8.name);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 16);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = new Integer(6))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.CY.name);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 8);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = new Integer(11))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.BOOL.name);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 1);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = new Integer(20))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.I8.name);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 16);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = new Integer(130))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.WSTR.name);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 255);
                row.set(DbschemaProviderTypesRowset.LiteralPrefix.name, "\"");
                row.set(DbschemaProviderTypesRowset.LiteralSuffix.name, "\"");
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.CaseSensitive.name, false);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class DbschemaColumnsRowset
    extends Rowset {
        private final Rowset.RistrictionTest tableCatalogRT = this.getRistrictionTest(TableCatalog);
        private final Rowset.RistrictionTest tableNameRT = this.getRistrictionTest(TableName);
        private final Rowset.RistrictionTest columnNameRT = this.getRistrictionTest(ColumnName);
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, "The name of the Database.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, null);
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column ColumnName = new Column("COLUMN_NAME", Type.String, null, true, false, "The name of the attribute hierarchy or measure.");
        private static final Column OrdinalPosition = new Column("ORDINAL_POSITION", Type.UnsignedInteger, null, false, false, "The position of the column, beginning with 1.");
        private static final Column ColumnHasDefault = new Column("COLUMN_HAS_DEFAULT", Type.Boolean, null, false, true, "Not supported.");
        private static final Column ColumnFlags = new Column("COLUMN_FLAGS", Type.UnsignedInteger, null, false, false, "A DBCOLUMNFLAGS bitmask indicating column properties.");
        private static final Column IsNullable = new Column("IS_NULLABLE", Type.Boolean, null, false, false, "Always returns false.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "The data type of the column. Returns a string for dimension columns and a variant for measures.");
        private static final Column CharacterMaximumLength = new Column("CHARACTER_MAXIMUM_LENGTH", Type.UnsignedInteger, null, false, true, "The maximum possible length of a value within the column.");
        private static final Column CharacterOctetLength = new Column("CHARACTER_OCTET_LENGTH", Type.UnsignedInteger, null, false, true, "The maximum possible length of a value within the column, in bytes, for character or binary columns.");
        private static final Column NumericPrecision = new Column("NUMERIC_PRECISION", Type.UnsignedShort, null, false, true, "The maximum precision of the column for numeric data types other than DBTYPE_VARNUMERIC.");
        private static final Column NumericScale = new Column("NUMERIC_SCALE", Type.Short, null, false, true, "The number of digits to the right of the decimal point for DBTYPE_DECIMAL, DBTYPE_NUMERIC, DBTYPE_VARNUMERIC. Otherwise, this is NULL.");
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_COLUMNS", 7, null, new Column[]{TableCatalog, TableSchema, TableName, ColumnName, OrdinalPosition, ColumnHasDefault, ColumnFlags, IsNullable, DataType, CharacterMaximumLength, CharacterOctetLength, NumericPrecision, NumericScale}, new Column[]{TableCatalog, TableSchema, TableName}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DbschemaColumnsRowset(request, handler);
            }
        };

        DbschemaColumnsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = ds.catalogs.catalogs;
            String roleStr = this.request.getRole();
            for (int g = 0; g < catalogs.length; ++g) {
                Connection connection;
                DataSourcesConfig.Catalog dsCatalog = catalogs[g];
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                RolapSchema schema = (RolapSchema)connection.getSchema();
                String catalogName = dsCatalog.name;
                if (!this.tableCatalogRT.passes(catalogName)) continue;
                Cube[] cubes = schema.getCubes();
                int ordinalPosition = 1;
                Rowset.Row row = null;
                for (int i = 0; i < cubes.length; ++i) {
                    RolapCube cube = (RolapCube)cubes[i];
                    SchemaReader schemaReader = cube.getSchemaReader(role);
                    String cubeName = cube.getName();
                    if (!this.tableNameRT.passes(cubeName)) continue;
                    Dimension[] dims = cube.getDimensions();
                    for (int j = 1; j < dims.length; ++j) {
                        Dimension dimension = dims[j];
                        Hierarchy[] hierarchies = dimension.getHierarchies();
                        for (int h = 0; h < hierarchies.length; ++h) {
                            HierarchyBase hierarchy = (HierarchyBase)hierarchies[h];
                            ordinalPosition = this.populateHierarchy(schemaReader, cube, hierarchy, ordinalPosition, rows);
                        }
                    }
                    RolapMember[] rms = cube.getMeasuresMembers();
                    for (int k = 1; k < rms.length; ++k) {
                        RolapMember member = rms[k];
                        Boolean isVisible = (Boolean)member.getPropertyValue(Property.VISIBLE.name);
                        if (isVisible != null && !isVisible.booleanValue()) continue;
                        String memberName = member.getName();
                        if (!this.columnNameRT.passes("Measures:" + memberName)) continue;
                        row = new Rowset.Row();
                        row.set(DbschemaColumnsRowset.TableCatalog.name, catalogName);
                        row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                        row.set(DbschemaColumnsRowset.ColumnName.name, "Measures:" + memberName);
                        row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                        row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                        row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                        row.set(DbschemaColumnsRowset.IsNullable.name, false);
                        row.set(DbschemaColumnsRowset.DataType.name, 5);
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 16);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        this.addRow(row, rows);
                    }
                }
            }
        }

        private int populateHierarchy(SchemaReader schemaReader, RolapCube cube, HierarchyBase hierarchy, int ordinalPosition, List rows) {
            if (!RowsetDefinition.access$200(schemaReader, hierarchy)) {
                return ordinalPosition;
            }
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            if (hierarchy.hasAll()) {
                Rowset.Row row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ":(All)!NAME");
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                row.set(DbschemaColumnsRowset.DataType.name, 130);
                row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                this.addRow(row, rows);
                row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ":(All)!UNIQUE_NAME");
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                row.set(DbschemaColumnsRowset.DataType.name, 130);
                row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                this.addRow(row, rows);
            }
            Level[] levels = hierarchy.getLevels();
            for (int k = 0; k < levels.length; ++k) {
                Level level = levels[k];
                ordinalPosition = this.populateLevel(cube, hierarchy, level, ordinalPosition, rows);
            }
            return ordinalPosition;
        }

        private int populateLevel(Cube cube, HierarchyBase hierarchy, Level level, int ordinalPosition, List rows) {
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            String levelName = level.getName();
            Rowset.Row row = new Rowset.Row();
            row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
            row.set(DbschemaColumnsRowset.TableName.name, cubeName);
            row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ':' + levelName + "!NAME");
            row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
            row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
            row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
            row.set(DbschemaColumnsRowset.IsNullable.name, false);
            row.set(DbschemaColumnsRowset.DataType.name, 130);
            row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
            row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
            this.addRow(row, rows);
            row = new Rowset.Row();
            row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
            row.set(DbschemaColumnsRowset.TableName.name, cubeName);
            row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ':' + levelName + "!UNIQUE_NAME");
            row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
            row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
            row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
            row.set(DbschemaColumnsRowset.IsNullable.name, false);
            row.set(DbschemaColumnsRowset.DataType.name, 130);
            row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
            row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
            this.addRow(row, rows);
            Property[] props = level.getProperties();
            for (int m = 0; m < props.length; ++m) {
                Property prop = props[m];
                String propName = prop.getName();
                row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ':' + levelName + '!' + propName);
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                DBType dbType = RowsetDefinition.access$300(prop);
                row.set(DbschemaColumnsRowset.DataType.name, dbType.getOrdinal());
                switch (prop.getType()) {
                    case 0: {
                        row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                        row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                        break;
                    }
                    case 1: {
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 16);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        break;
                    }
                    case 2: {
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 255);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        break;
                    }
                    case 3: {
                        row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                        row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                    }
                }
                this.addRow(row, rows);
            }
            return ordinalPosition;
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class DbschemaCatalogsRowset
    extends Rowset {
        private final Rowset.RistrictionTest catalogNameRT = this.getRistrictionTest(CatalogName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, "Catalog name. Cannot be NULL.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, false, "Human-readable description of the catalog.");
        private static final Column Roles = new Column("ROLES", Type.String, null, false, false, "A comma delimited list of roles to which the current user belongs. An asterisk (*) is included as a role if the current user is a server or database administrator. Username is appended to ROLES if one of the roles uses dynamic security.");
        private static final Column DateModified = new Column("DATE_MODIFIED", Type.DateTime, null, false, true, "The date that the catalog was last modified.");
        public static final RowsetDefinition definition = new RowsetDefinition("DBSCHEMA_CATALOGS", 6, "Returns information about literals supported by the provider.", new Column[]{CatalogName, Description, Roles, DateModified}, new Column[]{CatalogName}){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DbschemaCatalogsRowset(request, handler);
            }
        };

        DbschemaCatalogsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = ds.catalogs.catalogs;
            String role = this.request.getRole();
            for (int i = 0; i < catalogs.length; ++i) {
                Connection connection;
                DataSourcesConfig.Catalog dsCatalog = catalogs[i];
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role)) == null || !this.catalogNameRT.passes(dsCatalog.name)) continue;
                RolapSchema schema = (RolapSchema)connection.getSchema();
                Rowset.Row row = new Rowset.Row();
                row.set(DbschemaCatalogsRowset.CatalogName.name, dsCatalog.name);
                row.set(DbschemaCatalogsRowset.Description.name, "No description available");
                StringBuffer buf = new StringBuffer(100);
                Iterator roleNamesIt = schema.roleNames().iterator();
                while (roleNamesIt.hasNext()) {
                    String roleName = (String)roleNamesIt.next();
                    buf.append(roleName);
                    if (!roleNamesIt.hasNext()) continue;
                    buf.append(',');
                }
                row.set(DbschemaCatalogsRowset.Roles.name, buf.toString());
                this.addRow(row, rows);
            }
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class DiscoverLiteralsRowset
    extends Rowset {
        private static final Column LiteralName = new Column("LiteralName", Type.StringSometimesArray, null, true, false, "The name of the literal described in the row.\nExample: DBLITERAL_LIKE_PERCENT");
        private static final Column LiteralValue = new Column("LiteralValue", Type.String, null, false, false, "Contains the actual literal value.\nExample, if LiteralName is DBLITERAL_LIKE_PERCENT and the percent character (%) is used to match zero or more characters in a LIKE clause, this column's value would be \"%\".");
        private static final Column LiteralInvalidChars = new Column("LiteralInvalidChars", Type.String, null, false, false, "The characters, in the literal, that are not valid.\nFor example, if table names can contain anything other than a numeric character, this string would be \"0123456789\".");
        private static final Column LiteralInvalidStartingChars = new Column("LiteralInvalidStartingChars", Type.String, null, false, false, "The characters that are not valid as the first character of the literal. If the literal can start with any valid character, this is null.");
        private static final Column LiteralMaxLength = new Column("LiteralMaxLength", Type.Integer, null, false, false, "The maximum number of characters in the literal. If there is no maximum or the maximum is unknown, the value is ?1.");
        public static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_LITERALS", 5, "Returns information about literals supported by the provider.", new Column[]{LiteralName, LiteralValue, LiteralInvalidChars, LiteralInvalidStartingChars, LiteralMaxLength}, null){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DiscoverLiteralsRowset(request, handler);
            }
        };

        DiscoverLiteralsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            this.emit(Enumeration.Literal.enumeration, response);
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class DiscoverKeywordsRowset
    extends Rowset {
        private static final Column Keyword = new Column("Keyword", Type.StringSometimesArray, null, true, false, "A list of all the keywords reserved by a provider.\nExample: AND");
        public static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_KEYWORDS", 4, "Returns an XML list of keywords reserved by the provider.", new Column[]{Keyword}, null){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DiscoverKeywordsRowset(request, handler);
            }
        };
        private static final String[] keywords = new String[]{"$AdjustedProbability", "$Distance", "$Probability", "$ProbabilityStDev", "$ProbabilityStdDeV", "$ProbabilityVariance", "$StDev", "$StdDeV", "$Support", "$Variance", "AddCalculatedMembers", "Action", "After", "Aggregate", "All", "Alter", "Ancestor", "And", "Append", "As", "ASC", "Axis", "Automatic", "Back_Color", "BASC", "BDESC", "Before", "Before_And_After", "Before_And_Self", "Before_Self_After", "BottomCount", "BottomPercent", "BottomSum", "Break", "Boolean", "Cache", "Calculated", "Call", "Case", "Catalog_Name", "Cell", "Cell_Ordinal", "Cells", "Chapters", "Children", "Children_Cardinality", "ClosingPeriod", "Cluster", "ClusterDistance", "ClusterProbability", "Clusters", "CoalesceEmpty", "Column_Values", "Columns", "Content", "Contingent", "Continuous", "Correlation", "Cousin", "Covariance", "CovarianceN", "Create", "CreatePropertySet", "CrossJoin", "Cube", "Cube_Name", "CurrentMember", "CurrentCube", "Custom", "Cyclical", "DefaultMember", "Default_Member", "DESC", "Descendents", "Description", "Dimension", "Dimension_Unique_Name", "Dimensions", "Discrete", "Discretized", "DrillDownLevel", "DrillDownLevelBottom", "DrillDownLevelTop", "DrillDownMember", "DrillDownMemberBottom", "DrillDownMemberTop", "DrillTrough", "DrillUpLevel", "DrillUpMember", "Drop", "Else", "Empty", "End", "Equal_Areas", "Exclude_Null", "ExcludeEmpty", "Exclusive", "Expression", "Filter", "FirstChild", "FirstRowset", "FirstSibling", "Flattened", "Font_Flags", "Font_Name", "Font_size", "Fore_Color", "Format_String", "Formatted_Value", "Formula", "From", "Generate", "Global", "Head", "Hierarchize", "Hierarchy", "Hierary_Unique_name", "IIF", "IsEmpty", "Include_Null", "Include_Statistics", "Inclusive", "Input_Only", "IsDescendant", "Item", "Lag", "LastChild", "LastPeriods", "LastSibling", "Lead", "Level", "Level_Unique_Name", "Levels", "LinRegIntercept", "LinRegR2", "LinRegPoint", "LinRegSlope", "LinRegVariance", "Long", "MaxRows", "Median", "Member", "Member_Caption", "Member_Guid", "Member_Name", "Member_Ordinal", "Member_Type", "Member_Unique_Name", "Members", "Microsoft_Clustering", "Microsoft_Decision_Trees", "Mining", "Model", "Model_Existence_Only", "Models", "Move", "MTD", "Name", "Nest", "NextMember", "Non", "Normal", "Not", "Ntext", "Nvarchar", "OLAP", "On", "OpeningPeriod", "OpenQuery", "Or", "Ordered", "Ordinal", "Pages", "Pages", "ParallelPeriod", "Parent", "Parent_Level", "Parent_Unique_Name", "PeriodsToDate", "PMML", "Predict", "Predict_Only", "PredictAdjustedProbability", "PredictHistogram", "Prediction", "PredictionScore", "PredictProbability", "PredictProbabilityStDev", "PredictProbabilityVariance", "PredictStDev", "PredictSupport", "PredictVariance", "PrevMember", "Probability", "Probability_StDev", "Probability_StdDev", "Probability_Variance", "Properties", "Property", "QTD", "RangeMax", "RangeMid", "RangeMin", "Rank", "Recursive", "Refresh", "Related", "Rename", "Rollup", "Rows", "Schema_Name", "Sections", "Select", "Self", "Self_And_After", "Sequence_Time", "Server", "Session", "Set", "SetToArray", "SetToStr", "Shape", "Skip", "Solve_Order", "Sort", "StdDev", "Stdev", "StripCalculatedMembers", "StrToSet", "StrToTuple", "SubSet", "Support", "Tail", "Text", "Thresholds", "ToggleDrillState", "TopCount", "TopPercent", "TopSum", "TupleToStr", "Under", "Uniform", "UniqueName", "Use", "Value", "Value", "Var", "Variance", "VarP", "VarianceP", "VisualTotals", "When", "Where", "With", "WTD", "Xor"};

        DiscoverKeywordsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            for (int i = 0; i < keywords.length; ++i) {
                String keyword = keywords[i];
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverKeywordsRowset.Keyword.name, keyword);
                this.addRow(row, rows);
            }
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class DiscoverEnumeratorsRowset
    extends Rowset {
        private static final Column EnumName = new Column("EnumName", Type.StringArray, null, true, false, "The name of the enumerator that contains a set of values.");
        private static final Column EnumDescription = new Column("EnumDescription", Type.String, null, false, true, "A localizable description of the enumerator.");
        private static final Column EnumType = new Column("EnumType", Type.String, null, false, false, "The data type of the Enum values.");
        private static final Column ElementName = new Column("ElementName", Type.String, null, false, false, "The name of one of the value elements in the enumerator set.\nExample: TDP");
        private static final Column ElementDescription = new Column("ElementDescription", Type.String, null, false, true, "A localizable description of the element (optional).");
        private static final Column ElementValue = new Column("ElementValue", Type.String, null, false, true, "The value of the element.\nExample: 01");
        public static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_ENUMERATORS", 3, "Returns a list of names, data types, and enumeration values for enumerators supported by the provider of a specific data source.", new Column[]{EnumName, EnumDescription, EnumType, ElementName, ElementDescription, ElementValue}, null){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DiscoverEnumeratorsRowset(request, handler);
            }
        };

        DiscoverEnumeratorsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            Enumeration[] enumerators = DiscoverEnumeratorsRowset.getEnumerators();
            for (int i = 0; i < enumerators.length; ++i) {
                Enumeration enumerator = enumerators[i];
                String[] valueNames = enumerator.getNames();
                for (int j = 0; j < valueNames.length; ++j) {
                    String valueName = valueNames[j];
                    EnumeratedValues.Value value = enumerator.getValue(valueName, true);
                    Rowset.Row row = new Rowset.Row();
                    row.set(DiscoverEnumeratorsRowset.EnumName.name, enumerator.name);
                    row.set(DiscoverEnumeratorsRowset.EnumDescription.name, enumerator.description);
                    row.set(DiscoverEnumeratorsRowset.EnumType.name, "string");
                    row.set(DiscoverEnumeratorsRowset.ElementName.name, value.getName());
                    row.set(DiscoverEnumeratorsRowset.ElementDescription.name, value.getDescription());
                    switch (enumerator.type.ordinal) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            row.set(DiscoverEnumeratorsRowset.ElementValue.name, value.getOrdinal());
                        }
                    }
                    this.addRow(row, rows);
                }
            }
        }

        private static Enumeration[] getEnumerators() {
            HashSet<Enumeration> enumeratorSet = new HashSet<Enumeration>();
            String[] rowsetNames = enumeration.getNames();
            for (int i = 0; i < rowsetNames.length; ++i) {
                String rowsetName = rowsetNames[i];
                RowsetDefinition rowsetDefinition = (RowsetDefinition)enumeration.getValue(rowsetName, true);
                for (int j = 0; j < rowsetDefinition.columnDefinitions.length; ++j) {
                    Column column = rowsetDefinition.columnDefinitions[j];
                    if (column.enumeration == null) continue;
                    enumeratorSet.add(column.enumeration);
                }
            }
            Object[] enumerators = enumeratorSet.toArray(new Enumeration[enumeratorSet.size()]);
            Arrays.sort((Object[])enumerators, (Comparator)new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Enumeration)o1).name.compareTo(((Enumeration)o2).name);
                }
            });
            return enumerators;
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class DiscoverPropertiesRowset
    extends Rowset {
        private final Rowset.RistrictionTest propertyNameRT = this.getRistrictionTest(PropertyName);
        private static final Column PropertyName = new Column("PropertyName", Type.StringSometimesArray, null, true, false, "The name of the property.");
        private static final Column PropertyDescription = new Column("PropertyDescription", Type.String, null, false, false, "A localizable text description of the property.");
        private static final Column PropertyType = new Column("PropertyType", Type.String, null, false, false, "The XML data type of the property.");
        private static final Column PropertyAccessType = new Column("PropertyAccessType", Type.EnumString, Enumeration.Access.enumeration, false, false, "Access for the property. The value can be Read, Write, or ReadWrite.");
        private static final Column IsRequired = new Column("IsRequired", Type.Boolean, null, false, false, "True if a property is required, false if it is not required.");
        private static final Column Value = new Column("Value", Type.String, null, false, false, "The current value of the property.");
        public static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_PROPERTIES", 1, "Returns a list of information and values about the requested properties that are supported by the specified data source provider.", new Column[]{PropertyName, PropertyDescription, PropertyType, PropertyAccessType, IsRequired, Value}, null){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DiscoverPropertiesRowset(request, handler);
            }
        };

        DiscoverPropertiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            String[] propertyNames = PropertyDefinition.enumeration.getNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                String pname = propertyNames[i];
                if (!this.propertyNameRT.passes(pname)) continue;
                PropertyDefinition propertyDefinition = PropertyDefinition.getValue(pname);
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverPropertiesRowset.PropertyName.name, propertyDefinition.name);
                row.set(DiscoverPropertiesRowset.PropertyDescription.name, propertyDefinition.description);
                row.set(DiscoverPropertiesRowset.PropertyType.name, propertyDefinition.type);
                row.set(DiscoverPropertiesRowset.PropertyAccessType.name, propertyDefinition.access);
                row.set(DiscoverPropertiesRowset.IsRequired.name, false);
                row.set(DiscoverPropertiesRowset.Value.name, propertyDefinition.value);
                this.addRow(row, rows);
            }
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class DiscoverSchemaRowsetsRowset
    extends Rowset {
        private static final Column SchemaName = new Column("SchemaName", Type.StringArray, null, true, false, "The name of the schema/request. This returns the values in the RequestTypes enumeration, plus any additional types supported by the provider. The provider defines rowset structures for the additional types");
        private static final Column SchemaGuid = new Column("SchemaGuid", Type.UUID, null, false, true, "The GUID of the schema.");
        private static final Column Restrictions = new Column("Restrictions", Type.Array, null, false, false, "An array of the restrictions suppoted by provider. An example follows this table.");
        private static final Column Description = new Column("Description", Type.String, null, false, false, "A localizable description of the schema");
        private static RowsetDefinition definition = new RowsetDefinition("DISCOVER_SCHEMA_ROWSETS", 2, "Returns the names, values, and other information of all supported RequestType enumeration values.", new Column[]{SchemaName, SchemaGuid, Restrictions, Description}, null){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DiscoverSchemaRowsetsRowset(request, handler);
            }

            protected void writeRowsetXmlSchemaRowDef(SaxWriter writer) {
                writer.startElement("xsd:complexType", new String[]{"name", "row"});
                writer.startElement("xsd:sequence");
                for (int i = 0; i < this.columnDefinitions.length; ++i) {
                    Column column = this.columnDefinitions[i];
                    String name = XmlaUtil.encodeElementName(column.name);
                    if (column == DiscoverSchemaRowsetsRowset.access$100()) {
                        writer.startElement("xsd:element", new String[]{"sql:field", column.name, "name", name, "minOccurs", "0", "maxOccurs", "unbounded"});
                        writer.startElement("xsd:complexType");
                        writer.startElement("xsd:sequence");
                        writer.element("xsd:element", new String[]{"name", "Name", "type", "xsd:string", "sql:field", "Name"});
                        writer.element("xsd:element", new String[]{"name", "Type", "type", "xsd:string", "sql:field", "Type"});
                        writer.endElement();
                        writer.endElement();
                        writer.endElement();
                        continue;
                    }
                    String xsdType = column.type.columnType;
                    String[] attrs = null;
                    attrs = column.nullable ? (column.unbounded ? new String[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", "0", "maxOccurs", "unbounded"} : new String[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", "0"}) : (column.unbounded ? new String[]{"sql:field", column.name, "name", name, "type", xsdType, "maxOccurs", "unbounded"} : new String[]{"sql:field", column.name, "name", name, "type", xsdType});
                    writer.element("xsd:element", attrs);
                }
                writer.endElement();
                writer.endElement();
            }
        };

        public DiscoverSchemaRowsetsRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            RowsetDefinition[] rowsetDefinitions = enumeration.getValuesSortedByName().toArray(new RowsetDefinition[0]);
            for (int i = 0; i < rowsetDefinitions.length; ++i) {
                RowsetDefinition rowsetDefinition = rowsetDefinitions[i];
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverSchemaRowsetsRowset.SchemaName.name, rowsetDefinition.name);
                row.set(DiscoverSchemaRowsetsRowset.Restrictions.name, this.getRestrictions(rowsetDefinition));
                String desc = rowsetDefinition.description;
                row.set(DiscoverSchemaRowsetsRowset.Description.name, desc == null ? "" : desc);
                this.addRow(row, rows);
            }
        }

        private Rowset.XmlElement[] getRestrictions(RowsetDefinition rowsetDefinition) {
            ArrayList<Rowset.XmlElement> restrictionList = new ArrayList<Rowset.XmlElement>();
            Column[] columns = rowsetDefinition.columnDefinitions;
            for (int j = 0; j < columns.length; ++j) {
                Column column = columns[j];
                if (!column.restriction) continue;
                restrictionList.add((Rowset)this.new Rowset.XmlElement(DiscoverSchemaRowsetsRowset.Restrictions.name, null, new Rowset.XmlElement[]{(Rowset)this.new Rowset.XmlElement("Name", null, column.name), (Rowset)this.new Rowset.XmlElement("Type", null, column.getColumnType())}));
            }
            Rowset.XmlElement[] restrictions = restrictionList.toArray(new Rowset.XmlElement[restrictionList.size()]);
            return restrictions;
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static RowsetDefinition access$000() {
            return definition;
        }

        static Column access$100() {
            return Restrictions;
        }
    }

    static class DiscoverDatasourcesRowset
    extends Rowset {
        private static final Column DataSourceName = new Column("DataSourceName", Type.String, null, true, false, "The name of the data source, such as FoodMart 2000.");
        private static final Column DataSourceDescription = new Column("DataSourceDescription", Type.String, null, false, true, "A description of the data source, as entered by the publisher.");
        private static final Column URL = new Column("URL", Type.String, null, true, true, "The unique path that shows where to invoke the XML for Analysis methods for that data source.");
        private static final Column DataSourceInfo = new Column("DataSourceInfo", Type.String, null, false, true, "A string containing any additional information required to connect to the data source. This can include the Initial Catalog property or other information for the provider.\nExample: \"Provider=MSOLAP;Data Source=Local;\"");
        private static final Column ProviderName = new Column("ProviderName", Type.String, null, true, true, "The name of the provider behind the data source. \nExample: \"MSDASQL\"");
        private static final Column ProviderType = new Column("ProviderType", Type.EnumerationArray, Enumeration.ProviderType.enumeration, true, false, true, "The types of data supported by the provider. May include one or more of the following types. Example follows this table.\nTDP: tabular data provider.\nMDP: multidimensional data provider.\nDMP: data mining provider. A DMP provider implements the OLE DB for Data Mining specification.");
        private static final Column AuthenticationMode = new Column("AuthenticationMode", Type.EnumString, Enumeration.AuthenticationMode.enumeration, true, false, "Specification of what type of security mode the data source uses. Values can be one of the following:\nUnauthenticated: no user ID or password needs to be sent.\nAuthenticated: User ID and Password must be included in the information required for the connection.\nIntegrated: the data source uses the underlying security to determine authorization, such as Integrated Security provided by Microsoft Internet Information Services (IIS).");
        static final RowsetDefinition definition = new RowsetDefinition("DISCOVER_DATASOURCES", 0, "Returns a list of XML for Analysis data sources available on the server or Web Service.", new Column[]{DataSourceName, DataSourceDescription, URL, DataSourceInfo, ProviderName, ProviderType, AuthenticationMode}, null){

            public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
                return new DiscoverDatasourcesRowset(request, handler);
            }
        };

        public DiscoverDatasourcesRowset(XmlaRequest request, XmlaHandler handler) {
            super(definition, request, handler);
        }

        public void populate(XmlaResponse response, List rows) throws XmlaException {
            Iterator it = this.handler.getDataSourceEntries().values().iterator();
            while (it.hasNext()) {
                DataSourcesConfig.DataSource ds = (DataSourcesConfig.DataSource)((Object)it.next());
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverDatasourcesRowset.DataSourceName.name, ds.getDataSourceName());
                row.set(DiscoverDatasourcesRowset.DataSourceDescription.name, ds.getDataSourceDescription());
                row.set(DiscoverDatasourcesRowset.URL.name, ds.getURL());
                row.set(DiscoverDatasourcesRowset.DataSourceInfo.name, ds.getDataSourceName());
                row.set(DiscoverDatasourcesRowset.ProviderName.name, ds.getProviderName());
                row.set(DiscoverDatasourcesRowset.ProviderType.name, ds.getProviderType());
                row.set(DiscoverDatasourcesRowset.AuthenticationMode.name, ds.getAuthenticationMode());
                this.addRow(row, rows);
            }
        }

        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef.ordinal) {
                case 3: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }
    }

    static class Column {
        static final boolean RESTRICTION = true;
        static final boolean NOT_RESTRICTION = false;
        static final boolean REQUIRED = false;
        static final boolean OPTIONAL = true;
        static final boolean ONE_MAX = false;
        static final boolean UNBOUNDED = true;
        final String name;
        final Type type;
        final Enumeration enumeration;
        final String description;
        final boolean restriction;
        final boolean nullable;
        final boolean unbounded;

        Column(String name, Type type, Enumeration enumeratedType, boolean restriction, boolean nullable, String description) {
            this(name, type, enumeratedType, restriction, nullable, false, description);
        }

        Column(String name, Type type, Enumeration enumeratedType, boolean restriction, boolean nullable, boolean unbounded, String description) {
            Util.assertPrecondition(type != null, "Type.instance.isValid(type)");
            Util.assertPrecondition((type == Type.Enumeration || type == Type.EnumerationArray || type == Type.EnumString) == (enumeratedType != null), "(type == Type.Enumeration || type == Type.EnumerationArray || type == Type.EnumString) == (enumeratedType != null)");
            Util.assertPrecondition(description == null || description.indexOf(13) == -1, "description == null || description.indexOf('\r') == -1");
            this.name = name;
            this.type = type;
            this.enumeration = enumeratedType;
            this.description = description;
            this.restriction = restriction;
            this.nullable = nullable;
            this.unbounded = unbounded;
        }

        Object get(Object row) {
            try {
                String javaFieldName = this.name.substring(0, 1).toLowerCase() + this.name.substring(1);
                Field field = row.getClass().getField(javaFieldName);
                return field.get(row);
            }
            catch (NoSuchFieldException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (SecurityException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
        }

        public String getColumnType() {
            if (this.type.isEnum()) {
                return this.enumeration.type.columnType;
            }
            return this.type.columnType;
        }
    }

    static class DBType
    extends EnumeratedValues.BasicValue {
        public static final int I4_ORDINAL = 3;
        public static final DBType I4 = new DBType("INTEGER", 3, "A four-byte, signed integer: INTEGER", "DBTYPE_I4");
        public static final int R8_ORDINAL = 5;
        public static final DBType R8 = new DBType("DOUBLE", 5, "A double-precision floating-point value: Double", "DBTYPE_R8");
        public static final int CY_ORDINAL = 6;
        public static final DBType CY = new DBType("CURRENCY", 6, "A currency value: LARGE_INTEGER, Currency is a fixed-point number with four digits to the right of the decimal point. It is stored in an eight-byte signed integer, scaled by 10,000.", "DBTYPE_CY");
        public static final int BOOL_ORDINAL = 11;
        public static final DBType BOOL = new DBType("BOOLEAN", 11, "A Boolean value stored in the same way as in Automation: VARIANT_BOOL; 0 means false and ~0 (bitwise, the value is not 0; that is, all bits are set to 1) means true.", "DBTYPE_BOOL");
        public static final int VARIANT_ORDINAL = 12;
        public static final DBType VARIANT = new DBType("VARIANT", 12, "An Automation VARIANT", "DBTYPE_VARIANT");
        public static final int UI2_ORDINAL = 18;
        public static final DBType UI2 = new DBType("UNSIGNED_SHORT", 18, "A two-byte, unsigned integer", "DBTYPE_UI2");
        public static final int UI4_ORDINAL = 19;
        public static final DBType UI4 = new DBType("UNSIGNED_INTEGER", 19, "A four-byte, unsigned integer", "DBTYPE_UI4");
        public static final int I8_ORDINAL = 20;
        public static final DBType I8 = new DBType("LARGE_INTEGER", 20, "An eight-byte, signed integer: LARGE_INTEGER", "DBTYPE_I8");
        public static final int WSTR_ORDINAL = 130;
        public static final DBType WSTR = new DBType("STRING", 130, "A null-terminated Unicode character string: wchar_t[length]; If DBTYPE_WSTR is used by itself, the number of bytes allocated for the string, including the null-termination character, is specified by cbMaxLen in the DBBINDING structure. If DBTYPE_WSTR is combined with DBTYPE_BYREF, the number of bytes allocated for the string, including the null-termination character, is at least the length of the string plus two. In either case, the actual length of the string is determined from the bound length value. The maximum length of the string is the number of allocated bytes divided by sizeof(wchar_t) and truncated to the nearest integer.", "DBTYPE_WSTR");
        String dbTypeIndicator;

        public DBType(String name, int ordinal, String description, String dbTypeIndicator) {
            super(name, ordinal, description);
            this.dbTypeIndicator = dbTypeIndicator;
        }
    }

    static class Type
    extends EnumeratedValues.BasicValue {
        public static final int String_ORDINAL = 0;
        public static final Type String = new Type("string", 0, "xsd:string");
        public static final int StringArray_ORDINAL = 1;
        public static final Type StringArray = new Type("StringArray", 1, "xsd:string");
        public static final int Array_ORDINAL = 2;
        public static final Type Array = new Type("Array", 2, "xsd:string");
        public static final int Enumeration_ORDINAL = 3;
        public static final Type Enumeration = new Type("Enumeration", 3, "xsd:string");
        public static final int EnumerationArray_ORDINAL = 4;
        public static final Type EnumerationArray = new Type("EnumerationArray", 4, "xsd:string");
        public static final int EnumString_ORDINAL = 5;
        public static final Type EnumString = new Type("EnumString", 5, "xsd:string");
        public static final int Boolean_ORDINAL = 6;
        public static final Type Boolean = new Type("Boolean", 6, "xsd:boolean");
        public static final int StringSometimesArray_ORDINAL = 7;
        public static final Type StringSometimesArray = new Type("StringSometimesArray", 7, "xsd:string");
        public static final int Integer_ORDINAL = 8;
        public static final Type Integer = new Type("Integer", 8, "xsd:int");
        public static final int UnsignedInteger_ORDINAL = 9;
        public static final Type UnsignedInteger = new Type("UnsignedInteger", 9, "xsd:unsignedInt");
        public static final int DataTime_ORDINAL = 10;
        public static final Type DateTime = new Type("DateTime", 10, "xsd:dateTime");
        public static final int Short_ORDINAL = 11;
        public static final Type Short = new Type("Short", 11, "xsd:short");
        public static final int UUID_ORDINAL = 12;
        public static final Type UUID = new Type("UUID", 12, "uuid");
        public static final int UnsignedShort_ORDINAL = 13;
        public static final Type UnsignedShort = new Type("UnsignedShort", 13, "xsd:unsignedShort");
        public static final int Long_ORDINAL = 14;
        public static final Type Long = new Type("Long", 14, "xsd:long");
        public static final int UnsignedLong_ORDINAL = 15;
        public static final Type UnsignedLong = new Type("UnsignedLong", 15, "xsd:unsignedLong");
        public final String columnType;
        public static final EnumeratedValues enumeration = new EnumeratedValues(new Type[]{String, StringArray, Array, Enumeration, EnumerationArray, EnumString});

        public Type(String name, int ordinal, String columnType) {
            super(name, ordinal, null);
            this.columnType = columnType;
        }

        boolean isEnum() {
            switch (this.ordinal) {
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
            }
            return false;
        }
    }
}

