/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mondrian.olap.Util;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaRequestCallback;
import mondrian.xmla.XmlaServlet;
import mondrian.xmla.XmlaUtil;
import mondrian.xmla.impl.DefaultSaxWriter;
import mondrian.xmla.impl.DefaultXmlaRequest;
import mondrian.xmla.impl.DefaultXmlaResponse;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultXmlaServlet
extends XmlaServlet {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$xmla$impl$DefaultXmlaServlet == null ? (class$mondrian$xmla$impl$DefaultXmlaServlet = DefaultXmlaServlet.class$("mondrian.xmla.impl.DefaultXmlaServlet")) : class$mondrian$xmla$impl$DefaultXmlaServlet));
    protected static final String nl = Util.nl;
    private DocumentBuilderFactory domFactory = null;
    private static final /* synthetic */ Class class$mondrian$xmla$impl$DefaultXmlaServlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.domFactory = this.getDocumentBuilderFactory();
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        return factory;
    }

    protected void unmarshallSoapMessage(HttpServletRequest request, Element[] requestSoapParts) throws XmlaException {
        try {
            String msg;
            ServletInputStream inputStream = null;
            try {
                inputStream = request.getInputStream();
            }
            catch (IllegalStateException ex) {
                throw new XmlaException("Server", "00USMA01", "Request input method invoked at illegal time", ex);
            }
            catch (IOException ex) {
                throw new XmlaException("Server", "00USMA02", "Request input Exception occurred", ex);
            }
            DocumentBuilder domBuilder = null;
            try {
                domBuilder = this.domFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new XmlaException("Server", "00USMB01", "DocumentBuilder cannot be created which satisfies the configuration requested", ex);
            }
            Document soapDoc = null;
            try {
                soapDoc = domBuilder.parse(new InputSource((InputStream)inputStream));
            }
            catch (IOException ex) {
                throw new XmlaException("Server", "00USMC01", "DOM parse IO errors occur", ex);
            }
            catch (SAXException ex) {
                throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", ex);
            }
            Element envElem = soapDoc.getDocumentElement();
            if (LOGGER.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer(100);
                buf.append("XML/A request content").append(nl);
                buf.append(XmlaUtil.element2Text(envElem));
                LOGGER.debug((Object)buf.toString());
            }
            if ("Envelope".equals(envElem.getLocalName())) {
                if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(envElem.getNamespaceURI())) {
                    msg = "Invalid SOAP message: Envelope element not in SOAP namespace";
                    throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", new SAXException(msg));
                }
            } else {
                msg = "Invalid SOAP message: Top element not Envelope";
                throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", new SAXException(msg));
            }
            Element[] childs = XmlaUtil.filterChildElements(envElem, "http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (childs.length > 1) {
                String msg2 = "Invalid SOAP message: More than one Header elements";
                throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", new SAXException(msg2));
            }
            requestSoapParts[0] = childs.length == 1 ? childs[0] : null;
            childs = XmlaUtil.filterChildElements(envElem, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (childs.length != 1) {
                String msg3 = "Invalid SOAP message: Does not have one Body element";
                throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", new SAXException(msg3));
            }
            requestSoapParts[1] = childs[0];
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00USMU01", "Unknown error unmarshalling soap message", ex);
        }
    }

    protected void handleSoapHeader(HttpServletResponse response, Element[] requestSoapParts, byte[][] responseSoapParts, Map context) throws XmlaException {
        try {
            Element hdrElem = requestSoapParts[0];
            if (hdrElem == null || !hdrElem.hasChildNodes()) {
                return;
            }
            String encoding = response.getCharacterEncoding();
            byte[] bytes = null;
            NodeList nlst = hdrElem.getChildNodes();
            int nlen = nlst.getLength();
            for (int i = 0; i < nlen; ++i) {
                String mustUnderstandValue;
                Element e;
                Attr attr;
                Node n = nlst.item(i);
                if (!(n instanceof Element) || (attr = (e = (Element)n).getAttributeNode("mustUnderstand")) == null || (mustUnderstandValue = attr.getValue()) == null || !mustUnderstandValue.equals("1") || !"urn:schemas-microsoft-com:xml-analysis".equals(e.getNamespaceURI())) continue;
                String sessionIdStr = null;
                String localName = e.getLocalName();
                if (localName.equals("BeginSession")) {
                    sessionIdStr = this.generateSessionId(context);
                    context.put("session_id", sessionIdStr);
                    context.put("SessionState", "SessionStateBegin");
                } else if (localName.equals("Session")) {
                    sessionIdStr = this.getSessionId(e, context);
                    context.put("session_id", sessionIdStr);
                    context.put("SessionState", "SessionStateWithin");
                } else if (localName.equals("EndSession")) {
                    sessionIdStr = this.getSessionId(e, context);
                    context.put("session_id", sessionIdStr);
                    context.put("SessionState", "SessionStateEnd");
                } else {
                    String msg = "Invalid XML/A message:  Unknown \"mustUnderstand\" XMLA Header element \"" + localName + "\"";
                    throw new XmlaException("MustUnderstand", "00HSHA01", "SOAP Header must understand element not recognized", new RuntimeException(msg));
                }
                StringBuffer buf = new StringBuffer(100);
                buf.append("<Session ");
                buf.append("SessionId");
                buf.append("=\"");
                buf.append(sessionIdStr);
                buf.append("\" ");
                buf.append("xmlns=\"");
                buf.append("urn:schemas-microsoft-com:xml-analysis");
                buf.append("\" />");
                bytes = buf.toString().getBytes(encoding);
            }
            responseSoapParts[0] = bytes;
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00HSHU01", "Unknown error handle soap header", ex);
        }
    }

    protected String generateSessionId(Map context) {
        List callbacks = this.getCallbacks();
        if (callbacks.size() > 0) {
            XmlaRequestCallback callback = (XmlaRequestCallback)callbacks.get(0);
            return callback.generateSessionId(context);
        }
        return "";
    }

    protected String getSessionId(Element e, Map context) throws Exception {
        Attr attr = e.getAttributeNode("SessionId");
        if (attr == null) {
            String msg = "Invalid XML/A message: Session Header element with no SessionId attribute";
            throw new SAXException(msg);
        }
        String value = attr.getValue();
        if (value == null) {
            String msg = "Invalid XML/A message: Session Header element with SessionId attribute but no attribute value";
            throw new SAXException(msg);
        }
        return value;
    }

    protected void handleSoapBody(HttpServletResponse response, Element[] requestSoapParts, byte[][] responseSoapParts, Map context) throws XmlaException {
        try {
            String encoding = response.getCharacterEncoding();
            Element hdrElem = requestSoapParts[0];
            Element bodyElem = requestSoapParts[1];
            Element[] dreqs = XmlaUtil.filterChildElements(bodyElem, "urn:schemas-microsoft-com:xml-analysis", "Discover");
            Element[] ereqs = XmlaUtil.filterChildElements(bodyElem, "urn:schemas-microsoft-com:xml-analysis", "Execute");
            if (dreqs.length + ereqs.length != 1) {
                String msg = "Invalid XML/A message:  Body has " + dreqs.length + " Discover Requests and " + ereqs.length + " Execute Requests";
                throw new XmlaException("Client", "00HSBA01", "SOAP Body not correctly formed", new RuntimeException(msg));
            }
            Element xmlaReqElem = dreqs.length == 0 ? ereqs[0] : dreqs[0];
            ByteArrayOutputStream osBuf = new ByteArrayOutputStream();
            DefaultXmlaRequest xmlaReq = new DefaultXmlaRequest(xmlaReqElem, (String)context.get("role"));
            DefaultXmlaResponse xmlaRes = new DefaultXmlaResponse(osBuf, encoding);
            try {
                this.getXmlaHandler().process(xmlaReq, xmlaRes);
            }
            catch (XmlaException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new XmlaException("Server", "00HSBB01", "XMLA SOAP Body processing error", ex);
            }
            responseSoapParts[1] = osBuf.toByteArray();
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00HSBU01", "Unknown error handle soap body", ex);
        }
    }

    protected void marshallSoapMessage(HttpServletResponse response, byte[][] responseSoapParts) throws XmlaException {
        try {
            StringBuffer buf;
            String encoding;
            String string = encoding = this.charEncoding != null ? this.charEncoding : response.getCharacterEncoding();
            if (this.charEncoding != null) {
                response.setCharacterEncoding(this.charEncoding);
            }
            response.setContentType("text/xml");
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] soapHeader = responseSoapParts[0];
            byte[] soapBody = responseSoapParts[1];
            Object[] byteChunks = new Object[5];
            try {
                buf = new StringBuffer(500);
                buf.append("<?xml version=\"1.0\" encoding=\"");
                buf.append(encoding);
                buf.append("\"?>");
                buf.append(nl);
                buf.append("<");
                buf.append("SOAP-ENV");
                buf.append(":Envelope xmlns:");
                buf.append("SOAP-ENV");
                buf.append("=\"");
                buf.append("http://schemas.xmlsoap.org/soap/envelope/");
                buf.append("\" ");
                buf.append("SOAP-ENV");
                buf.append(":encodingStyle=\"");
                buf.append("http://schemas.xmlsoap.org/soap/encoding/");
                buf.append("\" >");
                buf.append(nl);
                buf.append("<");
                buf.append("SOAP-ENV");
                buf.append(":Header>");
                buf.append(nl);
                byteChunks[0] = buf.toString().getBytes(encoding);
                byteChunks[1] = soapHeader;
                buf.setLength(0);
                buf.append("</");
                buf.append("SOAP-ENV");
                buf.append(":Header>");
                buf.append(nl);
                buf.append("<");
                buf.append("SOAP-ENV");
                buf.append(":Body>");
                buf.append(nl);
                byteChunks[2] = buf.toString().getBytes(encoding);
                byteChunks[3] = soapBody;
                buf.setLength(0);
                buf.append(nl);
                buf.append("</");
                buf.append("SOAP-ENV");
                buf.append(":Body>");
                buf.append(nl);
                buf.append("</");
                buf.append("SOAP-ENV");
                buf.append(":Envelope>");
                buf.append(nl);
                byteChunks[4] = buf.toString().getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                LOGGER.warn((Object)"This should be handled at begin of processing request", (Throwable)uee);
            }
            if (LOGGER.isDebugEnabled()) {
                buf = new StringBuffer(100);
                buf.append("XML/A response content").append(nl);
                try {
                    for (int i = 0; i < byteChunks.length; ++i) {
                        byte[] chunk = (byte[])byteChunks[i];
                        if (chunk == null || chunk.length <= 0) continue;
                        buf.append(new String(chunk, encoding));
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    LOGGER.warn((Object)"This should be handled at begin of processing request", (Throwable)uee);
                }
                LOGGER.debug((Object)buf.toString());
            }
            if (LOGGER.isDebugEnabled()) {
                buf = new StringBuffer();
                buf.append("XML/A response content").append(nl);
            }
            try {
                int bufferSize = 4096;
                ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
                WritableByteChannel wch = Channels.newChannel((OutputStream)outputStream);
                ReadableByteChannel rch = null;
                for (int i = 0; i < byteChunks.length; ++i) {
                    if (byteChunks[i] == null || ((byte[])byteChunks[i]).length == 0) continue;
                    rch = Channels.newChannel(new ByteArrayInputStream((byte[])byteChunks[i]));
                    int readSize = 0;
                    do {
                        buffer.clear();
                        readSize = rch.read(buffer);
                        buffer.flip();
                        int writeSize = 0;
                        while ((writeSize += wch.write(buffer)) < readSize) {
                        }
                    } while (readSize == bufferSize);
                    rch.close();
                }
                outputStream.flush();
            }
            catch (IOException ioe) {
                LOGGER.error((Object)"Damn exception when transferring bytes over sockets", (Throwable)ioe);
            }
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00MSMU01", "Unknown error marshalling soap message", ex);
        }
    }

    protected void handleFault(HttpServletResponse response, byte[][] responseSoapParts, int phase, Throwable t) {
        response.reset();
        switch (phase) {
            case 1: {
                response.setStatus(401);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                response.setStatus(200);
            }
        }
        String code = null;
        String faultCode = null;
        String faultString = null;
        String detail = null;
        if (t instanceof XmlaException) {
            XmlaException xex = (XmlaException)t;
            code = xex.getCode();
            faultString = xex.getFaultString();
            faultCode = XmlaException.formatFaultCode(xex);
            detail = XmlaException.formatDetail(xex.getDetail());
        } else {
            t = XmlaException.getRootCause(t);
            code = "00UE001";
            faultString = "Internal Error";
            faultCode = XmlaException.formatFaultCode("Server", code);
            detail = XmlaException.formatDetail(t.getMessage());
        }
        String encoding = response.getCharacterEncoding();
        ByteArrayOutputStream osBuf = new ByteArrayOutputStream();
        try {
            DefaultSaxWriter writer = new DefaultSaxWriter(osBuf, encoding);
            writer.startDocument();
            writer.startElement("SOAP-ENV:Fault");
            writer.startElement("faultcode");
            writer.characters(faultCode);
            writer.endElement();
            writer.startElement("faultstring");
            writer.characters(faultString);
            writer.endElement();
            writer.startElement("faultactor");
            writer.characters("Mondrian");
            writer.endElement();
            if (phase != 4) {
                writer.startElement("detail");
                writer.startElement("XA:error", new String[]{"xmlns:XA", "http://mondrian.sourceforge.net"});
                writer.startElement("code");
                writer.characters(code);
                writer.endElement();
                writer.startElement("desc");
                writer.characters(detail);
                writer.endElement();
                writer.endElement();
                writer.endElement();
            }
            writer.endElement();
            writer.endDocument();
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.warn((Object)"This should be handled at begin of processing request", (Throwable)uee);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unexcepted runimt exception when handing SOAP fault :(");
        }
        responseSoapParts[1] = osBuf.toByteArray();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

