/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.ConversionServiceAware;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.support.AbstractConverter;
import org.springframework.binding.convert.support.TextToBoolean;
import org.springframework.binding.convert.support.TextToClass;
import org.springframework.binding.convert.support.TextToLabeledEnum;
import org.springframework.binding.convert.support.TextToNumber;
import org.springframework.binding.format.support.SimpleFormatterFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DefaultConversionService
implements ConversionService {
    private Map sourceClassConverters = new HashMap();
    private Map aliasMap = new HashMap();
    private ConversionService parent;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$springframework$binding$mapping$Mapping;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$springframework$binding$expression$Expression;
    static /* synthetic */ Class class$org$springframework$core$enums$LabeledEnum;
    static /* synthetic */ Class class$org$springframework$binding$convert$Converter;
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultConversionService() {
        this.addDefaultConverters();
    }

    public void setParent(ConversionService parent) {
        this.parent = parent;
    }

    public void setConverters(Converter[] converters) {
        this.sourceClassConverters = new HashMap(converters.length);
        this.addConverters(converters);
    }

    private void addDefaultConverters() {
        this.addConverter(new TextToClass());
        this.addConverter(new TextToNumber(new SimpleFormatterFactory()));
        this.addConverter(new TextToBoolean());
        this.addConverter(new TextToLabeledEnum());
        this.addDefaultAlias(class$java$lang$String == null ? (class$java$lang$String = DefaultConversionService.class$("java.lang.String")) : class$java$lang$String);
        this.addDefaultAlias(class$java$lang$Short == null ? (class$java$lang$Short = DefaultConversionService.class$("java.lang.Short")) : class$java$lang$Short);
        this.addDefaultAlias(class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultConversionService.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.addDefaultAlias(class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultConversionService.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.addDefaultAlias(class$java$lang$Long == null ? (class$java$lang$Long = DefaultConversionService.class$("java.lang.Long")) : class$java$lang$Long);
        this.addDefaultAlias(class$java$lang$Float == null ? (class$java$lang$Float = DefaultConversionService.class$("java.lang.Float")) : class$java$lang$Float);
        this.addDefaultAlias(class$java$lang$Double == null ? (class$java$lang$Double = DefaultConversionService.class$("java.lang.Double")) : class$java$lang$Double);
        this.addDefaultAlias(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DefaultConversionService.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        this.addDefaultAlias(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DefaultConversionService.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.addDefaultAlias(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultConversionService.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.addDefaultAlias(class$org$springframework$binding$mapping$Mapping == null ? (class$org$springframework$binding$mapping$Mapping = DefaultConversionService.class$("org.springframework.binding.mapping.Mapping")) : class$org$springframework$binding$mapping$Mapping);
        this.addDefaultAlias(class$java$lang$Class == null ? (class$java$lang$Class = DefaultConversionService.class$("java.lang.Class")) : class$java$lang$Class);
        this.addDefaultAlias(class$org$springframework$binding$expression$Expression == null ? (class$org$springframework$binding$expression$Expression = DefaultConversionService.class$("org.springframework.binding.expression.Expression")) : class$org$springframework$binding$expression$Expression);
        this.addAlias("labeledEnum", class$org$springframework$core$enums$LabeledEnum == null ? (class$org$springframework$core$enums$LabeledEnum = DefaultConversionService.class$("org.springframework.core.enums.LabeledEnum")) : class$org$springframework$core$enums$LabeledEnum);
    }

    public void addConverter(Converter converter) {
        Class[] sourceClasses = converter.getSourceClasses();
        Class[] targetClasses = converter.getTargetClasses();
        for (int i = 0; i < sourceClasses.length; ++i) {
            Class sourceClass = sourceClasses[i];
            HashMap<Class, Converter> sourceMap = (HashMap<Class, Converter>)this.sourceClassConverters.get(sourceClass);
            if (sourceMap == null) {
                sourceMap = new HashMap<Class, Converter>();
                this.sourceClassConverters.put(sourceClass, sourceMap);
            }
            for (int j = 0; j < targetClasses.length; ++j) {
                Class targetClass = targetClasses[j];
                sourceMap.put(targetClass, converter);
            }
        }
        if (converter instanceof ConversionServiceAware) {
            ((ConversionServiceAware)((Object)converter)).setConversionService(this);
        }
    }

    public void addConverter(Converter converter, String alias) {
        this.aliasMap.put(alias, converter);
        this.addConverter(converter);
    }

    public void addConverters(Converter[] converters) {
        for (int i = 0; i < converters.length; ++i) {
            this.addConverter(converters[i]);
        }
    }

    public void addAlias(String alias, Class targetType) {
        this.aliasMap.put(alias, targetType);
    }

    public void addDefaultAlias(Class targetType) {
        this.addAlias(StringUtils.uncapitalize((String)ClassUtils.getShortName((Class)targetType)), targetType);
    }

    public ConversionExecutor getConversionExecutorByTargetAlias(Class sourceClass, String alias) throws IllegalArgumentException {
        Assert.hasText((String)alias, (String)"The target alias is required and must either be a type alias (e.g 'boolean') or a generic converter alias (e.g. 'bean') ");
        Object targetType = this.aliasMap.get(alias);
        if (targetType == null) {
            return null;
        }
        if (targetType instanceof Class) {
            return this.getConversionExecutor(sourceClass, (Class)targetType);
        }
        Assert.isInstanceOf((Class)(class$org$springframework$binding$convert$Converter == null ? (class$org$springframework$binding$convert$Converter = DefaultConversionService.class$("org.springframework.binding.convert.Converter")) : class$org$springframework$binding$convert$Converter), targetType, (String)"Not a converter:");
        Converter conv = (Converter)targetType;
        return new ConversionExecutor(conv, class$java$lang$Object == null ? (class$java$lang$Object = DefaultConversionService.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public ConversionExecutor getConversionExecutor(Class sourceClass, Class targetClass) {
        if (this.sourceClassConverters == null || this.sourceClassConverters.isEmpty()) {
            throw new IllegalStateException("No converters have been added to this service's registry");
        }
        if (sourceClass.equals(targetClass)) {
            return new ConversionExecutor(new NoOpConverter(sourceClass, targetClass), targetClass);
        }
        Map sourceTargetConverters = this.findConvertersForSource(sourceClass);
        Converter converter = this.findTargetConverter(sourceTargetConverters, targetClass);
        if (converter != null) {
            return new ConversionExecutor(converter, targetClass);
        }
        if (this.parent != null) {
            return this.parent.getConversionExecutor(sourceClass, targetClass);
        }
        throw new IllegalArgumentException("No converter registered to convert from sourceClass '" + sourceClass + "' to target class '" + targetClass + "'");
    }

    public Class getClassByAlias(String alias) {
        Object clazz = this.aliasMap.get(alias);
        if (clazz != null) {
            Assert.isInstanceOf((Class)(class$java$lang$Class == null ? (class$java$lang$Class = DefaultConversionService.class$("java.lang.Class")) : class$java$lang$Class), clazz, (String)("Not a Class alias '" + alias + "': "));
        }
        return (Class)clazz;
    }

    protected Map findConvertersForSource(Class sourceClass) {
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(sourceClass);
        while (!classQueue.isEmpty()) {
            sourceClass = (Class)classQueue.removeLast();
            Map sourceTargetConverters = (Map)this.sourceClassConverters.get(sourceClass);
            if (sourceTargetConverters != null && !sourceTargetConverters.isEmpty()) {
                return sourceTargetConverters;
            }
            if (!sourceClass.isInterface() && sourceClass.getSuperclass() != null) {
                classQueue.addFirst(sourceClass.getSuperclass());
            }
            Class<?>[] interfaces = sourceClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                classQueue.addFirst(interfaces[i]);
            }
        }
        return Collections.EMPTY_MAP;
    }

    private Converter findTargetConverter(Map sourceTargetConverters, Class targetClass) {
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(targetClass);
        while (!classQueue.isEmpty()) {
            targetClass = (Class)classQueue.removeLast();
            Converter converter = (Converter)sourceTargetConverters.get(targetClass);
            if (converter != null) {
                return converter;
            }
            if (!targetClass.isInterface() && targetClass.getSuperclass() != null) {
                classQueue.addFirst(targetClass.getSuperclass());
            }
            Class<?>[] interfaces = targetClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                classQueue.addFirst(interfaces[i]);
            }
        }
        return null;
    }

    public ConversionService getParent() {
        return this.parent;
    }

    protected Map getSourceClassConverters() {
        return this.sourceClassConverters;
    }

    protected Map getAliasMap() {
        return this.aliasMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NoOpConverter
    extends AbstractConverter {
        private Class sourceClass;
        private Class targetClass;

        public NoOpConverter(Class sourceClass, Class targetClass) {
            this.sourceClass = sourceClass;
            this.targetClass = targetClass;
        }

        protected Object doConvert(Object source, Class targetClass, Map context) throws Exception {
            return source;
        }

        public Class[] getSourceClasses() {
            return new Class[]{this.sourceClass};
        }

        public Class[] getTargetClasses() {
            return new Class[]{this.targetClass};
        }
    }
}

