/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import java.util.LinkedList;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserException;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.binding.expression.support.StaticExpression;
import org.springframework.util.StringUtils;

public abstract class AbstractExpressionParser
implements ExpressionParser {
    private static final String DEFAULT_EXPRESSION_PREFIX = "${";
    private static final String DEFAULT_EXPRESSION_SUFFIX = "}";

    public boolean isExpression(String encodedCriteria) {
        return encodedCriteria.startsWith(this.getExpressionPrefix()) && encodedCriteria.endsWith(this.getExpressionSuffix());
    }

    protected String cutExpression(String encodedCriteria) {
        if (this.isExpression(encodedCriteria)) {
            return encodedCriteria.substring(DEFAULT_EXPRESSION_PREFIX.length(), encodedCriteria.length() - DEFAULT_EXPRESSION_SUFFIX.length());
        }
        return encodedCriteria;
    }

    protected String getExpressionPrefix() {
        return DEFAULT_EXPRESSION_PREFIX;
    }

    protected String getExpressionSuffix() {
        return DEFAULT_EXPRESSION_SUFFIX;
    }

    public Expression[] parseExpressions(String expressionString) throws ParserException {
        LinkedList<Expression> expressions = new LinkedList<Expression>();
        if (StringUtils.hasText((String)expressionString)) {
            int startIdx = 0;
            while (startIdx < expressionString.length()) {
                int exprStartIdx = expressionString.indexOf(this.getExpressionPrefix(), startIdx);
                if (exprStartIdx >= startIdx) {
                    int exprEndIdx;
                    if (exprStartIdx > startIdx) {
                        expressions.add(new StaticExpression(expressionString.substring(startIdx, exprStartIdx)));
                        startIdx = exprStartIdx;
                    }
                    if ((exprEndIdx = expressionString.indexOf(this.getExpressionSuffix(), exprStartIdx)) >= exprStartIdx) {
                        expressions.add(this.parseExpression(expressionString.substring(exprStartIdx, exprEndIdx + 1)));
                        startIdx = exprEndIdx + 1;
                        continue;
                    }
                    expressions.add(new StaticExpression(expressionString.substring(startIdx)));
                    startIdx = expressionString.length();
                    continue;
                }
                expressions.add(new StaticExpression(expressionString.substring(startIdx)));
                startIdx = expressionString.length();
            }
        }
        return expressions.toArray(new Expression[expressions.size()]);
    }

    public abstract Expression parseExpression(String var1) throws ParserException;

    public abstract PropertyExpression parsePropertyExpression(String var1) throws ParserException, UnsupportedOperationException;
}

