/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jxl.CellView;
import jxl.JXLException;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.Alignment;
import jxl.format.BoldStyle;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.RGB;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.CellValue;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JExcelApiExporterNature;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JExcelApiExporter
extends JRXlsAbstractExporter {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$export$JExcelApiExporter == null ? (class$net$sf$jasperreports$engine$export$JExcelApiExporter = JExcelApiExporter.class$("net.sf.jasperreports.engine.export.JExcelApiExporter")) : class$net$sf$jasperreports$engine$export$JExcelApiExporter));
    protected static final Colour WHITE = Colour.WHITE;
    protected static final Colour BLACK = Colour.BLACK;
    protected static final String EMPTY_SHEET_NAME = "Sheet1";
    private static Map colorsCache = new ReferenceMap();
    private static Colour[] FIXED_COLOURS = new Colour[]{WHITE, BLACK, Colour.PALETTE_BLACK, Colour.DEFAULT_BACKGROUND, Colour.DEFAULT_BACKGROUND1, Colour.AUTOMATIC, Colour.UNKNOWN};
    private Map loadedCellStyles = new HashMap();
    private WritableWorkbook workbook = null;
    private WritableSheet sheet = null;
    private Pattern backgroundMode = Pattern.SOLID;
    private Map numberFormats;
    private Map dateFormats;
    protected Map formatPatternsMap = null;
    protected boolean createCustomPalette;
    protected Map workbookColours = new HashMap();
    protected Map usedColours = new HashMap();
    protected ExporterNature nature = null;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$export$JExcelApiExporter;

    public JExcelApiExporter() {
        this.numberFormats = new HashMap();
        this.dateFormats = new HashMap();
    }

    protected void setParameters() {
        super.setParameters();
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
        this.createCustomPalette = this.getBooleanParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, "net.sf.jasperreports.export.xls.create.custom.palette", false);
        if (this.createCustomPalette) {
            this.initCustomPalette();
        }
        this.nature = new JExcelApiExporterNature(this.filter, this.isIgnoreGraphics);
    }

    protected void initCustomPalette() {
        for (int i = 0; i < FIXED_COLOURS.length; ++i) {
            Colour colour = FIXED_COLOURS[i];
            this.setColourUsed(colour);
        }
    }

    protected void setColourUsed(Colour colour) {
        this.usedColours.put(colour, colour.getDefaultRGB());
    }

    protected void setColourUsed(Colour colour, Color reportColour) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Modifying palette colour " + colour.getValue() + " to " + reportColour));
        }
        int red = reportColour.getRed();
        int green = reportColour.getGreen();
        int blue = reportColour.getBlue();
        this.workbook.setColourRGB(colour, red, green, blue);
        RGB customRGB = new RGB(red, green, blue);
        this.usedColours.put(colour, customRGB);
    }

    protected void setBackground() {
        this.backgroundMode = this.isWhitePageBackground ? Pattern.SOLID : Pattern.NONE;
    }

    protected void openWorkbook(OutputStream os) throws JRException {
        try {
            this.workbook = Workbook.createWorkbook((OutputStream)os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void createSheet(String name) {
        this.sheet = this.workbook.createSheet(name, Integer.MAX_VALUE);
        this.setSheetSettings(this.sheet);
    }

    protected void closeWorkbook(OutputStream os) throws JRException {
        if (this.sheet == null) {
            this.workbook.createSheet(EMPTY_SHEET_NAME, Integer.MAX_VALUE);
        }
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
        catch (WriteException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void setColumnWidth(int col, int width) {
        CellView cv = new CellView();
        cv.setSize(width);
        this.sheet.setColumnView(col, cv);
    }

    protected void setRowHeight(int y, int lastRowHeight) throws JRException {
        try {
            this.sheet.setRowView(y, lastRowHeight * 20);
        }
        catch (RowsExceededException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void setCell(int x, int y) {
    }

    protected void removeColumn(int col) {
        this.sheet.removeColumn(col);
    }

    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        try {
            Colour forecolor = BLACK;
            if (gridCell.getForecolor() != null) {
                forecolor = this.getWorkbookColour(gridCell.getForecolor());
            }
            Pattern mode = this.backgroundMode;
            Colour backcolor = WHITE;
            if (gridCell.getCellBackcolor() != null) {
                mode = Pattern.SOLID;
                backcolor = this.getWorkbookColour(gridCell.getCellBackcolor());
            }
            WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue());
            WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont, gridCell);
            this.sheet.addCell((WritableCell)new Blank(colIndex, rowIndex, (CellFormat)cellStyle));
        }
        catch (RowsExceededException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
        catch (WriteException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        Colour forecolor2 = this.getWorkbookColour(line.getForecolor());
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor2.getValue());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(Pattern.SOLID, forecolor2, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont2, gridCell);
        Blank cell2 = new Blank(x, y, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("Can't add cell.", e);
        }
    }

    protected void exportRectangle(JRPrintElement element, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        Colour forecolor = this.getWorkbookColour(element.getForecolor());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor());
        }
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont2, gridCell);
        Blank cell2 = new Blank(x, y, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("Can't add cell.", e);
        }
    }

    protected void exportText(JRPrintText text, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        JRStyledText styledText = this.getStyledText(text);
        if (styledText != null) {
            Colour forecolor = this.getWorkbookColour(text.getForecolor());
            WritableFont cellFont = this.getLoadedFont(text, forecolor.getValue());
            JRXlsAbstractExporter.TextAlignHolder alignment = JExcelApiExporter.getTextAlignHolder(text);
            int horizontalAlignment = this.getHorizontalAlignment(alignment);
            int verticalAlignment = this.getVerticalAlignment(alignment);
            int rotation = this.getRotation(alignment);
            Pattern mode = this.backgroundMode;
            Colour backcolor = WHITE;
            if (gridCell.getCellBackcolor() != null) {
                mode = Pattern.SOLID;
                backcolor = this.getWorkbookColour(gridCell.getCellBackcolor());
            }
            StyleInfo baseStyle = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, cellFont, gridCell.getBox());
            String textStr = styledText.getText();
            String href = null;
            JRHyperlinkProducer customHandler = this.getCustomHandler(text);
            if (customHandler == null) {
                switch (text.getHyperlinkType()) {
                    case 2: {
                        href = text.getHyperlinkReference();
                        break;
                    }
                }
            } else {
                href = customHandler.getHyperlink(text);
            }
            try {
                if (href == null) {
                    this.addCell(x, y, text, textStr, baseStyle);
                } else {
                    URL url = new URL(href);
                    WritableHyperlink hyperlink = new WritableHyperlink(x, y, x, y, url, textStr);
                    this.sheet.addHyperlink(hyperlink);
                }
            }
            catch (Exception e) {
                throw new JRException("Can't add cell.", e);
            }
        }
    }

    protected void addCell(int x, int y, JRPrintText text, String textStr, StyleInfo baseStyle) throws WriteException, RowsExceededException, JRException {
        CellValue cellValue = this.isDetectCellType ? this.getDetectedCellValue(x, y, text, textStr, baseStyle) : (this.isAutoDetectCellType ? this.getAutoDetectedCellValue(x, y, textStr, baseStyle) : this.getLabelCell(x, y, textStr, baseStyle));
        this.sheet.addCell((WritableCell)cellValue);
    }

    protected CellValue getDetectedCellValue(int x, int y, JRPrintText text, String textStr, StyleInfo baseStyle) throws JRException {
        TextValue textValue = this.getTextValue(text, textStr);
        CellTextValueHandler handler = new CellTextValueHandler(x, y, baseStyle);
        textValue.handle(handler);
        return handler.getResult();
    }

    protected NumberFormat getNumberFormat(String pattern) {
        String convertedPattern = this.getConvertedPattern(pattern);
        NumberFormat cellFormat = (NumberFormat)this.numberFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = new NumberFormat(convertedPattern);
            this.numberFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected DateFormat getDateFormat(String pattern) {
        String convertedPattern = this.getConvertedPattern(pattern);
        DateFormat cellFormat = (DateFormat)this.dateFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = new DateFormat(convertedPattern);
            this.dateFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected CellValue getAutoDetectedCellValue(int x, int y, String textStr, StyleInfo baseStyle) throws JRException {
        CellValue cellValue;
        try {
            double d = Double.parseDouble(textStr);
            WritableCellFormat cellStyle = this.getLoadedCellStyle(baseStyle);
            cellValue = new Number(x, y, d, (CellFormat)cellStyle);
        }
        catch (NumberFormatException nfe) {
            cellValue = this.getLabelCell(x, y, textStr, baseStyle);
        }
        return cellValue;
    }

    protected CellValue getLabelCell(int x, int y, String textStr, StyleInfo baseStyle) throws JRException {
        WritableCellFormat cellStyle = this.getLoadedCellStyle(baseStyle);
        Label cellValue = new Label(x, y, textStr, (CellFormat)cellStyle);
        return cellValue;
    }

    protected void addMergeRegion(JRExporterGridCell gridCell, int x, int y) throws JRException {
        if (gridCell.getColSpan() > 1 || gridCell.getRowSpan() > 1) {
            try {
                if (this.isCollapseRowSpan) {
                    this.sheet.mergeCells(x, y, x + gridCell.getColSpan() - 1, y);
                } else {
                    this.sheet.mergeCells(x, y, x + gridCell.getColSpan() - 1, y + gridCell.getRowSpan() - 1);
                }
            }
            catch (JXLException e) {
                throw new JRException("Can't merge cells.", e);
            }
        }
    }

    private int getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case 3: {
                return Alignment.RIGHT.getValue();
            }
            case 2: {
                return Alignment.CENTRE.getValue();
            }
            case 4: {
                return Alignment.JUSTIFY.getValue();
            }
        }
        return Alignment.LEFT.getValue();
    }

    private int getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case 3: {
                return VerticalAlignment.BOTTOM.getValue();
            }
            case 2: {
                return VerticalAlignment.CENTRE.getValue();
            }
            case 4: {
                return VerticalAlignment.JUSTIFY.getValue();
            }
        }
        return VerticalAlignment.TOP.getValue();
    }

    private int getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case 1: {
                return Orientation.PLUS_90.getValue();
            }
            case 2: {
                return Orientation.MINUS_90.getValue();
            }
        }
        return Orientation.HORIZONTAL.getValue();
    }

    protected void exportImage(JRPrintImage element, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        try {
            int leftPadding = element.getLeftPadding();
            int topPadding = element.getTopPadding();
            int rightPadding = element.getRightPadding();
            int bottomPadding = element.getBottomPadding();
            int availableImageWidth = element.getWidth() - leftPadding - rightPadding;
            availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
            int availableImageHeight = element.getHeight() - topPadding - bottomPadding;
            availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
            JRRenderable renderer = element.getRenderer();
            if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
                if (renderer.getType() == 0 && (renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, element.getOnErrorType())) != null) {
                    renderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, element.getOnErrorType());
                }
            } else {
                renderer = null;
            }
            if (renderer != null) {
                int normalWidth = availableImageWidth;
                int normalHeight = availableImageHeight;
                Dimension2D dimension = renderer.getDimension();
                if (dimension != null) {
                    normalWidth = (int)dimension.getWidth();
                    normalHeight = (int)dimension.getHeight();
                }
                float xalignFactor = 0.0f;
                switch (element.getHorizontalAlignment()) {
                    case 3: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (element.getVerticalAlignment()) {
                    case 3: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                BufferedImage bi = new BufferedImage(availableImageWidth, availableImageHeight, 2);
                Graphics2D grx = bi.createGraphics();
                if (1 == element.getMode()) {
                    grx.setColor(element.getBackcolor());
                    grx.fillRect(0, 0, availableImageWidth, availableImageHeight);
                }
                switch (element.getScaleImage()) {
                    case 1: {
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        renderer.render(grx, new Rectangle(xoffset, yoffset, normalWidth, normalHeight));
                        break;
                    }
                    case 2: {
                        renderer.render(grx, new Rectangle(0, 0, availableImageWidth, availableImageHeight));
                        break;
                    }
                    default: {
                        if (element.getHeight() <= 0) break;
                        double ratio = (double)normalWidth / (double)normalHeight;
                        if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                            normalWidth = availableImageWidth;
                            normalHeight = (int)((double)availableImageWidth / ratio);
                        } else {
                            normalWidth = (int)((double)availableImageHeight * ratio);
                            normalHeight = availableImageHeight;
                        }
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        renderer.render(grx, new Rectangle(xoffset, yoffset, normalWidth, normalHeight));
                    }
                }
                Pattern mode = this.backgroundMode;
                Colour background = WHITE;
                Colour forecolor = this.getWorkbookColour(element.getForecolor());
                if (element.getBorderColor() != null) {
                    forecolor = this.getWorkbookColour(element.getBorderColor());
                }
                WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue());
                if (element.getMode() == 1) {
                    mode = Pattern.SOLID;
                    background = this.getWorkbookColour(element.getBackcolor());
                }
                WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, background, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont2, gridCell);
                this.sheet.addCell((WritableCell)new Blank(x, y, (CellFormat)cellStyle2));
                WritableImage image = new WritableImage((double)x, (double)y, (double)gridCell.getColSpan(), (double)gridCell.getRowSpan(), JRImageLoader.loadImageDataFromAWTImage(bi, (byte)3));
                this.sheet.addImage(image);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JRException("The cell cannot be added", ex);
        }
        catch (Error err) {
            err.printStackTrace();
            throw new JRException("The cell cannot be added", err);
        }
    }

    protected Colour getWorkbookColour(Color awtColor) {
        Colour colour;
        if (this.createCustomPalette) {
            colour = (Colour)this.workbookColours.get(awtColor);
            if (colour == null) {
                colour = this.determineWorkbookColour(awtColor);
                this.workbookColours.put(awtColor, colour);
            }
        } else {
            colour = JExcelApiExporter.getNearestColour(awtColor);
        }
        return colour;
    }

    protected Colour determineWorkbookColour(Color awtColor) {
        Colour workbookColour;
        int minDist = 999;
        Colour minColour = null;
        int minDistAvailable = 999;
        Colour minColourAvailable = null;
        Colour[] colors = Colour.getAllColours();
        for (int i = 0; i < colors.length; ++i) {
            Colour colour = colors[i];
            RGB customRGB = (RGB)this.usedColours.get(colour);
            RGB rgb = customRGB == null ? colour.getDefaultRGB() : customRGB;
            int dist = JExcelApiExporter.rgbDistance(awtColor, rgb);
            if (dist < minDist) {
                minDist = dist;
                minColour = colour;
            }
            if (dist == 0) break;
            if (customRGB != null || dist >= minDistAvailable) continue;
            minDistAvailable = dist;
            minColourAvailable = colour;
        }
        if (minDist == 0) {
            if (!this.usedColours.containsKey(minColour)) {
                this.setColourUsed(minColour);
            }
            workbookColour = minColour;
        } else if (minColourAvailable == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No more available colours in the palette.  Using the nearest match for " + awtColor));
            }
            workbookColour = minColour;
        } else {
            this.setColourUsed(minColourAvailable, awtColor);
            workbookColour = minColourAvailable;
        }
        return workbookColour;
    }

    protected static Colour getNearestColour(Color awtColor) {
        Colour color = (Colour)colorsCache.get(awtColor);
        if (color == null) {
            Colour[] colors = Colour.getAllColours();
            if (colors != null && colors.length > 0) {
                int minDiff = 999;
                for (int i = 0; i < colors.length; ++i) {
                    Colour crtColor = colors[i];
                    int diff = JExcelApiExporter.rgbDistance(awtColor, crtColor.getDefaultRGB());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            colorsCache.put(awtColor, color);
        }
        return color;
    }

    protected static int rgbDistance(Color awtColor, RGB rgb) {
        int diff = Math.abs(rgb.getRed() - awtColor.getRed()) + Math.abs(rgb.getGreen() - awtColor.getGreen()) + Math.abs(rgb.getBlue() - awtColor.getBlue());
        return diff;
    }

    private WritableFont getLoadedFont(JRFont font, int forecolor) throws JRException {
        WritableFont cellFont = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                WritableFont cf = (WritableFont)this.loadedFonts.get(i);
                int fontSize = font.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = font.getFontName();
                if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
                    fontName = (String)this.fontMap.get(fontName);
                }
                if (!cf.getName().equals(fontName) || cf.getColour().getValue() != forecolor || cf.getPointSize() != fontSize || !(cf.getUnderlineStyle() == UnderlineStyle.SINGLE ? font.isUnderline() : !font.isUnderline()) || cf.isStruckout() != font.isStrikeThrough() || !(cf.getBoldWeight() == BoldStyle.BOLD.getValue() ? font.isBold() : !font.isBold()) || cf.isItalic() != font.isItalic()) continue;
                cellFont = cf;
                break;
            }
        }
        try {
            if (cellFont == null) {
                int fontSize = font.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = font.getFontName();
                if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
                    fontName = (String)this.fontMap.get(fontName);
                }
                cellFont = new WritableFont(WritableFont.createFont((String)fontName), fontSize, font.isBold() ? WritableFont.BOLD : WritableFont.NO_BOLD, font.isItalic(), font.isUnderline() ? UnderlineStyle.SINGLE : UnderlineStyle.NO_UNDERLINE, Colour.getInternalColour((int)forecolor));
                cellFont.setStruckout(font.isStrikeThrough());
                this.loadedFonts.add(cellFont);
            }
        }
        catch (Exception e) {
            throw new JRException("Can't get loaded fonts.", e);
        }
        return cellFont;
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRExporterGridCell gridCell) throws JRException {
        StyleInfo styleKey = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, gridCell.getBox());
        return this.getLoadedCellStyle(styleKey);
    }

    protected WritableCellFormat getLoadedCellStyle(StyleInfo styleKey) throws JRException {
        WritableCellFormat cellStyle = (WritableCellFormat)this.loadedCellStyles.get(styleKey);
        if (cellStyle == null) {
            try {
                cellStyle = styleKey.getDisplayFormat() == null ? new WritableCellFormat(styleKey.font) : new WritableCellFormat(styleKey.font, styleKey.getDisplayFormat());
                cellStyle.setBackground(styleKey.backcolor, styleKey.mode);
                cellStyle.setAlignment(Alignment.getAlignment((int)styleKey.horizontalAlignment));
                cellStyle.setVerticalAlignment(VerticalAlignment.getAlignment((int)styleKey.verticalAlignment));
                cellStyle.setOrientation(Orientation.getOrientation((int)styleKey.rotation));
                cellStyle.setWrap(true);
                if (!this.isIgnoreCellBorder) {
                    BoxStyle box = styleKey.box;
                    cellStyle.setBorder(Border.TOP, box.topBorder, box.topBorderColour);
                    cellStyle.setBorder(Border.BOTTOM, box.bottomBorder, box.bottomBorderColour);
                    cellStyle.setBorder(Border.LEFT, box.leftBorder, box.leftBorderColour);
                    cellStyle.setBorder(Border.RIGHT, box.rightBorder, box.rightBorderColour);
                }
            }
            catch (Exception e) {
                throw new JRException("Error setting cellFormat-template.", e);
            }
            this.loadedCellStyles.put(styleKey, cellStyle);
        }
        return cellStyle;
    }

    protected static BorderLineStyle getBorderLineStyle(byte lineStyle) {
        BorderLineStyle retVal = null;
        switch (lineStyle) {
            case 5: {
                retVal = BorderLineStyle.THIN;
                break;
            }
            case 1: 
            case 2: {
                retVal = BorderLineStyle.MEDIUM;
                break;
            }
            case 3: {
                retVal = BorderLineStyle.THICK;
                break;
            }
            case 4: {
                retVal = BorderLineStyle.DOTTED;
                break;
            }
            default: {
                retVal = BorderLineStyle.NONE;
            }
        }
        return retVal;
    }

    private final void setSheetSettings(WritableSheet sheet) {
        PageOrientation po = this.jasperPrint.getOrientation() == 1 ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        PaperSize ps = this.getSuitablePaperSize(this.jasperPrint);
        if (ps != null) {
            sheet.setPageSetup(po, ps, 0.0, 0.0);
        } else {
            sheet.setPageSetup(po);
        }
        SheetSettings sheets = sheet.getSettings();
        sheets.setTopMargin(0.0);
        sheets.setLeftMargin(0.0);
        sheets.setRightMargin(0.0);
        sheets.setBottomMargin(0.0);
        sheets.setHeaderMargin(0.0);
        sheets.setFooterMargin(0.0);
    }

    private final PaperSize getSuitablePaperSize(JasperPrint jasP) {
        if (jasP == null) {
            return null;
        }
        long width = 0L;
        long height = 0L;
        PaperSize ps = null;
        if (jasP.getPageWidth() != 0 && jasP.getPageHeight() != 0) {
            double dWidth = (double)jasP.getPageWidth() / 72.0;
            double dHeight = (double)jasP.getPageHeight() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 3; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 3) {
                    ps = PaperSize.A3;
                    break;
                }
                if (i == 4) {
                    ps = PaperSize.A4;
                    break;
                }
                if (i != 5) break;
                ps = PaperSize.A5;
                break;
            }
            if (ps == null) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = PaperSize.LETTER;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = PaperSize.LEGAL;
                }
            }
        }
        return ps;
    }

    public static JRXlsAbstractExporter.TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        short horizontalAlignment;
        short verticalAlignment;
        short rotation = textElement.getRotation();
        block0 : switch (textElement.getRotation()) {
            case 1: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 3;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                }
                horizontalAlignment = 1;
                break;
            }
            case 2: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 1;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                }
                horizontalAlignment = 3;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignment();
                verticalAlignment = textElement.getVerticalAlignment();
            }
        }
        return new JRXlsAbstractExporter.TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    private final int calculateWidthForDinAN(int n) {
        return (int)(Math.pow(2.0, -0.25 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateHeightForDinAN(int n) {
        return (int)(Math.pow(2.0, 0.25 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateWidthForDinBN(int n) {
        return (int)(Math.pow(2.0, -((double)n / 2.0)) * 1000.0);
    }

    private final int calculateHeightForDinBN(int n) {
        return (int)(Math.pow(2.0, 0.5 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateWidthForDinCN(int n) {
        return (int)(Math.pow(2.0, -0.125 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateHeightForDinCN(int n) {
        return (int)(Math.pow(2.0, 0.375 - (double)n / 2.0) * 1000.0);
    }

    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int x, int y) throws JRException {
        this.addMergeRegion(gridCell, x, y);
        Colour forecolor = this.getWorkbookColour(frame.getForecolor());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (frame.getMode() == 1) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(frame.getBackcolor());
        }
        WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue());
        WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), cellFont, gridCell);
        Blank cell = new Blank(x, y, (CellFormat)cellStyle);
        try {
            this.sheet.addCell((WritableCell)cell);
        }
        catch (JXLException e) {
            throw new JRException("Can't add cell.", e);
        }
    }

    private String getConvertedPattern(String pattern) {
        if (this.formatPatternsMap != null && this.formatPatternsMap.containsKey(pattern)) {
            return (String)this.formatPatternsMap.get(pattern);
        }
        return pattern;
    }

    protected ExporterNature getNature() {
        return this.nature;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class StyleInfo {
        protected final Pattern mode;
        protected final Colour backcolor;
        protected final int horizontalAlignment;
        protected final int verticalAlignment;
        protected final int rotation;
        protected final WritableFont font;
        protected final BoxStyle box;
        private DisplayFormat displayFormat;
        private int hashCode;

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRBox box) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = new BoxStyle(box);
            this.computeHash();
        }

        protected void computeHash() {
            int hash = this.mode.hashCode();
            hash = 31 * hash + this.backcolor.hashCode();
            hash = 31 * hash + this.horizontalAlignment;
            hash = 31 * hash + this.verticalAlignment;
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + this.font.hashCode();
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            this.hashCode = hash = 31 * hash + (this.displayFormat == null ? 0 : this.displayFormat.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo k = (StyleInfo)o;
            return k.mode.equals(this.mode) && k.backcolor.equals(this.backcolor) && k.horizontalAlignment == this.horizontalAlignment && k.verticalAlignment == this.verticalAlignment && k.rotation == this.rotation && k.font.equals((Object)this.font) && (k.box == null ? this.box == null : this.box != null && k.box.equals(this.box)) && (k.displayFormat == null ? this.displayFormat == null : this.displayFormat != null && k.displayFormat.equals(this.displayFormat));
        }

        public DisplayFormat getDisplayFormat() {
            return this.displayFormat;
        }

        public void setDisplayFormat(DisplayFormat displayFormat) {
            this.displayFormat = displayFormat;
            this.computeHash();
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.displayFormat + ")";
        }
    }

    protected class BoxStyle {
        protected final BorderLineStyle topBorder;
        protected final BorderLineStyle bottomBorder;
        protected final BorderLineStyle leftBorder;
        protected final BorderLineStyle rightBorder;
        protected final Colour topBorderColour;
        protected final Colour bottomBorderColour;
        protected final Colour leftBorderColour;
        protected final Colour rightBorderColour;
        private final int hash;

        public BoxStyle(JRBox box) {
            if (box != null && box.getTopBorder() != 0) {
                this.topBorder = JExcelApiExporter.getBorderLineStyle(box.getTopBorder());
                this.topBorderColour = JExcelApiExporter.this.getWorkbookColour(box.getTopBorderColor());
            } else {
                this.topBorder = BorderLineStyle.NONE;
                this.topBorderColour = BLACK;
            }
            if (box != null && box.getBottomBorder() != 0) {
                this.bottomBorder = JExcelApiExporter.getBorderLineStyle(box.getBottomBorder());
                this.bottomBorderColour = JExcelApiExporter.this.getWorkbookColour(box.getBottomBorderColor());
            } else {
                this.bottomBorder = BorderLineStyle.NONE;
                this.bottomBorderColour = BLACK;
            }
            if (box != null && box.getLeftBorder() != 0) {
                this.leftBorder = JExcelApiExporter.getBorderLineStyle(box.getLeftBorder());
                this.leftBorderColour = JExcelApiExporter.this.getWorkbookColour(box.getLeftBorderColor());
            } else {
                this.leftBorder = BorderLineStyle.NONE;
                this.leftBorderColour = BLACK;
            }
            if (box != null && box.getRightBorder() != 0) {
                this.rightBorder = JExcelApiExporter.getBorderLineStyle(box.getRightBorder());
                this.rightBorderColour = JExcelApiExporter.this.getWorkbookColour(box.getRightBorderColor());
            } else {
                this.rightBorder = BorderLineStyle.NONE;
                this.rightBorderColour = BLACK;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.topBorder.hashCode();
            hashCode = 31 * hashCode + this.topBorderColour.hashCode();
            hashCode = 31 * hashCode + this.bottomBorder.hashCode();
            hashCode = 31 * hashCode + this.bottomBorderColour.hashCode();
            hashCode = 31 * hashCode + this.leftBorder.hashCode();
            hashCode = 31 * hashCode + this.leftBorderColour.hashCode();
            hashCode = 31 * hashCode + this.rightBorder.hashCode();
            hashCode = 31 * hashCode + this.rightBorderColour.hashCode();
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.topBorder.equals(this.topBorder) && b.topBorderColour.equals(this.topBorderColour) && b.bottomBorder.equals(this.bottomBorder) && b.bottomBorderColour.equals(this.bottomBorderColour) && b.leftBorder.equals(this.leftBorder) && b.leftBorderColour.equals(this.leftBorderColour) && b.rightBorder.equals(this.rightBorder) && b.rightBorderColour.equals(this.rightBorderColour);
        }

        public String toString() {
            return "(" + this.topBorder.getValue() + "/" + this.topBorderColour.getValue() + "," + this.bottomBorder.getValue() + "/" + this.bottomBorderColour.getValue() + "," + this.leftBorder.getValue() + "/" + this.leftBorderColour.getValue() + "," + this.rightBorder.getValue() + "/" + this.rightBorderColour.getValue() + ")";
        }
    }

    protected class CellTextValueHandler
    implements TextValueHandler {
        private final int x;
        private final int y;
        private final StyleInfo baseStyle;
        private CellValue result;

        public CellTextValueHandler(int x, int y, StyleInfo baseStyle) {
            this.x = x;
            this.y = y;
            this.baseStyle = baseStyle;
        }

        public void handle(StringTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = new Label(this.x, this.y, textValue.getText(), (CellFormat)cellStyle);
        }

        public void handle(NumberTextValue textValue) throws JRException {
            if (textValue.getPattern() != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getNumberFormat(textValue.getPattern()));
            }
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new Number(this.x, this.y, textValue.getValue().doubleValue(), (CellFormat)cellStyle);
        }

        public void handle(DateTextValue textValue) throws JRException {
            this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getDateFormat(textValue.getPattern()));
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new DateTime(this.x, this.y, textValue.getValue(), (CellFormat)cellStyle);
        }

        public void handle(BooleanTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new Boolean(this.x, this.y, textValue.getValue().booleanValue(), (CellFormat)cellStyle);
        }

        protected Blank blank(WritableCellFormat cellStyle) {
            return new Blank(this.x, this.y, (CellFormat)cellStyle);
        }

        public CellValue getResult() {
            return this.result;
        }
    }
}

