/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.data.JRJpaDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJpaQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$query$JRJpaQueryExecuter == null ? (class$net$sf$jasperreports$engine$query$JRJpaQueryExecuter = JRJpaQueryExecuter.class$("net.sf.jasperreports.engine.query.JRJpaQueryExecuter")) : class$net$sf$jasperreports$engine$query$JRJpaQueryExecuter));
    private final Integer reportMaxCount;
    private EntityManager em = (EntityManager)this.getParameterValue("JPA_ENTITY_MANAGER");
    private Query query;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$query$JRJpaQueryExecuter;

    public JRJpaQueryExecuter(JRDataset dataset, Map parameters) {
        super(dataset, parameters);
        this.reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
        if (this.em == null) {
            log.warn((Object)"The supplied javax.persistence.EntityManager object is null.");
        }
        this.parseQuery();
    }

    public JRDataSource createDatasource() throws JRException {
        JRDataSource datasource = null;
        String queryString = this.getQueryString();
        if (this.em != null && queryString != null && queryString.trim().length() > 0) {
            this.createQuery(queryString);
            datasource = this.createResultDatasource();
        }
        return datasource;
    }

    protected synchronized void createQuery(String queryString) {
        Map queryHintsMap;
        this.query = this.em.createQuery(queryString);
        List parameterNames = this.getCollectedParameterNames();
        if (!parameterNames.isEmpty()) {
            HashSet<String> namesSet = new HashSet<String>();
            Iterator iter = parameterNames.iterator();
            while (iter.hasNext()) {
                String parameterName = (String)iter.next();
                if (!namesSet.add(parameterName)) continue;
                JRValueParameter parameter = this.getValueParameter(parameterName);
                this.query.setParameter(this.getEjbqlParameterName(parameterName), parameter.getValue());
            }
        }
        if ((queryHintsMap = (Map)this.getParameterValue("JPA_QUERY_HINTS_MAP")) != null) {
            Iterator i = queryHintsMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry pairs = i.next();
                log.debug((Object)("EJBQL query hint [" + pairs.getKey() + "] set."));
                this.query.setHint((String)pairs.getKey(), pairs.getValue());
            }
        }
        JRPropertiesMap datasetProperties = this.dataset.getPropertiesMap();
        String[] propertyNames = datasetProperties.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            String queryHint;
            String propertyName = propertyNames[i];
            if (!propertyName.startsWith("net.sf.jasperreports.ejbql.query.hint.") || (queryHint = propertyName.replaceFirst("net.sf.jasperreports.ejbql.query.hint.", "")) == null || queryHint.length() <= 0) continue;
            String property = datasetProperties.getProperty(propertyName);
            log.debug((Object)("EJBQL query hint [" + queryHint + "] set to: " + property));
            this.query.setHint(queryHint, (Object)property);
        }
    }

    protected JRDataSource createResultDatasource() {
        JRJpaDataSource resDatasource;
        JRPropertiesMap datasetProperties = this.dataset.getPropertiesMap();
        try {
            int pageSize = JRProperties.getIntegerProperty(datasetProperties, "net.sf.jasperreports.ejbql.query.page.size", 0);
            resDatasource = new JRJpaDataSource(this, pageSize);
        }
        catch (NumberFormatException e) {
            throw new JRRuntimeException("The net.sf.jasperreports.ejbql.query.page.size property must be numerical.");
        }
        return resDatasource;
    }

    public synchronized void close() {
        this.query = null;
    }

    public synchronized boolean cancelQuery() throws JRException {
        return false;
    }

    protected String getParameterReplacement(String parameterName) {
        return ':' + this.getEjbqlParameterName(parameterName);
    }

    protected String getEjbqlParameterName(String parameterName) {
        return JRStringUtil.getLiteral(parameterName);
    }

    public List getResultList() {
        if (this.reportMaxCount != null) {
            this.query.setMaxResults(this.reportMaxCount.intValue());
        }
        return this.query.getResultList();
    }

    public List getResultList(int firstIndex, int resultCount) {
        if (this.reportMaxCount != null && firstIndex + resultCount > this.reportMaxCount) {
            resultCount = this.reportMaxCount - firstIndex;
        }
        this.query.setFirstResult(firstIndex);
        this.query.setMaxResults(resultCount);
        return this.query.getResultList();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

