/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.webflow.FlowException;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.impl.FlowExecutionImpl;
import org.springframework.webflow.execution.repository.CannotContinueConversationException;
import org.springframework.webflow.execution.repository.ConversationLock;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.NoSuchConversationException;
import org.springframework.webflow.execution.repository.continuation.Conversation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;
import org.springframework.webflow.execution.repository.support.NoOpConversationLock;

public class ContinuationFlowExecutionRepository
extends AbstractFlowExecutionRepository
implements Serializable {
    private static final long serialVersionUID = -602931852676786766L;
    private Map conversations = new HashMap();
    private transient FlowExecutionContinuationFactory continuationFactory = new SerializedFlowExecutionContinuationFactory();
    private int maxContinuations = 25;

    public ContinuationFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices) {
        super(repositoryServices);
    }

    public FlowExecutionContinuationFactory getContinuationFactory() {
        return this.continuationFactory;
    }

    public void setContinuationFactory(FlowExecutionContinuationFactory continuationFactory) {
        this.continuationFactory = continuationFactory;
    }

    public int getMaxContinuations() {
        return this.maxContinuations;
    }

    public void setMaxContinuations(int maxContinuations) {
        this.maxContinuations = maxContinuations;
    }

    public ConversationLock getLock(Serializable conversationId) {
        return NoOpConversationLock.INSTANCE;
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        Conversation conversation = this.getRequiredConversation(key.getConversationId());
        FlowExecutionContinuation continuation = this.getRequiredContinuation(conversation, key);
        FlowExecutionImpl impl = (FlowExecutionImpl)this.rehydrate(continuation.getFlowExecution());
        impl.setScope(conversation.getScope());
        return impl;
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) {
        Conversation conversation = this.getOrCreateConversation(key.getConversationId());
        conversation.setScope(flowExecution.getScope());
        this.removeConversationAttributes(flowExecution);
        conversation.addContinuation(this.continuationFactory.createContinuation(key.getContinuationId(), flowExecution));
    }

    private void removeConversationAttributes(FlowExecution flowExecution) {
        ((FlowExecutionImpl)flowExecution).setScope(null);
    }

    public FlowExecutionKey getCurrentFlowExecutionKey(Serializable conversationId) throws FlowExecutionRepositoryException {
        return new FlowExecutionKey(conversationId, this.getConversation(conversationId).getCurrentContinuation().getId());
    }

    public ViewSelection getCurrentViewSelection(Serializable conversationId) throws FlowException {
        return this.getConversation(conversationId).getCurrentViewSelection();
    }

    public void setCurrentViewSelection(Serializable conversationId, ViewSelection viewSelection) throws FlowException {
        this.getConversation(conversationId).setCurrentViewSelection(viewSelection);
    }

    public void invalidateConversation(Serializable conversationId) {
        this.conversations.remove(conversationId);
    }

    private Conversation getConversation(Serializable conversationId) {
        return (Conversation)this.conversations.get(conversationId);
    }

    private Conversation getRequiredConversation(Serializable conversationId) throws NoSuchConversationException {
        Conversation conversation = this.getConversation(conversationId);
        if (conversation == null) {
            throw new NoSuchConversationException(conversationId);
        }
        return conversation;
    }

    private FlowExecutionContinuation getRequiredContinuation(Conversation conversation, FlowExecutionKey continuationKey) throws CannotContinueConversationException {
        FlowExecutionContinuation continuation = conversation.getContinuation(continuationKey.getContinuationId());
        if (continuation == null) {
            throw new CannotContinueConversationException(continuationKey);
        }
        return continuation;
    }

    private Conversation getOrCreateConversation(Serializable conversationId) {
        Conversation conversation = this.getConversation(conversationId);
        if (conversation == null) {
            conversation = this.createConversation();
            this.conversations.put(conversationId, conversation);
        }
        return conversation;
    }

    protected Conversation createConversation() {
        return new Conversation(this.maxContinuations);
    }
}

