/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.catedit;

import com.tonbeller.wcf.catedit.Category;
import com.tonbeller.wcf.catedit.CategoryElementRenderer;
import com.tonbeller.wcf.catedit.CategoryModel;
import com.tonbeller.wcf.catedit.CategoryModelChangeEvent;
import com.tonbeller.wcf.catedit.CategoryModelChangeListener;
import com.tonbeller.wcf.catedit.DefaultCategoryElementRenderer;
import com.tonbeller.wcf.catedit.DefaultItemElementRenderer;
import com.tonbeller.wcf.catedit.Item;
import com.tonbeller.wcf.catedit.ItemElementRenderer;
import com.tonbeller.wcf.changeorder.ChangeOrderMgr;
import com.tonbeller.wcf.changeorder.ChangeOrderModel;
import com.tonbeller.wcf.changeorder.ChangeOrderUtils;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.NestableComponentSupport;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CategoryEditor
extends NestableComponentSupport
implements ChangeOrderModel,
CategoryModelChangeListener {
    CategoryModel model;
    String rootElementName = "cat-edit";
    String changeCategoryButtonElementName = "cat-button";
    CategoryElementRenderer categoryRenderer = new DefaultCategoryElementRenderer();
    ItemElementRenderer itemRenderer = new DefaultItemElementRenderer();
    Dispatcher dispatcher = new DispatcherSupport();
    ChangeOrderMgr changeOrderMgr;
    Document factory;
    RequestContext context;

    public CategoryEditor(String id, Component parent) {
        super(id, parent);
        super.getDispatcher().addRequestListener(null, null, this.dispatcher);
    }

    public CategoryEditor(String id, Component parent, CategoryModel model) {
        super(id, parent);
        super.getDispatcher().addRequestListener(null, null, this.dispatcher);
        this.setModel(model);
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.changeOrderMgr = new ChangeOrderMgr(super.getDispatcher(), this, this);
    }

    public Element render(RequestContext context, Document factory) throws Exception {
        this.factory = factory;
        this.context = context;
        this.itemRenderer.startRendering(context);
        this.dispatcher.clear();
        this.dispatcher.addRequestListener(null, null, this.itemRenderer);
        Element rootElem = factory.createElement(this.rootElementName);
        List categories = this.model.getCategories();
        if (categories != null && categories.size() > 0) {
            this.renderRootElement(rootElem);
        }
        this.itemRenderer.stopRendering();
        return rootElem;
    }

    void renderRootElement(Element rootElem) {
        this.changeOrderMgr.startRendering(this.context);
        Iterator it = this.model.getCategories().iterator();
        while (it.hasNext()) {
            Category cat = (Category)it.next();
            Element catElem = this.renderCategory(cat);
            rootElem.appendChild(catElem);
        }
        this.changeOrderMgr.stopRendering();
    }

    Element renderCategory(Category cat) {
        Element catElem = this.categoryRenderer.render(this.context, this.factory, cat);
        int count = cat.getItems().size();
        int index = 0;
        Iterator it = cat.getItems().iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            Element itemElem = this.renderItem(item, cat);
            catElem.appendChild(itemElem);
            this.changeOrderMgr.renderButton(itemElem, cat, item, index, count);
            ++index;
        }
        return catElem;
    }

    Element renderItem(Item item, Category cat) {
        Element itemElem = this.itemRenderer.render(this.context, this.factory, cat, item);
        int N = cat.getItems().size();
        if (item.isMovable() && (N > 1 || cat.isEmptyAllowed())) {
            Iterator it = this.model.getCategories().iterator();
            while (it.hasNext()) {
                Category other = (Category)it.next();
                if (other.equals(cat)) continue;
                Element buttonElem = this.renderChangeCategoryButton(item, cat, other);
                itemElem.appendChild(buttonElem);
            }
        }
        return itemElem;
    }

    Element renderChangeCategoryButton(Item item, Category source, Category target) {
        Element buttonElem = this.factory.createElement(this.changeCategoryButtonElementName);
        buttonElem.setAttribute("icon", target.getIcon());
        buttonElem.setAttribute("title", target.getTitle());
        String id = DomUtils.randomId();
        buttonElem.setAttribute("id", id);
        this.dispatcher.addRequestListener(id, null, new ChangeCategoryButtonHandler(item, source, target));
        return buttonElem;
    }

    public CategoryModel getModel() {
        return this.model;
    }

    public void setModel(CategoryModel newModel) {
        if (this.model != null) {
            this.model.removeCategoryModelChangeListener(this);
        }
        this.model = newModel;
        if (this.model != null) {
            this.model.addCategoryModelChangeListener(this);
        }
    }

    public void categoryModelChanged(CategoryModelChangeEvent event) {
        this.itemRenderer.categoryModelChanged(event);
        this.dispatcher.clear();
    }

    public CategoryElementRenderer getCategoryRenderer() {
        return this.categoryRenderer;
    }

    public String getChangeCategoryButtonElementName() {
        return this.changeCategoryButtonElementName;
    }

    public ItemElementRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public void setCategoryRenderer(CategoryElementRenderer categoryRenderer) {
        this.categoryRenderer = categoryRenderer;
    }

    public void setChangeCategoryButtonElementName(String changeCategoryButtonElementName) {
        this.changeCategoryButtonElementName = changeCategoryButtonElementName;
    }

    public void setItemRenderer(ItemElementRenderer itemRenderer) {
        this.itemRenderer = itemRenderer;
    }

    public void setRootElementName(String rootElementName) {
        this.rootElementName = rootElementName;
    }

    public boolean mayMove(Object scope, Object item) {
        Category cat = (Category)scope;
        if (!cat.isOrderSignificant()) {
            return false;
        }
        return cat.getItems().size() > 0 || cat.isEmptyAllowed();
    }

    public void move(Object scope, Object item, int oldIndex, int newIndex) {
        Category cat = (Category)scope;
        if (cat == null) {
            return;
        }
        ArrayList items = new ArrayList();
        items.addAll(cat.getItems());
        ChangeOrderUtils.move(items, oldIndex, newIndex);
        cat.changeOrder(items);
    }

    class ChangeCategoryButtonHandler
    implements RequestListener {
        Item item;
        Category source;
        Category target;

        ChangeCategoryButtonHandler(Item item, Category source, Category target) {
            this.item = item;
            this.source = source;
            this.target = target;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            CategoryEditor.this.validate(context);
            this.source.removeItem(this.item);
            this.target.addItem(this.item);
        }
    }
}

