/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.changeorder.ChangeOrderMgr;
import com.tonbeller.wcf.changeorder.ChangeOrderModel;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.NestableComponentSupport;
import com.tonbeller.wcf.component.RenderListener;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.convert.BooleanConverter;
import com.tonbeller.wcf.convert.CheckBoxConverter;
import com.tonbeller.wcf.convert.RadioButtonConverter;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.selection.SelectionMgr;
import com.tonbeller.wcf.selection.SelectionModel;
import com.tonbeller.wcf.tree.DefaultNodeRenderer;
import com.tonbeller.wcf.tree.DeleteNodeModel;
import com.tonbeller.wcf.tree.NodeIterator;
import com.tonbeller.wcf.tree.NodeRenderer;
import com.tonbeller.wcf.tree.TreeBounding;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.tree.TreeModelChangeEvent;
import com.tonbeller.wcf.tree.TreeModelChangeListener;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TreeComponent
extends NestableComponentSupport {
    String treeElementName = "xtree-component";
    NodeRenderer nodeRenderer = new DefaultNodeRenderer();
    SelectionMgr selectionMgr;
    ChangeOrderMgr changeOrderMgr;
    ChangeOrderModel changeOrderModel;
    String border = null;
    String renderId = null;
    String width = null;
    String error = null;
    Set expanded = new HashSet();
    Dispatcher dispatcher = new DispatcherSupport();
    BooleanConverter radioConv = new RadioButtonConverter();
    BooleanConverter checkConv = new CheckBoxConverter();
    Resources resources = Resources.instance();
    TreeModel model;
    TreeBounding bounding = NO_BOUNDING;
    private static final TreeBounding NO_BOUNDING = new TreeBounding(){

        public boolean isBounded(Object parent) {
            return false;
        }

        public void unbound(Object parent) {
        }
    };
    RequestContext context;
    Document factory;
    int nodeCounter;
    DeleteNodeModel deleteNodeModel;
    TreeModelChangeListener changeListener = new TreeModelChangeListener(){

        public void treeModelChanged(TreeModelChangeEvent event) {
            if (event.isIdentityChanged()) {
                TreeComponent.this.expanded.clear();
                TreeComponent.this.dispatcher.clear();
            }
        }
    };

    public TreeComponent(String id, Component parent) {
        this(id, parent, null);
    }

    public TreeComponent(String id, Component parent, TreeModel model) {
        super(id, parent);
        this.selectionMgr = new SelectionMgr(this.getDispatcher(), this);
        this.changeOrderMgr = new ChangeOrderMgr(this.getDispatcher(), this);
        super.getDispatcher().addRequestListener(null, null, this.dispatcher);
        this.setModel(model);
    }

    public void setComparator(Comparator comp) {
        this.expanded = new TreeSet(comp);
    }

    public void setModel(TreeModel newModel) {
        this.bounding = NO_BOUNDING;
        if (this.model != null) {
            this.model.removeTreeModelChangeListener(this.changeListener);
        }
        this.model = newModel;
        if (this.model != null) {
            this.model.addTreeModelChangeListener(this.changeListener);
        }
        if (this.model instanceof ChangeOrderModel) {
            this.changeOrderMgr.setModel((ChangeOrderModel)((Object)this.model));
        } else {
            this.changeOrderMgr.setModel(null);
        }
        this.expanded.clear();
        this.selectionMgr.getSelectionModel().clear();
        this.dispatcher.clear();
    }

    public Element render(RequestContext context, Document factory) throws Exception {
        return this.render(context, factory, true);
    }

    private Element render(RequestContext context, Document factory, boolean clearDispatcher) throws Exception {
        this.factory = factory;
        this.context = context;
        if (clearDispatcher) {
            this.dispatcher.clear();
        }
        Element treeElem = factory.createElement(this.treeElementName);
        this.renderTree(treeElem);
        return treeElem;
    }

    Element renderTree(Element treeElem) {
        this.selectionMgr.startRendering(this.context);
        this.changeOrderMgr.startRendering(this.context);
        if (this.nodeRenderer instanceof RenderListener) {
            ((RenderListener)((Object)this.nodeRenderer)).startRendering(this.context);
        }
        this.nodeCounter = 0;
        Object[] roots = this.model.getRoots();
        if (roots == null) {
            treeElem.setAttribute("error", this.resources.getResourceBundle().getMessage("JAJ_000_wcf.tree.TreeComponent.restrictedAccess", null, this.resources.getLocaleContextHolderLocale()));
            return treeElem;
        }
        for (int i = 0; i < roots.length; ++i) {
            Element nodeElem = this.renderNode(null, roots, i, 0);
            if (nodeElem == null) continue;
            treeElem.appendChild(nodeElem);
        }
        if (this.nodeRenderer instanceof RenderListener) {
            ((RenderListener)((Object)this.nodeRenderer)).stopRendering();
        }
        this.changeOrderMgr.stopRendering();
        this.selectionMgr.stopRendering();
        if (this.border != null) {
            treeElem.setAttribute("border", this.border);
        }
        if (this.renderId != null) {
            treeElem.setAttribute("renderId", this.renderId);
        }
        if (this.width != null) {
            treeElem.setAttribute("width", this.width);
        }
        if (this.error != null) {
            treeElem.setAttribute("error", this.error);
        }
        return treeElem;
    }

    Element renderNode(Object parent, Object[] nodes, int nodeIndex, int level) {
        Object node = nodes[nodeIndex];
        if (this.deleteNodeModel != null && this.deleteNodeModel.getDeleted().contains(node)) {
            return null;
        }
        Element nodeElem = this.nodeRenderer.renderNode(this.context, this.factory, node);
        ++this.nodeCounter;
        this.renderEvenOddAttr(nodeElem);
        String id = DomUtils.randomId();
        nodeElem.setAttribute("id", id);
        nodeElem.setAttribute("level", "" + level);
        this.renderExpandedAttr(node, nodeElem, id);
        if (this.expanded.contains(node)) {
            Object[] children = this.model.getChildren(node);
            for (int i = 0; i < children.length; ++i) {
                Element childElem = this.renderNode(node, children, i, level + 1);
                if (childElem == null) continue;
                nodeElem.appendChild(childElem);
            }
        }
        this.selectionMgr.renderButton(nodeElem, node);
        this.changeOrderMgr.renderButton(nodeElem, parent, node, nodeIndex, nodes.length);
        this.renderDeleteButton(nodeElem, node);
        try {
            nodeElem.setUserData("nodedata", node, null);
        }
        catch (Error error) {
            return nodeElem;
        }
        return nodeElem;
    }

    void renderDeleteButton(Element elem, final Object node) {
        if (this.deleteNodeModel == null || !this.deleteNodeModel.isDeletable(node)) {
            return;
        }
        Element button = DomUtils.appendElement(elem, "delete-button");
        String id = DomUtils.randomId();
        button.setAttribute("id", id);
        RequestListener deleter = new RequestListener(){

            public void request(RequestContext context) throws Exception {
                Scroller.enableScroller(context);
                NodeIterator it = new NodeIterator(TreeComponent.this.getModel(), node, false);
                while (it.hasNext()) {
                    Object n = it.next();
                    TreeComponent.this.deleteNodeModel.delete(n);
                    TreeComponent.this.getSelectionModel().remove(n);
                    TreeComponent.this.expanded.remove(n);
                }
            }
        };
        this.dispatcher.addRequestListener(id, null, deleter);
    }

    void renderExpandedAttr(Object node, Element nodeElem, String id) {
        if (this.bounding.isBounded(node)) {
            nodeElem.setAttribute("state", "bounded");
            this.dispatcher.addRequestListener(id + ".unbound", null, new UnboundHandler(node));
        } else if (this.expanded.contains(node)) {
            nodeElem.setAttribute("state", "expanded");
            this.dispatcher.addRequestListener(id + ".collapse", null, new CollapseHandler(node));
        } else if (this.model.hasChildren(node)) {
            nodeElem.setAttribute("state", "collapsed");
            this.dispatcher.addRequestListener(id + ".expand", null, new ExpandHandler(node));
        } else {
            nodeElem.setAttribute("state", "leaf");
        }
    }

    void renderEvenOddAttr(Element nodeElem) {
        if (this.nodeCounter % 2 == 0) {
            nodeElem.setAttribute("style", "even");
        } else {
            nodeElem.setAttribute("style", "odd");
        }
    }

    public SelectionModel getSelectionModel() {
        return this.selectionMgr.getSelectionModel();
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        this.selectionMgr.setSelectionModel(selectionModel);
    }

    public void collapse(Object node) {
        this.expanded.remove(node);
    }

    public void expand(Object node) {
        this.expanded.add(node);
    }

    public void collapseAll() {
        this.expanded.clear();
    }

    public void expandSelected() {
        this.expandSelected(false);
    }

    public void expandSelected(boolean expandSelected) {
        this.expanded.clear();
        Iterator it = this.selectionMgr.getSelectionModel().getSelection().iterator();
        while (it.hasNext()) {
            Object node = it.next();
            if (expandSelected && this.model.hasChildren(node)) {
                this.expanded.add(node);
            }
            node = this.model.getParent(node);
            while (node != null) {
                this.expanded.add(node);
                node = this.model.getParent(node);
            }
        }
    }

    public void selectVisible() {
        SelectionModel sm = this.selectionMgr.getSelectionModel();
        sm.clear();
        Object[] roots = this.model.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            this.recurseSelectVisible(sm, roots[i]);
        }
    }

    private void recurseSelectVisible(SelectionModel sm, Object node) {
        if (sm.isSelectable(node)) {
            sm.add(node);
        }
        if (this.expanded.contains(node)) {
            Object[] children = this.model.getChildren(node);
            for (int i = 0; i < children.length; ++i) {
                this.recurseSelectVisible(sm, children[i]);
            }
        }
    }

    public TreeModel getModel() {
        return this.model;
    }

    public NodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public String getTreeElementName() {
        return this.treeElementName;
    }

    public void setNodeRenderer(NodeRenderer nodeRenderer) {
        if (this.nodeRenderer instanceof RequestListener) {
            super.getDispatcher().removeRequestListener((RequestListener)((Object)this.nodeRenderer));
        }
        this.nodeRenderer = nodeRenderer;
        if (this.nodeRenderer instanceof RequestListener) {
            super.getDispatcher().addRequestListener(null, null, (RequestListener)((Object)this.nodeRenderer));
        }
    }

    public void setTreeElementName(String treeElementName) {
        this.treeElementName = treeElementName;
    }

    public ChangeOrderModel getChangeOrderModel() {
        return this.changeOrderMgr.getModel();
    }

    public void setChangeOrderModel(ChangeOrderModel changeOrderModel) {
        this.changeOrderMgr.setModel(changeOrderModel);
    }

    public void setCutPasteMode(boolean b) {
        this.changeOrderMgr.setCutPasteMode(b);
    }

    public String getBorder() {
        return this.border;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    public void setRenderId(String renderId) {
        this.renderId = renderId;
    }

    public String getRenderId() {
        return this.renderId;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public DeleteNodeModel getDeleteNodeModel() {
        return this.deleteNodeModel;
    }

    public void setDeleteNodeModel(DeleteNodeModel model) {
        this.deleteNodeModel = model;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String string) {
        this.error = string;
    }

    public TreeBounding getBounding() {
        return this.bounding;
    }

    public void setBounding(TreeBounding bounding) {
        if (bounding == null) {
            bounding = NO_BOUNDING;
        }
        this.bounding = bounding;
    }

    class UnboundHandler
    implements RequestListener {
        Object node;

        public UnboundHandler(Object node) {
            this.node = node;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            TreeComponent.this.bounding.unbound(this.node);
            TreeComponent.this.validate(context);
        }
    }

    class ExpandHandler
    implements RequestListener {
        Object node;

        public ExpandHandler(Object node) {
            this.node = node;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            TreeComponent.this.expanded.add(this.node);
            TreeComponent.this.validate(context);
        }
    }

    class CollapseHandler
    implements RequestListener {
        Object node;

        public CollapseHandler(Object node) {
            this.node = node;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller(context);
            TreeComponent.this.expanded.remove(this.node);
            TreeComponent.this.validate(context);
        }
    }
}

