/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.tree.TreeModelChangeEvent;
import com.tonbeller.wcf.tree.TreeModelChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TreeModelChangeSupport {
    TreeModel source;
    ArrayList listeners = new ArrayList();

    public TreeModelChangeSupport(TreeModel source) {
        this.source = source;
    }

    public void fireModelChanged(boolean identityChanged, Object root) {
        if (this.listeners.size() > 0) {
            TreeModelChangeEvent event = new TreeModelChangeEvent(this.source, root, identityChanged);
            List copy = (List)this.listeners.clone();
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                ((TreeModelChangeListener)it.next()).treeModelChanged(event);
            }
        }
    }

    public void fireModelChanged(TreeModelChangeEvent event) {
        this.fireModelChanged(event.isIdentityChanged(), event.getSubtree());
    }

    public void fireModelChanged(boolean identityChanged) {
        this.fireModelChanged(identityChanged, null);
    }

    public void addTreeModelChangeListener(TreeModelChangeListener l) {
        this.listeners.add(l);
    }

    public void removeTreeModelChangeListener(TreeModelChangeListener l) {
        this.listeners.remove(l);
    }
}

