/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.jaspersoft.jasperserver.api.JSException;
import com.tonbeller.jpivot.mondrian.MondrianCell;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianResult;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.table.AbstractTableModel;
import com.tonbeller.wcf.table.DefaultTableRow;
import com.tonbeller.wcf.table.TableRow;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import mondrian.olap.MemoryLimitExceededException;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.util.MemoryMonitor;
import mondrian.util.MemoryMonitorFactory;
import org.apache.log4j.Logger;

public class MondrianDrillThroughTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger((Class)MondrianDrillThroughTableModel.class);
    private Resources resources;
    private MondrianCell monCell;
    private String title = "";
    private String caption = "";
    private String sql = "";
    private String jdbcUser;
    private String jdbcUrl;
    private String jdbcPassword;
    private String jdbcDriver;
    private String dataSourceName;
    private DataSource dataSource;
    private static Context jndiContext;
    private boolean ready = false;
    private String[] columnTitles = new String[0];
    private String encoding = Resources.instance().getCharacterEncoding();
    private Locale locale;
    private Connection con;
    private ResultSet rs;
    private int rowCount;

    public MondrianDrillThroughTableModel(Cell cell) {
        this.resources = Resources.instance();
        if (cell != null) {
            this.monCell = (MondrianCell)cell;
            this.locale = this.monCell.getModel().getLocale();
            this.title = this.resources.getResourceBundle().getMessage("jpivot.MondrianDrillThroughTableModel.message.drillThroughTable", null, this.locale);
        }
    }

    public int getRowCount() {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.rowCount;
    }

    public int getRowCount(ResultSet set) throws JSException {
        int rowCount = 0;
        if (set != null) {
            try {
                int currentRow = set.getRow();
                int n = rowCount = set.last() ? set.getRow() : 0;
                if (currentRow == 0) {
                    set.beforeFirst();
                } else {
                    set.absolute(currentRow);
                }
            }
            catch (SQLException e) {
                if (this.isDerby(this.con) && e.getMessage().contains("Feature not implemented")) {
                    throw new JSException("Out of memory during drill through");
                }
                throw new JSException("Cannot get drill through row count", (Throwable)e);
            }
        }
        return rowCount;
    }

    public TableRow getRow(int rowIndex) {
        if (!this.ready) {
            this.executeQuery();
        }
        Object[] row = null;
        try {
            ResultSetMetaData md = this.getResultSet().getMetaData();
            int numCols = md.getColumnCount();
            this.getResultSet().first();
            this.getResultSet().relative(rowIndex);
            row = new Object[numCols];
            for (int i = 0; i < numCols; ++i) {
                row[i] = this.getResultSet().getObject(i + 1);
                if (!(row[i] instanceof String)) continue;
                row[i] = new String(((String)row[i]).getBytes(this.encoding), this.encoding);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new DefaultTableRow(row);
    }

    public String getTitle() {
        return this.title;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
        this.ready = false;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getColumnCount() {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.columnTitles.length;
    }

    public String getColumnTitle(int columnIndex) {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.columnTitles[columnIndex];
    }

    public String[] getColumnTitles() {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.columnTitles;
    }

    private void executeQuery() {
        if (this.sql == null || "".equals(this.sql)) {
            return;
        }
        class Listener
        implements MemoryMonitor.Listener {
            String oomMsg;

            Listener() {
            }

            public void memoryUsageNotification(long used, long max) {
                StringBuffer buf = new StringBuffer(200);
                buf.append("OutOfMemory used=");
                buf.append(used);
                buf.append(", max=");
                buf.append(max);
                if (MondrianDrillThroughTableModel.this.dataSourceName != null) {
                    buf.append(" for data source: ");
                    buf.append(MondrianDrillThroughTableModel.this.dataSourceName);
                } else if (MondrianDrillThroughTableModel.this.jdbcUrl != null) {
                    buf.append(" for jcbc URL: ");
                    buf.append(MondrianDrillThroughTableModel.this.jdbcUrl);
                }
                this.oomMsg = buf.toString();
            }

            void check() throws MemoryLimitExceededException {
                if (this.oomMsg != null) {
                    throw new MemoryLimitExceededException(this.oomMsg);
                }
            }
        }
        Listener listener = new Listener();
        MemoryMonitor mm = MemoryMonitorFactory.getMemoryMonitor();
        try {
            mm.addListener((MemoryMonitor.Listener)listener);
            if (this.con != null) {
                this.con.close();
            }
            this.con = this.getConnection();
            Statement s = this.con.createStatement(1005, 1007);
            this.rs = s.executeQuery(this.sql);
            ResultSetMetaData md = this.rs.getMetaData();
            int numCols = md.getColumnCount();
            this.columnTitles = new String[numCols];
            this.rowCount = this.getRowCount(this.rs);
            listener.check();
            if (logger != null) {
                logger.debug((Object)this.resources.getString("jpivot.MondrianDrillThroughTableModel.message.encoding", new Object[]{this.encoding}));
            }
            for (int i = 0; i < numCols; ++i) {
                this.columnTitles[i] = new String(md.getColumnName(i + 1).getBytes(this.encoding), this.encoding);
            }
            this.locale = this.monCell != null ? this.monCell.getModel().getLocale() : Locale.getDefault();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (logger != null) {
                logger.error((Object)this.resources.getString("jpivot.MondrianDrillThroughTableModel.error.questionMark"), (Throwable)e);
            }
            this.ready = false;
            throw new JSException(e.getMessage(), (Throwable)e);
        }
        catch (Error e) {
            logger.error((Object)"Error occurred ", (Throwable)e);
            this.ready = false;
            throw new JSException(e.getMessage(), (Throwable)e);
        }
        this.ready = true;
    }

    public void setTitle(Cell cell, boolean isIncludeOnlySelectedMeasure) {
        int colDisp = 1;
        if (!isIncludeOnlySelectedMeasure) {
            try {
                MondrianModel model = ((MondrianCell)cell).getModel();
                if (model == null) {
                    return;
                }
                QueryAdapter qa = model.getQueryAdapter();
                if (qa == null) {
                    return;
                }
                Result modelResult = model.getResult();
                if (modelResult == null) {
                    return;
                }
                colDisp = qa.isSwapAxes() ? ((MondrianResult)modelResult).getPosize()[1] : ((MondrianResult)modelResult).getPosize()[0];
                if (colDisp == 0) {
                    return;
                }
            }
            catch (OlapException e) {
                logger.error((Object)"Cannot determine column disposition due to Olap model error.");
            }
        }
        if (this.getColumnTitles().length - colDisp < 0) {
            logger.error((Object)"Cannot determine column index.");
            return;
        }
        this.title = this.title.concat(this.resources.getResourceBundle().getMessage("jpivot.MondrianDrillThroughTableModel.label.for", null, this.locale) + "[" + this.getColumnTitles()[this.getColumnTitles().length - colDisp] + " = " + (this.getMonCell() == null ? "" : this.getMonCell().getFormattedValue()) + "]");
    }

    private Connection getConnection() throws SQLException {
        if (this.dataSourceName == null) {
            if (this.jdbcUrl == null) {
                throw new RuntimeException(this.resources.getString("jpivot.MondrianDrillThroughTableModel.error.connectionError", new Object[]{RolapConnectionProperties.Jdbc, RolapConnectionProperties.DataSource}));
            }
            return DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
        }
        return this.getDataSource().getConnection();
    }

    private DataSource getDataSource() {
        if (this.dataSource == null) {
            try {
                this.dataSource = (DataSource)this.getJndiContext().lookup(this.dataSourceName);
            }
            catch (NamingException e) {
                throw new RuntimeException(this.resources.getString("jpivot.MondrianDrillThroughTableModel.error.dataSourceError", new Object[]{this.dataSourceName}), e);
            }
        }
        return this.dataSource;
    }

    private Context getJndiContext() throws NamingException {
        if (jndiContext == null) {
            jndiContext = new InitialContext();
        }
        return jndiContext;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setMonCell(MondrianCell mCell) {
        this.monCell = mCell;
    }

    public MondrianCell getMonCell() {
        return this.monCell;
    }

    public Connection getCon() {
        return this.con;
    }

    public ResultSet getResultSet() {
        try {
            this.rs.getRow();
        }
        catch (Exception e) {
            this.executeQuery();
            return this.rs;
        }
        return this.rs;
    }

    public boolean isDerby(Connection jdbcConnection) {
        String productName = null;
        try {
            productName = jdbcConnection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new JSException("failed to get productName", (Throwable)e);
        }
        return productName.trim().toUpperCase().equals("APACHE DERBY");
    }
}

