/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.query.MDXElement;
import com.tonbeller.jpivot.olap.query.MDXLevel;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MondrianLevel
implements Level,
MDXElement,
MDXLevel {
    private mondrian.olap.Level monLevel;
    private MondrianHierarchy hierarchy;
    private ArrayList aMembers;
    private MondrianModel model;
    private Resources resources;
    boolean drilling;
    boolean zooming;

    protected MondrianLevel(mondrian.olap.Level monLevel, MondrianHierarchy hierarchy, MondrianModel model) {
        this.monLevel = monLevel;
        this.hierarchy = hierarchy;
        this.model = model;
        this.resources = Resources.instance((Locale)model.getLocale(), (Class)MondrianLevel.class);
        this.aMembers = new ArrayList();
        hierarchy.addLevel(this);
    }

    protected void addMember(MondrianMember member) {
        this.aMembers.add(member);
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public String getLabel() {
        String label = this.monLevel.getCaption();
        return this.resources.getOptionalString(label, label);
    }

    public int getDepth() {
        return this.monLevel.getDepth();
    }

    public void accept(Visitor visitor) {
        visitor.visitLevel(this);
    }

    public Object getRootDecoree() {
        return this;
    }

    public mondrian.olap.Level getMonLevel() {
        return this.monLevel;
    }

    public String getUniqueName() {
        return this.monLevel.getUniqueName();
    }

    public boolean isAll() {
        return this.monLevel.isAll();
    }

    public boolean hasChildLevel() {
        return this.monLevel.getChildLevel() != null;
    }

    public List getMembers() {
        return this.aMembers;
    }

    public boolean isDrilling() {
        return this.drilling;
    }

    public void setDrilling(boolean drilling) {
        this.drilling = drilling;
    }

    public boolean isZooming() {
        return this.zooming;
    }

    public void setZooming(boolean zooming) {
        this.zooming = zooming;
    }
}

