/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.mondrian.MondrianResult;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import com.tonbeller.jpivot.olap.query.Quax;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Formula;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.SchemaReader;
import org.apache.log4j.Logger;

public class MondrianMemberTree
extends ExtensionSupport
implements MemberTree {
    static Logger logger = Logger.getLogger((Class)MondrianMemberTree.class);

    public MondrianMemberTree() {
        super.setId("memberTree");
    }

    public Member[] getRootMembers(Hierarchy hier) {
        try {
            return this.internalGetRootMembers(hier);
        }
        catch (ResultLimitExceededException e) {
            logger.error(null, (Throwable)e);
            throw new MemberTree.TooManyMembersException(e);
        }
    }

    private Member[] internalGetRootMembers(Hierarchy hier) {
        MondrianQueryAdapter adapter;
        Quax quax;
        mondrian.olap.Member[] monMembers;
        Query q;
        mondrian.olap.Hierarchy monHier;
        MondrianModel model;
        block9: {
            model = (MondrianModel)this.getModel();
            monHier = ((MondrianHierarchy)hier).getMonHierarchy();
            q = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
            SchemaReader scr = q.getSchemaReader(true);
            monMembers = null;
            try {
                monMembers = scr.getHierarchyRootMembers(monHier);
            }
            catch (Exception e) {
                if (!e.getMessage().startsWith("Internal error: Illegal access")) break block9;
                return null;
            }
        }
        ArrayList<MondrianMember> aMem = new ArrayList<MondrianMember>();
        final ArrayList<MondrianMember> visibleRootMembers = new ArrayList<MondrianMember>();
        int k = monMembers.length;
        for (int i = 0; i < k; ++i) {
            mondrian.olap.Member monMember = monMembers[i];
            if (!this.isVisible(monMember)) continue;
            aMem.add(model.addMember(monMembers[i]));
        }
        Formula[] formulas = q.getFormulas();
        for (int i = 0; i < formulas.length; ++i) {
            MondrianMember m;
            Formula f = formulas[i];
            mondrian.olap.Member monMem = f.getMdxMember();
            if (monMem == null || !monMem.getHierarchy().equals(monHier) || !this.isVisible(monMem) || aMem.contains(m = model.addMember(monMem))) continue;
            aMem.add(m);
        }
        MondrianResult res = model.currentResult();
        if (res != null && (quax = (adapter = (MondrianQueryAdapter)model.getQueryAdapter()).findQuax(hier.getDimension())) != null) {
            int iDim = quax.dimIdx(hier.getDimension());
            int iAx = quax.getOrdinal();
            if (adapter.isSwapAxes()) {
                iAx = (iAx + 1) % 2;
            }
            Axis axis = res.getAxes()[iAx];
            List positions = axis.getPositions();
            Iterator iter = positions.iterator();
            while (iter.hasNext()) {
                Position pos = (Position)iter.next();
                Member[] posMembers = pos.getMembers();
                MondrianMember mem = (MondrianMember)posMembers[iDim];
                if (mem.getMonMember().getParentMember() != null) continue;
                if (!visibleRootMembers.contains(mem)) {
                    visibleRootMembers.add(mem);
                }
                if (aMem.contains(mem)) continue;
                aMem.add(mem);
            }
        }
        Member[] members = aMem.toArray(new Member[0]);
        if (visibleRootMembers.size() != 0) {
            Arrays.sort(members, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Member m1 = (Member)arg0;
                    Member m2 = (Member)arg1;
                    int index1 = visibleRootMembers.indexOf(m1);
                    int index2 = visibleRootMembers.indexOf(m2);
                    if (index2 == -1) {
                        return -1;
                    }
                    if (index1 == -1) {
                        return 1;
                    }
                    return index1 - index2;
                }
            });
        }
        return members;
    }

    private boolean isVisible(mondrian.olap.Member monMember) {
        if (monMember.getName().startsWith(".")) {
            return false;
        }
        Object visible = monMember.getPropertyValue(Property.VISIBLE.name);
        return !Boolean.FALSE.equals(visible);
    }

    public boolean hasChildren(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        if (monMember.isCalculatedInQuery()) {
            return false;
        }
        if (monMember.getLevel().getChildLevel() != null) {
            return true;
        }
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getMonConnection().getSchemaReader();
        return scr.isDrillable(monMember);
    }

    public Member[] getChildren(Member member) {
        try {
            return this.internalGetChildren(member);
        }
        catch (ResultLimitExceededException e) {
            logger.error(null, (Throwable)e);
            throw new MemberTree.TooManyMembersException(e);
        }
    }

    private Member[] internalGetChildren(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getMonConnection().getSchemaReader();
        mondrian.olap.Member[] monChildren = scr.getMemberChildren(monMember);
        Member[] children = new Member[monChildren.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = model.addMember(monChildren[i]);
        }
        return children;
    }

    public Member getParent(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getMonConnection().getSchemaReader();
        mondrian.olap.Member monParent = scr.getMemberParent(monMember);
        if (monParent == null) {
            return null;
        }
        MondrianMember parent = model.addMember(monParent);
        return parent;
    }
}

