/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator.hierarchy;

import com.tonbeller.jpivot.navigator.hierarchy.AbstractCategory;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyItem;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyNavigator;
import com.tonbeller.jpivot.navigator.member.MemberSelectionModel;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.navi.PlaceHierarchiesOnAxes;
import com.tonbeller.jpivot.olap.navi.PlaceMembersOnAxes;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.RequestContext;
import java.util.Collection;
import java.util.Iterator;

class AxisCategory
extends AbstractCategory {
    Axis axis;
    Object[] memberExpressions;

    public AxisCategory(HierarchyNavigator navi, Axis axis, String name, String icon, String title) {
        super(navi, name, icon, title);
        this.axis = axis;
        Hierarchy[] hiers = axis.getHierarchies();
        for (int i = 0; i < hiers.length; ++i) {
            Hierarchy hier = hiers[i];
            HierarchyItem hi = new HierarchyItem(this, hier);
            this.items.add(hi);
        }
    }

    public void itemClicked(RequestContext context, HierarchyItem item) {
        MemberSelectionModel selection = new MemberSelectionModel();
        if (this.navi.getMemberExtension() == null) {
            selection.setMode(0);
        } else {
            selection.setMode(2);
        }
        selection.setOrderedSelection(item.getAxisSelection());
        this.navi.itemClicked(context, item, selection, true);
    }

    void setSelection(HierarchyItem item, Collection selection) {
        item.setAxisSelection(selection);
    }

    String validateSelection(HierarchyItem item, Collection selection) {
        Resources res = this.getNavigator().getRes();
        if (selection.size() < 1) {
            return res.getString("jsp.jpivot.selection.mustSelectOneOrMore");
        }
        Hierarchy hier = null;
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Member m = (Member)it.next();
            Hierarchy mh = m.getLevel().getHierarchy();
            if (hier == null) {
                hier = mh;
                continue;
            }
            if (hier.equals(mh)) continue;
            return res.getString("jsp.jpivot.selection.selection.multipleHierarchies");
        }
        return null;
    }

    public boolean isOrderSignificant() {
        return true;
    }

    void prepareApplyChanges() {
        if (!this.isDirty()) {
            return;
        }
        this.setDirty(false);
        PlaceHierarchiesOnAxes hierExtension = this.navi.getHierarchyExtension();
        PlaceMembersOnAxes memberExtension = this.navi.getMemberExtension();
        if (hierExtension == null) {
            return;
        }
        this.memberExpressions = new Object[this.getItems().size()];
        Iterator it = this.getItems().iterator();
        for (int i = 0; i < this.memberExpressions.length; ++i) {
            HierarchyItem hi = (HierarchyItem)it.next();
            this.memberExpressions[i] = hi.getExpression() != null ? hi.getExpression() : (hi.isAxisSelectionDirty() && memberExtension != null ? memberExtension.createMemberExpression(hi.getAxisSelection()) : hierExtension.createMemberExpression(hi.getHierarchy()));
        }
    }

    void applyChanges() {
        PlaceHierarchiesOnAxes hierExtension = this.navi.getHierarchyExtension();
        if (hierExtension == null) {
            return;
        }
        if (this.memberExpressions != null) {
            hierExtension.setQueryAxis((Axis)this.axis.getRootDecoree(), this.memberExpressions);
            this.memberExpressions = null;
        }
    }

    public boolean isEmptyAllowed() {
        return false;
    }

    public boolean isSlicer() {
        return false;
    }
}

