/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.model;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class OlapUtils {
    static final Set infix = new HashSet();
    static final Set prefix = new HashSet();
    static Resources resources;
    static final Set singleRecordLevelNames;

    private OlapUtils() {
    }

    public static Cell[][] getCellMatrix(Result result) {
        int rows;
        int cols;
        switch (result.getAxes().length) {
            case 0: {
                cols = 1;
                rows = 1;
                break;
            }
            case 1: {
                cols = result.getAxes()[0].getPositions().size();
                rows = 1;
                break;
            }
            case 2: {
                cols = result.getAxes()[0].getPositions().size();
                rows = result.getAxes()[1].getPositions().size();
                break;
            }
            default: {
                throw new IllegalArgumentException("result must be 0,1 or 2 dimensional");
            }
        }
        Iterator it = result.getCells().iterator();
        Cell[][] matrix = new Cell[rows][cols];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                matrix[row][col] = (Cell)it.next();
            }
        }
        return matrix;
    }

    public static List getCellList(Cell[][] matrix) {
        if (matrix.length == 0) {
            return Collections.EMPTY_LIST;
        }
        int rows = matrix.length;
        int cols = matrix[0].length;
        ArrayList<Cell> list = new ArrayList<Cell>(rows * cols);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                list.add(matrix[row][col]);
            }
        }
        return list;
    }

    public static Cell[][] transposeCellMatrix(Cell[][] oldCells) {
        int rows = oldCells.length;
        int cols = oldCells[0].length;
        Cell[][] newCells = new Cell[cols][rows];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                newCells[col][row] = oldCells[row][col];
            }
        }
        return newCells;
    }

    public static int countHierarchies(Axis axis) {
        List positions = axis.getPositions();
        if (positions.size() == 0) {
            return 0;
        }
        return ((Position)positions.get(0)).getMembers().length;
    }

    public static Level getParentLevel(Level level) {
        Hierarchy hier = level.getHierarchy();
        Level[] levels = hier.getLevels();
        for (int i = 1; i < levels.length; ++i) {
            if (!level.equals(levels[i])) continue;
            return levels[i - 1];
        }
        return null;
    }

    public static Level getChildLevel(Level level) {
        Hierarchy hier = level.getHierarchy();
        Level[] levels = hier.getLevels();
        for (int i = 0; i < levels.length - 1; ++i) {
            if (!level.equals(levels[i])) continue;
            return levels[i + 1];
        }
        return null;
    }

    public static boolean compareMembers(Member[] aMem1, Member[] aMem2) {
        if (aMem1.length != aMem2.length) {
            return false;
        }
        for (int i = 0; i < aMem1.length; ++i) {
            if (aMem1[i] == null) {
                return false;
            }
            if (((Object)aMem1[i]).equals(aMem2[i])) continue;
            return false;
        }
        return true;
    }

    public static Set getVisibleDimensions(OlapModel model) throws OlapException {
        HashSet<Dimension> visible = new HashSet<Dimension>();
        Axis[] axes = model.getResult().getAxes();
        for (int i = 0; i < axes.length; ++i) {
            Hierarchy[] hiers = axes[i].getHierarchies();
            for (int j = 0; j < hiers.length; ++j) {
                visible.add(hiers[j].getDimension());
            }
        }
        return visible;
    }

    public static Set getSlicerDimensions(OlapModel model) throws OlapException {
        Set visible = OlapUtils.getVisibleDimensions(model);
        HashSet<Dimension> slicer = new HashSet<Dimension>();
        Dimension[] dims = model.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            if (visible.contains(dims[i])) continue;
            slicer.add(dims[i]);
        }
        return slicer;
    }

    public static boolean isInfixFunction(String fuName) {
        return infix.contains(fuName);
    }

    public static boolean isPrefixFunction(String fuName) {
        return prefix.contains(fuName);
    }

    public static boolean isSingleRecord(Hierarchy hier) {
        Level lowest = OlapUtils.getLowestLevel(hier);
        if (lowest != null && lowest.getLabel() != null && singleRecordLevelNames != null) {
            return singleRecordLevelNames.contains(lowest.getLabel());
        }
        return false;
    }

    public static boolean isSingleRecord(Dimension dim) {
        Hierarchy[] hiers = dim.getHierarchies();
        for (int i = 0; i < hiers.length; ++i) {
            if (!OlapUtils.isSingleRecord(hiers[i])) continue;
            return true;
        }
        return false;
    }

    public static Level getLowestLevel(Hierarchy hier) {
        Level[] levels = hier.getLevels();
        if (levels != null && levels.length > 0) {
            return levels[levels.length - 1];
        }
        return null;
    }

    public static Set getActiveSlicerDimensions(OlapModel model) throws OlapException {
        HashSet<Dimension> active = new HashSet<Dimension>();
        Axis slicer = model.getResult().getSlicer();
        Hierarchy[] hiers = slicer.getHierarchies();
        for (int j = 0; j < hiers.length; ++j) {
            active.add(hiers[j].getDimension());
        }
        return active;
    }

    public static Set getActiveSlicerHierarchies(OlapModel model) throws OlapException {
        HashSet<Hierarchy> active = new HashSet<Hierarchy>();
        Axis slicer = model.getResult().getSlicer();
        Hierarchy[] hiers = slicer.getHierarchies();
        for (int j = 0; j < hiers.length; ++j) {
            active.add(hiers[j]);
        }
        return active;
    }

    public static Set getSlicerHierarchies(OlapModel model) throws OlapException {
        Dimension dim;
        Hierarchy hier;
        Set visible = OlapUtils.getVisibleDimensions(model);
        Axis slicer = model.getResult().getSlicer();
        HashSet<Dimension> selectedSlicerDims = new HashSet<Dimension>();
        HashSet<Hierarchy> selectedSlicerHiers = new HashSet<Hierarchy>();
        List positions = slicer.getPositions();
        Iterator iter = positions.iterator();
        while (iter.hasNext()) {
            Position pos = (Position)iter.next();
            Member[] posMembers = pos.getMembers();
            for (int i = 0; i < posMembers.length; ++i) {
                hier = posMembers[i].getLevel().getHierarchy();
                dim = hier.getDimension();
                if (!selectedSlicerHiers.contains(hier)) {
                    selectedSlicerHiers.add(hier);
                }
                if (selectedSlicerDims.contains(dim)) continue;
                selectedSlicerDims.add(dim);
            }
        }
        HashSet<Hierarchy> slicerHiers = new HashSet<Hierarchy>();
        Dimension[] dims = model.getDimensions();
        block2: for (int i = 0; i < dims.length; ++i) {
            if (visible.contains(dims[i])) continue;
            if (!selectedSlicerDims.contains(dims[i])) {
                slicerHiers.add(dims[i].getHierarchies()[0]);
                continue;
            }
            Iterator it = selectedSlicerHiers.iterator();
            while (it.hasNext()) {
                hier = (Hierarchy)it.next();
                dim = hier.getDimension();
                if (!dim.equals(dims[i])) continue;
                slicerHiers.add(hier);
                continue block2;
            }
        }
        return slicerHiers;
    }

    static {
        Object s = new String[]{"and", "or", "xor", "*", "/", "+", "-", "%", "<", ">", "<=", ">=", "<>", "="};
        for (int i = 0; i < ((String[])s).length; ++i) {
            infix.add(s[i]);
        }
        prefix.add("-");
        prefix.add("not");
        resources = Resources.instance((Class)OlapUtils.class);
        singleRecordLevelNames = new HashSet();
        s = resources.getString("jsp.jpivot.single.record.level");
        StringTokenizer st = new StringTokenizer((String)s);
        while (st.hasMoreTokens()) {
            singleRecordLevelNames.add(st.nextToken());
        }
    }
}

