/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.jaspersoft.jasperserver.api.JSException;
import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.navi.ExpandAll;
import com.tonbeller.jpivot.olap.query.DrillExpandPositionExt;
import com.tonbeller.jpivot.olap.query.MdxOlapModel;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import com.tonbeller.jpivot.table.TableComponentExtensionSupport;
import com.tonbeller.jpivot.table.navi.DrillExpandPositionUI;
import com.tonbeller.jpivot.table.navi.DrillReplaceUI;
import com.tonbeller.jpivot.tags.OlapModelProxy;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ExpandAllExt
extends ExtensionSupport
implements ExpandAll {
    private static Logger logger = Logger.getLogger((Class)ExpandAllExt.class);
    private Result result;
    private Axis[] axes;
    private DrillExpandPositionExt mdep;
    private boolean exceeded;

    public ExpandAllExt() {
        super.setId("expandAll");
    }

    public boolean canExpand(Position position, Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        Member[] pathMembers = this.memberPath(position, member);
        return model.getQueryAdapter().canExpand(pathMembers);
    }

    public boolean canCollapse(Position position, Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        Member[] pathMembers = this.memberPath(position, member);
        return model.getQueryAdapter().canCollapse(pathMembers);
    }

    public void expand(Position position, Member member) {
        logger.debug((Object)"expand position member");
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        Member[] pathMembers = this.memberPath(position, member);
        model.getQueryAdapter().expand(pathMembers);
    }

    public void expand(OlapModel olapModel) {
        logger.debug((Object)"expand all");
        try {
            this.exceeded = false;
            if (this.isExpandable(olapModel)) {
                this.doExpandAll(this.axes, this.mdep);
            } else {
                this.exceeded = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"expand all failed");
        }
        catch (Error error) {
            error.printStackTrace();
            logger.error((Object)"expand all encountered an error");
            return;
        }
    }

    public void doExpandAll(Axis[] axes, DrillExpandPositionExt mdep) {
        try {
            for (int k = 0; k < axes.length; ++k) {
                List positions = axes[k].getPositions();
                Position pos = null;
                for (int i = 0; i < positions.size(); ++i) {
                    pos = (Position)positions.get(i);
                    Member[] members = pos.getMembers();
                    for (int j = 0; j < members.length; ++j) {
                        if (!mdep.canExpand(pos, members[j])) continue;
                        mdep.expand(pos, pos.getMembers()[j]);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"jsexception.expand.all.exception", (Throwable)e);
            throw new JSException("jsexception.expand.all.exception");
        }
        finally {
            logger.debug((Object)"Done with expand all");
        }
    }

    public boolean isExpandable(OlapModel olapModel) {
        boolean expandable = false;
        int count = 0;
        try {
            if (olapModel == null) {
                logger.error((Object)"no olap model.");
                return false;
            }
            ArrayList listeners = (ArrayList)((OlapModelProxy)olapModel).getListeners();
            if (listeners == null) {
                logger.error((Object)"no model listeners.");
                return false;
            }
            TableComponentExtensionSupport dep = null;
            Iterator itr = listeners.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (!(obj instanceof DrillExpandPositionUI)) continue;
                dep = (DrillExpandPositionUI)obj;
                break;
            }
            if (dep == null || !dep.isEnabled()) {
                logger.error((Object)"no drill expand position UI.");
                return false;
            }
            logger.debug((Object)"drill position enabled");
            this.mdep = (DrillExpandPositionExt)olapModel.getExtension("drillExpandPosition");
            if (this.mdep == null) {
                logger.error((Object)"no drill expand position extension.");
                return false;
            }
            this.result = olapModel.getResult();
            if (this.result == null) {
                logger.error((Object)"no model result.");
                return false;
            }
            this.axes = this.result.getAxes();
            if (this.axes == null || this.axes.length == 0) {
                logger.error((Object)"no result axes.");
                return false;
            }
            for (int k = 0; k < this.axes.length; ++k) {
                List positions = this.axes[k].getPositions();
                Position pos = null;
                for (int i = 0; i < positions.size(); ++i) {
                    pos = (Position)positions.get(i);
                    Member[] members = pos.getMembers();
                    for (int j = 0; j < members.length; ++j) {
                        if (!this.mdep.canExpand(pos, members[j])) continue;
                        if (count == 0) {
                            this.mdep.expand(pos, pos.getMembers()[j]);
                            this.mdep.collapse(pos, members[j]);
                        }
                        ++count;
                    }
                }
            }
            expandable = count <= Integer.parseInt(Resources.instance().getString("JAJ_000_jpivot.ExpandAllExt.MaxExpand"));
        }
        catch (Exception e) {
            logger.error((Object)"jsexception.count.expand.all.exception", (Throwable)e);
            throw new JSException("jsexception.expand.all.exception");
        }
        return expandable;
    }

    public void collapse(Position position, Member member) {
        logger.debug((Object)"collapse position member");
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        Member[] pathMembers = this.memberPath(position, member);
        model.getQueryAdapter().collapse(pathMembers);
    }

    public void collapse(OlapModel model) {
        ArrayList listeners = (ArrayList)((OlapModelProxy)model).getListeners();
        TableComponentExtensionSupport dep = null;
        logger.debug((Object)"collapse all");
        Iterator itr = listeners.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof DrillExpandPositionUI)) continue;
            dep = (DrillExpandPositionUI)obj;
            break;
        }
        logger.debug((Object)"restore state");
        if (dep != null && dep.isEnabled()) {
            ((MdxOlapModel)this.getModel()).getQueryAdapter().restoreView();
        }
        if (this.isExpandable(model)) {
            this.exceeded = false;
        }
    }

    public void zoom_out(OlapModel model) {
        ArrayList listeners = (ArrayList)((OlapModelProxy)model).getListeners();
        TableComponentExtensionSupport dr = null;
        logger.debug((Object)"zoom out all");
        Iterator itr = listeners.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof DrillReplaceUI)) continue;
            dr = (DrillReplaceUI)obj;
            break;
        }
        logger.debug((Object)"restore state");
        if (dr != null && dr.isEnabled()) {
            ((MdxOlapModel)this.getModel()).getQueryAdapter().restoreView();
        }
    }

    private Member[] memberPath(Position position, Member member) {
        Member[] posMembers = position.getMembers();
        int pathlen = 0;
        for (int i = 0; i < posMembers.length; ++i) {
            if (!((Object)posMembers[i]).equals(member)) continue;
            pathlen = i + 1;
            break;
        }
        if (pathlen == 0) {
            return null;
        }
        Member[] pathMembers = new Member[pathlen];
        for (int i = 0; i < pathlen; ++i) {
            pathMembers[i] = posMembers[i];
        }
        return pathMembers;
    }

    public boolean isExceeded() {
        return this.exceeded;
    }
}

