/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.tonbeller.jpivot.core.ModelSupport;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.query.ExpBean;
import com.tonbeller.jpivot.olap.query.MDXMember;
import com.tonbeller.jpivot.olap.query.Memento;
import com.tonbeller.jpivot.olap.query.PositionNodeBean;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QuaxBean;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import com.tonbeller.jpivot.olap.query.SortRankBase;
import com.tonbeller.jpivot.util.TreeNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public abstract class MdxOlapModel
extends ModelSupport {
    static Logger logger = Logger.getLogger((Class)MdxOlapModel.class);
    protected Stack navigationTrace;
    protected Map drillMap;

    public abstract String getCurrentMdx();

    protected void quaxesFromBeans(Quax[] quaxes, QuaxBean[] quaxBeans) throws OlapException {
        for (int i = 0; i < quaxes.length; ++i) {
            boolean qubonMode = quaxBeans[i].isQubonMode();
            quaxes[i].setQubonMode(qubonMode);
            quaxes[i].setGenerateIndex(quaxBeans[i].getGenerateIndex());
            quaxes[i].setGenerateMode(quaxBeans[i].getGenerateMode());
            quaxes[i].setNHierExclude(quaxBeans[i].getNHierExclude());
            PositionNodeBean rootBean = quaxBeans[i].getPosTreeRoot();
            TreeNode rootNode = this.createPosTreeFromBean(rootBean);
            quaxes[i].setPosTreeRoot(rootNode, true);
            quaxes[i].changed(this, false);
            quaxes[i].setHierarchizeNeeded(quaxBeans[i].isHierarchizeNeeded());
        }
    }

    protected void restoreSort(SortRankBase sortExt, Memento memento) {
        block3: {
            String[] sortPosUniqueNames;
            if (sortExt != null && (sortPosUniqueNames = memento.getSortPosMembers()) != null) {
                Member[] members = new Member[sortPosUniqueNames.length];
                for (int i = 0; i < members.length; ++i) {
                    Member m = this.lookupMemberByUName(sortPosUniqueNames[i]);
                    if (m == null) {
                        logger.warn((Object)("sort position member not found " + sortPosUniqueNames[i]));
                        break block3;
                    }
                    members[i] = m;
                }
                sortExt.setSortPosMembers(members);
                sortExt.setQuaxToSort(memento.getQuaxToSort());
                sortExt.setSortMode(memento.getSortMode());
                sortExt.setSorting(memento.isSorting());
                sortExt.setTopBottomCount(memento.getTopBottomCount());
            }
        }
    }

    private TreeNode createPosTreeFromBean(PositionNodeBean rootBean) throws OlapException {
        ExpBean expBean = rootBean.getReference();
        Object exp = expBean == null ? null : this.createExpFromBean(expBean);
        TreeNode node = new TreeNode(exp);
        PositionNodeBean[] beanChildren = rootBean.getChildren();
        if (beanChildren == null) {
            return node;
        }
        for (int i = 0; i < beanChildren.length; ++i) {
            TreeNode childNode = this.createPosTreeFromBean(beanChildren[i]);
            node.addChildNode(childNode);
        }
        return node;
    }

    protected void beanFromQuax(QuaxBean quaxBean, Quax quax) throws OlapException {
        quaxBean.setOrdinal(quax.getOrdinal());
        quaxBean.setNDimension(quax.getNDimension());
        boolean qubonMode = quax.isQubonMode();
        quaxBean.setQubonMode(qubonMode);
        PositionNodeBean posTreeRoot = this.createPosTreeBean(quax.getPosTreeRoot(), null);
        quaxBean.setPosTreeRoot(posTreeRoot);
        quaxBean.setHierarchizeNeeded(quax.isHierarchizeNeeded());
        quaxBean.setGenerateIndex(quax.getGenerateIndex());
        quaxBean.setGenerateMode(quax.getGenerateMode());
        quaxBean.setNHierExclude(quax.getNHierExclude());
    }

    PositionNodeBean createPosTreeBean(TreeNode node, ExpBean reference) throws OlapException {
        PositionNodeBean bean = new PositionNodeBean();
        bean.setReference(reference);
        if (node == null) {
            bean.setChildren(new PositionNodeBean[0]);
            return bean;
        }
        List childrenList = node.getChildren();
        PositionNodeBean[] children = new PositionNodeBean[childrenList.size()];
        for (int i = 0; i < children.length; ++i) {
            TreeNode childNode = (TreeNode)childrenList.get(i);
            ExpBean refBean = this.createBeanFromExp(childNode.getReference());
            children[i] = this.createPosTreeBean(childNode, refBean);
        }
        bean.setChildren(children);
        return bean;
    }

    protected void storeSort(SortRankBase sortExt, Memento memento) {
        Member[] sortPosMembers = sortExt.getSortPosMembers();
        if (sortPosMembers != null) {
            String[] uniqueNames = new String[sortPosMembers.length];
            for (int i = 0; i < uniqueNames.length; ++i) {
                uniqueNames[i] = ((MDXMember)sortPosMembers[i]).getUniqueName();
            }
            memento.setSortPosMembers(uniqueNames);
            memento.setQuaxToSort(sortExt.getQuaxToSort());
            memento.setTopBottomCount(sortExt.getTopBottomCount());
            memento.setSortMode(sortExt.getSortMode());
            memento.setSorting(sortExt.isSorting());
        }
    }

    protected abstract Object createExpFromBean(ExpBean var1) throws OlapException;

    protected abstract ExpBean createBeanFromExp(Object var1) throws OlapException;

    public abstract Member lookupMemberByUName(String var1);

    public Stack getNavigationTrace() {
        return this.navigationTrace;
    }

    public void initNavigationTrace() {
        this.navigationTrace = new Stack();
    }

    public Map getDrillMap() {
        return this.drillMap;
    }

    public void initDrillMap() {
        this.drillMap = new HashMap();
    }

    public abstract QueryAdapter getQueryAdapter();

    public Throwable getRootCause(Exception ex) {
        Throwable rootCause = ex;
        for (Throwable cause = ex.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }
}

