/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.tonbeller.jpivot.mondrian.MondrianDimension;
import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.query.ExpGenerator;
import com.tonbeller.jpivot.olap.query.MDXLevel;
import com.tonbeller.jpivot.olap.query.QuaxChangeListener;
import com.tonbeller.jpivot.olap.query.QuaxUti;
import com.tonbeller.jpivot.olap.query.SetExp;
import com.tonbeller.jpivot.util.TreeNode;
import com.tonbeller.jpivot.util.TreeNodeCallback;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Quax {
    static Logger logger = Logger.getLogger((Class)Quax.class);
    protected int nDimension;
    private Hierarchy[] hiers;
    private boolean[] containsUF;
    private List[] ufMemberLists;
    protected TreeNode posTreeRoot = null;
    private int ordinal;
    private boolean qubonMode = false;
    private boolean hierarchizeNeeded = false;
    private int nHierExclude = 0;
    private int generateMode = 0;
    private int generateIndex = -1;
    private Object expGenerate = null;
    private Collection changeListeners = new ArrayList();
    private QuaxUti uti;
    private Map canExpandMemberMap = new HashMap();
    private Map canExpandPosMap = new HashMap();
    private Map canCollapseMemberMap = new HashMap();
    private Map canCollapsePosMap = new HashMap();
    private QuaxState quaxState = null;
    private Map quaxMap = new HashMap();

    public Quax(int ordinal) {
        this.ordinal = ordinal;
        this.qubonMode = false;
    }

    public void addChangeListener(QuaxChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(QuaxChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void changed(Object source, boolean changedMemberSet) {
        Iterator iter = this.changeListeners.iterator();
        while (iter.hasNext()) {
            QuaxChangeListener listener = (QuaxChangeListener)iter.next();
            listener.quaxChanged(this, source, changedMemberSet);
        }
        this.canExpandMemberMap.clear();
        this.canExpandPosMap.clear();
        this.canCollapseMemberMap.clear();
        this.canCollapsePosMap.clear();
    }

    public void init(List positions) {
        int nDimension = 0;
        this.hierarchizeNeeded = false;
        this.nHierExclude = 0;
        this.qubonMode = true;
        if (positions.size() == 0) {
            Member[][] aPosMem = new Member[0][0];
            this.setHiers(new Hierarchy[0]);
            this.setHiers(this.hiers);
            return;
        }
        nDimension = ((Position)positions.get(0)).getMembers().length;
        Member[][] aPosMem = new Member[positions.size()][nDimension];
        int j = 0;
        Iterator iter = positions.iterator();
        while (iter.hasNext()) {
            Position pos = (Position)iter.next();
            aPosMem[j++] = pos.getMembers();
        }
        Hierarchy[] hiers = new Hierarchy[nDimension];
        for (int j2 = 0; j2 < hiers.length; ++j2) {
            Member m = aPosMem[0][j2];
            hiers[j2] = m.getLevel().getHierarchy();
        }
        this.setHiers(hiers);
        this.initPositions(aPosMem);
        this.posTreeRoot.walkTree(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDim = node.getLevel();
                if (iDim == Quax.this.nDimension) {
                    return 3;
                }
                if (node.getChildren().size() == 1) {
                    return 0;
                }
                Quax.this.qubonMode = false;
                return 3;
            }
        });
        if (this.qubonMode) {
            this.nHierExclude = nDimension - 1;
        }
    }

    private void initPositions(Member[][] aPosMemStart) {
        if (aPosMemStart.length == 0) {
            this.posTreeRoot = null;
            return;
        }
        this.posTreeRoot = new TreeNode(null);
        int iEnd = this.addToPosTree(aPosMemStart, 0, aPosMemStart.length, 0, this.posTreeRoot);
        while (iEnd < aPosMemStart.length) {
            iEnd = this.addToPosTree(aPosMemStart, iEnd, aPosMemStart.length, 0, this.posTreeRoot);
        }
        this.posTreeRoot.walkTree(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDim1 = node.getLevel();
                if (iDim1 == Quax.this.nDimension - 1) {
                    if (node.getChildren().size() <= 1) {
                        return 1;
                    }
                    Object[] memArray = new Object[node.getChildren().size()];
                    int i = 0;
                    Iterator iter = node.getChildren().iterator();
                    while (iter.hasNext()) {
                        TreeNode child = (TreeNode)iter.next();
                        memArray[i++] = child.getReference();
                    }
                    node.getChildren().clear();
                    Object oFun = Quax.this.uti.createFunCall("{}", memArray, 2);
                    TreeNode newChild = new TreeNode(oFun);
                    node.addChildNode(newChild);
                    return 1;
                }
                return 0;
            }
        });
        this.containsUF = new boolean[this.nDimension];
        this.ufMemberLists = new List[this.nDimension];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after initPositions " + this.toString()));
        }
    }

    protected int addToPosTree(Member[][] aPosMem, int iStartPos, int iEndPos, int iDim, TreeNode parentNode) {
        int iEndRange;
        Member currentOfDim = aPosMem[iStartPos][iDim];
        Object o = this.uti.objForMember(currentOfDim);
        TreeNode newNode = new TreeNode(o);
        parentNode.addChildNode(newNode);
        for (iEndRange = iStartPos + 1; iEndRange < iEndPos && aPosMem[iEndRange][iDim] == aPosMem[iStartPos][iDim]; ++iEndRange) {
        }
        int nextDim = iDim + 1;
        if (nextDim < this.nDimension) {
            int iEndChild = this.addToPosTree(aPosMem, iStartPos, iEndRange, nextDim, newNode);
            while (iEndChild < iEndRange) {
                iEndChild = this.addToPosTree(aPosMem, iEndChild, iEndRange, nextDim, newNode);
            }
        }
        return iEndRange;
    }

    public int dimIdx(Dimension dim) {
        if (this.hiers == null || this.hiers.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.hiers.length; ++i) {
            if (!this.hiers[i].getDimension().equals(dim)) continue;
            return i;
        }
        return -1;
    }

    public void regeneratePosTree(Object[] sets, boolean hiersChanged) {
        if (hiersChanged) {
            this.nDimension = sets.length;
            this.hiers = new Hierarchy[this.nDimension];
            for (int i = 0; i < this.nDimension; ++i) {
                try {
                    this.hiers[i] = this.uti.hierForExp(sets[i]);
                    continue;
                }
                catch (CannotHandleException e) {
                    logger.fatal((Object)"could not determine Hierarchy for set");
                    logger.fatal((Object)e);
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            this.containsUF = new boolean[this.nDimension];
            this.ufMemberLists = new List[this.nDimension];
            this.generateIndex = 0;
            this.generateMode = 0;
        }
        if (this.posTreeRoot == null) {
            return;
        }
        this.posTreeRoot.getChildren().clear();
        TreeNode current = this.posTreeRoot;
        this.nHierExclude = 0;
        int nChildrenFound = 0;
        boolean childrenFound = false;
        for (int i = 0; i < this.nDimension; ++i) {
            TreeNode newNode;
            if (sets[i] instanceof SetExp) {
                SetExp setx = (SetExp)sets[i];
                newNode = new TreeNode(setx.getOExp());
                int mode = setx.getMode();
                if (mode > 0) {
                    this.generateMode = mode;
                    this.generateIndex = i;
                    this.expGenerate = setx.getOExp();
                }
            } else {
                boolean bChildrenFound = this.findChildrenCall(sets[i], 0);
                if (bChildrenFound) {
                    childrenFound = true;
                    nChildrenFound = i + 1;
                }
                newNode = new TreeNode(sets[i]);
                if (this.generateIndex == i && this.generateMode == 2 && !sets[i].equals(this.expGenerate)) {
                    this.resetGenerate();
                }
            }
            current.addChildNode(newNode);
            current = newNode;
            if (this.uti.canHandle(newNode.getReference())) continue;
            this.containsUF[i] = true;
        }
        this.qubonMode = true;
        this.nHierExclude = this.nDimension - nChildrenFound;
        if (!childrenFound) {
            this.hierarchizeNeeded = false;
        }
    }

    private boolean findChildrenCall(Object oExp, int level) {
        if (!this.uti.isFunCall(oExp)) {
            return false;
        }
        if (level > 0 && this.uti.isFunCallTo(oExp, "children")) {
            return true;
        }
        int nArgs = this.uti.funCallArgCount(oExp);
        for (int i = 0; i < nArgs; ++i) {
            if (!this.findChildrenCall(this.uti.funCallArg(oExp, i), level + 1)) continue;
            return true;
        }
        return false;
    }

    public boolean canExpand(Member[] pathMembers) {
        int iDim = pathMembers.length - 1;
        if (!this.allowNavigate(iDim, false)) {
            return false;
        }
        List<Member> li = Arrays.asList(pathMembers);
        if (this.canExpandPosMap.containsKey(li)) {
            Boolean bCanExpand = (Boolean)this.canExpandPosMap.get(li);
            return bCanExpand;
        }
        boolean childFound = this.checkChildPosition(pathMembers);
        Boolean bool = new Boolean(!childFound);
        this.canExpandPosMap.put(li, bool);
        return !childFound;
    }

    public void expand(Member[] mPath) {
        TreeNode newNode;
        if (this.qubonMode) {
            this.resolveUnions();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("expand after resolveUnions " + this.toString()));
            }
        }
        int iDim = mPath.length - 1;
        TreeNode bestNode = this.findBestNode(mPath);
        int bestNodeIndex = bestNode.getLevel() - 1;
        List tailNodeList = mPath.length < this.nDimension ? this.collectTailNodes(this.posTreeRoot, mPath) : Collections.EMPTY_LIST;
        Object oMember = this.uti.objForMember(mPath[iDim]);
        Object fChildren = this.uti.createFunCall("Children", new Object[]{oMember}, 1);
        TreeNode parent = bestNode;
        if (bestNodeIndex == iDim) {
            parent = bestNode.getParent();
        } else {
            for (int i = bestNodeIndex + 1; i < mPath.length - 1; ++i) {
                oMember = this.uti.objForMember(mPath[i]);
                newNode = new TreeNode(oMember);
                parent.addChildNode(newNode);
                parent = newNode;
            }
        }
        int n = this.nDimension - iDim - 1;
        if (n < this.nHierExclude) {
            this.nHierExclude = n;
        }
        newNode = new TreeNode(fChildren);
        parent.addChildNode(newNode);
        if (mPath.length < this.nDimension) {
            Iterator iter = tailNodeList.iterator();
            while (iter.hasNext()) {
                TreeNode tailNode = (TreeNode)iter.next();
                newNode.addChildNode(tailNode.deepCopy());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after expand " + this.toString()));
        }
        this.qubonMode = false;
        this.hierarchizeNeeded = true;
        this.changed(this, false);
    }

    public boolean canExpand(Member member) {
        if (!this.allowNavigate(member, false)) {
            return false;
        }
        if (this.canExpandMemberMap.containsKey(member)) {
            Boolean bCanExpand = (Boolean)this.canExpandMemberMap.get(member);
            return true;
        }
        boolean b = !this.findMemberChild(member);
        Boolean bool = new Boolean(b);
        this.canExpandMemberMap.put(member, bool);
        return b;
    }

    public void expand(final Member member) {
        if (this.qubonMode) {
            this.resolveUnions();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("expand after resolveUnions " + this.toString()));
            }
        }
        this.nHierExclude = 0;
        final int iDim = this.dimIdx(this.uti.dimForMember(member));
        final ArrayList nodesForMember = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Object oExp = node.getReference();
                if (Quax.this.uti.isMember(oExp)) {
                    if (Quax.this.uti.equalMember(oExp, member)) {
                        nodesForMember.add(node);
                    }
                } else if (Quax.this.isMemberInFunCall(oExp, member, iDim)) {
                    nodesForMember.add(node);
                }
                return 1;
            }
        });
        Object oMember = this.uti.objForMember(member);
        Object fChildren = this.uti.createFunCall("Children", new Object[]{oMember}, 1);
        Iterator iter = nodesForMember.iterator();
        while (iter.hasNext()) {
            TreeNode node = (TreeNode)iter.next();
            TreeNode newNode = new TreeNode(fChildren);
            Iterator iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                TreeNode child = (TreeNode)iterator.next();
                newNode.addChildNode(child.deepCopy());
            }
            TreeNode parent = node.getParent();
            parent.addChildNode(newNode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after expand member " + this.toString()));
        }
        this.hierarchizeNeeded = true;
        this.changed(this, false);
    }

    public boolean canCollapse(Member[] pathMembers) {
        int iDim = pathMembers.length - 1;
        if (!this.allowNavigate(iDim, false)) {
            return false;
        }
        List<Member> li = Arrays.asList(pathMembers);
        if (this.canCollapsePosMap.containsKey(li)) {
            Boolean bCanCollapse = (Boolean)this.canCollapsePosMap.get(li);
            return bCanCollapse;
        }
        boolean childFound = this.checkChildPosition(pathMembers);
        Boolean bool = new Boolean(childFound);
        this.canCollapsePosMap.put(li, bool);
        return childFound;
    }

    public void collapse(final Member[] mPath) {
        Iterator iter;
        int i;
        if (this.qubonMode) {
            this.resolveUnions();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("collapse after resolveUnions " + this.toString()));
            }
        }
        final int iDim = mPath.length - 1;
        final List[] splitLists = new List[mPath.length];
        for (i = 0; i < splitLists.length; ++i) {
            splitLists[i] = new ArrayList();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                Object oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (Quax.this.uti.isMember(oExp)) {
                        if (Quax.this.uti.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    if (Quax.this.isMemberInFunCall(oExp, mPath[idi], idi)) {
                        return 0;
                    }
                    return 1;
                }
                boolean found = false;
                if (Quax.this.uti.isMember(oExp)) {
                    if (Quax.this.uti.checkDescendantO(mPath[iDim], oExp)) {
                        found = true;
                    }
                } else if (Quax.this.isChildOfMemberInFunCall(oExp, mPath[iDim], iDim)) {
                    found = true;
                }
                if (found) {
                    int level = node.getLevel();
                    TreeNode currentNode = node;
                    while (level > 0) {
                        Object o = currentNode.getReference();
                        if (!Quax.this.uti.isMember(o) && !splitLists[level - 1].contains(currentNode)) {
                            splitLists[level - 1].add(currentNode);
                        }
                        currentNode = currentNode.getParent();
                        level = currentNode.getLevel();
                    }
                }
                return 1;
            }
        });
        for (i = splitLists.length - 1; i >= 0; --i) {
            iter = splitLists[i].iterator();
            while (iter.hasNext()) {
                TreeNode n = (TreeNode)iter.next();
                this.splitFunCall(n, mPath[i], i);
            }
        }
        final ArrayList removeList = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                Object oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (Quax.this.uti.isMember(oExp)) {
                        if (Quax.this.uti.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    return 1;
                }
                if (idi == iDim) {
                    if (!Quax.this.uti.isMember(oExp)) {
                        if (Quax.this.uti.isFunCallTo(oExp, "Children")) {
                            Object oMember = Quax.this.uti.funCallArg(oExp, 0);
                            if (Quax.this.uti.objForMember(mPath[iDim]).equals(oMember) || Quax.this.uti.checkDescendantO(mPath[iDim], oMember)) {
                                removeList.add(node);
                            }
                        } else if (Quax.this.uti.isFunCallTo(oExp, "{}")) {
                            int nArgs = Quax.this.uti.funCallArgCount(oExp);
                            ArrayList<Object> removeMembers = new ArrayList<Object>();
                            for (int i = 0; i < nArgs; ++i) {
                                Object oSetMember = Quax.this.uti.funCallArg(oExp, i);
                                if (!Quax.this.uti.checkDescendantO(mPath[iDim], oSetMember)) continue;
                                removeMembers.add(oSetMember);
                            }
                            int nRemove = removeMembers.size();
                            if (nRemove == nArgs) {
                                removeList.add(node);
                            } else if (nRemove > 0) {
                                Object[] remaining = new Object[nArgs - nRemove];
                                int j = 0;
                                for (int i = 0; i < nArgs; ++i) {
                                    Object oSetMember = Quax.this.uti.funCallArg(oExp, i);
                                    if (removeMembers.contains(oSetMember)) continue;
                                    remaining[j++] = oSetMember;
                                }
                                if (remaining.length == 1) {
                                    node.setReference(remaining[0]);
                                } else {
                                    Object newSet = Quax.this.uti.createFunCall("{}", remaining, 2);
                                    node.setReference(newSet);
                                }
                            }
                        } else if (Quax.this.uti.isFunCallTo(oExp, "Union")) {
                            Object oRemain = Quax.this.removeDescendantsFromFunCall(oExp, mPath[iDim], iDim);
                            if (oRemain == null) {
                                removeList.add(node);
                            } else {
                                node.setReference(oRemain);
                            }
                        }
                        return 1;
                    }
                    if (Quax.this.uti.isMember(oExp) && Quax.this.uti.checkDescendantO(mPath[iDim], oExp)) {
                        removeList.add(node);
                    }
                    return 1;
                }
                logger.error((Object)("unexpected tree node level " + idi + " " + Quax.this.uti.memberString(mPath)));
                return 3;
            }
        });
        iter = removeList.iterator();
        while (iter.hasNext()) {
            TreeNode nodeToRemove = (TreeNode)iter.next();
            this.removePathToNode(nodeToRemove);
        }
        int n = this.nDimension - iDim - 1;
        if (n < this.nHierExclude) {
            this.nHierExclude = n;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after collapse " + this.toString()));
        }
        this.changed(this, false);
    }

    public boolean canCollapse(Member member) {
        if (!this.allowNavigate(member, false)) {
            return false;
        }
        if (this.canCollapseMemberMap.containsKey(member)) {
            Boolean bCanCollapse = (Boolean)this.canCollapseMemberMap.get(member);
            return bCanCollapse;
        }
        boolean b = this.findMemberChild(member);
        Boolean bool = new Boolean(b);
        this.canCollapseMemberMap.put(member, bool);
        return b;
    }

    public void collapse(final Member member) {
        if (this.qubonMode) {
            this.resolveUnions();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("collapse member after resolveUnions " + this.toString()));
            }
        }
        final int iDim = this.dimIdx(this.uti.dimForMember(member));
        final ArrayList nodesForMember = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Object oExp = node.getReference();
                if (Quax.this.uti.isMember(oExp)) {
                    if (Quax.this.uti.checkDescendantO(member, oExp)) {
                        nodesForMember.add(node);
                    }
                } else if (Quax.this.isDescendantOfMemberInFunCall(oExp, member, iDimNode)) {
                    nodesForMember.add(node);
                }
                return 1;
            }
        });
        Iterator iter = nodesForMember.iterator();
        while (iter.hasNext()) {
            TreeNode node = (TreeNode)iter.next();
            Object oExp = node.getReference();
            if (this.uti.isMember(oExp)) {
                this.removePathToNode(node);
                continue;
            }
            Object oComplement = this.removeDescendantsFromFunCall(oExp, member, iDim);
            if (oComplement == null) {
                this.removePathToNode(node);
                continue;
            }
            node.setReference(oComplement);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after collapse " + this.toString()));
        }
        this.changed(this, false);
    }

    public boolean canDrillDown(Member member) {
        return this.allowNavigate(member, true);
    }

    public void drillDown(Member member) {
        int iDim = this.dimIdx(this.uti.dimForMember(member));
        Object[] sets = new Object[this.nDimension];
        Object oMember = this.uti.objForMember(member);
        Object fChildren = this.uti.createFunCall("Children", new Object[]{oMember}, 1);
        for (int i = 0; i < this.nDimension; ++i) {
            sets[i] = i == iDim ? fChildren : this.genExpForDim(i);
        }
        this.quaxState = new QuaxState(this.nDimension, this.hiers, this.posTreeRoot);
        if (this.quaxState != null) {
            this.quaxState.setQubornMode(this.isQubonMode());
            this.quaxState.setHierarchizeNeeded(this.isHierarchizeNeeded());
            this.quaxState.setNHierExclude(this.getNHierExclude());
            this.quaxState.setNewLevel(this.getNewLevel(member));
            this.quaxMap.put(member, this.quaxState);
        }
        this.regeneratePosTree(sets, false);
        this.changed(this, false);
    }

    private Level getNewLevel(Member member) {
        int i;
        if (member == null) {
            return null;
        }
        Level level = member.getLevel();
        if (level == null) {
            return null;
        }
        Hierarchy hierarchy = level.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        Level[] levels = hierarchy.getLevels();
        if (levels == null) {
            return null;
        }
        for (i = 0; !(i >= levels.length || levels[i] != null && levels[i].equals(level)); ++i) {
        }
        return levels[i + 1];
    }

    public boolean canDrillUp(Hierarchy hier) {
        final int iDim = this.dimIdx(hier.getDimension());
        if (!this.allowNavigate(iDim, true)) {
            return false;
        }
        int ret = this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Object oExp = node.getReference();
                if (!Quax.this.uti.isMember(oExp)) {
                    if (Quax.this.isFunCallNotTopLevel(oExp, iDimNode)) {
                        return 3;
                    }
                    return 1;
                }
                if (Quax.this.uti.levelDepthForMember(oExp) > 0) {
                    return 3;
                }
                return 1;
            }
        });
        return ret == 3;
    }

    public void drillUp(Hierarchy hier) {
        int iDim = this.dimIdx(hier.getDimension());
        Object[] sets = new Object[this.nDimension];
        for (int i = 0; i < this.nDimension; ++i) {
            sets[i] = i == iDim ? this.drillupExp(iDim, hier) : this.genExpForDim(i);
        }
        this.regeneratePosTree(sets, false);
        this.changed(this, false);
    }

    public void drillUp(Level level) {
        if (level == null) {
            return;
        }
        Hierarchy hierarchy = level.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        int iDim = this.dimIdx(hierarchy.getDimension());
        Object[] sets = new Object[this.nDimension];
        for (int i = 0; i < this.nDimension; ++i) {
            sets[i] = i == iDim ? this.drillupExp(iDim, level.getHierarchy()) : this.genExpForDim(i);
        }
        this.regeneratePosTree(sets, false);
        this.quaxState = this.getQuaxState(level);
        if (this.quaxState != null) {
            this.nDimension = this.quaxState.getDimension();
            this.hiers = this.quaxState.getHiers();
            this.posTreeRoot = this.quaxState.getPosTreeRoot();
            this.setNHierExclude(this.quaxState.getNHierExclude());
            this.setQubonMode(this.quaxState.isQubornMode());
            this.setHierarchizeNeeded(this.quaxState.isHierarchizeNeeded());
        }
        this.changed(this, false);
    }

    private QuaxState getQuaxState(Level level) {
        if (level == null) {
            return null;
        }
        QuaxState result = null;
        Hierarchy hier = level.getHierarchy();
        if (hier == null) {
            return null;
        }
        Level[] levels = hier.getLevels();
        if (levels == null) {
            return null;
        }
        block0: for (int i = 1; i < levels.length && levels[i] != null; ++i) {
            if (!levels[i].equals(level)) continue;
            List memberList = this.getMembers(levels[i - 1]);
            if (memberList == null) {
                return null;
            }
            for (int j = 0; j < memberList.size(); ++j) {
                Member mm = (Member)memberList.get(j);
                if (!this.quaxMap.containsKey(mm)) continue;
                result = (QuaxState)this.quaxMap.get(mm);
                this.quaxMap.remove(mm);
                break block0;
            }
        }
        if (result == null) {
            Iterator itrQuaxMap = this.quaxMap.entrySet().iterator();
            while (itrQuaxMap.hasNext()) {
                Map.Entry objState = itrQuaxMap.next();
                if (objState == null || !(objState instanceof QuaxState)) continue;
                QuaxState quaxState = (QuaxState)((Object)objState);
                Level newLevel = quaxState.getNewLevel();
                if (newLevel == null) {
                    return null;
                }
                if (!newLevel.equals(level)) continue;
                result = quaxState;
                this.quaxMap.remove(quaxState);
                break;
            }
        }
        return result;
    }

    private List getMembers(Level level) {
        if (level == null) {
            return null;
        }
        List<XMLA_Member> result = null;
        if (level instanceof MondrianLevel) {
            result = ((MondrianLevel)level).getMembers();
        } else if (level instanceof XMLA_Level) {
            try {
                result = Arrays.asList(((XMLA_Level)level).getMembers());
            }
            catch (OlapException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Object genExp(boolean genHierarchize) {
        if (this.generateMode > 0 && this.generateIndex > 0) {
            return this.genGenerateExp(genHierarchize);
        }
        return this.genNormalExp(genHierarchize);
    }

    private Object genNormalExp(boolean genHierarchize) {
        ExpGenerator expGenerator = new ExpGenerator(this.uti);
        if (!genHierarchize) {
            expGenerator.init(this.posTreeRoot, this.hiers);
            Object exp = expGenerator.genExp();
            return exp;
        }
        if (this.nHierExclude == 0) {
            expGenerator.init(this.posTreeRoot, this.hiers);
            Object exp = expGenerator.genExp();
            Object eHier = this.uti.createFunCall("Hierarchize", new Object[]{exp}, 0);
            return eHier;
        }
        return this.genLeftRight(expGenerator, this.nDimension - this.nHierExclude, this.nHierExclude);
    }

    private Object genLeftRight(ExpGenerator expGenerator, int nLeft, int nRight) {
        int i;
        Object leftExp = null;
        if (nLeft > 0) {
            TreeNode leftRoot = this.posTreeRoot.deepCopyPrune(nLeft);
            leftRoot.setReference(null);
            Hierarchy[] leftHiers = new Hierarchy[nLeft];
            for (i = 0; i < leftHiers.length; ++i) {
                leftHiers[i] = this.hiers[i];
            }
            expGenerator.init(leftRoot, leftHiers);
            leftExp = expGenerator.genExp();
            leftExp = this.uti.createFunCall("Hierarchize", new Object[]{leftExp}, 0);
        }
        Object rightExp = null;
        Hierarchy[] rightHiers = new Hierarchy[nRight];
        for (i = 0; i < nRight; ++i) {
            rightHiers[i] = this.hiers[nLeft + i];
        }
        TreeNode rightRoot = new TreeNode(null);
        TreeNode current = this.posTreeRoot;
        for (int i2 = 0; i2 < nLeft; ++i2) {
            List list = current.getChildren();
            current = (TreeNode)list.get(0);
        }
        List list = current.getChildren();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            TreeNode node = (TreeNode)iter.next();
            TreeNode cnode = node.deepCopy();
            rightRoot.addChildNode(cnode);
        }
        expGenerator.init(rightRoot, rightHiers);
        rightExp = expGenerator.genExp();
        if (leftExp == null) {
            return rightExp;
        }
        Object exp = this.uti.createFunCall("CrossJoin", new Object[]{leftExp, rightExp}, 0);
        return exp;
    }

    private Object genGenerateExp(boolean genHierarchize) {
        ExpGenerator expGenerator = new ExpGenerator(this.uti);
        if (this.nDimension - this.generateIndex > this.nHierExclude) {
            logger.warn((Object)("unexpected values: nHierExclude=" + this.nHierExclude + " generateIndex=" + this.generateIndex));
        }
        Object leftExp = null;
        if (genHierarchize && this.nHierExclude > this.nDimension - this.generateIndex && this.nHierExclude < this.nDimension) {
            int nLeft = this.nDimension - this.nHierExclude;
            int nRight = this.generateIndex - nLeft;
            leftExp = this.genLeftRight(expGenerator, nLeft, nRight);
        } else {
            TreeNode leftRoot = this.posTreeRoot.deepCopyPrune(this.generateIndex);
            leftRoot.setReference(null);
            Hierarchy[] leftHiers = new Hierarchy[this.generateIndex];
            for (int i = 0; i < leftHiers.length; ++i) {
                leftHiers[i] = this.hiers[i];
            }
            expGenerator.init(leftRoot, leftHiers);
            leftExp = expGenerator.genExp();
            if (genHierarchize) {
                leftExp = this.uti.createFunCall("Hierarchize", new Object[]{leftExp}, 0);
            }
        }
        TreeNode topCountNode = this.posTreeRoot;
        for (int i = 0; i <= this.generateIndex; ++i) {
            List children = topCountNode.getChildren();
            topCountNode = (TreeNode)children.get(0);
        }
        Object topcount = topCountNode.getReference();
        Object origTopcountSet = this.uti.funCallArg(topcount, 0);
        Object currentMembersTuple = this.genCurrentTuple();
        Object ocj = this.uti.createFunCall("Crossjoin", new Object[]{currentMembersTuple, origTopcountSet}, 0);
        String fun = this.uti.funCallName(topcount);
        int n = this.uti.funCallArgCount(topcount);
        Object[] args = new Object[n];
        for (int i = 1; i < n; ++i) {
            args[i] = this.uti.funCallArg(topcount, i);
        }
        args[0] = ocj;
        Object newTopcount = this.uti.createFunCall(fun, args, 0);
        Object oGenerate = this.uti.createFunCall("Generate", new Object[]{leftExp, newTopcount}, 0);
        if (this.generateIndex + 1 == this.nDimension) {
            return oGenerate;
        }
        int nRight = this.nDimension - this.generateIndex - 1;
        Hierarchy[] rightHiers = new Hierarchy[nRight];
        for (int i = 1; i <= nRight; ++i) {
            rightHiers[nRight - i] = this.hiers[this.nDimension - i];
        }
        TreeNode root = new TreeNode(null);
        List list = topCountNode.getChildren();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            TreeNode node = (TreeNode)iter.next();
            root.addChildNode(node.deepCopy());
        }
        expGenerator.init(root, rightHiers);
        Object rightExp = expGenerator.genExp();
        Object exp = this.uti.createFunCall("CrossJoin", new Object[]{oGenerate, rightExp}, 0);
        return exp;
    }

    private Object genCurrentTuple() {
        Object[] currentsOfDim = new Object[this.generateIndex];
        for (int i = 0; i < currentsOfDim.length; ++i) {
            Dimension dim = this.hiers[i].getDimension();
            currentsOfDim[i] = this.uti.createFunCall("CurrentMember", new Object[]{this.uti.objForDim(dim)}, 1);
        }
        Object oTuple = this.generateIndex > 1 ? this.uti.createFunCall("()", currentsOfDim, 3) : currentsOfDim[0];
        Object oSet = this.uti.createFunCall("{}", new Object[]{oTuple}, 2);
        return oSet;
    }

    private boolean checkChildPosition(final Member[] mPath) {
        int ret = this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDim = mPath.length - 1;
                int iDimNode = node.getLevel() - 1;
                Object oExp = node.getReference();
                if (iDimNode < iDim) {
                    if (Quax.this.uti.isMember(oExp)) {
                        if (Quax.this.uti.equalMember(oExp, mPath[iDimNode])) {
                            return 0;
                        }
                        return 1;
                    }
                    if (Quax.this.isMemberInFunCall(oExp, mPath[iDimNode], iDimNode)) {
                        return 0;
                    }
                    return 1;
                }
                if (Quax.this.uti.isMember(oExp)) {
                    if (Quax.this.uti.checkParent(mPath[iDimNode], oExp)) {
                        return 3;
                    }
                    return 1;
                }
                if (Quax.this.isChildOfMemberInFunCall(oExp, mPath[iDimNode], iDimNode)) {
                    return 3;
                }
                return 1;
            }
        });
        return ret == 3;
    }

    private void resolveUnions() {
        final List[] setLists = new List[this.nDimension];
        for (int i = 0; i < setLists.length; ++i) {
            setLists[i] = new ArrayList();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                Object oExp = node.getReference();
                if (!Quax.this.uti.isMember(oExp)) {
                    Quax.this.funToList(oExp, setLists[iDimNode]);
                } else {
                    setLists[iDimNode].add(oExp);
                }
                return 0;
            }
        });
        this.posTreeRoot = new TreeNode(null);
        this.crossJoinTree(setLists, this.posTreeRoot, 0);
        this.qubonMode = false;
    }

    private TreeNode findBestNode(final Member[] mPath) {
        final TreeNode[] bestNode = new TreeNode[]{this.posTreeRoot};
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDim = mPath.length - 1;
                int iDimNode = node.getLevel() - 1;
                Object oExp = node.getReference();
                if (!Quax.this.uti.isMember(oExp)) {
                    return 1;
                }
                if (Quax.this.uti.equalMember(oExp, mPath[iDimNode])) {
                    if (iDimNode == iDim) {
                        bestNode[0] = node;
                        return 3;
                    }
                    bestNode[0] = node;
                    return 0;
                }
                return 1;
            }
        });
        return bestNode[0];
    }

    private List collectTailNodes(TreeNode startNode, final Member[] mPath) {
        final ArrayList tailNodes = new ArrayList();
        startNode.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDim = mPath.length - 1;
                int iDimNode = node.getLevel() - 1;
                Object oExp = node.getReference();
                boolean match = false;
                if (Quax.this.uti.isMember(oExp)) {
                    if (Quax.this.uti.equalMember(oExp, mPath[iDimNode])) {
                        match = true;
                    }
                } else if (Quax.this.isMemberInFunCall(oExp, mPath[iDimNode], iDimNode)) {
                    match = true;
                }
                if (match) {
                    if (iDimNode == iDim) {
                        tailNodes.addAll(node.getChildren());
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
        });
        return tailNodes;
    }

    private boolean findMemberChild(final Member member) {
        final int iDim = this.dimIdx(this.uti.dimForMember(member));
        int ret = this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Object oExp = node.getReference();
                if (Quax.this.uti.isMember(oExp) ? Quax.this.uti.checkParent(member, oExp) : Quax.this.isChildOfMemberInFunCall(oExp, member, iDimNode)) {
                    return 3;
                }
                return 1;
            }
        });
        return false;
    }

    public String toString() {
        final StringBuffer sbPosTree = new StringBuffer();
        sbPosTree.append("number of hierarchies excluded from HIEARARCHIZE=" + this.nHierExclude);
        sbPosTree.append('\n');
        if (this.posTreeRoot == null) {
            sbPosTree.append("Root=null");
            return sbPosTree.toString();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                sbPosTree.append("\n");
                for (int i = 0; i < iDimNode - 1; ++i) {
                    sbPosTree.append("   ");
                }
                if (iDimNode > 0) {
                    sbPosTree.append("+--");
                }
                Object oExp = node.getReference();
                if (!Quax.this.uti.isMember(oExp)) {
                    sbPosTree.append(Quax.this.uti.funString(oExp));
                } else {
                    sbPosTree.append(Quax.this.uti.getMemberUniqueName(oExp));
                }
                return 0;
            }
        });
        return sbPosTree.toString();
    }

    private void crossJoinTree(List[] setLists, TreeNode currentNode, int iDim) {
        Iterator iter = setLists[iDim].iterator();
        while (iter.hasNext()) {
            Object oExp = iter.next();
            TreeNode newNode = new TreeNode(oExp);
            if (iDim < this.nDimension - 1) {
                this.crossJoinTree(setLists, newNode, iDim + 1);
            }
            currentNode.addChildNode(newNode);
        }
    }

    private void splitFunCall(TreeNode nFunCall, Member member, int iHier) {
        Object oExp = nFunCall.getReference();
        if (!this.isMemberInFunCall(oExp, member, nFunCall.getLevel() - 1)) {
            return;
        }
        Object oComplement = this.createComplement(oExp, member, iHier);
        if (oComplement == null) {
            nFunCall.setReference(this.uti.objForMember(member));
            return;
        }
        TreeNode newNodeComplement = new TreeNode(oComplement);
        TreeNode newNodeMember = new TreeNode(this.uti.objForMember(member));
        Iterator iter = nFunCall.getChildren().iterator();
        while (iter.hasNext()) {
            TreeNode nChild = (TreeNode)iter.next();
            newNodeComplement.addChildNode(nChild.deepCopy());
            newNodeMember.addChildNode(nChild.deepCopy());
        }
        TreeNode nInsert = nFunCall.getParent();
        nFunCall.remove();
        nInsert.addChildNode(newNodeComplement);
        nInsert.addChildNode(newNodeMember);
    }

    private void removePathToNode(TreeNode nodeToRemove) {
        if (nodeToRemove.getParent().getChildren().size() > 1) {
            nodeToRemove.remove();
        } else {
            TreeNode parent = nodeToRemove.getParent();
            while (parent.getParent().getChildren().size() == 1) {
                parent = parent.getParent();
            }
            if (parent.getLevel() > 0) {
                parent.remove();
            }
        }
    }

    public Object genExpForDim(int iDimension) {
        int start;
        Object set;
        if (this.generateIndex >= 0 && this.generateIndex == iDimension && this.generateMode > 0) {
            TreeNode topCountNode = (TreeNode)this.posTreeRoot.getChildren().get(0);
            for (int i = 0; i < this.generateIndex; ++i) {
                List children = topCountNode.getChildren();
                topCountNode = (TreeNode)children.get(0);
            }
            Object topcount = topCountNode.getReference();
            SetExp setexp = new SetExp(this.generateMode, topcount, this.hiers[iDimension]);
            return setexp;
        }
        List funCallList = this.collectFunCalls(iDimension);
        List memberList = this.collectMembers(iDimension);
        this.cleanupMemberList(funCallList, memberList, iDimension);
        if (funCallList.size() == 0 && memberList.size() == 1) {
            return memberList.get(0);
        }
        Object mSet = null;
        if (memberList.size() > 0) {
            Object[] aExp = memberList.toArray(new Object[0]);
            mSet = this.uti.createFunCall("{}", aExp, 2);
        }
        if (funCallList.size() == 0) {
            return mSet;
        }
        if (funCallList.size() == 1 && mSet == null) {
            return funCallList.get(0);
        }
        if (mSet != null) {
            set = mSet;
            start = 0;
        } else {
            set = funCallList.get(0);
            start = 1;
        }
        for (int j = start; j < funCallList.size(); ++j) {
            set = this.uti.createFunCall("Union", new Object[]{set, funCallList.get(j)}, 0);
        }
        return set;
    }

    private Object drillupExp(int iDim, Hierarchy hier) {
        int[] maxLevel = new int[]{0};
        List drillupList = this.collectDrillup(iDim, maxLevel);
        Object expForHier = null;
        if (maxLevel[0] == 0) {
            expForHier = this.uti.topLevelMembers(hier, false);
        } else if (drillupList.size() == 1) {
            expForHier = drillupList.get(0);
        } else {
            Iterator iter = drillupList.iterator();
            while (iter.hasNext()) {
                Object oExp = iter.next();
                if (expForHier == null) {
                    expForHier = oExp;
                    continue;
                }
                expForHier = this.uti.createFunCall("Union", new Object[]{expForHier, oExp}, 0);
            }
        }
        return expForHier;
    }

    private List collectDrillup(final int iDim, final int[] maxLevel) {
        final ArrayList drillupList = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Object oExp = node.getReference();
                if (!Quax.this.uti.isMember(oExp)) {
                    Quax.this.addFunCallToDrillup(drillupList, oExp, maxLevel);
                } else {
                    Member m = Quax.this.uti.memberForObj(oExp);
                    Quax.this.uti.addMemberUncles(drillupList, m, maxLevel);
                }
                return 1;
            }
        });
        return drillupList;
    }

    private List collectFunCalls(final int iDim) {
        if (this.posTreeRoot == null) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList funCallList = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                String unique;
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Object oExp = node.getReference();
                if (!Quax.this.uti.isMember(oExp) && !funCallList.contains(unique = Quax.this.uti.funString(oExp).toString())) {
                    funCallList.add(oExp);
                    funCallList.add(unique);
                }
                return 1;
            }
        });
        Iterator iter = funCallList.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof String)) continue;
            iter.remove();
        }
        return funCallList;
    }

    private void cleanupMemberList(List funCallList, List memberList, int iDim) {
        if (funCallList.size() > 0 && memberList.size() > 0) {
            Iterator itMem = memberList.iterator();
            block0: while (itMem.hasNext()) {
                Object oMember = itMem.next();
                Member m = this.uti.memberForObj(oMember);
                Iterator itFun = funCallList.iterator();
                while (itFun.hasNext()) {
                    Object oFun = itFun.next();
                    if (!this.isMemberInFunCall(oFun, m, iDim)) continue;
                    itMem.remove();
                    continue block0;
                }
            }
        }
    }

    List collectMembers(final int iDim) {
        if (this.posTreeRoot == null) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList memberList = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Object oExp = node.getReference();
                if (Quax.this.uti.isMember(oExp) && !memberList.contains(oExp)) {
                    memberList.add(oExp);
                }
                return 1;
            }
        });
        return memberList;
    }

    private void addFunCallToDrillup(List list, Object oFun, int[] maxLevel) {
        if (this.uti.isFunCallTo(oFun, "Union")) {
            for (int i = 0; i < 2; ++i) {
                Object fExp = this.uti.funCallArg(oFun, i);
                this.addFunCallToDrillup(list, fExp, maxLevel);
            }
        } else if (this.uti.isFunCallTo(oFun, "{}")) {
            for (int i = 0; i < this.uti.funCallArgCount(oFun); ++i) {
                Object oMember = this.uti.funCallArg(oFun, i);
                Member m = this.uti.memberForObj(oMember);
                this.uti.addMemberUncles(list, m, maxLevel);
            }
        } else if (this.uti.isFunCallTo(oFun, "Children")) {
            Object oMember = this.uti.funCallArg(oFun, 0);
            Member m = this.uti.memberForObj(oMember);
            this.uti.addMemberSiblings(list, m, maxLevel);
        } else if (this.uti.isFunCallTo(oFun, "Descendants")) {
            Object oMember = this.uti.funCallArg(oFun, 0);
            Member m = this.uti.memberForObj(oMember);
            Object oLevel = this.uti.funCallArg(oFun, 1);
            Level lev = this.uti.LevelForObj(oLevel);
            int level = this.uti.levelDepthForMember(m);
            int levlev = ((MDXLevel)((Object)lev)).getDepth();
            if (levlev == level + 1) {
                this.uti.addMemberSiblings(list, m, maxLevel);
            } else if (levlev == level + 2) {
                this.uti.addMemberChildren(list, m, maxLevel);
            } else {
                Level parentLevel = this.uti.getParentLevel(lev);
                this.uti.addMemberDescendants(list, m, parentLevel, maxLevel);
            }
        } else if (this.uti.isFunCallTo(oFun, "Members")) {
            Object oLevel = this.uti.funCallArg(oFun, 0);
            Level lev = this.uti.LevelForObj(oLevel);
            int levlev = ((MDXLevel)((Object)lev)).getDepth();
            if (levlev == 0) {
                return;
            }
            Level parentLevel = this.uti.getParentLevel(lev);
            this.uti.addLevelMembers(list, parentLevel, maxLevel);
        } else {
            Object oFun2 = this.uti.funCallArg(oFun, 0);
            this.addFunCallToDrillup(list, oFun2, maxLevel);
        }
    }

    private void funToList(Object oFun, List list) {
        if (this.uti.isFunCallTo(oFun, "Union")) {
            Object oArg0 = this.uti.funCallArg(oFun, 0);
            Object oArg1 = this.uti.funCallArg(oFun, 1);
            this.funToList(oArg0, list);
            this.funToList(oArg1, list);
        } else if (this.uti.isFunCallTo(oFun, "{}")) {
            for (int i = 0; i < this.uti.funCallArgCount(oFun); ++i) {
                Object oMember = this.uti.funCallArg(oFun, i);
                list.add(oMember);
            }
        } else {
            list.add(oFun);
        }
    }

    public void hierarchizePositions(Member[][] aPosMem) {
        int i;
        int nDimension = aPosMem[0].length;
        final Map[] firstOccurrences = new HashMap[nDimension];
        for (i = 0; i < nDimension; ++i) {
            firstOccurrences[i] = new HashMap();
        }
        for (i = 0; i < aPosMem.length; ++i) {
            for (int j = 0; j < nDimension; ++j) {
                if (firstOccurrences[j].containsKey(aPosMem[i][j])) continue;
                firstOccurrences[j].put(aPosMem[i][j], new Integer(i));
            }
        }
        Arrays.sort(aPosMem, new Comparator(){

            public int compare(Object o1, Object o2) {
                Member[] a1 = (Member[])o1;
                Member[] a2 = (Member[])o2;
                for (int i = 0; i < a1.length; ++i) {
                    int level2;
                    if (((Object)a1[i]).equals(a2[i])) continue;
                    int level1 = ((MDXLevel)((Object)a1[i].getLevel())).getDepth();
                    if (level1 == (level2 = ((MDXLevel)((Object)a1[i].getLevel())).getDepth())) {
                        int first1 = (Integer)firstOccurrences[i].get(a1[i]);
                        int first2 = (Integer)firstOccurrences[i].get(a2[i]);
                        return first1 - first2;
                    }
                    return level1 - level2;
                }
                return 0;
            }
        });
    }

    public QuaxUti getUti() {
        return this.uti;
    }

    public void setUti(QuaxUti uti) {
        this.uti = uti;
    }

    public int getNDimension() {
        return this.nDimension;
    }

    public TreeNode getPosTreeRoot() {
        return this.posTreeRoot;
    }

    public boolean isHierarchizeNeeded() {
        return this.hierarchizeNeeded;
    }

    public void setHierarchizeNeeded(boolean b) {
        this.hierarchizeNeeded = b;
    }

    public void setPosTreeRoot(TreeNode posTreeRoot, boolean hiersChanged) {
        this.posTreeRoot = posTreeRoot;
        if (hiersChanged) {
            TreeNode firstNode = posTreeRoot;
            ArrayList<Hierarchy> hiersList = new ArrayList<Hierarchy>();
            List children = firstNode.getChildren();
            while (children.size() > 0) {
                Hierarchy hier;
                firstNode = (TreeNode)children.get(0);
                Object oExp = firstNode.getReference();
                try {
                    hier = this.uti.hierForExp(oExp);
                }
                catch (CannotHandleException e) {
                    logger.fatal((Object)"could not determine Hierarchy for set");
                    logger.fatal((Object)e);
                    throw new IllegalArgumentException(e.getMessage());
                }
                hiersList.add(hier);
                ++this.nDimension;
                children = firstNode.getChildren();
            }
            this.hiers = hiersList.toArray(new Hierarchy[0]);
            this.nDimension = this.hiers.length;
            this.containsUF = new boolean[this.nDimension];
            this.ufMemberLists = new List[this.nDimension];
            posTreeRoot.walkChildren(new TreeNodeCallback(){

                public int handleTreeNode(TreeNode node) {
                    int iDimNode = node.getLevel() - 1;
                    Object oExp = node.getReference();
                    if (!Quax.this.uti.canHandle(oExp)) {
                        ((Quax)Quax.this).containsUF[iDimNode] = true;
                    }
                    return 0;
                }
            });
        }
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setHiers(Hierarchy[] hierarchies) {
        this.hiers = hierarchies;
        this.nDimension = hierarchies.length;
    }

    public Hierarchy[] getHiers() {
        return this.hiers;
    }

    public boolean isQubonMode() {
        return this.qubonMode;
    }

    public void setQubonMode(boolean qubonMode) {
        this.qubonMode = qubonMode;
    }

    private boolean isMemberInFunCall(Object oExp, Member member, int hierIndex) {
        boolean b = false;
        try {
            b = this.uti.isMemberInFunCall(oExp, member);
        }
        catch (CannotHandleException e) {
            if (this.ufMemberLists[hierIndex] == null) {
                throw new IllegalArgumentException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getMessage());
            }
            b = this.ufMemberLists[hierIndex].contains(member);
        }
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFunCallNotTopLevel(Object oExp, int hierIndex) {
        boolean b = false;
        try {
            return this.uti.isFunCallNotTopLevel(oExp);
        }
        catch (CannotHandleException e) {
            Member m;
            if (this.ufMemberLists[hierIndex] == null) {
                throw new IllegalArgumentException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getMessage());
            }
            Iterator iter = this.ufMemberLists[hierIndex].iterator();
            do {
                if (!iter.hasNext()) return b;
            } while (this.uti.isMemberOnToplevel(m = (Member)iter.next()));
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isChildOfMemberInFunCall(Object oExp, Member member, int hierIndex) {
        boolean b = false;
        try {
            return this.uti.isChildOfMemberInFunCall(oExp, member);
        }
        catch (CannotHandleException e) {
            Member m;
            if (this.ufMemberLists[hierIndex] == null) {
                throw new IllegalArgumentException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getMessage());
            }
            Iterator iter = this.ufMemberLists[hierIndex].iterator();
            do {
                if (!iter.hasNext()) return b;
            } while (!this.uti.checkParent(member, this.uti.objForMember(m = (Member)iter.next())));
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDescendantOfMemberInFunCall(Object oExp, Member member, int hierIndex) {
        boolean b = false;
        try {
            return this.uti.isDescendantOfMemberInFunCall(oExp, member);
        }
        catch (CannotHandleException e) {
            Member m;
            if (this.ufMemberLists[hierIndex] == null) {
                throw new IllegalArgumentException("Unknow Function - no member list, dimension=" + hierIndex + " function=" + e.getMessage());
            }
            Iterator iter = this.ufMemberLists[hierIndex].iterator();
            do {
                if (!iter.hasNext()) return b;
            } while (!this.uti.checkDescendantM(member, m = (Member)iter.next()));
            return true;
        }
    }

    private Object removeDescendantsFromFunCall(Object oFun, Member member, int iHier) {
        try {
            return this.removeDescendantsFromFunCall(oFun, member);
        }
        catch (CannotHandleException e) {
            logger.error((Object)("Unkown FunCall " + this.uti.funCallName(oFun)));
            if (this.ufMemberLists[iHier] == null) {
                throw new IllegalArgumentException("Unknow Function - no member list, dimension=" + iHier + " function=" + e.getMessage());
            }
            ArrayList<Object> newList = new ArrayList<Object>();
            Iterator iter = this.ufMemberLists[iHier].iterator();
            while (iter.hasNext()) {
                Member m = (Member)iter.next();
                if (this.uti.checkDescendantM(member, m)) continue;
                newList.add(this.uti.objForMember(m));
            }
            return this.uti.createFunCall("{}", newList.toArray(), 2);
        }
    }

    private Object removeDescendantsFromFunCall(Object oFun, Member member) throws CannotHandleException {
        if (this.uti.isFunCallTo(oFun, "Children")) {
            return null;
        }
        if (this.uti.isFunCallTo(oFun, "Descendants")) {
            return null;
        }
        if (this.uti.isFunCallTo(oFun, "Members")) {
            Level level = member.getLevel();
            Object[] members = this.uti.getLevelMembers(level);
            ArrayList<Object> remainder = new ArrayList<Object>();
            for (int i = 0; i < members.length; ++i) {
                if (this.uti.checkDescendantO(member, members[i])) continue;
                remainder.add(members[i]);
            }
            return this.uti.createMemberSet(remainder);
        }
        if (this.uti.isFunCallTo(oFun, "{}")) {
            ArrayList<Object> remainder = new ArrayList<Object>();
            for (int i = 0; i < this.uti.funCallArgCount(oFun); ++i) {
                Object om = this.uti.funCallArg(oFun, i);
                if (this.uti.checkDescendantO(member, om)) continue;
                remainder.add(om);
            }
            return this.uti.createMemberSet(remainder);
        }
        if (this.uti.isFunCallTo(oFun, "Union")) {
            Object[] uargs = new Object[]{this.removeDescendantsFromFunCall(this.uti.funCallArg(oFun, 0), member), this.removeDescendantsFromFunCall(this.uti.funCallArg(oFun, 0), member)};
            if (uargs[0] == null && uargs[1] == null) {
                return null;
            }
            if (uargs[1] == null) {
                return uargs[0];
            }
            if (uargs[0] == null) {
                return uargs[1];
            }
            if (this.uti.isMember(uargs[0])) {
                uargs[0] = this.uti.createFunCall("{}", new Object[]{uargs[0]}, 2);
            }
            if (this.uti.isMember(uargs[1])) {
                uargs[1] = this.uti.createFunCall("{}", new Object[]{uargs[1]}, 2);
            }
            if (this.uti.isFunCallTo(uargs[0], "{}") && this.uti.isFunCallTo(uargs[1], "{}")) {
                return this.unionOfSets(uargs[0], uargs[1]);
            }
            return this.uti.createFunCall("Union", uargs, 0);
        }
        throw new CannotHandleException(this.uti.funCallName(oFun));
    }

    private Object createComplement(Object oFun, Member member, int iHier) {
        try {
            return this.createComplement(oFun, member);
        }
        catch (CannotHandleException e) {
            logger.error((Object)("Unkown FunCall " + this.uti.funCallName(oFun)));
            if (this.ufMemberLists[iHier] == null) {
                throw new IllegalArgumentException("Unknow Function - no member list, dimension=" + iHier + " function=" + e.getMessage());
            }
            ArrayList<Object> newList = new ArrayList<Object>();
            Iterator iter = this.ufMemberLists[iHier].iterator();
            while (iter.hasNext()) {
                Member m = (Member)iter.next();
                if (((Object)member).equals(m)) continue;
                newList.add(this.uti.objForMember(m));
            }
            return this.uti.createFunCall("{}", newList.toArray(), 2);
        }
    }

    private Object createComplement(Object oFun, Member member) throws CannotHandleException {
        if (this.uti.isFunCallTo(oFun, "Children")) {
            Object oParent = this.uti.funCallArg(oFun, 0);
            Object oMember = this.uti.objForMember(member);
            if (!this.uti.checkChild(member, oParent)) {
                return oFun;
            }
            Object[] oChildren = this.uti.getChildren(oParent);
            if (oChildren.length < 2) {
                return null;
            }
            Object[] mComplement = new Object[oChildren.length - 1];
            int ii = 0;
            for (int i = 0; i < oChildren.length; ++i) {
                if (oChildren[i].equals(oMember)) continue;
                mComplement[ii++] = oChildren[i];
            }
            if (mComplement.length == 1) {
                return mComplement[0];
            }
            Object oComplement = this.uti.createFunCall("{}", mComplement, 2);
            return oComplement;
        }
        if (this.uti.isFunCallTo(oFun, "{}")) {
            int nComp = 0;
            int nArg = this.uti.funCallArgCount(oFun);
            Object oMember = this.uti.objForMember(member);
            for (int i = 0; i < nArg; ++i) {
                Object o = this.uti.funCallArg(oFun, i);
                if (o.equals(oMember)) continue;
                ++nComp;
            }
            if (nComp == 0) {
                return null;
            }
            if (nComp == nArg) {
                return oFun;
            }
            Object[] mComplement = new Object[nComp];
            int ii = 0;
            for (int i = 0; i < nArg; ++i) {
                Object o = this.uti.funCallArg(oFun, i);
                if (o.equals(oMember)) continue;
                mComplement[ii++] = o;
            }
            if (mComplement.length == 1) {
                return mComplement[0];
            }
            Object oComplement = this.uti.createFunCall("{}", mComplement, 2);
            return oComplement;
        }
        if (this.uti.isFunCallTo(oFun, "Union")) {
            Object[] complements = new Object[2];
            for (int i = 0; i < 2; ++i) {
                Object o = this.uti.funCallArg(oFun, i);
                complements[i] = this.createComplement(o, member);
            }
            if (complements[0] == null && complements[1] == null) {
                return null;
            }
            if (complements[0] != null && complements[1] == null) {
                return complements[0];
            }
            if (complements[0] == null && complements[1] != null) {
                return complements[1];
            }
            if (!this.uti.isFunCall(complements[0])) {
                complements[0] = this.uti.createFunCall("{}", new Object[]{complements[0]}, 2);
            }
            if (!this.uti.isFunCall(complements[1])) {
                complements[1] = this.uti.createFunCall("{}", new Object[]{complements[1]}, 2);
            }
            if (this.uti.isFunCallTo(complements[0], "{}") && this.uti.isFunCallTo(complements[1], "{}")) {
                return this.unionOfSets(complements[0], complements[1]);
            }
            Object newUnion = this.uti.createFunCall("Union", complements, 0);
            return newUnion;
        }
        throw new CannotHandleException(this.uti.funCallName(oFun));
    }

    public int getGenerateIndex() {
        return this.generateIndex;
    }

    public void setGenerateIndex(int i) {
        this.generateIndex = i;
    }

    public int getGenerateMode() {
        return this.generateMode;
    }

    public void setGenerateMode(int i) {
        this.generateMode = i;
    }

    public void resetGenerate() {
        this.generateMode = 0;
        this.generateIndex = -1;
        this.expGenerate = null;
    }

    public int getNHierExclude() {
        return this.nHierExclude;
    }

    public void setNHierExclude(int hierExclude) {
        this.nHierExclude = hierExclude;
    }

    private boolean allowNavigate(Member member, boolean qubon) {
        int iDim = this.dimIdx(this.uti.dimForMember(member));
        return this.allowNavigate(iDim, qubon);
    }

    private boolean allowNavigate(int iDim, boolean qubon) {
        if (qubon && this.generateIndex >= 0 && this.generateMode == 2 && iDim == this.generateIndex) {
            return false;
        }
        return qubon || this.generateIndex < 0 || this.generateMode != 2 || iDim < this.generateIndex;
    }

    private Object unionOfSets(Object set1, Object set2) {
        int j;
        int n1 = this.uti.funCallArgCount(set1);
        int n2 = this.uti.funCallArgCount(set2);
        Object[] newSet = new Object[n1 + n2];
        int i = 0;
        for (j = 0; j < n1; ++j) {
            newSet[i++] = this.uti.funCallArg(set1, j);
        }
        for (j = 0; j < n2; ++j) {
            newSet[i++] = this.uti.funCallArg(set2, j);
        }
        return this.uti.createFunCall("{}", newSet, 2);
    }

    public void setHierMemberList(int iHier, List list) {
        this.ufMemberLists[iHier] = list;
    }

    public boolean isUnknownFunction(int iHier) {
        return this.containsUF[iHier];
    }

    public class UnknownFunction {
        private Object fCall;
        private int hierIndex;
        private List memberList = null;

        public UnknownFunction(int hierIndex, Object fCall) {
            this.hierIndex = hierIndex;
            this.fCall = fCall;
        }

        public Object getFCall() {
            return this.fCall;
        }

        public List getMemberList() {
            return this.memberList;
        }

        public void setMemberList(List list) {
            this.memberList = list;
        }
    }

    public static class CannotHandleException
    extends Exception {
        public CannotHandleException(String arg0) {
            super(arg0);
        }
    }

    class QuaxState {
        private int nDimension;
        private TreeNode posTreeRoot;
        private Hierarchy[] hiers;
        private boolean qubornMode;
        private boolean hierarchizeNeeded;
        private int nHierExclude;
        private Level newLevel;

        public QuaxState(int nDimension, Hierarchy[] hiers, TreeNode posTreeRoot) {
            this.setDiminsion(nDimension);
            this.setPosTreeRoot(posTreeRoot);
            this.setHiers(hiers);
        }

        public void setDiminsion(int nDimension) {
            this.nDimension = nDimension;
        }

        public int getDimension() {
            return this.nDimension;
        }

        public void setPosTreeRoot(TreeNode posTreeRoot) {
            this.posTreeRoot = posTreeRoot.deepCopy();
        }

        public TreeNode getPosTreeRoot() {
            return this.posTreeRoot;
        }

        public void setHiers(Hierarchy[] hiers) {
            this.hiers = this.copyHiers(hiers);
        }

        public Hierarchy[] getHiers() {
            return this.hiers;
        }

        private Hierarchy[] copyHiers(Hierarchy[] hiers) {
            Hierarchy[] result;
            block2: {
                block3: {
                    result = null;
                    if (hiers == null || hiers.length <= 0) break block2;
                    if (hiers[0] == null || !(hiers[0] instanceof MondrianHierarchy)) break block3;
                    result = new MondrianHierarchy[hiers.length];
                    for (int i = 0; i < hiers.length && hiers[i] != null; ++i) {
                        result[i] = new MondrianHierarchy(((MondrianHierarchy)hiers[i]).getMonHierarchy(), (MondrianDimension)hiers[i].getDimension(), (MondrianModel)((MondrianHierarchy)hiers[i]).getModel());
                    }
                    break block2;
                }
                if (hiers[0] == null || !(hiers[0] instanceof XMLA_Hierarchy)) break block2;
                result = new XMLA_Hierarchy[hiers.length];
                for (int i = 0; i < hiers.length && hiers[i] != null; ++i) {
                    XMLA_Hierarchy hierarchy = (XMLA_Hierarchy)hiers[i];
                    XMLA_Model model = (XMLA_Model)hierarchy.getModel();
                    result[i] = new XMLA_Hierarchy(model, hiers[i].getDimension());
                }
            }
            return result;
        }

        public void setQubornMode(boolean b) {
            this.qubornMode = b;
        }

        public boolean isQubornMode() {
            return this.qubornMode;
        }

        public void setHierarchizeNeeded(boolean b) {
            this.hierarchizeNeeded = b;
        }

        public boolean isHierarchizeNeeded() {
            return this.hierarchizeNeeded;
        }

        public void setNHierExclude(int n) {
            this.nHierExclude = n;
        }

        public int getNHierExclude() {
            return this.nHierExclude;
        }

        public void setNewLevel(Level newLevel) {
            this.newLevel = newLevel;
        }

        public Level getNewLevel() {
            return this.newLevel;
        }
    }
}

