/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.core.ModelSupport;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapUtils;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.SortRank;
import com.tonbeller.jpivot.olap.query.MDXElement;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QuaxChangeListener;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import org.apache.log4j.Logger;

public abstract class SortRankBase
extends ExtensionSupport
implements SortRank,
QuaxChangeListener {
    protected int topBottomCount = 10;
    protected int sortMode = 1;
    protected boolean sorting = false;
    protected Member[] sortPosMembers = null;
    protected Quax quaxToSort = null;
    protected boolean sortAcrossCubeHierarchy = false;
    protected boolean sortInDescendingOrder = false;
    protected boolean displayFirstNumRows = false;
    private static final int STATE_NONE = 0;
    private static final int STATE_TOP = 1;
    private static final int STATE_BOTTOM = 2;
    static Logger logger = Logger.getLogger((Class)SortRankBase.class);

    public SortRankBase() {
        super.setId("sortRank");
    }

    public void quaxChanged(Quax quax, Object source, boolean changedByNavi) {
        if (quax != this.quaxToSort) {
            return;
        }
        if (!changedByNavi) {
            return;
        }
        if (!this.sorting) {
            return;
        }
        boolean logDebug = logger.isDebugEnabled();
        if (logDebug) {
            logger.debug((Object)"Quax changed by navi - switch sorting off");
        }
        this.sorting = false;
        ModelSupport model = (ModelSupport)this.getModel();
        model.fireModelChanged();
    }

    public int getTopBottomCount() {
        return this.topBottomCount;
    }

    public void setTopBottomCount(int topBottomCount) {
        boolean logInfo = logger.isInfoEnabled();
        if (this.topBottomCount == topBottomCount) {
            return;
        }
        if (logInfo) {
            logger.info((Object)("change topBottomCount from " + this.topBottomCount + " to " + topBottomCount));
        }
        this.topBottomCount = topBottomCount;
        if (this.sorting && this.sortPosMembers != null && (this.sortMode == 5 || this.sortMode == 6)) {
            ((ModelSupport)this.getModel()).fireModelChanged();
        }
    }

    public int getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(int sortMode) {
        if (this.sortMode == sortMode) {
            return;
        }
        boolean logInfo = logger.isInfoEnabled();
        if (logInfo) {
            logger.info((Object)("change topBottomCount from " + this.sortMode + " to " + sortMode));
        }
        this.sortMode = sortMode;
        if (this.sorting && this.sortPosMembers != null) {
            ((ModelSupport)this.getModel()).fireModelChanged();
        }
    }

    public boolean isCurrentSorting(Position position) {
        if (!this.sorting || this.sortPosMembers == null) {
            return false;
        }
        return OlapUtils.compareMembers(this.sortPosMembers, position.getMembers());
    }

    public boolean isSortable(Position position) {
        Member[] members = position.getMembers();
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].getLevel().getHierarchy().getDimension().isMeasure()) continue;
            return true;
        }
        return false;
    }

    public void sort(Axis membersToSort, Position position) {
        boolean logInfo = logger.isInfoEnabled();
        if (membersToSort.getPositions().isEmpty()) {
            logger.warn((Object)"reject sort, the axis to be sorted is empty");
            this.sorting = false;
            return;
        }
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        this.sortPosMembers = position.getMembers();
        Hierarchy[] hiers = membersToSort.getHierarchies();
        Dimension dim = hiers[0].getDimension();
        this.quaxToSort = model.getQueryAdapter().findQuax(dim);
        if (this.quaxToSort == null) {
            logger.warn((Object)"reject sort, the Quax is null");
            this.sorting = false;
            return;
        }
        if (logInfo) {
            String poString = "";
            Member[] members = position.getMembers();
            for (int i = 0; i < members.length; ++i) {
                if (i > 0) {
                    poString = poString + " ";
                }
                poString = poString + ((MDXElement)((Object)members[i])).getUniqueName();
            }
            logger.info((Object)("change Sort Position " + poString + " iAxisToSort=" + this.quaxToSort.getOrdinal()));
        }
        ((ModelSupport)this.getModel()).fireModelChanged();
    }

    public boolean isSorting() {
        return this.sorting;
    }

    public void setSorting(boolean sorting) {
        if (sorting == this.sorting) {
            return;
        }
        boolean logInfo = logger.isInfoEnabled();
        if (logInfo) {
            logger.info((Object)("change sorting to " + sorting));
        }
        this.sorting = sorting;
        ((ModelSupport)this.getModel()).fireModelChanged();
    }

    public void reset() {
        boolean logDebug = logger.isDebugEnabled();
        if (logDebug) {
            logger.debug((Object)"SortRank set to initial state");
        }
        this.topBottomCount = 10;
        this.sortMode = 1;
        this.sorting = false;
        this.sortPosMembers = null;
        Quax[] quaxes = ((QueryAdapter.QueryAdapterHolder)((Object)this.getModel())).getQueryAdapter().getQuaxes();
        for (int i = 0; i < quaxes.length; ++i) {
            quaxes[i].addChangeListener(this);
        }
        this.sortAcrossCubeHierarchy = false;
        this.sortInDescendingOrder = false;
        this.displayFirstNumRows = false;
    }

    public Member[] getSortPosMembers() {
        return this.sortPosMembers;
    }

    public void setSortPosMembers(Member[] sortPosMembers) {
        this.sortPosMembers = sortPosMembers;
    }

    public abstract void addSortToQuery();

    public int getQuaxToSort() {
        return this.quaxToSort.getOrdinal();
    }

    public int activeQuaxToSort() {
        if (this.sorting && this.sortPosMembers != null) {
            return this.quaxToSort.getOrdinal();
        }
        return -1;
    }

    public void setQuaxToSort(int ordinal) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        this.quaxToSort = model.getQueryAdapter().getQuaxes()[ordinal];
    }

    public boolean isSortOnQuery() {
        return this.sorting && this.sortPosMembers != null;
    }

    public boolean getSortAcrossCubeHierarchy() {
        return this.sortAcrossCubeHierarchy;
    }

    public void setSortAcrossCubeHierarchy(boolean b) {
        this.sortAcrossCubeHierarchy = b;
    }

    public boolean getSortInDescendingOrder() {
        return this.sortInDescendingOrder;
    }

    public void setSortInDescendingOrder(boolean b) {
        this.sortInDescendingOrder = b;
    }

    public boolean getDisplayFirstNumRows() {
        return this.displayFirstNumRows;
    }

    public void setDisplayFirstNumRows(boolean b) {
        this.displayFirstNumRows = b;
    }
}

