/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.print;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import org.apache.avalon.framework.ExceptionUtil;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;

public class PrintDelegate {
    private static String servletDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertFO2PDF(File fo, File pdf) throws IOException, FOPException {
        ConsoleLogger logger = new ConsoleLogger(1);
        Configuration.put((String)"fontBaseDir", (Object)(servletDir + "WEB-INF/jpivot/print/"));
        logger.debug("fontBaseDir=" + Configuration.getStringValue((String)"fontBaseDir"));
        String fopConfigPath = servletDir + "WEB-INF/jpivot/print/userconfig.xml";
        logger.debug("fopConfigPath=" + fopConfigPath);
        new Options(new File(fopConfigPath));
        logger.debug("Construct driver");
        Driver driver = new Driver();
        driver.setLogger((Logger)logger);
        MessageHandler.setScreenLogger((Logger)logger);
        logger.debug("Setup Renderer (output format)");
        driver.setRenderer(1);
        logger.debug("FOP renderer set to PDF");
        FileOutputStream out = new FileOutputStream(pdf);
        try {
            driver.setOutputStream((OutputStream)out);
            FileInputStream in = new FileInputStream(fo);
            try {
                driver.setInputSource(new InputSource(in));
                driver.run();
            }
            finally {
                ((InputStream)in).close();
            }
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            return;
        }
        servletDir = args[0];
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.tonbeller.jpivot.print.resources");
            if (resourceBundle == null) {
                System.out.println("resources not loaded\n");
                return;
            }
            System.out.println(resourceBundle.getLocale().toString() + " resources loaded\n");
            System.out.println("FOP ExampleFO2PDF\n");
            System.out.println("Preparing...");
            File baseDir = new File(servletDir);
            System.out.println("baseDir=" + baseDir);
            File outDir = new File(servletDir);
            System.out.println("outDir=" + outDir);
            File fofile = new File(baseDir, "web-inf/jpivot/print/swString.fo");
            System.out.println("fofile=" + fofile);
            File pdffile = new File(outDir, "web-inf/jpivot/print/swString.pdf");
            System.out.println("file=" + pdffile);
            System.out.println("Input: XSL-FO (" + fofile + ")");
            System.out.println("Output: PDF (" + pdffile + ")");
            System.out.println();
            System.out.println("Transforming...");
            PrintDelegate app = new PrintDelegate();
            app.convertFO2PDF(fofile, pdffile);
            System.out.println("Success!");
        }
        catch (Exception e) {
            System.err.println(ExceptionUtil.printStackTrace((Throwable)e));
            System.exit(-1);
        }
    }
}

