/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.print;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.client.OlapUnitImpl;
import com.tonbeller.jpivot.chart.ChartComponent;
import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.OlapModelDecorator;
import com.tonbeller.jpivot.print.PrintComponent;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.TableComponentExtensionSupport;
import com.tonbeller.jpivot.table.navi.AxisStyleUI;
import com.tonbeller.jpivot.table.navi.DrillReplaceUI;
import com.tonbeller.jpivot.table.navi.DrillThroughUI;
import com.tonbeller.jpivot.tags.OlapModelProxy;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.bookmarks.BookmarkManager;
import com.tonbeller.wcf.component.ComponentSupport;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestContextFactoryFinder;
import com.tonbeller.wcf.table.EditableTableComponent;
import com.tonbeller.wcf.utils.I18nReplacer;
import com.tonbeller.wcf.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.acegisecurity.AccessDeniedException;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.messaging.MessageHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class PrintServlet
extends HttpServlet {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((Class)PrintServlet.class);
    private static final int XLS = 0;
    private static final int PDF = 1;
    private static final int FILE = 2;
    String filename;
    Resources resources = Resources.instance();
    Driver driver;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.loadFopDriver(config);
    }

    private void loadFopDriver(ServletConfig config) {
        try {
            ConsoleLogger consoleLogger = new ConsoleLogger(1);
            Configuration.put((String)"fontBaseDir", (Object)config.getServletContext().getRealPath("/WEB-INF/jpivot/print/"));
            MessageHandler.setScreenLogger((Logger)consoleLogger);
            consoleLogger.debug("fontBaseDir=" + Configuration.getStringValue((String)"fontBaseDir"));
            String fopConfigPath = config.getServletContext().getRealPath("/WEB-INF/jpivot/print/userconfig.xml");
            consoleLogger.debug("fopConfigPath=" + fopConfigPath);
            new Options(new File(fopConfigPath));
            consoleLogger.debug("Construct driver");
            this.driver = new Driver();
            this.driver.setLogger((Logger)consoleLogger);
            consoleLogger.debug("Setup Renderer (output format)");
            this.driver.setRenderer(1);
            consoleLogger.debug("FOP renderer set to PDF");
        }
        catch (FOPException e) {
            e.printStackTrace();
            logger.info((Object)"FOP user config file not loaded");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)"FOP user config file not loaded");
        }
    }

    public void destroy() {
    }

    protected void processRequest(RequestContext context) throws ServletException, IOException {
        block42: {
            HttpServletRequest request = context.getRequest();
            HttpServletResponse response = context.getResponse();
            String type = request.getParameter("type");
            if (type == null) {
                throw new ServletException("Output type not supplied");
            }
            String view = request.getParameter("view");
            if (view == null) {
                throw new ServletException("View not supplied");
            }
            String xslUri = request.getParameter("xsluri");
            if (xslUri == null) {
                throw new ServletException("XSL URI not supplied");
            }
            String outputRef = request.getParameter("outputref");
            if (outputRef == null) {
                throw new ServletException("Output reference not supplied");
            }
            if (request.getParameter("view") != null && request.getParameter("type") != null) {
                try {
                    int intType = -1;
                    if (type.equalsIgnoreCase("XLS")) {
                        intType = 0;
                    } else if (type.equalsIgnoreCase("PDF")) {
                        intType = 1;
                    } else if (type.equalsIgnoreCase("FILE")) {
                        intType = 2;
                        if (!this.save(context)) {
                            throw new IOException();
                        }
                        String viewUri = request.getParameter("name");
                        String drillThrough = request.getParameter("drillthrough");
                        String fromPage = request.getHeader("Referer");
                        fromPage = this.appendViewUri(viewUri, fromPage);
                        fromPage = this.appendDrillThrough(context, fromPage);
                        response.sendRedirect(fromPage);
                    }
                    switch (intType) {
                        case 0: {
                            RendererParameters.setParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"excel", (String)"request");
                            response.setContentType("application/vnd.ms-excel");
                            this.filename = "xls_export.xls";
                            break;
                        }
                        case 1: {
                            RendererParameters.setParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"print", (String)"request");
                            response.setContentType("application/pdf");
                            this.filename = "xls_export.pdf";
                        }
                    }
                    boolean xslCache = true;
                    boolean xslCacheDt = true;
                    String tableRef = view + "/table";
                    String chartRef = view + "/chart";
                    String printRef = view + "/print";
                    String drillThroughRef = view + ".drillthroughtable";
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    ServletOutputStream outStream = response.getOutputStream();
                    PrintWriter out = new PrintWriter((OutputStream)outStream);
                    HttpSession session = request.getSession();
                    response.setHeader("Content-Disposition", "attachment; filename=" + this.filename);
                    ComponentSupport table = (ComponentSupport)context.getModelReference(outputRef);
                    if (table != null) {
                        ChartComponent chart;
                        AxisStyleUI asu;
                        boolean restoreDrillReplace = false;
                        boolean restoreParentCells = false;
                        boolean restoreParentColumns = false;
                        TableComponent tc = (TableComponent)context.getModelReference(tableRef);
                        if (tc == null) {
                            return;
                        }
                        Map m = tc.getExtensions();
                        if (m == null) {
                            return;
                        }
                        DrillReplaceUI dru = (DrillReplaceUI)m.get("drillReplace");
                        if (dru == null) {
                            return;
                        }
                        boolean bDrillReplace = dru.isEnabled();
                        if (bDrillReplace) {
                            ((TableComponentExtensionSupport)dru).setEnabled(false);
                            restoreDrillReplace = true;
                        }
                        if ((asu = (AxisStyleUI)m.get("axisStyle")) == null) {
                            return;
                        }
                        PrintComponent printConfig = (PrintComponent)((Object)context.getModelReference(printRef));
                        if (printConfig != null) {
                            boolean bLevelStyle;
                            boolean bHideSpans;
                            if ((intType == 0 && printConfig.isIncludeParentCellsExcel() || intType == 1 && printConfig.isIncludeParentCellsPdf()) && !(bHideSpans = asu.isHideSpans())) {
                                asu.setHideSpans(true);
                                restoreParentCells = true;
                            }
                            if ((intType == 0 && printConfig.isIncludeParentColumnsExcel() || intType == 1 && printConfig.isIncludeParentColumnsPdf()) && !(bLevelStyle = asu.isLevelStyle())) {
                                asu.setLevelStyle(true);
                                restoreParentColumns = true;
                            }
                            if (printConfig.isSetTableWidth()) {
                                parameters.put(printConfig.PRINT_TABLE_WIDTH, new Double(printConfig.getTableWidth()));
                            }
                            if (printConfig.getReportTitle().trim().length() != 0) {
                                parameters.put(printConfig.PRINT_TITLE, printConfig.getReportTitle().trim());
                            }
                            parameters.put(printConfig.PRINT_PAGE_ORIENTATION, printConfig.getPageOrientation());
                            parameters.put(printConfig.PRINT_PAPER_TYPE, printConfig.getPaperType());
                            if (printConfig.getPaperType().equals(this.resources.getString("jsp.wcf.print.custom"))) {
                                parameters.put(printConfig.PRINT_PAGE_WIDTH, new Double(printConfig.getPageWidth()));
                                parameters.put(printConfig.PRINT_PAGE_HEIGHT, new Double(printConfig.getPageHeight()));
                            }
                            parameters.put(printConfig.PRINT_CHART_PAGEBREAK, new Boolean(printConfig.isChartPageBreak()));
                        }
                        if ((chart = (ChartComponent)request.getSession().getAttribute(chartRef)) != null && chart.isVisible()) {
                            String host = request.getServerName();
                            int port = request.getServerPort();
                            String location = request.getContextPath();
                            String scheme = request.getScheme();
                            String chartServlet = scheme + "://" + host + ":" + port + location + "/GetChart";
                            parameters.put("chartimage", chartServlet + "?filename=" + chart.getFilename());
                            parameters.put("chartheight", new Integer(chart.getChartHeight()));
                            parameters.put("chartwidth", new Integer(chart.getChartWidth()));
                        }
                        parameters.put("context", context.getRequest().getContextPath());
                        if (table instanceof TableComponent) {
                            ((TableComponent)table).setDirty(true);
                        }
                        Document document = table.render(context);
                        logger.debug((Object)"getting I18nReplacer...");
                        I18nReplacer replacer = I18nReplacer.instance((Resources)Resources.instance());
                        if (replacer != null) {
                            replacer.replaceAll((Node)document);
                            logger.debug((Object)"replaced fmt:key in dom tree");
                        }
                        if (table instanceof TableComponent) {
                            ((TableComponent)table).setDirty(true);
                        }
                        DOMSource source = new DOMSource(document);
                        Transformer transformer = XmlUtils.getTransformer((HttpSession)session, (String)xslUri, (boolean)xslCache);
                        Iterator it = parameters.keySet().iterator();
                        while (it.hasNext()) {
                            String name = (String)it.next();
                            Object value = parameters.get(name);
                            transformer.setParameter(name, value);
                        }
                        StringWriter sw = new StringWriter();
                        StreamResult result = new StreamResult(sw);
                        transformer.transform(source, result);
                        sw.flush();
                        String swString = sw.toString();
                        if (intType == 0) {
                            logger.info((Object)"Writing XLS");
                            response.setContentLength(swString.length());
                            out.write(swString);
                            RendererParameters.removeParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"excel", (String)"request");
                        } else {
                            logger.info((Object)"Creating PDF!");
                            try {
                                ByteArrayInputStream bain = new ByteArrayInputStream(swString.getBytes(this.resources.getCharacterEncoding()));
                                ByteArrayOutputStream baout = new ByteArrayOutputStream(bain.available());
                                this.convertFO2PDF(bain, baout);
                                byte[] content = baout.toByteArray();
                                response.setContentLength(content.length);
                                outStream.write(content);
                                RendererParameters.removeParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"print", (String)"request");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        out.flush();
                        out.close();
                        outStream.flush();
                        if (restoreDrillReplace) {
                            ((TableComponentExtensionSupport)dru).setEnabled(true);
                        }
                        if (restoreParentCells) {
                            asu.setHideSpans(false);
                        }
                        if (restoreParentColumns) {
                            asu.setLevelStyle(false);
                        }
                        if (restoreDrillReplace || restoreParentCells || restoreParentColumns) {
                            table.render(context);
                            table.validate(context);
                        }
                        break block42;
                    }
                    throw new ServletException("Output reference invalid");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String appendViewUri(String viewUri, String fromPage) {
        String result = fromPage;
        if (!fromPage.contains("name=")) {
            result = !fromPage.contains("?") ? result + "?" + viewUri : result + "&" + viewUri;
            result = result + "name=" + viewUri;
        }
        return result;
    }

    private String appendDrillThrough(RequestContext context, String fromPage) {
        String result = fromPage;
        OlapModel olapModel = (OlapModel)context.getSession().getAttribute("olapModel");
        if (olapModel != null) {
            Object listener = null;
            Iterator itrListeners = ((OlapModelProxy)olapModel).getListeners().iterator();
            while (itrListeners.hasNext() && !((listener = itrListeners.next()) instanceof DrillThroughUI)) {
            }
            if (listener != null && !fromPage.contains("drillthrough")) {
                String useBrowser = "y";
                result = fromPage + "&drillthrough=" + useBrowser;
            }
        }
        return result;
    }

    private String appendDrillThroughTableXls(String swString, StringWriter swDt) {
        String result = null;
        int idxEndOfTable = swString.indexOf("</body>");
        String swDtString = swDt.toString();
        int idxStartOfDrillThroughTable = swDtString.indexOf("<table");
        result = swString.substring(0, idxEndOfTable) + "<br/>" + swDtString.substring(idxStartOfDrillThroughTable);
        return result;
    }

    private String appendDrillThroughTablePdf(String swString, StringWriter swDt) {
        String result = null;
        int idxEndOfTable = swString.lastIndexOf("<fo:block text-align=\"left\">" + this.resources.getString("JAJ_000_jsp.viewOlap.slicer"));
        idxEndOfTable = swString.indexOf("</fo:block>", idxEndOfTable);
        idxEndOfTable = swString.indexOf("</fo:block>", idxEndOfTable + 1);
        String swDtString = swDt.toString();
        int idxStartOfDrillThroughTable = swDtString.indexOf("<fo:table table-layout=\"fixed\" width=\"100%\">");
        result = swString.substring(0, idxEndOfTable) + "\n<fo:table break-before=\"page\" " + swDtString.substring(idxStartOfDrillThroughTable + "<fo:table ".length());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertFO2PDF(ByteArrayInputStream bain, ByteArrayOutputStream baout) throws IOException, FOPException {
        this.driver.setOutputStream((OutputStream)baout);
        logger.debug((Object)"Setup input");
        this.driver.setInputSource(new InputSource(bain));
        logger.debug((Object)"Process FO");
        this.driver.run();
        logger.debug((Object)"PDF file generation completed");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestContext context = RequestContextFactoryFinder.createContext((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
        try {
            this.processRequest(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        finally {
            context.invalidate();
        }
    }

    public String getServletInfo() {
        return "Export OLAP table to Excel or PDF";
    }

    private boolean save(RequestContext context) {
        HttpSession session = context.getRequest().getSession();
        String currentView = (String)session.getAttribute("currentView");
        if (currentView == null) {
            throw new JSException("No current OLAP view");
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getServletContext());
        RepositoryService repository = (RepositoryService)ctx.getBean("repositoryService");
        OlapUnitImpl olapUnit = (OlapUnitImpl)repository.getResource(null, currentView);
        if (olapUnit == null) {
            throw new JSException("No OLAP Model retrieved");
        }
        ResourceReference olapCltConn = olapUnit.getOlapClientConnection();
        Object state = BookmarkManager.instance((HttpSession)context.getRequest().getSession()).collectSessionState(0);
        OlapModel olapModel = (OlapModel)session.getAttribute("olapModel");
        Model mdl = ((OlapModelDecorator)olapModel).getRootModel();
        String drillThruSQL = null;
        if (mdl instanceof MondrianModel) {
            try {
                EditableTableComponent et;
                if (currentView != null && (et = (EditableTableComponent)session.getAttribute(currentView + ".drillthroughtable")) != null) {
                    drillThruSQL = ((MondrianDrillThroughTableModel)et.getModel()).getSql();
                    ((HashMap)state).put("drillThruSQL", drillThruSQL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String mdxQuery = null;
        if (mdl instanceof MondrianModel) {
            try {
                mdxQuery = ((MondrianModel)mdl).getCurrentMdx();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (mdl instanceof XMLA_Model) {
            mdxQuery = ((XMLA_Model)mdl).getCurrentMdx();
        }
        olapUnit.setMdxQuery(mdxQuery);
        String olapViewName = currentView.substring(currentView.lastIndexOf(47) + 1, currentView.length());
        olapUnit.setName(olapViewName);
        olapUnit.setLabel(context.getRequest().getParameter("label"));
        olapUnit.setDescription(context.getRequest().getParameter("description"));
        olapUnit.setOlapClientConnection(olapCltConn);
        olapUnit.setParentFolder(context.getRequest().getParameter("parentFolder"));
        HashMap newState = new HashMap();
        this.removeNonCurrentViewBookmark(newState, (HashMap)state, currentView);
        olapUnit.setOlapViewOptions(newState);
        try {
            repository.saveResource(null, (Resource)olapUnit);
            olapUnit.setVersion(olapUnit.getVersion() + 1);
            session.setAttribute("olapUnit", (Object)olapUnit);
        }
        catch (JSDuplicateResourceException e) {
            e.printStackTrace();
        }
        catch (AccessDeniedException f) {
            String errMsg = this.resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.save.accessDenied", null, this.resources.getLocaleContextHolderLocale());
            session.setAttribute("save_access_denied", (Object)errMsg);
        }
        return true;
    }

    private void removeNonCurrentViewBookmark(HashMap pureState, HashMap state, String existingPathAndObject) {
        Set set = state.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if ((!key.startsWith(existingPathAndObject) || key.length() <= existingPathAndObject.length() || key.charAt(existingPathAndObject.length()) != '.' && key.charAt(existingPathAndObject.length()) != '/') && !key.equals("drillThruSQL")) continue;
            Object value = state.get(key);
            pureState.put(key, value);
        }
    }
}

