/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.table.AxisBuilderSupport;
import com.tonbeller.jpivot.table.RowAxisBuilder;
import com.tonbeller.jpivot.table.RowAxisConfig;
import com.tonbeller.jpivot.table.SpanBuilderImpl;
import com.tonbeller.jpivot.table.span.HierarchyHeaderFactory;
import com.tonbeller.jpivot.table.span.IgnorePropertiesHierarchyHeaderFactory;
import com.tonbeller.jpivot.table.span.LevelHeaderFactory;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanCalc;
import com.tonbeller.jpivot.test.olap.TestHierarchy;
import mondrian.olap.HierarchyBase;
import mondrian.rolap.RolapLevel;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class RowAxisBuilderBreadcrumbsImpl
extends AxisBuilderSupport
implements RowAxisBuilder,
RowAxisConfig {
    int positionHeader;
    SpanCalc headerSpans;
    private static final Logger logger = Logger.getLogger((Class)RowAxisBuilderBreadcrumbsImpl.class);

    public RowAxisBuilderBreadcrumbsImpl() {
        super(new SpanBuilderImpl("row-heading", "heading-heading"));
        this.setMemberIndent(true);
        this.setShowParentMembers(true);
        this.setHierarchyHeader(0);
        this.setMemberSpan(3);
        this.setHeaderSpan(3);
        this.setPositionHeader(1);
    }

    public void buildRow(Element parent, int rowIndex) {
        boolean even = rowIndex % 2 == 0;
        for (int i = 0; i < this.spanCalc.getHierarchyCount(); ++i) {
            Span span = this.spanCalc.getSpan(rowIndex, i);
            if (!span.isSignificant()) continue;
            int rowspan = span.getPositionSpan();
            int colspan = span.getHierarchySpan();
            this.buildHeading(parent, span, rowspan, colspan, even);
        }
    }

    public int getColumnCount() {
        return this.spanCalc.getHierarchyCount();
    }

    public int getRowCount() {
        return this.spanCalc.getPositionCount();
    }

    public int getPositionHeader() {
        return this.positionHeader;
    }

    public void setPositionHeader(int positionHeader) {
        this.positionHeader = positionHeader;
        this.setDirty(true);
    }

    public void buildHeaderRow(Element parent, int rowIndex) {
        boolean even = rowIndex % 2 == 0;
        for (int i = 0; i < this.headerSpans.getHierarchyCount(); ++i) {
            Span span = this.headerSpans.getSpan(rowIndex, i);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("building header row: " + span));
            }
            if (!span.isSignificant()) continue;
            int rowspan = span.getPositionSpan();
            int colspan = span.getHierarchySpan();
            this.buildHeading(parent, span, rowspan, colspan, even);
        }
    }

    public int getHeaderRowCount() {
        if (this.headerSpans == null) {
            return 0;
        }
        return this.headerSpans.getPositionCount();
    }

    public SpanCalc getHeaderSpanCalc() {
        return this.headerSpans;
    }

    public void initialize(Axis axis) {
        super.initialize(axis);
        switch (this.positionHeader) {
            case 3: {
                logger.info((Object)"HIERARCHY_LEVEL_HEADER");
                SpanCalc sc1 = this.spanCalc.createPositionHeader(new IgnorePropertiesHierarchyHeaderFactory());
                SpanCalc sc2 = this.spanCalc.createPositionHeader(new LevelHeaderFactory());
                this.headerSpans = this.getAllHeader(sc1, sc2);
                break;
            }
            case 2: {
                logger.info((Object)"LEVEL_HEADER");
                this.headerSpans = this.spanCalc.createPositionHeader(new LevelHeaderFactory());
                break;
            }
            case 1: {
                logger.info((Object)"HIERARCHY_HEADER");
                this.headerSpans = this.spanCalc.createPositionHeader(new HierarchyHeaderFactory());
                break;
            }
            default: {
                this.headerSpans = null;
            }
        }
        if (this.headerSpans != null) {
            this.headerSpans.setConfig(this.spanCalc.getConfig());
        }
    }

    private SpanCalc getAllHeader(SpanCalc sc1, SpanCalc sc2) {
        Span[][] hierSpans = sc1.getSpans();
        Span[][] levelSpans = sc2.getSpans();
        for (int i = 0; i < hierSpans.length; ++i) {
            Span[] hierSpans1 = hierSpans[i];
            Span[] levelSpans1 = levelSpans[i];
            for (int j = 0; j < hierSpans1.length; ++j) {
                Hierarchy mh = (Hierarchy)hierSpans1[j].getObject();
                Level ml = (Level)levelSpans1[j].getObject();
                if (mh instanceof MondrianHierarchy) {
                    HierarchyBase rh = (HierarchyBase)((MondrianHierarchy)mh).getMonHierarchy();
                    RolapLevel rl = (RolapLevel)((MondrianLevel)ml).getMonLevel();
                    if (!rl.getName().equals("(All)")) continue;
                    rl.setCaption(rh.getName());
                    continue;
                }
                if (!(mh instanceof TestHierarchy)) continue;
            }
        }
        return sc2;
    }

    public void stopBuild() {
        super.stopBuild();
        this.headerSpans = null;
    }

    protected Axis getAxis() {
        return this.table.getRowAxis();
    }
}

