/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.table.ColumnAxisBuilder;
import com.tonbeller.jpivot.table.RowAxisBuilder;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.SpanBuilderDecorator;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.TableComponentExtensionSupport;
import com.tonbeller.jpivot.table.navi.DrillReplaceUI;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.tags.OlapModelProxy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DrillExpandUI
extends TableComponentExtensionSupport
implements ModelChangeListener {
    boolean available;
    boolean renderActions;
    static Map canCollapseMap = new HashMap();
    Resources resources;
    boolean isDrillReplace = false;
    Dispatcher dispatcher = new DispatcherSupport();

    public void initialize(RequestContext context, TableComponent table) throws Exception {
        super.initialize(context, table);
        table.getOlapModel().addModelChangeListener(this);
        this.available = this.initializeExtension();
        table.getDispatcher().addRequestListener(null, null, (RequestListener)this.dispatcher);
        RowAxisBuilder rab = table.getRowAxisBuilder();
        DomDecorator rhr = new DomDecorator(rab.getSpanBuilder());
        rab.setSpanBuilder(rhr);
        ColumnAxisBuilder cab = table.getColumnAxisBuilder();
        DomDecorator chr = new DomDecorator(cab.getSpanBuilder());
        cab.setSpanBuilder(chr);
        this.resources = Resources.instance();
    }

    public void startBuild(RequestContext context) {
        super.startBuild(context);
        this.renderActions = RendererParameters.isRenderActions((RequestContext)context);
        if (this.renderActions) {
            this.dispatcher.clear();
        }
    }

    private boolean isZooming() {
        boolean zooming = false;
        Object listener = null;
        List listeners = ((OlapModelProxy)this.table.getOlapModel()).getListeners();
        for (int i = 0; i < listeners.size() && !((listener = listeners.get(i)) instanceof DrillReplaceUI); ++i) {
        }
        if (listener != null) {
            zooming = ((DrillReplaceUI)listener).isEnabled();
        }
        return zooming;
    }

    private boolean isDrilling(Span span) {
        if (span == null) {
            return false;
        }
        boolean result = false;
        Displayable object = span.getObject();
        if (object == null) {
            return false;
        }
        if (object instanceof MondrianLevel) {
            result = ((MondrianLevel)object).isDrilling();
        } else if (object instanceof MondrianMember) {
            result = ((MondrianMember)object).isDrilling();
        } else if (object instanceof XMLA_Level) {
            result = ((XMLA_Level)object).isDrilling();
        } else if (object instanceof XMLA_Member) {
            result = ((XMLA_Member)object).isDrilling();
        }
        return result;
    }

    private boolean canZoomOut(Span span) {
        boolean result;
        block16: {
            Displayable object;
            block17: {
                if (span == null) {
                    return false;
                }
                result = false;
                object = span.getObject();
                if (object == null) {
                    return false;
                }
                if (!(object instanceof MondrianLevel)) break block17;
                MondrianLevel level = (MondrianLevel)object;
                if (level == null) {
                    return false;
                }
                Hierarchy hierarchy = level.getHierarchy();
                if (hierarchy == null) {
                    return false;
                }
                MondrianLevel[] levels = (MondrianLevel[])hierarchy.getLevels();
                if (levels == null) {
                    return false;
                }
                mondrian.olap.Level monLevel = level.getMonLevel();
                if (monLevel == null) {
                    return false;
                }
                String label = level.getMonLevel().getName();
                if (label == null) break block16;
                for (int i = 1; i < levels.length && levels[i] != null; ++i) {
                    if (levels[i].getLabel() == null || !levels[i].getLabel().equals(label) || levels[i - 1] == null) continue;
                    result = levels[i - 1].isZooming();
                    List memberList = levels[i - 1].getMembers();
                    if (memberList == null) continue;
                    Iterator itr = memberList.iterator();
                    while (itr.hasNext()) {
                        result |= ((MondrianMember)itr.next()).isZooming();
                    }
                    break block16;
                }
                break block16;
            }
            if (object instanceof XMLA_Level) {
                Level level = (Level)object;
                Hierarchy hierarchy = level.getHierarchy();
                if (hierarchy == null) {
                    return false;
                }
                Level[] levels = hierarchy.getLevels();
                if (levels == null) {
                    return false;
                }
                String label = ((XMLA_Level)level).getName();
                if (label != null) {
                    for (int i = 1; i < levels.length && levels[i] != null; ++i) {
                        if (levels[i].getLabel() == null || !levels[i].getLabel().equals(label) || levels[i - 1] == null) continue;
                        result = ((XMLA_Level)levels[i - 1]).isZooming();
                        XMLA_Member[] members = null;
                        try {
                            members = ((XMLA_Level)levels[i - 1]).getMembers();
                        }
                        catch (OlapException e) {
                            e.printStackTrace();
                        }
                        if (members == null) continue;
                        for (int j = 0; j < members.length && members[j] != null; ++j) {
                            result |= members[j].isZooming();
                        }
                        break;
                    }
                }
            }
        }
        return result;
    }

    protected abstract boolean initializeExtension();

    protected abstract boolean canExpand(Span var1);

    protected abstract void expand(Span var1);

    protected abstract boolean canCollapse(Span var1);

    protected abstract void collapse(Span var1);

    protected abstract boolean canZoom(Span var1);

    protected abstract void zoom_out(Span var1);

    protected abstract String getExpandImage();

    protected abstract String getCollapseImage();

    protected abstract String getZoomOutImage();

    protected abstract String getOtherImage();

    protected abstract boolean isExceeded();

    public boolean isAvailable() {
        return this.available;
    }

    static int indexOf(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    static boolean positionContainsMember(Span s) {
        if (!s.isMember()) {
            return false;
        }
        Member m = (Member)s.getMember().getRootDecoree();
        Position p = (Position)s.getPosition().getRootDecoree();
        return DrillExpandUI.indexOf(p.getMembers(), m) >= 0;
    }

    public void modelChanged(ModelChangeEvent e) {
    }

    public void structureChanged(ModelChangeEvent e) {
        this.available = this.initializeExtension();
        this.dispatcher.clear();
    }

    class ZoomHandler
    implements RequestListener {
        Span span;

        ZoomHandler(Span span) {
            this.span = span;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            if (DrillExpandUI.this.canZoom(this.span)) {
                DrillExpandUI.this.zoom_out(this.span);
            }
        }
    }

    class CollapseHandler
    implements RequestListener {
        Span span;

        CollapseHandler(Span span) {
            this.span = span;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            if (DrillExpandUI.this.canCollapse(this.span)) {
                DrillExpandUI.this.collapse(this.span);
            }
        }
    }

    class ExpandHandler
    implements RequestListener {
        Span span;

        ExpandHandler(Span span) {
            this.span = span;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            if (DrillExpandUI.this.canExpand(this.span)) {
                DrillExpandUI.this.expand(this.span);
            }
        }
    }

    class DomDecorator
    extends SpanBuilderDecorator {
        DomDecorator(SpanBuilder delegate) {
            super(delegate);
        }

        public Element build(SpanBuilder.SBContext sbctx, Span span, boolean even) {
            Element parent = super.build(sbctx, span, even);
            if (this.table.getCorner() != null && DrillExpandUI.this.getExpandImage().endsWith("-all")) {
                Element corner = this.table.getCorner();
                String expandAllMode = "up";
                String collapseAllMode = "up";
                String zoomOutAllMode = "up";
                if (DrillExpandUI.this.isZooming()) {
                    expandAllMode = "d";
                    collapseAllMode = "d";
                } else {
                    zoomOutAllMode = "d";
                }
                corner.setAttribute("dimensions", DrillExpandUI.this.resources.getString("Dimensions"));
                String id_expand = DomUtils.randomId();
                corner.setAttribute("id-expand-all", id_expand);
                corner.setAttribute("img-expand-all", DrillExpandUI.this.getExpandImage());
                corner.setAttribute("title-expand-all", DrillExpandUI.this.resources.getString("JAJ_000_jsp.jpivot.expandAll"));
                corner.setAttribute("expand-all-mode", expandAllMode);
                if (expandAllMode.equals("d")) {
                    corner.setAttribute("expandAllDisabled", "disabled");
                }
                DrillExpandUI.this.dispatcher.addRequestListener(id_expand, null, (RequestListener)new ExpandHandler(span));
                String id_collapse = DomUtils.randomId();
                corner.setAttribute("id-collapse-all", id_collapse);
                corner.setAttribute("img-collapse-all", DrillExpandUI.this.getCollapseImage());
                corner.setAttribute("title-collapse-all", DrillExpandUI.this.resources.getString("JAJ_000_jsp.jpivot.collapseAll"));
                corner.setAttribute("collapse-all-mode", collapseAllMode);
                if (collapseAllMode.equals("d")) {
                    corner.setAttribute("collapseAllDisabled", "disabled");
                }
                DrillExpandUI.this.dispatcher.addRequestListener(id_collapse, null, (RequestListener)new CollapseHandler(span));
                String id_zoom_out_all = DomUtils.randomId();
                corner.setAttribute("id-zoom-out-all", id_zoom_out_all);
                corner.setAttribute("img-zoom-out-all", DrillExpandUI.this.getZoomOutImage());
                corner.setAttribute("title-zoom-out-all", DrillExpandUI.this.resources.getString("JAJ_000_jsp.jpivot.zoomOutAll"));
                corner.setAttribute("zoom-out-all-mode", zoomOutAllMode);
                if (zoomOutAllMode.equals("d")) {
                    corner.setAttribute("zoomOutAllDisabled", "disabled");
                }
                DrillExpandUI.this.dispatcher.addRequestListener(id_zoom_out_all, null, (RequestListener)new ZoomHandler(span));
                String exceeded = "";
                if (DrillExpandUI.this.getExpandImage().equals("expand-all") && DrillExpandUI.this.isExceeded()) {
                    exceeded = "true";
                    corner.setAttribute("exceededMessage", DrillExpandUI.this.resources.getString("JAJ_000_jpivot.ExpandAllExt.ExceededText"));
                }
                corner.setAttribute("exceeded", exceeded);
                return parent;
            }
            if (!(DrillExpandUI.this.enabled && DrillExpandUI.this.renderActions && DrillExpandUI.this.available)) {
                return parent;
            }
            String id = DomUtils.randomId();
            if (DrillExpandUI.this.canExpand(span)) {
                Element elem = this.table.insert(DrillExpandUI.this.getExpandImage(), parent);
                elem.setAttribute("id", id);
                elem.setAttribute("img", DrillExpandUI.this.getExpandImage());
                if (DrillExpandUI.this.getCollapseImage().startsWith("drill-replace")) {
                    elem.setAttribute("title", DrillExpandUI.this.resources.getString("JAJ_000_jsp.jpivot.zoomIn"));
                } else {
                    elem.setAttribute("title", DrillExpandUI.this.resources.getString("JAJ_000_jsp.jpivot.drillPositionMember"));
                }
                if (!DrillExpandUI.this.isDrilling(span)) {
                    elem.setAttribute("name", span.getObject().getLabel());
                }
                DrillExpandUI.this.dispatcher.addRequestListener(id, null, (RequestListener)new ExpandHandler(span));
                NodeList children = parent.getChildNodes();
                int count = 0;
                block0: for (int i = 0; i < children.getLength(); ++i) {
                    Node caption = children.item(i);
                    NamedNodeMap nMap = caption.getAttributes();
                    for (int j = 0; j < nMap.getLength(); ++j) {
                        if (!"caption".equals(nMap.item(j).getNodeName()) || !span.getObject().getLabel().equals(nMap.item(j).getNodeValue()) || !DrillExpandUI.this.isDrillReplace || ++count <= 1) continue;
                        parent.removeChild(caption);
                        continue block0;
                    }
                }
            } else if (DrillExpandUI.this.canCollapse(span)) {
                Element elem;
                if (DrillExpandUI.this.getCollapseImage().startsWith("drill-replace")) {
                    if (DrillExpandUI.this.canZoomOut(span)) {
                        elem = this.table.insert(DrillExpandUI.this.getCollapseImage(), parent);
                        elem.setAttribute("id", id);
                        elem.setAttribute("img", DrillExpandUI.this.getCollapseImage());
                        elem.setAttribute("name", span.getObject().getLabel());
                        elem.setAttribute("title", DrillExpandUI.this.resources.getString("JAJ_000_jsp.jpivot.zoomOut"));
                    }
                } else {
                    elem = this.table.insert(DrillExpandUI.this.getCollapseImage(), parent);
                    elem.setAttribute("id", id);
                    elem.setAttribute("img", DrillExpandUI.this.getCollapseImage());
                    elem.setAttribute("title", DrillExpandUI.this.resources.getString("JAJ_000_jsp.jpivot.collapsePositionMember"));
                }
                DrillExpandUI.this.dispatcher.addRequestListener(id, null, (RequestListener)new CollapseHandler(span));
                NodeList children = parent.getChildNodes();
                int count = 0;
                block2: for (int i = 0; i < children.getLength(); ++i) {
                    Node caption = children.item(i);
                    NamedNodeMap nMap = caption.getAttributes();
                    for (int j = 0; j < nMap.getLength(); ++j) {
                        if (!"caption".equals(nMap.item(j).getNodeName()) || !span.getObject().getLabel().equals(nMap.item(j).getNodeValue()) || !DrillExpandUI.this.isDrillReplace || ++count <= 1) continue;
                        parent.removeChild(caption);
                        continue block2;
                    }
                }
            } else {
                NodeList children = parent.getChildNodes();
                boolean existNode = false;
                for (int i = 0; i < children.getLength(); ++i) {
                    Node caption = children.item(i);
                    NamedNodeMap nMap = caption.getAttributes();
                    for (int j = 0; j < nMap.getLength(); ++j) {
                        if (!"caption".equals(nMap.item(j).getNodeName()) || !span.getObject().getLabel().equals(nMap.item(j).getNodeValue())) continue;
                        existNode = true;
                    }
                }
                if (!existNode && DrillExpandUI.this.isDrillReplace) {
                    Element caption = this.table.insert("caption", parent);
                    caption.setAttribute("caption", span.getObject().getLabel());
                    sbctx.setCaption(caption, span.getObject().getLabel());
                }
            }
            return parent;
        }
    }
}

