/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.jaspersoft.jasperserver.war.control.OlapModelController;
import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.mondrian.MondrianCell;
import com.tonbeller.jpivot.mondrian.MondrianDrillThrough;
import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.navi.DrillThrough;
import com.tonbeller.jpivot.olap.query.MdxOlapModel;
import com.tonbeller.jpivot.olap.query.ResultBase;
import com.tonbeller.jpivot.table.CellBuilder;
import com.tonbeller.jpivot.table.CellBuilderDecorator;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.TableComponentExtensionSupport;
import com.tonbeller.jpivot.tags.OlapModelProxy;
import com.tonbeller.jpivot.xmla.XMLA_Cell;
import com.tonbeller.jpivot.xmla.XMLA_DrillThrough;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.table.EditableTableComponent;
import com.tonbeller.wcf.table.EmptyTableModel;
import com.tonbeller.wcf.table.ITableComponent;
import com.tonbeller.wcf.table.TableColumn;
import com.tonbeller.wcf.table.TableModel;
import com.tonbeller.wcf.table.TableModelDecorator;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Element;

public class DrillThroughUI
extends TableComponentExtensionSupport
implements ModelChangeListener {
    boolean available;
    boolean active;
    boolean renderActions;
    Dispatcher dispatcher = new DispatcherSupport();
    DrillThrough extension;
    boolean printformVisible;
    TableModelDecorator tableModel = new TableModelDecorator(EmptyTableModel.instance());
    Resources resources = Resources.instance();
    private boolean showTableBelowCube = false;
    private boolean hideDillThroughLinks = false;
    private boolean includeOnlySelectedMeasure = true;
    RequestContext context;
    public static final String ID = "drillThrough";
    private boolean drillThroughMode;

    public String getId() {
        return ID;
    }

    public void initialize(RequestContext context, TableComponent table) throws Exception {
        super.initialize(context, table);
        table.getOlapModel().addModelChangeListener(this);
        if (!this.initializeExtension()) {
            this.available = false;
            return;
        }
        this.available = true;
        table.getDispatcher().addRequestListener(null, null, (RequestListener)this.dispatcher);
        CellBuilder cb = table.getCellBuilder();
        DomDecorator cr = new DomDecorator(table.getCellBuilder(), this);
        table.setCellBuilder(cr);
        this.context = context;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void startBuild(RequestContext context) {
        super.startBuild(context);
        this.renderActions = RendererParameters.isRenderActions((RequestContext)context);
        if (this.renderActions) {
            this.dispatcher.clear();
        }
    }

    protected boolean initializeExtension() {
        OlapModel om = this.table.getOlapModel();
        this.extension = (DrillThrough)om.getExtension(ID);
        return this.extension != null;
    }

    protected boolean canDrillThrough(Cell cell) {
        return this.extension.canDrillThrough((Cell)cell.getRootDecoree());
    }

    protected TableModel drillThrough(Cell cell) throws OlapException {
        XMLA_Model model = null;
        ResultBase resultBase = null;
        TableModel result = null;
        try {
            if (this.extension instanceof MondrianDrillThrough) {
                result = ((MondrianDrillThrough)this.extension).drillThrough((Cell)cell.getRootDecoree(), this);
            } else if (this.extension instanceof XMLA_DrillThrough) {
                model = (XMLA_Model)((XMLA_DrillThrough)this.extension).getModel();
                if (model == null) {
                    return null;
                }
                resultBase = (ResultBase)model.getResult();
                if (resultBase == null) {
                    return null;
                }
                ((XMLA_DrillThrough)this.extension).setIncludeOnlySelectedMeasure(this.isIncludeOnlySelectedMeasure());
                result = this.extension.drillThrough((Cell)cell.getRootDecoree());
            }
        }
        catch (OlapException e) {
            throw new OlapException("failed to set drillThrough flags.");
        }
        return result;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void modelChanged(ModelChangeEvent e) {
    }

    public void structureChanged(ModelChangeEvent e) {
        this.initializeExtension();
        this.dispatcher.clear();
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public boolean isShowTableBelowCube() {
        return this.showTableBelowCube;
    }

    public boolean isHideDillThroughLinks() {
        return this.hideDillThroughLinks;
    }

    public boolean isIncludeOnlySelectedMeasure() {
        return this.includeOnlySelectedMeasure;
    }

    public void setShowTableBelowCube(boolean b) {
        try {
            if (this.table == null) {
                return;
            }
            OlapModel olapModel = this.table.getOlapModel();
            if (olapModel != null && olapModel instanceof OlapModelProxy) {
                OlapModel sessOlapModel;
                OlapModelController.OlapSessionState olapSessionState;
                HashMap olapModels;
                if (this.showTableBelowCube != b) {
                    this.table.getHttpSession().setAttribute("changemode", (Object)"true");
                }
                olapModel.setShowTableBelowCube(b);
                if (this.table.getHttpSession() != null && (olapModels = (HashMap)this.table.getHttpSession().getAttribute("olapModels")) != null && (olapSessionState = (OlapModelController.OlapSessionState)olapModels.get(olapModel.getID())) != null && (sessOlapModel = olapSessionState.getOlapModel()) != null) {
                    sessOlapModel.setShowTableBelowCube(b);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showTableBelowCube = b;
    }

    private void setCubeToBrowser(OlapModel olapModel, boolean b) {
        if (this.showTableBelowCube && !b || this.showTableBelowCube || b) {
            // empty if block
        }
    }

    public void setHideDillThroughLinks(boolean b) {
        this.hideDillThroughLinks = b;
    }

    public void setIncludeOnlySelectedMeasure(boolean b) {
        this.includeOnlySelectedMeasure = b;
    }

    public boolean getDrillThroughMode() throws OlapException {
        MdxOlapModel model = null;
        ResultBase resultBase = null;
        if (this.extension instanceof MondrianDrillThrough) {
            model = (MondrianModel)((MondrianDrillThrough)this.extension).getModel();
            if (model == null) {
                return false;
            }
            resultBase = (ResultBase)model.getResult();
        } else if (this.extension instanceof XMLA_DrillThrough) {
            model = (XMLA_Model)((XMLA_DrillThrough)this.extension).getModel();
            if (model == null) {
                return false;
            }
            resultBase = (ResultBase)((XMLA_Model)model).getResult();
        }
        if (resultBase == null) {
            return false;
        }
        this.drillThroughMode = resultBase.isDrillThroughMode();
        return this.drillThroughMode;
    }

    class DrillThroughHandler
    implements RequestListener {
        Cell cell;

        DrillThroughHandler(Cell cell) {
            this.cell = cell;
        }

        public void request(RequestContext context) throws Exception {
            Scroller.enableScroller((RequestContext)context);
            if (DrillThroughUI.this.canDrillThrough(this.cell)) {
                HttpSession session = context.getSession();
                String drillTableRef = DrillThroughUI.this.table.getOlapModel().getID() + ".drillthroughtable";
                ITableComponent tc = (ITableComponent)session.getAttribute(drillTableRef);
                Locale locale = (Locale)session.getAttribute("locale");
                if (this.cell instanceof MondrianCell) {
                    MondrianCell monCell = (MondrianCell)this.cell;
                    monCell.getModel().setLocale(locale);
                } else if (this.cell instanceof XMLA_Cell) {
                    // empty if block
                }
                TableModel tm = DrillThroughUI.this.drillThrough(this.cell);
                if (tm == null) {
                    return;
                }
                ((MondrianDrillThroughTableModel)tm).setTitle(this.cell, DrillThroughUI.this.isIncludeOnlySelectedMeasure());
                session.setAttribute("inDrillThrough", (Object)"true");
                tc.setModel(tm);
                tc.setVisible(true);
                TableColumn[] tableColumns = ((EditableTableComponent)tc).getTableComp().getTableColumns();
                for (int i = 0; i < tableColumns.length; ++i) {
                    TableColumn tableColumn = tableColumns[i];
                    tableColumn.setHidden(false);
                }
            }
        }
    }

    class DomDecorator
    extends CellBuilderDecorator {
        DrillThroughUI dt;

        DomDecorator(CellBuilder delegate, DrillThroughUI dt) {
            super(delegate);
            this.dt = dt;
        }

        public Element build(Cell cell, boolean even) {
            Element elem;
            Element parent = super.build(cell, even);
            if (!DrillThroughUI.this.enabled || !DrillThroughUI.this.renderActions || DrillThroughUI.this.extension == null) {
                return parent;
            }
            String id = DomUtils.randomId();
            String hideLinks = "";
            if (DrillThroughUI.this.canDrillThrough(cell) && !cell.isNull()) {
                elem = this.table.insert("drill-through", parent);
                elem.setAttribute("id", id);
                elem.setAttribute("title", DrillThroughUI.this.resources.getString("jsp.jpivot.showSourceData"));
                elem.setAttribute("value", cell.getFormattedValue());
                if (DrillThroughUI.this.isHideDillThroughLinks()) {
                    hideLinks = "true";
                }
                elem.setAttribute("hideLinks", hideLinks);
                String useBrowser = "";
                if (!DrillThroughUI.this.isShowTableBelowCube()) {
                    useBrowser = "true";
                }
                elem.setAttribute("useBrowser", useBrowser);
            } else {
                elem = this.table.insert("drill-through", parent);
                elem.setAttribute("value", cell.getFormattedValue());
                hideLinks = "true";
                String useBrowser = "";
                if (!DrillThroughUI.this.isShowTableBelowCube()) {
                    useBrowser = "true";
                }
                elem.setAttribute("useBrowser", useBrowser);
            }
            try {
                if (this.table != null && this.table.getOlapModel() != null && this.table.getOlapModel() instanceof MondrianModel) {
                    this.table.getOlapModel().setShowTableBelowCube(DrillThroughUI.this.isShowTableBelowCube());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DrillThroughUI.this.dispatcher.addRequestListener(id, null, (RequestListener)new DrillThroughHandler(cell));
            return parent;
        }
    }
}

