/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_Position;
import com.tonbeller.jpivot.xmla.XMLA_Result;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.table.AbstractTableModel;
import com.tonbeller.wcf.table.DefaultTableRow;
import com.tonbeller.wcf.table.TableRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class XMLA_DrillThroughTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger((Class)XMLA_DrillThroughTableModel.class);
    Resources resources = Resources.instance();
    private String title = this.resources.getString("jpivot.MondrianDrillThroughTableModel.label.drillThroughTable");
    private String caption = "";
    private String dataSourceName;
    private int cellOrdinal;
    private Locale locale = Locale.getDefault();
    XMLA_Model model;
    XMLA_Model drillModel;
    XMLA_Result drillResult;
    private boolean ready = false;
    private TableRow[] rows = new TableRow[0];
    private String[] columnTitles = new String[0];

    public int getCellOrdinal() {
        return this.cellOrdinal;
    }

    public void setCellOrdinal(int cellOrdinal) {
        this.cellOrdinal = cellOrdinal;
    }

    public XMLA_Model getModel() {
        return this.model;
    }

    public void setModel(XMLA_Model model) {
        this.model = model;
    }

    public int getRowCount() {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.rows.length;
    }

    public TableRow getRow(int rowIndex) {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.rows[rowIndex];
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getColumnCount() {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.columnTitles.length;
    }

    public String getColumnTitle(int columnIndex) {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.columnTitles[columnIndex];
    }

    private String buildDrillThroughMdx(XMLA_Result res) {
        Axis[] axes = res.getAxes();
        StringBuffer mdxBuf = new StringBuffer(" Drillthrough Select ");
        int nXPositions = axes[0].getPositions().size();
        int posIdx = 0;
        for (int i = 0; i < axes.length; ++i) {
            posIdx = i == 0 ? this.cellOrdinal - this.cellOrdinal / nXPositions * nXPositions : this.cellOrdinal / nXPositions;
            XMLA_Position position = (XMLA_Position)axes[i].getPositions().get(posIdx);
            Member[] positionMembers = position.getMembers();
            if (i == 1) {
                mdxBuf.append(",");
            }
            mdxBuf.append("{(");
            for (int j = 0; j < positionMembers.length; ++j) {
                XMLA_Member member = (XMLA_Member)positionMembers[j];
                if (j > 0) {
                    mdxBuf.append(",");
                }
                mdxBuf.append(member.getUniqueName());
            }
            mdxBuf.append(")}");
            if (i == 0) {
                mdxBuf.append(" on Columns");
                continue;
            }
            mdxBuf.append(" on Rows");
        }
        mdxBuf.append(" from [" + this.model.getCube() + "]");
        Axis slicer = res.getSlicer();
        List slicerList = slicer.getPositions();
        XMLA_Position slicerPosition = (XMLA_Position)slicerList.get(0);
        Member[] slicerMembers = slicerPosition.getMembers();
        for (int j = 0; j < slicerMembers.length; ++j) {
            XMLA_Member member = (XMLA_Member)slicerMembers[j];
            if (j == 0) {
                mdxBuf.append(" Where ( ");
            } else if (j > 0) {
                mdxBuf.append(" , ");
            }
            mdxBuf.append(member.getUniqueName());
        }
        if (slicerMembers.length > 0) {
            mdxBuf.append(")");
        }
        return mdxBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery() {
        XMLA_Result res = null;
        try {
            res = (XMLA_Result)this.model.getResult();
            String mdx = this.buildDrillThroughMdx(res);
            if (this.drillModel == null) {
                this.drillModel = new XMLA_Model();
                this.drillModel.setCatalog(this.model.getCatalog());
                this.drillModel.setDataSource(this.model.getDataSource());
                this.drillModel.setMdxQuery(mdx);
                this.drillModel.setID("Drill" + this.model.getID());
                this.drillModel.setUri(this.model.getUri());
                this.drillModel.setUser(this.model.getUser());
                this.drillModel.setPassword(this.model.getPassword());
                this.drillModel.initialize();
            }
            this.drillResult = (XMLA_Result)this.drillModel.getDrillResult();
            Map headerMap = this.drillResult.getDrillHeader();
            int numCols = headerMap.size();
            this.columnTitles = new String[numCols];
            Set headerSet = headerMap.entrySet();
            Iterator headerSetIt = headerSet.iterator();
            while (headerSetIt.hasNext()) {
                Map.Entry e = headerSetIt.next();
                this.columnTitles[((Integer)e.getValue()).intValue()] = e.getKey().toString();
            }
            List dataRows = this.drillResult.getDrillRows();
            ArrayList<DefaultTableRow> tempRows = new ArrayList<DefaultTableRow>();
            Iterator dataRowIt = dataRows.iterator();
            while (dataRowIt.hasNext()) {
                Object[] row = new Object[numCols];
                HashMap columnMap = (HashMap)dataRowIt.next();
                Set columnSet = columnMap.entrySet();
                Iterator colSetIt = columnSet.iterator();
                while (colSetIt.hasNext()) {
                    Map.Entry e = colSetIt.next();
                    String value = e.getValue().toString();
                    String colName = e.getKey().toString();
                    int colNo = (Integer)headerMap.get(colName);
                    row[colNo] = value;
                }
                tempRows.add(new DefaultTableRow(row));
            }
            this.rows = tempRows.toArray(new TableRow[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"?", (Throwable)e);
            this.rows = new TableRow[1];
            this.columnTitles = new String[1];
            this.columnTitles[0] = "An error occured";
            Object[] row = new Object[]{e.toString()};
            this.rows[0] = new DefaultTableRow(row);
            this.ready = false;
            return;
        }
        this.ready = true;
    }

    public String getCaption() {
        return Resources.instance().getOptionalString(this.caption, this.caption);
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

