/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.mdxparse.CompoundId;
import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.ExpVisitor;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.query.MDXMember;
import com.tonbeller.jpivot.util.StringUtil;
import com.tonbeller.jpivot.xmla.XMLA_Dimension;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class XMLA_Member
implements Member,
MDXMember,
Exp {
    static Logger logger = Logger.getLogger((Class)XMLA_Member.class);
    private XMLA_Model model;
    private long ordinal;
    private String name;
    private int type;
    private String caption;
    private long childrenCardinality = -1L;
    private long parentLevel;
    private String uniqueName;
    private String parentUniqueName = null;
    private String key;
    private boolean isPlaceHolderMember;
    private boolean isDataMember;
    private long displayInfo = -1L;
    private String dimUName = null;
    private XMLA_Level level;
    private XMLA_Member parent = null;
    private ArrayList aChildren = null;
    private List properties = new ArrayList();
    private boolean isCalculated;
    private boolean complete = false;
    private boolean propsOk = false;
    private boolean childrenOk = false;
    private boolean parentOk = false;
    private boolean drilling;
    private boolean zooming;

    public XMLA_Member(XMLA_Model model, String uName, String caption, XMLA_Level lev, boolean isCalculated) {
        if (model.lookupMemberByUName(uName) != null) {
            logger.fatal((Object)("cannot create member doubly " + uName));
            throw new IllegalArgumentException("cannot create member doubly " + uName);
        }
        this.model = model;
        this.uniqueName = uName;
        this.caption = caption;
        this.level = lev;
        this.isCalculated = isCalculated;
        logger.debug((Object)("<init>: uName - " + uName + ", level - " + lev + ", isCalculated - " + isCalculated));
        model.addMember(this);
        if (model.isMicrosoft() || isCalculated) {
            this.parentUniqueName = StringUtil.parentFromUName(uName);
            if (this.parentUniqueName == null) {
                this.parent = null;
                this.parentOk = true;
                logger.debug((Object)("parentUniqueName from uName: " + uName + " == null"));
            } else {
                this.parent = (XMLA_Member)model.lookupMemberByUName(this.parentUniqueName);
                logger.debug((Object)("lookupMemberByUName(" + this.parentUniqueName + "): " + this.parent));
                if (this.parent != null) {
                    this.parentOk = true;
                }
            }
        }
        if (this.level == null && isCalculated) {
            String dimUname = StringUtil.dimFromUName(this.uniqueName);
            XMLA_Dimension dim = model.lookupDimByUName(dimUname);
            logger.debug((Object)("looked up dimension name: " + this.uniqueName + " = " + dim));
            if (dim != null) {
                if (dim.isMeasure()) {
                    Hierarchy[] hiers = dim.getHierarchies();
                    Level[] levs = hiers[0].getLevels();
                    this.level = (XMLA_Level)levs[0];
                    logger.debug((Object)("isMeasure: " + this.level));
                } else {
                    XMLA_Member pm = null;
                    if (model.isMicrosoft() && this.parentUniqueName != null) {
                        pm = (XMLA_Member)model.lookupMemberByUName(this.parentUniqueName);
                        if (pm != null) {
                            this.level = ((XMLA_Level)pm.getLevel()).getChildLevel();
                        }
                        logger.debug((Object)("normal dimension: " + this.level));
                    }
                    if (this.level == null) {
                        Hierarchy hier = null;
                        if (pm != null) {
                            hier = pm.getHierarchy();
                            logger.debug((Object)("hierarchy from member: " + hier));
                        } else {
                            String hierUname = dim.getDefaultHier();
                            hier = model.lookupHierByUName(hierUname);
                            logger.debug((Object)("hierarchy from DefaultHier: " + hier));
                        }
                        if (hier != null) {
                            logger.debug((Object)("trying default hierarchy: " + hier));
                            Level[] levs = hier.getLevels();
                            for (int i = 0; i < levs.length; ++i) {
                                if (((XMLA_Level)levs[i]).getDepth() != 0) continue;
                                this.level = (XMLA_Level)levs[i];
                                break;
                            }
                        }
                    }
                }
            }
        }
        if (this.level == null) {
            throw new IllegalArgumentException("Member " + uName + " Level=null");
        }
        if (this.level.getChildLevel() == null || isCalculated) {
            this.childrenCardinality = 0L;
            this.childrenOk = true;
        }
    }

    public boolean isEqual(Member otherM) {
        XMLA_Member other = (XMLA_Member)otherM;
        return this.uniqueName.equals(other.uniqueName);
    }

    public boolean isChildOf(Member otherM) throws OlapException {
        XMLA_Hierarchy otherHier;
        XMLA_Member other = (XMLA_Member)otherM;
        XMLA_Hierarchy thisHier = (XMLA_Hierarchy)this.level.getHierarchy();
        if (!thisHier.isEqual(otherHier = (XMLA_Hierarchy)other.getLevel().getHierarchy())) {
            return false;
        }
        long otherLevelNumber = ((XMLA_Level)other.getLevel()).getDepth();
        if ((long)this.level.getDepth() <= otherLevelNumber) {
            return false;
        }
        XMLA_Member m = this;
        while ((long)m.level.getDepth() > otherLevelNumber) {
            m = (XMLA_Member)m.getParent();
        }
        return m.isEqual(other);
    }

    public void accept(Visitor visitor) {
        visitor.visitMember(this);
    }

    public Object getRootDecoree() {
        return this;
    }

    public String getLabel() {
        return this.getCaption();
    }

    public String getCaption() {
        return Resources.instance().getOptionalString(this.caption, this.caption);
    }

    public long getChildrenCardinality() {
        return this.childrenCardinality;
    }

    public boolean isDataMember() {
        return this.isDataMember;
    }

    public boolean isPlaceHolderMember() {
        return this.isPlaceHolderMember;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    public long getParentLevel() {
        return this.parentLevel;
    }

    public int getType() {
        return this.type;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void complete(String name, int type, long ordinal, String parentUniqueName, long childrenCardinality, long parentLevel, boolean isDataMember, boolean isPlaceHolderMember, String key) {
        this.childrenCardinality = childrenCardinality;
        this.isDataMember = isDataMember;
        this.isPlaceHolderMember = isPlaceHolderMember;
        this.key = key;
        this.name = name;
        this.ordinal = ordinal;
        this.parentLevel = parentLevel;
        this.type = type;
        this.parentUniqueName = parentUniqueName;
        this.complete = true;
    }

    public String getParentUniqueName() {
        return this.parentUniqueName;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(XMLA_Level level) {
        this.level = level;
    }

    public Property[] getProperties() {
        if (this.isCalculated || this.properties.size() == 0) {
            return new Property[0];
        }
        return this.properties.toArray(new Property[0]);
    }

    public Property getProperty(String name) {
        if (this.isCalculated || this.properties.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            Property prop = (Property)this.properties.get(i);
            if (!name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public int getRootDistance() {
        if (this.level == null && this.isCalculated) {
            return 0;
        }
        return this.level.getDepth();
    }

    public int getDepth() {
        if (this.level == null && this.isCalculated) {
            return 0;
        }
        return this.level.getDepth();
    }

    public XMLA_Member[] getChildren() throws OlapException {
        if (this.childrenOk) {
            if (this.childrenCardinality == 0L) {
                return new XMLA_Member[0];
            }
            return this.aChildren.toArray(new XMLA_Member[0]);
        }
        this.model.retrieveMemberChildren(this);
        return this.aChildren.toArray(new XMLA_Member[0]);
    }

    public void setChildren(ArrayList aChildren) {
        this.aChildren = aChildren;
        this.childrenCardinality = aChildren == null ? 0L : (long)aChildren.size();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Member getParent() throws OlapException {
        if (this.parentOk) {
            return this.parent;
        }
        if (this.model.isMicrosoft() || this.isCalculated) {
            this.parentUniqueName = StringUtil.parentFromUName(this.uniqueName);
            if (this.parentUniqueName == null) {
                this.parent = null;
                this.parentOk = true;
                return this.parent;
            }
            this.parent = (XMLA_Member)this.model.lookupMemberByUName(this.parentUniqueName);
            if (this.parent != null) {
                this.parentOk = true;
                return this.parent;
            }
        }
        this.model.retrieveMemberParent(this);
        return this.parent;
    }

    public Dimension getDimension() {
        if (this.level != null) {
            return this.level.getHierarchy().getDimension();
        }
        XMLA_Dimension dim = this.model.lookupDimByUName(this.dimUName);
        return dim;
    }

    public void setParent(XMLA_Member parent) {
        this.parent = parent;
        this.parentOk = true;
    }

    public Hierarchy getHierarchy() {
        if (this.level != null) {
            return this.level.getHierarchy();
        }
        XMLA_Dimension dim = (XMLA_Dimension)this.getDimension();
        String defHier = dim.getDefaultHier();
        if (defHier != null && defHier.length() > 0) {
            return this.model.lookupHierByUName(defHier);
        }
        return null;
    }

    public boolean isCalculated() {
        return this.isCalculated;
    }

    public String toMdx() {
        return this.uniqueName;
    }

    public Object clone() {
        String[] nameParts = StringUtil.splitUniqueName(this.uniqueName);
        CompoundId clone = new CompoundId(nameParts[0], false);
        for (int i = 1; i < nameParts.length; ++i) {
            clone.append(nameParts[i], false);
        }
        return clone;
    }

    public void addProp(Property prop) {
        this.properties.add(prop);
    }

    public void clearProps() {
        this.properties.clear();
    }

    public boolean isPropsOk() {
        return this.propsOk;
    }

    public void setPropsOk(boolean b) {
        this.propsOk = b;
    }

    public boolean isChildrenOk() {
        return this.childrenOk;
    }

    public boolean isParentOk() {
        return this.parentOk;
    }

    public void setChildrenOk(boolean b) {
        this.childrenOk = b;
    }

    public void setParentOk(boolean b) {
        this.parentOk = b;
    }

    public boolean isSAP() {
        return this.model.isSAP();
    }

    public boolean isMicrosoft() {
        return this.model.isMicrosoft();
    }

    public boolean isMondrian() {
        return this.model.isMondrian();
    }

    public void accept(ExpVisitor visitor) {
        visitor.visitMember(this);
    }

    public long getDisplayInfo() {
        return this.displayInfo;
    }

    public void setDisplayInfo(String strDisplayInfo) {
        if (strDisplayInfo == null || this.displayInfo != -1L) {
            return;
        }
        this.displayInfo = Long.parseLong(strDisplayInfo);
        if (this.childrenCardinality == -1L) {
            this.childrenCardinality = Math.abs(this.displayInfo) % 65536L;
        }
    }

    public boolean isAll() {
        return ((XMLA_Level)this.getLevel()).isAll();
    }

    public boolean isDrilling() {
        return this.drilling;
    }

    public void setDrilling(boolean drilling) {
        this.drilling = drilling;
    }

    public boolean isZooming() {
        return this.zooming;
    }

    public void setZooming(boolean zooming) {
        this.zooming = zooming;
    }
}

