/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.resources;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.flexdock.logging.Log;
import org.flexdock.plaf.resources.ResourceHandler;

public class ConstructorHandler
extends ResourceHandler {
    private Constructor constructor;

    public ConstructorHandler(Constructor constructor) {
        this.constructor = constructor;
    }

    public Object getResource(String stringValue) {
        Object[] arguments = this.getArguments(stringValue);
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (Exception e) {
            Log.debug(e.getMessage(), e);
            return null;
        }
    }

    private Object[] getArguments(String data) {
        Class<?>[] paramTypes;
        String[] supplied = this.parseArguments(data);
        Object[] arguments = new Object[supplied.length];
        if (arguments.length != (paramTypes = this.constructor.getParameterTypes()).length) {
            throw new IllegalArgumentException("Cannot match '" + data + "' to constructor " + this.constructor + ".");
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            arguments[i] = this.toObject(supplied[i], paramTypes[i]);
        }
        return arguments;
    }

    private Object toObject(String data, Class type) {
        if (type == Integer.TYPE) {
            return new Integer(data);
        }
        if (type == Long.TYPE) {
            return new Long(data);
        }
        if (type == Boolean.TYPE) {
            return new Boolean(data);
        }
        if (type == Float.TYPE) {
            return new Float(data);
        }
        if (type == Double.TYPE) {
            return new Double(data);
        }
        if (type == Byte.TYPE) {
            return new Byte(data);
        }
        if (type == Short.TYPE) {
            return new Short(data);
        }
        return data;
    }

    private String[] parseArguments(String data) {
        if (!data.endsWith(",")) {
            data = data + ",";
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(data, ",");
        while (st.hasMoreTokens()) {
            args.add(st.nextToken().trim());
        }
        return args.toArray(new String[0]);
    }
}

