/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.chart;

import com.tonbeller.jpivot.chart.ChartFactory;
import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.navi.DrillThrough;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentSupport;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.table.ITableComponent;
import com.tonbeller.wcf.table.TableModel;
import com.tonbeller.wcf.utils.DomUtils;
import com.tonbeller.wcf.utils.XmlUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.ByteArrayInputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.OverLIBToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.ui.VerticalAlignment;
import org.jfree.util.Rotation;
import org.jfree.util.TableOrder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChartComponent
extends ComponentSupport
implements ModelChangeListener {
    private static Logger logger = Logger.getLogger((Class)ChartComponent.class);
    private Resources resources = Resources.instance((Class)ChartComponent.class);
    String ref;
    Document document;
    OlapModel olapModel;
    boolean dirty = true;
    Locale locale;
    Result result;
    Iterator cellIterator;
    int dimCount;
    Element rootElement;
    int colCount;
    String CHART_SERVLET = "/DisplayChart";
    final String CHART_SERVLET_KEY = "chartServlet";
    boolean baseDisplayURLSet = false;
    String webControllerURL = "";
    String filename = null;
    final int DEFAULT_CHART_WIDTH = 500;
    final int DEFAULT_CHART_HEIGHT = 300;
    String chartTitle = "";
    Font titleFont = JFreeChart.DEFAULT_TITLE_FONT;
    String fontName = this.getResources().getString("jsp.wcf.chart.sansserif");
    int fontStyle = 1;
    int fontSize = 18;
    String slicerFontName = this.getResources().getString("jsp.wcf.chart.sansserif");
    int slicerFontStyle = 0;
    int slicerFontSize = 12;
    String axisFontName = this.getResources().getString("jsp.wcf.chart.sansserif");
    int axisFontStyle = 0;
    int axisFontSize = 12;
    String axisTickFontName = this.getResources().getString("jsp.wcf.chart.sansserif");
    int axisTickFontStyle = 0;
    int axisTickFontSize = 12;
    String legendFontName = this.getResources().getString("jsp.wcf.chart.sansserif");
    int legendFontStyle = 0;
    int legendFontSize = 10;
    int legendPosition = 3;
    int slicerPosition = 1;
    int slicerAlignment = 3;
    int bgColorR = 255;
    int bgColorG = 255;
    int bgColorB = 255;
    int chartType = 1;
    int chartHeight = 300;
    int chartWidth = 500;
    String horizAxisLabel = "";
    String vertAxisLabel = "";
    boolean showLegend = true;
    boolean showSlicer = true;
    boolean showTooltips = true;
    boolean drillThroughEnabled = false;
    int tickLabelRotate = 30;
    ChartRenderingInfo info = null;
    Dispatcher dispatcher = new DispatcherSupport();

    public ChartComponent(String id, Component parent, String ref, String baseDisplayURL, String controllerURL, RequestContext context) {
        super(id, parent);
        this.ref = ref;
        this.olapModel = (OlapModel)context.getModelReference(ref);
        this.olapModel.addModelChangeListener(this);
        Resources.instance();
        Resources.instance();
        this.locale = Resources.instance().getLocaleContextHolderLocale();
        if (this.locale == null) {
            this.locale = context.getLocale();
        }
        this.getDispatcher().addRequestListener(null, null, (RequestListener)this.dispatcher);
        String chartServlet = baseDisplayURL;
        if (chartServlet == null) {
            chartServlet = context.getServletContext().getInitParameter("chartServlet");
        } else {
            this.baseDisplayURLSet = true;
        }
        if (chartServlet != null) {
            this.CHART_SERVLET = chartServlet;
        }
        if (controllerURL != null) {
            this.webControllerURL = controllerURL;
        }
    }

    public ChartComponent(String id, Component parent, String ref, RequestContext context) {
        this(id, parent, ref, null, null, context);
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
    }

    public Document render(RequestContext context) throws Exception {
        if (this.dirty) {
            this.dispatcher.clear();
            this.result = this.olapModel.getResult();
            this.cellIterator = this.result.getCells().iterator();
            this.dimCount = this.result.getAxes().length;
            DefaultCategoryDataset dataset = null;
            switch (this.dimCount) {
                case 1: {
                    logger.info((Object)this.getResources().getString("jpivot.ChartComponent.message.oneDD"));
                    dataset = this.build1dimDataset();
                    break;
                }
                case 2: {
                    logger.info((Object)this.getResources().getString("jpivot.ChartComponent.message.twoDD"));
                    dataset = this.build2dimDataset();
                    break;
                }
                default: {
                    logger.error((Object)this.getResources().getString("jpivot.ChartComponent.message.wrongDimensions"));
                    throw new IllegalArgumentException(this.getResources().getString("jpivot.ChartComponent.error.wrongDimensions"));
                }
            }
            this.dirty = false;
            this.titleFont = new Font(this.fontName, this.fontStyle, this.fontSize);
            jpivotCategoryURLGenerator urlGenerator = new jpivotCategoryURLGenerator(this.webControllerURL);
            JFreeChart chart = null;
            switch (this.chartType) {
                case 1: {
                    chart = ChartFactory.createBarChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.VERTICAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 2: {
                    chart = ChartFactory.createBarChart3D(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.VERTICAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 3: {
                    chart = ChartFactory.createBarChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.HORIZONTAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 4: {
                    chart = ChartFactory.createBarChart3D(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.HORIZONTAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 5: {
                    chart = ChartFactory.createStackedBarChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.VERTICAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 6: {
                    chart = ChartFactory.createStackedBarChart3D(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.VERTICAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 7: {
                    chart = ChartFactory.createStackedBarChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.HORIZONTAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 8: {
                    chart = ChartFactory.createStackedBarChart3D(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.HORIZONTAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 9: {
                    chart = ChartFactory.createLineChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.VERTICAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 10: {
                    chart = ChartFactory.createLineChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.HORIZONTAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 11: {
                    chart = ChartFactory.createAreaChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.VERTICAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 12: {
                    chart = ChartFactory.createAreaChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.HORIZONTAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 13: {
                    chart = ChartFactory.createStackedAreaChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.VERTICAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 14: {
                    chart = ChartFactory.createStackedAreaChart(this.chartTitle, this.titleFont, this.horizAxisLabel, this.vertAxisLabel, (CategoryDataset)dataset, PlotOrientation.HORIZONTAL, this.showLegend, this.showTooltips, this.drillThroughEnabled, (CategoryURLGenerator)urlGenerator);
                    break;
                }
                case 15: {
                    chart = ChartFactory.createPieChart(this.chartTitle, this.titleFont, (CategoryDataset)dataset, TableOrder.BY_COLUMN, this.showLegend, this.showTooltips, this.drillThroughEnabled, (PieURLGenerator)new jpivotPieURLGenerator(TableOrder.BY_COLUMN, dataset, this.webControllerURL));
                    break;
                }
                case 16: {
                    chart = ChartFactory.createPieChart(this.chartTitle, this.titleFont, (CategoryDataset)dataset, TableOrder.BY_ROW, this.showLegend, this.showTooltips, this.drillThroughEnabled, (PieURLGenerator)new jpivotPieURLGenerator(TableOrder.BY_ROW, dataset, this.webControllerURL));
                    break;
                }
                case 17: {
                    chart = ChartFactory.create3DPieChart(this.chartTitle, this.titleFont, (CategoryDataset)dataset, TableOrder.BY_COLUMN, this.showLegend, this.showTooltips, this.drillThroughEnabled, (PieURLGenerator)new jpivotPieURLGenerator(TableOrder.BY_COLUMN, dataset, this.webControllerURL));
                    break;
                }
                case 18: {
                    chart = ChartFactory.create3DPieChart(this.chartTitle, this.titleFont, (CategoryDataset)dataset, TableOrder.BY_ROW, this.showLegend, this.showTooltips, this.drillThroughEnabled, (PieURLGenerator)new jpivotPieURLGenerator(TableOrder.BY_ROW, dataset, this.webControllerURL));
                    break;
                }
                default: {
                    throw new Exception(this.getResources().getString("jpivot.ChartComponent.error.unknownChartType"));
                }
            }
            try {
                PiePlot3D piePlot;
                chart.setBackgroundPaint((Paint)new Color(this.bgColorR, this.bgColorG, this.bgColorB));
                Font slicerFont = new Font(this.slicerFontName, this.slicerFontStyle, this.slicerFontSize);
                Font axisFont = new Font(this.axisFontName, this.axisFontStyle, this.axisFontSize);
                Font axisTickFont = new Font(this.axisTickFontName, this.axisTickFontStyle, this.axisTickFontSize);
                Font legendFont = new Font(this.legendFontName, this.legendFontStyle, this.legendFontSize);
                Plot plot = chart.getPlot();
                if (plot instanceof CategoryPlot) {
                    CategoryPlot catPlot = (CategoryPlot)plot;
                    catPlot.getDomainAxis().setLabelFont(axisFont);
                    catPlot.getRangeAxis().setLabelFont(axisFont);
                    catPlot.getDomainAxis().setTickLabelFont(axisTickFont);
                    catPlot.getRangeAxis().setTickLabelFont(axisTickFont);
                    catPlot.getDomainAxis().setMaximumCategoryLabelWidthRatio(100.0f);
                    double angle = -Math.PI / 180 * (double)this.tickLabelRotate;
                    CategoryLabelPositions oldp = catPlot.getDomainAxis().getCategoryLabelPositions();
                    CategoryLabelPositions newp = new CategoryLabelPositions(oldp.getLabelPosition(RectangleEdge.TOP), new CategoryLabelPosition(RectangleAnchor.TOP, TextBlockAnchor.TOP_RIGHT, TextAnchor.TOP_RIGHT, angle, CategoryLabelWidthType.RANGE, 0.0f), oldp.getLabelPosition(RectangleEdge.LEFT), oldp.getLabelPosition(RectangleEdge.RIGHT));
                    catPlot.getDomainAxis().setCategoryLabelPositions(newp);
                } else if (plot instanceof PiePlot3D) {
                    piePlot = (PiePlot3D)plot;
                    piePlot.setLabelFont(axisFont);
                    piePlot.setDirection(Rotation.CLOCKWISE);
                    piePlot.setForegroundAlpha(0.5f);
                    piePlot.setNoDataMessage(this.getResources().getString("jpivot.ChartComponent.error.noData"));
                } else if (plot instanceof PiePlot) {
                    piePlot = (PiePlot)plot;
                    piePlot.setLabelFont(axisFont);
                }
                LegendTitle legend = chart.getLegend();
                if (legend != null) {
                    legend.setItemFont(legendFont);
                    RectangleEdge legendRectEdge = RectangleEdge.BOTTOM;
                    switch (this.legendPosition) {
                        case 0: {
                            legendRectEdge = RectangleEdge.LEFT;
                            break;
                        }
                        case 1: {
                            legendRectEdge = RectangleEdge.TOP;
                            break;
                        }
                        case 2: {
                            legendRectEdge = RectangleEdge.RIGHT;
                            break;
                        }
                        case 3: {
                            legendRectEdge = RectangleEdge.BOTTOM;
                        }
                    }
                    legend.setPosition(legendRectEdge);
                }
                if (this.showSlicer) {
                    RectangleEdge slicerRectPos = RectangleEdge.BOTTOM;
                    HorizontalAlignment slicerHorizAlignment = HorizontalAlignment.LEFT;
                    switch (this.slicerPosition) {
                        case 0: {
                            slicerRectPos = RectangleEdge.TOP;
                            break;
                        }
                        case 1: {
                            slicerRectPos = RectangleEdge.BOTTOM;
                            break;
                        }
                        case 2: {
                            slicerRectPos = RectangleEdge.RIGHT;
                            break;
                        }
                        case 3: {
                            slicerRectPos = RectangleEdge.LEFT;
                        }
                    }
                    switch (this.slicerAlignment) {
                        case 4: {
                            slicerHorizAlignment = HorizontalAlignment.CENTER;
                            break;
                        }
                        case 3: {
                            slicerHorizAlignment = HorizontalAlignment.LEFT;
                            break;
                        }
                        case 2: {
                            slicerHorizAlignment = HorizontalAlignment.RIGHT;
                        }
                    }
                    TextTitle slicer = new TextTitle(this.buildSlicer(), slicerFont, (Paint)Color.BLACK, slicerRectPos, slicerHorizAlignment, VerticalAlignment.CENTER, new RectangleInsets(0.0, 0.0, 0.0, 0.0));
                    slicer.setPosition(slicerRectPos);
                    chart.addSubtitle((Title)slicer);
                }
                this.info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                HttpSession session = context.getSession();
                this.filename = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)this.chartWidth, (int)this.chartHeight, (ChartRenderingInfo)this.info, (HttpSession)session);
            }
            catch (Exception e) {
                this.filename = this.getResources().getString("jpivot.ChartComponent.label.filename");
                this.dirty = true;
            }
        }
        DocumentBuilder parser2 = XmlUtils.getParser();
        String xchart = "<xchart>" + this.writeImageMap(this.filename, this.info, false) + "</xchart>";
        logger.debug((Object)this.resources.getString("jpivot.ChartComponent.message.encoding", new Object[]{this.getResources().getCharacterEncoding()}));
        ByteArrayInputStream stream = new ByteArrayInputStream(xchart.getBytes(this.getResources().getCharacterEncoding()));
        this.document = parser2.parse(stream);
        Element root = this.document.getDocumentElement();
        String graphURL = this.getGraphURL(context);
        Element img = this.document.createElement("img");
        img.setAttribute("src", graphURL);
        img.setAttribute("width", new Integer(this.chartWidth).toString());
        img.setAttribute("height", new Integer(this.chartHeight).toString());
        img.setAttribute("style", "border:0;");
        img.setAttribute("usemap", "#" + this.filename);
        root.appendChild(img);
        return this.document;
    }

    public String getGraphURL(RequestContext context) {
        String graphURL = "";
        graphURL = this.baseDisplayURLSet ? this.CHART_SERVLET : context.getRequest().getContextPath() + this.CHART_SERVLET;
        graphURL = graphURL + (graphURL.indexOf(63) >= 0 ? "&" : "?") + "filename=" + this.getFilename();
        return graphURL;
    }

    public String writeImageMap(String name, ChartRenderingInfo info, boolean useOverLibForToolTips) {
        StringBuffer sb = new StringBuffer();
        sb.append("<map name=\"" + name + "\">");
        EntityCollection entities = info.getEntityCollection();
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            ChartEntity entity = (ChartEntity)iterator.next();
            String area = "";
            area = useOverLibForToolTips ? entity.getImageMapAreaTag((ToolTipTagFragmentGenerator)new OverLIBToolTipTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator()) : entity.getImageMapAreaTag((ToolTipTagFragmentGenerator)new StandardToolTipTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator());
            if ((area = area.replaceAll("&", "&amp;")).length() <= 0) continue;
            sb.append(area);
        }
        sb.append("</map>");
        return sb.toString();
    }

    private String buildSlicer() {
        StringBuffer slicer = new StringBuffer();
        slicer.append(this.getResources().getString("jpivot.ChartComponent.label.slicer") + " ");
        Iterator pi = this.result.getSlicer().getPositions().iterator();
        while (pi.hasNext()) {
            Position p = (Position)pi.next();
            Member[] members = p.getMembers();
            for (int i = 0; i < members.length; ++i) {
                slicer.append(members[i].getLevel().getLabel());
                slicer.append("=");
                slicer.append(members[i].getLabel());
                if (i >= members.length - 1) continue;
                slicer.append(", ");
            }
        }
        return slicer.toString();
    }

    private DefaultCategoryDataset build1dimDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        List columnPositions = this.result.getAxes()[0].getPositions();
        this.colCount = columnPositions.size();
        List cells = this.result.getCells();
        String series = this.getResources().getString("jpivot.ChartComponent.label.series");
        for (int i = 0; i < this.colCount; ++i) {
            Member[] colMembers = ((Position)columnPositions.get(i)).getMembers();
            StringBuffer key = new StringBuffer();
            for (int j = 0; j < colMembers.length; ++j) {
                key.append(colMembers[j].getLabel() + ".");
            }
            dataset.addValue(this.getNumberValue((Cell)cells.get(i)), (Comparable)((Object)series), (Comparable)((Object)key.toString()));
        }
        return dataset;
    }

    private Number getNumberValue(Cell cell) {
        Object value = cell.getValue();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.locale);
        DecimalFormat formatter = new DecimalFormat();
        formatter.setDecimalFormatSymbols(dfs);
        Number number = null;
        try {
            number = (Number)value;
        }
        catch (Exception e) {
            number = null;
        }
        return number;
    }

    private String buildName(MemberTree myTree, Member[] members) {
        String retValue = new String();
        HashMap<String, Level> levelMap = new HashMap<String, Level>();
        HashMap<String, Hierarchy> hierarchyMap = new HashMap<String, Hierarchy>();
        for (int j = members.length - 1; j >= 0; --j) {
            Member member = members[j];
            while (member != null) {
                if (!levelMap.containsValue(member.getLevel())) {
                    levelMap.put(member.getLevel().toString(), member.getLevel());
                    if (member.getRootDistance() == 0) {
                        if (!hierarchyMap.containsValue(member.getLevel().getHierarchy()) || myTree.getRootMembers(member.getLevel().getHierarchy()).length > 1) {
                            hierarchyMap.put(member.getLevel().getHierarchy().toString(), member.getLevel().getHierarchy());
                            retValue = member.getLabel() + "." + retValue;
                        }
                    } else {
                        hierarchyMap.put(member.getLevel().getHierarchy().toString(), member.getLevel().getHierarchy());
                        retValue = member.getLabel() + "." + retValue;
                    }
                }
                member = myTree.getParent(member);
            }
        }
        return retValue;
    }

    private DefaultCategoryDataset build2dimDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        List columnPositions = this.result.getAxes()[0].getPositions();
        int colCount = columnPositions.size();
        List rowPositions = this.result.getAxes()[1].getPositions();
        int rowCount = rowPositions.size();
        List cells = this.result.getCells();
        MemberTree myTree = (MemberTree)this.olapModel.getExtension("memberTree");
        for (int i = 0; i < colCount; ++i) {
            Position p = (Position)columnPositions.get(i);
            Member[] colMembers = p.getMembers();
            String label = this.buildName(myTree, colMembers);
            for (int k = 0; k < rowCount; ++k) {
                Position rp = (Position)rowPositions.get(k);
                Member[] rowMembers = rp.getMembers();
                String key = this.buildName(myTree, rowMembers);
                Cell cell = (Cell)cells.get(k * colCount + i);
                dataset.addValue(this.getNumberValue(cell), (Comparable)((Object)label.toString()), (Comparable)((Object)key.toString()));
            }
        }
        return dataset;
    }

    public int getColCount() {
        return this.colCount;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void modelChanged(ModelChangeEvent e) {
        this.dirty = true;
    }

    public void structureChanged(ModelChangeEvent e) {
        this.dirty = true;
    }

    public int getChartHeight() {
        return this.chartHeight;
    }

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
        this.dirty = true;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
        this.dirty = true;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
        this.dirty = true;
    }

    public int getChartWidth() {
        return this.chartWidth;
    }

    public void setChartWidth(int chartWidth) {
        this.chartWidth = chartWidth;
        this.dirty = true;
    }

    public String getHorizAxisLabel() {
        return this.horizAxisLabel;
    }

    public void setHorizAxisLabel(String axisLabel) {
        this.horizAxisLabel = axisLabel;
        this.dirty = true;
    }

    public boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
        this.dirty = true;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontname) {
        this.fontName = fontname;
        this.dirty = true;
    }

    public String getVertAxisLabel() {
        return this.vertAxisLabel;
    }

    public void setVertAxisLabel(String axisLabel) {
        this.vertAxisLabel = axisLabel;
        this.dirty = true;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.dirty = true;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
        this.dirty = true;
    }

    public int getBgColorB() {
        return this.bgColorB;
    }

    public void setBgColorB(int bgColorB) {
        this.bgColorB = this.checkRGB(bgColorB);
        this.dirty = true;
    }

    public int getBgColorG() {
        return this.bgColorG;
    }

    public void setBgColorG(int bgColorG) {
        this.bgColorG = this.checkRGB(bgColorG);
        this.dirty = true;
    }

    public int getBgColorR() {
        return this.bgColorR;
    }

    public void setBgColorR(int bgColorR) {
        this.bgColorR = this.checkRGB(bgColorR);
        this.dirty = true;
    }

    private int checkRGB(int v) {
        if (v > 255) {
            v = 255;
        } else if (v < 0) {
            v = 0;
        }
        return v;
    }

    protected boolean canDrillThrough(Cell cell) {
        return ((DrillThrough)this.olapModel.getExtension("drillThrough")).canDrillThrough((Cell)cell.getRootDecoree());
    }

    protected TableModel drillThrough(Cell cell) {
        return ((DrillThrough)this.olapModel.getExtension("drillThrough")).drillThrough((Cell)cell.getRootDecoree());
    }

    public boolean isDrillThroughEnabled() {
        return this.drillThroughEnabled;
    }

    public void setDrillThroughEnabled(boolean drillThroughEnabled) {
        this.drillThroughEnabled = drillThroughEnabled;
    }

    public String getAxisFontName() {
        return this.axisFontName;
    }

    public void setAxisFontName(String axisFontName) {
        this.axisFontName = axisFontName;
    }

    public int getAxisFontSize() {
        return this.axisFontSize;
    }

    public void setAxisFontSize(int axisFontSize) {
        this.axisFontSize = axisFontSize;
    }

    public int getAxisFontStyle() {
        return this.axisFontStyle;
    }

    public void setAxisFontStyle(int axisFontStyle) {
        this.axisFontStyle = axisFontStyle;
    }

    public String getLegendFontName() {
        return this.legendFontName;
    }

    public void setLegendFontName(String legendFontName) {
        this.legendFontName = legendFontName;
    }

    public int getLegendFontSize() {
        return this.legendFontSize;
    }

    public void setLegendFontSize(int legendFontSize) {
        this.legendFontSize = legendFontSize;
    }

    public int getLegendFontStyle() {
        return this.legendFontStyle;
    }

    public void setLegendFontStyle(int legendFontStyle) {
        this.legendFontStyle = legendFontStyle;
    }

    public int getSlicerAlignment() {
        return this.slicerAlignment;
    }

    public void setSlicerAlignment(int slicerAlignment) {
        this.slicerAlignment = slicerAlignment;
    }

    public String getSlicerFontName() {
        return this.slicerFontName;
    }

    public void setSlicerFontName(String slicerFontName) {
        this.slicerFontName = slicerFontName;
    }

    public int getSlicerFontSize() {
        return this.slicerFontSize;
    }

    public void setSlicerFontSize(int slicerFontSize) {
        this.slicerFontSize = slicerFontSize;
    }

    public int getSlicerFontStyle() {
        return this.slicerFontStyle;
    }

    public void setSlicerFontStyle(int slicerFontStyle) {
        this.slicerFontStyle = slicerFontStyle;
    }

    public int getSlicerPosition() {
        return this.slicerPosition;
    }

    public void setSlicerPosition(int slicerPosition) {
        this.slicerPosition = slicerPosition;
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(int legendPosition) {
        this.legendPosition = legendPosition;
    }

    public String getAxisTickFontName() {
        return this.axisTickFontName;
    }

    public void setAxisTickFontName(String axisTickFontName) {
        this.axisTickFontName = axisTickFontName;
    }

    public int getAxisTickFontSize() {
        return this.axisTickFontSize;
    }

    public void setAxisTickFontSize(int axisTickFontSize) {
        this.axisTickFontSize = axisTickFontSize;
    }

    public int getAxisTickFontStyle() {
        return this.axisTickFontStyle;
    }

    public void setAxisTickFontStyle(int axisTickFontStyle) {
        this.axisTickFontStyle = axisTickFontStyle;
    }

    public int getTickLabelRotate() {
        return this.tickLabelRotate;
    }

    public void setTickLabelRotate(int tickLabelRotate) {
        this.tickLabelRotate = tickLabelRotate;
    }

    public boolean isShowSlicer() {
        return this.showSlicer;
    }

    public void setShowSlicer(boolean showSlicer) {
        this.showSlicer = showSlicer;
    }

    public String getFilename() {
        return this.filename;
    }

    public Resources getResources() {
        return this.resources;
    }

    class DrillThroughHandler
    implements RequestListener {
        Cell cell;

        DrillThroughHandler(Cell cell) {
            this.cell = cell;
        }

        public void request(RequestContext context) throws Exception {
            if (ChartComponent.this.canDrillThrough(this.cell)) {
                HttpSession session = context.getSession();
                String drillTableRef = ChartComponent.this.olapModel.getID() + ".drillthroughtable";
                ITableComponent tc = (ITableComponent)session.getAttribute(drillTableRef);
                TableModel tm = ChartComponent.this.drillThrough(this.cell);
                tc.setModel(tm);
                tc.setVisible(true);
            }
        }
    }

    public class jpivotCategoryURLGenerator
    extends StandardCategoryURLGenerator {
        private String prefix = "";
        private String seriesParameterName = "col";
        private String categoryParameterName = "row";
        private List cells;

        jpivotCategoryURLGenerator() {
            this.cells = ChartComponent.this.result.getCells();
        }

        jpivotCategoryURLGenerator(String prefix) {
            this.cells = ChartComponent.this.result.getCells();
            this.prefix = prefix;
        }

        public String generateURL(CategoryDataset data, int series, int category) {
            String url = this.prefix;
            int cellpos = category * ChartComponent.this.colCount + series;
            if (ChartComponent.this.canDrillThrough((Cell)this.cells.get(cellpos)) && !((Cell)this.cells.get(cellpos)).isNull()) {
                String id = DomUtils.randomId();
                ChartComponent.this.dispatcher.addRequestListener(id, null, (RequestListener)new DrillThroughHandler((Cell)this.cells.get(cellpos)));
                boolean firstParameter = url.indexOf("?") == -1;
                url = url + (firstParameter ? "?" : "&");
                url = url + id;
                return url;
            }
            return null;
        }
    }

    public class jpivotPieURLGenerator
    extends StandardPieURLGenerator {
        private String prefix = "";
        private List cells;
        private int rowCount;
        private TableOrder order;

        jpivotPieURLGenerator() {
            this.cells = ChartComponent.this.result.getCells();
        }

        jpivotPieURLGenerator(String prefix) {
            this.cells = ChartComponent.this.result.getCells();
            this.prefix = prefix;
        }

        jpivotPieURLGenerator(TableOrder order, DefaultCategoryDataset dataset) {
            this.cells = ChartComponent.this.result.getCells();
            this.order = order;
            this.rowCount = dataset.getRowCount();
        }

        jpivotPieURLGenerator(TableOrder order, DefaultCategoryDataset dataset, String controllerURL) {
            this(order, dataset);
            this.prefix = controllerURL;
        }

        public String generateURL(PieDataset data, Comparable key, int pieIndex) {
            String url = this.prefix;
            int index = data.getIndex(key);
            int cellpos = this.order == TableOrder.BY_COLUMN ? pieIndex * this.rowCount + index : pieIndex + this.rowCount * index;
            if (ChartComponent.this.canDrillThrough((Cell)this.cells.get(cellpos)) && !((Cell)this.cells.get(cellpos)).isNull()) {
                String id = DomUtils.randomId();
                ChartComponent.this.dispatcher.addRequestListener(id, null, (RequestListener)new DrillThroughHandler((Cell)this.cells.get(cellpos)));
                boolean firstParameter = url.indexOf("?") == -1;
                url = url + (firstParameter ? "?" : "&");
                url = url + id;
                return url;
            }
            return null;
        }
    }
}

