/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianUtil;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.navi.ExpressionParser;
import com.tonbeller.jpivot.param.SqlAccess;
import com.tonbeller.wcf.param.SessionParam;
import javax.sql.DataSource;
import mondrian.rolap.RolapMember;
import org.apache.log4j.Logger;

public class MondrianSqlAccess
extends ExtensionSupport
implements SqlAccess {
    private static Logger logger = Logger.getLogger((Class)MondrianSqlAccess.class);

    public DataSource getDataSource() {
        MondrianModel mm = (MondrianModel)this.getModel();
        return mm.getSqlDataSource();
    }

    public SessionParam createParameter(Member member, String paramName) {
        MondrianMember mm = (MondrianMember)member;
        RolapMember rm = (RolapMember)mm.getMonMember();
        paramName = this.checkParamName(paramName, rm);
        if (rm.getSqlKey() == null) {
            return null;
        }
        SessionParam p = new SessionParam();
        p.setSqlValue(rm.getSqlKey());
        p.setDisplayName(member.getLevel().getLabel());
        p.setDisplayValue(member.getLabel());
        ExpressionParser parser2 = (ExpressionParser)this.getModel().getExtension("expressionParser");
        if (parser2 != null) {
            p.setMdxValue(parser2.unparse(member));
        }
        p.setName(paramName);
        return p;
    }

    private String checkParamName(String paramName, RolapMember rm) {
        if (paramName != null) {
            return paramName;
        }
        return MondrianUtil.defaultParamName((mondrian.olap.Member)rm);
    }

    public SessionParam createParameter(Member member, String paramName, String propertyName) {
        MondrianMember mm = (MondrianMember)member;
        RolapMember rm = (RolapMember)mm.getMonMember();
        paramName = this.checkParamName(paramName, rm);
        Object propertyValue = rm.getPropertyValue(propertyName);
        SessionParam p = new SessionParam();
        p.setSqlValue(propertyValue);
        p.setDisplayName(member.getLevel().getLabel());
        p.setDisplayValue(member.getLabel());
        ExpressionParser parser2 = (ExpressionParser)this.getModel().getExtension("expressionParser");
        if (parser2 != null) {
            p.setMdxValue(parser2.unparse(member));
        }
        p.setName(paramName);
        return p;
    }
}

