/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.param;

import com.tonbeller.jpivot.olap.model.Expression;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.navi.ExpressionParser;
import com.tonbeller.jpivot.olap.navi.SetParameter;
import com.tonbeller.wcf.expr.ExprUtils;
import com.tonbeller.wcf.param.SessionParam;
import com.tonbeller.wcf.param.SessionParamPool;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class SetParameterTag
extends TagSupport {
    String httpParam;
    String mdxParam;
    String sessionParam;
    String query;

    public int doStartTag() throws JspException {
        if (this.httpParam == null == (this.sessionParam == null)) {
            throw new JspException("either httpParam or sessionParam required");
        }
        if (this.httpParam != null) {
            return this.doStartTagHttp();
        }
        return this.doStartTagSession();
    }

    public int doStartTagSession() throws JspException {
        return 0;
    }

    public int doStartTagHttp() throws JspException {
        String value = this.pageContext.getRequest().getParameter(this.httpParam);
        if (value != null) {
            return 1;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.httpParam != null) {
            return this.doEndTagHttp();
        }
        return this.doEndTagSession();
    }

    public int doEndTagSession() throws JspException {
        SessionParamPool pool = SessionParamPool.instance((HttpSession)this.pageContext.getSession());
        SessionParam p = pool.getParam(this.sessionParam);
        if (p != null) {
            this.setQueryParam(p.getMdxValue());
        }
        return super.doEndTag();
    }

    public int doEndTagHttp() throws JspException {
        String value = this.pageContext.getRequest().getParameter(this.httpParam);
        if (value != null) {
            this.setQueryParam(value);
        }
        return super.doEndTag();
    }

    private void setQueryParam(String value) throws JspException {
        OlapModel model = (OlapModel)ExprUtils.getModelReference((PageContext)this.pageContext, (String)this.query);
        if (model == null) {
            throw new JspException("OlapModel/Query " + this.query + " not found");
        }
        SetParameter setter = (SetParameter)model.getExtension("setParameter");
        if (setter == null) {
            throw new JspException("SetParameter not supported");
        }
        ExpressionParser parser2 = (ExpressionParser)model.getExtension("expressionParser");
        if (parser2 == null) {
            throw new JspException("ExpressionParser not supported");
        }
        try {
            Expression expr = parser2.parse(value);
            setter.setParameter(this.mdxParam, expr);
        }
        catch (ExpressionParser.InvalidSyntaxException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void setHttpParam(String string) {
        this.httpParam = string;
    }

    public void setMdxParam(String string) {
        this.mdxParam = string;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public void setSessionParam(String sessionParam) {
        this.sessionParam = sessionParam;
    }
}

