/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.span;

import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.MemberPropertyMeta;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.navi.MemberProperties;
import com.tonbeller.jpivot.table.span.MemberPropertyMetaFilter;
import com.tonbeller.jpivot.table.span.PropertyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ScopedPropertyMetaSet {
    private MemberProperties extension;
    private Map scopeMap = new HashMap();

    public ScopedPropertyMetaSet(MemberProperties extension) {
        this.extension = extension;
    }

    public void addAll(Collection memberPropertyMetas) {
        Iterator it = memberPropertyMetas.iterator();
        while (it.hasNext()) {
            MemberPropertyMeta mpm = (MemberPropertyMeta)it.next();
            this.add(mpm);
        }
    }

    public void removeAll(Collection memberPropertyMetas) {
        Iterator it = memberPropertyMetas.iterator();
        while (it.hasNext()) {
            MemberPropertyMeta mpm = (MemberPropertyMeta)it.next();
            this.remove(mpm);
        }
    }

    public void addMember(Member member) {
        if (member == null) {
            return;
        }
        String scope = this.extension.getPropertyScope(member);
        Property[] properties = member.getProperties();
        properties = PropertyUtils.normalize(properties);
        for (int i = 0; i < properties.length; ++i) {
            String label = properties[i].getLabel();
            String name = properties[i].getName();
            MemberPropertyMeta mpm = new MemberPropertyMeta(label, name, scope);
            this.add(mpm);
        }
    }

    public void add(MemberPropertyMeta mpm) {
        String scope = mpm.getScope();
        ScopeList scopeList = (ScopeList)this.scopeMap.get(scope);
        if (scopeList == null) {
            scopeList = new ScopeList();
            this.scopeMap.put(scope, scopeList);
        }
        scopeList.add(mpm);
    }

    public void remove(MemberPropertyMeta mpm) {
        String scope = mpm.getScope();
        ScopeList scopeList = (ScopeList)this.scopeMap.get(scope);
        if (scopeList == null) {
            return;
        }
        scopeList.remove(mpm);
    }

    public boolean contains(MemberPropertyMeta mpm) {
        return this.contains(mpm.getScope(), mpm.getName());
    }

    public boolean contains(String scope, String name) {
        ScopeList scopeList = (ScopeList)this.scopeMap.get(scope);
        if (scopeList == null) {
            return false;
        }
        return scopeList.contains(name);
    }

    MemberPropertyMeta lookup(String scope, String name) {
        ScopeList scopeList = (ScopeList)this.scopeMap.get(scope);
        if (scopeList == null) {
            return null;
        }
        return scopeList.lookup(name);
    }

    public List intersectList(List metas) {
        ArrayList<MemberPropertyMeta> list = new ArrayList<MemberPropertyMeta>();
        Iterator it = metas.iterator();
        while (it.hasNext()) {
            MemberPropertyMeta mpm = (MemberPropertyMeta)it.next();
            if ((mpm = this.lookup(mpm.getScope(), mpm.getName())) == null) continue;
            list.add(mpm);
        }
        return list;
    }

    public List metaList(MemberPropertyMetaFilter filter) {
        ArrayList<MemberPropertyMeta> list = new ArrayList<MemberPropertyMeta>();
        Iterator it = this.scopeMap.values().iterator();
        while (it.hasNext()) {
            ScopeList scopeList = (ScopeList)it.next();
            Iterator vt = scopeList.iterator();
            while (vt.hasNext()) {
                MemberPropertyMeta meta = (MemberPropertyMeta)vt.next();
                if (!filter.accept(meta)) continue;
                list.add(meta);
            }
        }
        return list;
    }

    public ScopedPropertyMetaSet metaSet(MemberPropertyMetaFilter filter) {
        ScopedPropertyMetaSet set = new ScopedPropertyMetaSet(this.extension);
        Iterator it = this.scopeMap.values().iterator();
        while (it.hasNext()) {
            ScopeList scopeList = (ScopeList)it.next();
            Iterator vt = scopeList.iterator();
            while (vt.hasNext()) {
                MemberPropertyMeta meta = (MemberPropertyMeta)vt.next();
                if (!filter.accept(meta)) continue;
                set.add(meta);
            }
        }
        return set;
    }

    String[] getAllNames() {
        TreeSet<String> allNames = new TreeSet<String>();
        Iterator it = this.scopeMap.values().iterator();
        while (it.hasNext()) {
            ScopeList scopeList = (ScopeList)it.next();
            Iterator vt = scopeList.iterator();
            while (vt.hasNext()) {
                MemberPropertyMeta meta = (MemberPropertyMeta)vt.next();
                allNames.add(meta.getName());
            }
        }
        return allNames.toArray(new String[allNames.size()]);
    }

    public MemberPropertyMetaFilter createAllFilter() {
        return new AllFilter();
    }

    public MemberPropertyMetaFilter createScopesFilter(Set scopes) {
        return new ScopesFilter(scopes);
    }

    public MemberPropertyMetaFilter createIgnoreInlineFilter() {
        return new IgnoreInlineFilter();
    }

    static class IgnoreInlineFilter
    implements MemberPropertyMetaFilter {
        IgnoreInlineFilter() {
        }

        public boolean accept(MemberPropertyMeta meta) {
            return !PropertyUtils.isInline(meta.getName());
        }
    }

    class ScopesFilter
    implements MemberPropertyMetaFilter {
        Set scopes;

        public ScopesFilter(Set scopes) {
            this.scopes = scopes;
        }

        public boolean accept(MemberPropertyMeta meta) {
            return this.scopes.contains(meta.getScope());
        }
    }

    static class AllFilter
    implements MemberPropertyMetaFilter {
        AllFilter() {
        }

        public boolean accept(MemberPropertyMeta meta) {
            return true;
        }
    }

    class ScopeList {
        List list = new ArrayList();
        Map map = new HashMap();

        ScopeList() {
        }

        void add(MemberPropertyMeta mpm) {
            String name = mpm.getName();
            if (!this.map.containsKey(name)) {
                this.map.put(name, mpm);
                this.list.add(mpm);
            }
        }

        void remove(MemberPropertyMeta mpm) {
            if ((mpm = (MemberPropertyMeta)this.map.get(mpm.getName())) == null) {
                return;
            }
            this.map.remove(mpm.getName());
            this.list.remove(mpm);
        }

        MemberPropertyMeta lookup(String name) {
            return (MemberPropertyMeta)this.map.get(name);
        }

        boolean contains(String name) {
            return this.map.containsKey(name);
        }

        Iterator iterator() {
            return this.list.iterator();
        }
    }
}

