/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.tags;

import com.tonbeller.jpivot.tags.Log4jStateLogger;
import com.tonbeller.jpivot.tags.StateLogger;
import com.tonbeller.jpivot.tags.StateManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PageStateManager
implements StateManager {
    Map map = new HashMap();
    StateManager.State current;
    StateLogger logger = new Log4jStateLogger();

    void showCurrent() throws Exception {
        if (this.current != null) {
            this.logger.show(this.current);
            this.current.show();
        }
    }

    void hideCurrent() throws Exception {
        if (this.current != null) {
            this.logger.hide(this.current);
            this.current.hide();
        }
    }

    public void initializeAndShow(StateManager.State next) throws Exception {
        this.hideCurrent();
        StateManager.State prev = (StateManager.State)this.map.get(next.getName());
        if (prev != null) {
            this.logger.destroy(prev);
            prev.destroy();
        }
        this.map.put(next.getName(), next);
        this.logger.initialize(next);
        next.initialize();
        this.current = next;
        this.showCurrent();
    }

    public void showByName(String name) throws Exception {
        StateManager.State s = (StateManager.State)this.map.get(name);
        if (s == null) {
            this.logger.error("could not find state for " + name);
            return;
        }
        if (this.current != s) {
            this.hideCurrent();
            this.current = s;
            this.showCurrent();
        }
    }

    public void destroyAll() throws Exception {
        this.hideCurrent();
        this.current = null;
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            StateManager.State s = (StateManager.State)it.next();
            this.logger.destroy(s);
            s.destroy();
        }
        this.map.clear();
    }

    public void destroyByName(String name) throws Exception {
        StateManager.State s = (StateManager.State)this.map.get(name);
        if (s == null) {
            this.logger.error("query " + name + " not found");
            return;
        }
        if (s == this.current) {
            this.hideCurrent();
            this.current = null;
        }
        this.logger.destroy(s);
        s.destroy();
        this.map.remove(name);
    }

    public StateLogger getLogger() {
        return this.logger;
    }

    public void setLogger(StateLogger logger) {
        this.logger = logger;
    }
}

