/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroup;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContentProcessing;
import org.apache.ws.commons.schema.XmlSchemaDerivationMethod;
import org.apache.ws.commons.schema.XmlSchemaDocumentation;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaGroupRef;
import org.apache.ws.commons.schema.XmlSchemaIdentityConstraint;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaKeyref;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaRedefine;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.XmlSchemaUse;
import org.apache.ws.commons.schema.XmlSchemaXPath;
import org.apache.ws.commons.schema.utils.DOMUtil;
import org.apache.ws.commons.schema.utils.Tokenizer;
import org.apache.ws.commons.schema.utils.XDOMUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaBuilder {
    Document doc;
    XmlSchema schema;
    XmlSchemaCollection collection;
    DocumentBuilderFactory docFac;

    SchemaBuilder(XmlSchemaCollection collection) {
        this.collection = collection;
        this.schema = new XmlSchema(collection);
    }

    XmlSchema build(Document doc, String uri, ValidationEventHandler veh) {
        Element schemaEl = doc.getDocumentElement();
        return this.handleXmlSchemaElement(schemaEl, uri);
    }

    XmlSchema handleXmlSchemaElement(Element schemaEl, String uri) {
        this.setNamespaceAttributes(this.schema, schemaEl);
        if (!this.collection.namespaces.containsKey(this.schema.targetNamespace)) {
            this.collection.namespaces.put(this.schema.targetNamespace, this.schema);
        }
        this.schema.setElementFormDefault(this.getFormDefault(schemaEl, "elementFormDefault"));
        this.schema.setAttributeFormDefault(this.getFormDefault(schemaEl, "attributeFormDefault"));
        this.schema.setBlockDefault(this.getDerivation(schemaEl, "blockDefault"));
        this.schema.setFinalDefault(this.getDerivation(schemaEl, "finalDefault"));
        this.schema.setSourceURI(uri);
        Element el = XDOMUtil.getFirstChildElementNS((Node)schemaEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            XmlSchemaAnnotated group;
            XmlSchemaType type;
            if (el.getLocalName().equals("simpleType")) {
                type = this.handleSimpleType(this.schema, el, schemaEl);
                this.schema.addType(type);
                this.schema.items.add(type);
                this.collection.resolveType(type.getQName(), type);
            } else if (el.getLocalName().equals("complexType")) {
                type = this.handleComplexType(this.schema, el, schemaEl);
                this.schema.addType(type);
                this.schema.items.add(type);
                this.collection.resolveType(type.getQName(), type);
            } else if (el.getLocalName().equals("element")) {
                XmlSchemaElement element = this.handleElement(this.schema, el, schemaEl, true);
                if (element.qualifiedName != null) {
                    this.schema.elements.collection.put(element.qualifiedName, element);
                } else if (element.refName != null) {
                    this.schema.elements.collection.put(element.refName, element);
                }
                this.schema.items.add(element);
            } else if (el.getLocalName().equals("include")) {
                XmlSchemaInclude include = this.handleInclude(this.schema, el, schemaEl);
                this.schema.includes.add(include);
                this.schema.items.add(include);
            } else if (el.getLocalName().equals("import")) {
                XmlSchemaImport schemaImport = this.handleImport(this.schema, el, schemaEl);
                this.schema.includes.add(schemaImport);
                this.schema.items.add(schemaImport);
            } else if (el.getLocalName().equals("group")) {
                group = this.handleGroup(this.schema, el, schemaEl);
                this.schema.groups.collection.put(group.name, group);
                this.schema.items.add(group);
            } else if (el.getLocalName().equals("attributeGroup")) {
                group = this.handleAttributeGroup(this.schema, el, schemaEl);
                this.schema.attributeGroups.collection.put(((XmlSchemaAttributeGroup)group).name, group);
                this.schema.items.add(group);
            } else if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(this.schema, el, schemaEl);
                this.schema.attributes.collection.put(attr.qualifiedName, attr);
                this.schema.items.add(attr);
            } else if (el.getLocalName().equals("redefine")) {
                XmlSchemaRedefine redefine = this.handleRedefine(this.schema, el, schemaEl);
                this.schema.includes.add(redefine);
            } else if (!el.getLocalName().equals("notation") && el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(this.schema, el, schemaEl);
                this.schema.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return this.schema;
    }

    private XmlSchemaAnnotation handleAnnotation(XmlSchema schema, Element annotEl, Element schemaEl) {
        XmlSchemaAnnotation annotation = new XmlSchemaAnnotation();
        XmlSchemaObjectCollection collection = annotation.getItems();
        Element el = DOMUtil.getFirstChildElement(annotEl);
        while (el != null) {
            if (el.getLocalName().equals("documentation")) {
                XmlSchemaDocumentation doc = new XmlSchemaDocumentation();
                doc.setMarkup(el.getChildNodes());
                collection.add(doc);
            }
            el = DOMUtil.getFirstChildElement(el);
        }
        return annotation;
    }

    private XmlSchemaRedefine handleRedefine(XmlSchema schema, Element redefineEl, Element schemaEl) {
        XmlSchemaRedefine redefine = new XmlSchemaRedefine();
        redefine.schemaLocation = redefineEl.getAttribute("schemaLocation");
        redefine.schema = this.resolveXmlSchema(null, redefine.schemaLocation);
        Element el = XDOMUtil.getFirstChildElementNS((Node)redefineEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            XmlSchemaAnnotated group;
            XmlSchemaType type;
            if (el.getLocalName().equals("simpleType")) {
                type = this.handleSimpleType(schema, el, schemaEl);
                redefine.schemaTypes.collection.put(type.getQName(), type);
                redefine.items.add(type);
            } else if (el.getLocalName().equals("complexType")) {
                type = this.handleComplexType(schema, el, schemaEl);
                redefine.schemaTypes.collection.put(type.getQName(), type);
                redefine.items.add(type);
            } else if (el.getLocalName().equals("group")) {
                group = this.handleGroup(schema, el, schemaEl);
                redefine.groups.collection.put(group.name, group);
                redefine.items.add(group);
            } else if (el.getLocalName().equals("attributeGroup")) {
                group = this.handleAttributeGroup(schema, el, schemaEl);
                redefine.attributeGroups.collection.put(((XmlSchemaAttributeGroup)group).name, group);
                redefine.items.add(group);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(el);
                redefine.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return redefine;
    }

    void setNamespaceAttributes(XmlSchema schema, Element schemaEl) {
        Node parent = schemaEl.getParentNode();
        if (parent instanceof Element) {
            this.setNamespaceAttributes(schema, (Element)parent);
        }
        NamedNodeMap map = schemaEl.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            if (map.item(i).getNodeName().startsWith("xmlns:")) {
                schema.namespaces.put(map.item(i).getLocalName(), map.item(i).getNodeValue());
                if (!map.item(i).getNodeValue().equals("http://www.w3.org/2001/XMLSchema")) continue;
                schema.schema_ns_prefix = map.item(i).getLocalName();
                continue;
            }
            if (!map.item(i).getNodeName().startsWith("xmlns")) continue;
            schema.namespaces.put("", map.item(i).getNodeValue());
        }
        if (schemaEl.getAttributeNode("targetNamespace") != null) {
            String contain = schemaEl.getAttribute("targetNamespace");
            if (!schema.namespaces.containsValue(contain)) {
                this.putNamespace("", contain);
            }
            if (!contain.equals("")) {
                schema.targetNamespace = contain;
            }
        }
    }

    private void putNamespace(String prefix, String namespace) {
        while (this.schema.namespaces.containsKey(prefix)) {
            prefix = "gen" + new Random().nextInt(999);
        }
        this.schema.namespaces.put(prefix, namespace);
    }

    XmlSchemaSimpleType handleSimpleType(XmlSchema schema, Element simpleEl, Element schemaEl) {
        Element restrictionEl;
        Element simpleTypeAnnotationEl;
        XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(schema);
        if (simpleEl.hasAttribute("name")) {
            simpleType.name = simpleEl.getAttribute("name");
        }
        if (simpleEl.hasAttribute("final")) {
            String finalstr = simpleEl.getAttribute("final");
            if (finalstr.equalsIgnoreCase("all") | finalstr.equalsIgnoreCase("#all")) {
                simpleType.setFinal(new XmlSchemaDerivationMethod("all"));
            } else {
                simpleType.setFinal(new XmlSchemaDerivationMethod(finalstr));
            }
        }
        if ((simpleTypeAnnotationEl = DOMUtil.getFirstChildElementNS(simpleEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation simpleTypeAnnotation = this.handleAnnotation(simpleTypeAnnotationEl);
            simpleType.setAnnotation(simpleTypeAnnotation);
        }
        if ((restrictionEl = DOMUtil.getFirstChildElementNS(simpleEl, "http://www.w3.org/2001/XMLSchema", "restriction")) != null) {
            XmlSchemaSimpleTypeRestriction restriction = new XmlSchemaSimpleTypeRestriction();
            Element restAnnotationEl = DOMUtil.getFirstChildElementNS(restrictionEl, "http://www.w3.org/2001/XMLSchema", "annotation");
            if (restAnnotationEl != null) {
                XmlSchemaAnnotation restAnnotation = this.handleAnnotation(restAnnotationEl);
                restriction.setAnnotation(restAnnotation);
            }
            Element inlineSimpleType = DOMUtil.getFirstChildElementNS(restrictionEl, "http://www.w3.org/2001/XMLSchema", "simpleType");
            if (restrictionEl.hasAttribute("base")) {
                String name = restrictionEl.getAttribute("base");
                String[] temp = Tokenizer.tokenize(name, ":");
                String namespace = "";
                if (temp.length != 1) {
                    namespace = temp[0];
                }
                namespace = schema.namespaces.get(namespace).toString();
                name = Tokenizer.lastToken(name, ":")[1];
                restriction.baseTypeName = new QName(namespace, name);
            } else if (inlineSimpleType != null) {
                XmlSchemaSimpleType baseType;
                restriction.baseType = baseType = this.handleSimpleType(schema, inlineSimpleType, schemaEl);
            }
            Element el = XDOMUtil.getFirstChildElementNS((Node)restrictionEl, "http://www.w3.org/2001/XMLSchema");
            while (el != null) {
                if (!el.getLocalName().equals("annotation") && !el.getLocalName().equals("simpleType")) {
                    XmlSchemaFacet facet = XmlSchemaFacet.construct(el);
                    Element annotation = DOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "annotation");
                    if (annotation != null) {
                        XmlSchemaAnnotation facetAnnotation = this.handleAnnotation(annotation);
                        facet.setAnnotation(facetAnnotation);
                    }
                    restriction.facets.add(facet);
                }
                el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
            }
            simpleType.content = restriction;
        } else {
            Element listEl = DOMUtil.getFirstChildElementNS(simpleEl, "http://www.w3.org/2001/XMLSchema", "list");
            if (listEl != null) {
                XmlSchemaSimpleTypeList list = new XmlSchemaSimpleTypeList();
                if (listEl.hasAttribute("itemType")) {
                    String namespace;
                    String name = listEl.getAttribute("itemType");
                    String[] namespaceFromEl = Tokenizer.tokenize(name, ":");
                    if (namespaceFromEl.length > 1) {
                        Object result = schema.namespaces.get(namespaceFromEl[0]);
                        if (result == null) {
                            throw new XmlSchemaException("No namespace found in given itemType");
                        }
                        namespace = result.toString();
                    } else {
                        namespace = schema.targetNamespace;
                    }
                    name = Tokenizer.lastToken(name, ":")[1];
                    list.itemTypeName = new QName(namespace, name);
                } else {
                    Element inlineListType = DOMUtil.getFirstChildElementNS(listEl, "http://www.w3.org/2001/XMLSchema", "simpleType");
                    if (inlineListType != null) {
                        XmlSchemaSimpleType baseType;
                        list.itemType = baseType = this.handleSimpleType(schema, inlineListType, schemaEl);
                    }
                }
                Element listAnnotationEl = DOMUtil.getFirstChildElementNS(listEl, "http://www.w3.org/2001/XMLSchema", "annotation");
                if (listAnnotationEl != null) {
                    XmlSchemaAnnotation listAnnotation = this.handleAnnotation(listAnnotationEl);
                    list.setAnnotation(listAnnotation);
                }
                simpleType.content = list;
            } else {
                Element unionEl = DOMUtil.getFirstChildElementNS(simpleEl, "http://www.w3.org/2001/XMLSchema", "union");
                if (unionEl != null) {
                    XmlSchemaSimpleTypeUnion union = new XmlSchemaSimpleTypeUnion();
                    if (unionEl.hasAttribute("memberTypes")) {
                        String memberTypes;
                        union.memberTypesSource = memberTypes = unionEl.getAttribute("memberTypes");
                        Vector<QName> v = new Vector<QName>();
                        StringTokenizer tokenizer = new StringTokenizer(memberTypes, " ");
                        while (tokenizer.hasMoreTokens()) {
                            String member = tokenizer.nextToken();
                            int pos = member.indexOf(":");
                            String prefix = "";
                            String localName = "";
                            if (pos == -1) {
                                localName = member;
                            } else {
                                prefix = member.substring(0, pos);
                                localName = member.substring(pos + 1);
                            }
                            v.add(new QName((String)schema.namespaces.get(prefix), localName));
                        }
                        union.memberTypesQNames = new QName[v.size()];
                        v.copyInto(union.memberTypesQNames);
                    }
                    Element inlineUnionType = DOMUtil.getFirstChildElementNS(unionEl, "http://www.w3.org/2001/XMLSchema", "simpleType");
                    while (inlineUnionType != null) {
                        XmlSchemaSimpleType unionSimpleType = this.handleSimpleType(schema, inlineUnionType, schemaEl);
                        union.baseTypes.add(unionSimpleType);
                        union.memberTypesSource = union.memberTypesSource + " " + unionSimpleType.name;
                        inlineUnionType = DOMUtil.getNextSiblingElementNS(inlineUnionType, "http://www.w3.org/2001/XMLSchema", "simpleType");
                    }
                    Element unionAnnotationEl = DOMUtil.getFirstChildElementNS(unionEl, "http://www.w3.org/2001/XMLSchema", "annotation");
                    if (unionAnnotationEl != null) {
                        XmlSchemaAnnotation unionAnnotation = this.handleAnnotation(unionAnnotationEl);
                        union.setAnnotation(unionAnnotation);
                    }
                    simpleType.content = union;
                }
            }
        }
        return simpleType;
    }

    XmlSchemaComplexType handleComplexType(XmlSchema schema, Element complexEl, Element schemaEl) {
        XmlSchemaComplexType ct = new XmlSchemaComplexType(schema);
        if (complexEl.hasAttribute("name")) {
            String name;
            ct.name = name = complexEl.getAttribute("name");
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)complexEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                XmlSchemaSequence sequence = this.handleSequence(schema, el, schemaEl);
                ct.particle = sequence;
            } else if (el.getLocalName().equals("choice")) {
                XmlSchemaChoice choice = this.handleChoice(schema, el, schemaEl);
                ct.particle = choice;
            } else if (el.getLocalName().equals("all")) {
                XmlSchemaAll all = this.handleAll(schema, el, schemaEl);
                ct.particle = all;
            } else if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(schema, el, schemaEl);
                ct.attributes.add(attr);
            } else if (el.getLocalName().equals("attributeGroup")) {
                XmlSchemaAttributeGroupRef attrGroup = this.handleAttributeGroupRef(schema, el, schemaEl);
                ct.attributes.add(attrGroup);
            } else if (el.getLocalName().equals("group")) {
                XmlSchemaGroupRef group = this.handleGroupRef(schema, el, schemaEl);
                ct.particle = group.particle == null ? group : group.particle;
            } else if (el.getLocalName().equals("simpleContent")) {
                XmlSchemaSimpleContent simpleContent = this.handleSimpleContent(schema, el, schemaEl);
                ct.contentModel = simpleContent;
            } else if (el.getLocalName().equals("complexContent")) {
                XmlSchemaComplexContent complexContent = this.handleComplexContent(schema, el, schemaEl);
                ct.contentModel = complexContent;
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                ct.setAnnotation(ann);
            } else if (el.getLocalName().equals("anyAttribute")) {
                XmlSchemaAnyAttribute anyAtt = this.handleAnyAttribute(schema, el, schemaEl);
                ct.setAnyAttribute(anyAtt);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        if (complexEl.hasAttribute("block")) {
            String blockStr = complexEl.getAttribute("block");
            if (blockStr.equalsIgnoreCase("all") | blockStr.equalsIgnoreCase("#all")) {
                ct.setBlock(new XmlSchemaDerivationMethod("all"));
            } else {
                ct.setBlock(new XmlSchemaDerivationMethod(blockStr));
            }
        }
        if (complexEl.hasAttribute("final")) {
            String finalstr = complexEl.getAttribute("final");
            if (finalstr.equalsIgnoreCase("all") | finalstr.equalsIgnoreCase("#all")) {
                ct.setFinal(new XmlSchemaDerivationMethod("all"));
            } else {
                ct.setFinal(new XmlSchemaDerivationMethod(finalstr));
            }
        }
        if (complexEl.hasAttribute("abstract")) {
            String abs = complexEl.getAttribute("abstract");
            if (abs.equalsIgnoreCase("true")) {
                ct.setAbstract(true);
            } else {
                ct.setAbstract(false);
            }
        }
        if (complexEl.hasAttribute("mixed")) {
            String mixed = complexEl.getAttribute("mixed");
            if (mixed.equalsIgnoreCase("true")) {
                ct.setMixed(true);
            } else {
                ct.setMixed(false);
            }
        }
        return ct;
    }

    private XmlSchemaSimpleContent handleSimpleContent(XmlSchema schema, Element simpleEl, Element schemaEl) {
        XmlSchemaSimpleContent simpleContent = new XmlSchemaSimpleContent();
        Element el = XDOMUtil.getFirstChildElementNS((Node)simpleEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("restriction")) {
                XmlSchemaSimpleContentRestriction restriction = this.handleSimpleContentRestriction(schema, el, schemaEl);
                simpleContent.content = restriction;
            } else if (el.getLocalName().equals("extension")) {
                XmlSchemaSimpleContentExtension ext = this.handleSimpleContentExtension(schema, el, schemaEl);
                simpleContent.content = ext;
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                simpleContent.setAnnotation(ann);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return simpleContent;
    }

    private XmlSchemaComplexContent handleComplexContent(XmlSchema schema, Element complexEl, Element schemaEl) {
        XmlSchemaComplexContent complexContent = new XmlSchemaComplexContent();
        Element el = XDOMUtil.getFirstChildElementNS((Node)complexEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("restriction")) {
                XmlSchemaComplexContentRestriction restriction = this.handleComplexContentRestriction(schema, el, schemaEl);
                complexContent.content = restriction;
            } else if (el.getLocalName().equals("extension")) {
                XmlSchemaComplexContentExtension ext = this.handleComplexContentExtension(schema, el, schemaEl);
                complexContent.content = ext;
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                complexContent.setAnnotation(ann);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return complexContent;
    }

    private XmlSchemaSimpleContentRestriction handleSimpleContentRestriction(XmlSchema schema, Element restrictionEl, Element schemaEl) {
        XmlSchemaSimpleContentRestriction restriction = new XmlSchemaSimpleContentRestriction();
        if (restrictionEl.hasAttribute("base")) {
            String name = restrictionEl.getAttribute("base");
            Object result = schema.namespaces.get(Tokenizer.tokenize(name, ":")[0]);
            if (result == null) {
                throw new XmlSchemaException("No namespace found in given base simple content type");
            }
            name = Tokenizer.lastToken(name, ":")[1];
            restriction.baseTypeName = new QName(result.toString(), name);
        }
        if (restrictionEl.hasAttribute("id")) {
            restriction.id = restrictionEl.getAttribute("id");
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)restrictionEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(schema, el, schemaEl);
                restriction.attributes.add(attr);
            } else if (el.getLocalName().equals("attributeGroup")) {
                XmlSchemaAttributeGroupRef attrGroup = this.handleAttributeGroupRef(schema, el, schemaEl);
                restriction.attributes.add(attrGroup);
            } else if (el.getLocalName().equals("simpleType")) {
                XmlSchemaSimpleType type;
                restriction.baseType = type = this.handleSimpleType(schema, el, schemaEl);
            } else if (el.getLocalName().equals("anyAttribute")) {
                restriction.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                restriction.setAnnotation(ann);
            } else {
                XmlSchemaFacet facet = XmlSchemaFacet.construct(el);
                NodeList annotations = el.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "annotation");
                if (annotations.getLength() > 0) {
                    XmlSchemaAnnotation facetAnnotation = this.handleAnnotation(el);
                    facet.setAnnotation(facetAnnotation);
                }
                restriction.facets.add(facet);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return restriction;
    }

    private XmlSchemaSimpleContentExtension handleSimpleContentExtension(XmlSchema schema, Element extEl, Element schemaEl) {
        XmlSchemaSimpleContentExtension ext = new XmlSchemaSimpleContentExtension();
        if (extEl.hasAttribute("base")) {
            String name = extEl.getAttribute("base");
            if (name.indexOf(58) != -1) {
                String nsFromEl = Tokenizer.tokenize(name, ":")[0];
                Object result = schema.namespaces.get(nsFromEl);
                if (result == null) {
                    throw new XmlSchemaException("No namespace found in given base simple content type");
                }
                name = Tokenizer.lastToken(name, ":")[1];
                ext.baseTypeName = new QName(result.toString(), name);
            } else {
                ext.baseTypeName = new QName(schema.getNamespace(""), name);
            }
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)extEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(schema, el, schemaEl);
                ext.attributes.add(attr);
            } else if (el.getLocalName().equals("attributeGroup")) {
                XmlSchemaAttributeGroupRef attrGroup = this.handleAttributeGroupRef(schema, el, schemaEl);
                ext.attributes.add(attrGroup);
            } else if (el.getLocalName().equals("anyAttribute")) {
                ext.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                ext.setAnnotation(ann);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return ext;
    }

    private XmlSchemaComplexContentRestriction handleComplexContentRestriction(XmlSchema schema, Element restrictionEl, Element schemaEl) {
        XmlSchemaComplexContentRestriction restriction = new XmlSchemaComplexContentRestriction();
        if (restrictionEl.hasAttribute("base")) {
            String name = restrictionEl.getAttribute("base");
            String prefix = name.indexOf(":") < 0 ? "" : name.substring(0, name.indexOf(":"));
            Object result = schema.namespaces.get(prefix);
            if (result == null) {
                throw new XmlSchemaException("No namespace found in given base complex content base type");
            }
            name = Tokenizer.lastToken(name, ":")[1];
            restriction.baseTypeName = new QName(result.toString(), name);
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)restrictionEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                XmlSchemaSequence sequence = this.handleSequence(schema, el, schemaEl);
                restriction.particle = sequence;
            } else if (el.getLocalName().equals("choice")) {
                XmlSchemaChoice choice = this.handleChoice(schema, el, schemaEl);
                restriction.particle = choice;
            } else if (el.getLocalName().equals("all")) {
                XmlSchemaAll all = this.handleAll(schema, el, schemaEl);
                restriction.particle = all;
            } else if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(schema, el, schemaEl);
                restriction.attributes.add(attr);
            } else if (el.getLocalName().equals("attributeGroup")) {
                XmlSchemaAttributeGroupRef attrGroup = this.handleAttributeGroupRef(schema, el, schemaEl);
                restriction.attributes.add(attrGroup);
            } else if (el.getLocalName().equals("group")) {
                XmlSchemaGroupRef group = this.handleGroupRef(schema, el, schemaEl);
                restriction.particle = group;
            } else if (el.getLocalName().equals("anyAttribute")) {
                restriction.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                restriction.setAnnotation(ann);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return restriction;
    }

    private XmlSchemaComplexContentExtension handleComplexContentExtension(XmlSchema schema, Element extEl, Element schemaEl) {
        XmlSchemaComplexContentExtension ext = new XmlSchemaComplexContentExtension();
        if (extEl.hasAttribute("base")) {
            Object result;
            String name = extEl.getAttribute("base");
            String namespaceFromEl = "";
            if (name.indexOf(":") > 0) {
                namespaceFromEl = Tokenizer.tokenize(name, ":")[0];
            }
            if ((result = schema.namespaces.get(namespaceFromEl)) == null) {
                throw new XmlSchemaException("No namespace found in given base complex content base type");
            }
            name = Tokenizer.lastToken(name, ":")[1];
            ext.baseTypeName = new QName(result.toString(), name);
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)extEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                XmlSchemaSequence sequence = this.handleSequence(schema, el, schemaEl);
                ext.particle = sequence;
            } else if (el.getLocalName().equals("choice")) {
                XmlSchemaChoice choice = this.handleChoice(schema, el, schemaEl);
                ext.particle = choice;
            } else if (el.getLocalName().equals("all")) {
                XmlSchemaAll all = this.handleAll(schema, el, schemaEl);
                ext.particle = all;
            } else if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(schema, el, schemaEl);
                ext.attributes.add(attr);
            } else if (el.getLocalName().equals("attributeGroup")) {
                XmlSchemaAttributeGroupRef attrGroup = this.handleAttributeGroupRef(schema, el, schemaEl);
                ext.attributes.add(attrGroup);
            } else if (el.getLocalName().equals("group")) {
                XmlSchemaGroupRef group = this.handleGroupRef(schema, el, schemaEl);
                ext.particle = group;
            } else if (el.getLocalName().equals("anyAttribute")) {
                ext.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                ext.setAnnotation(ann);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return ext;
    }

    private XmlSchemaAttributeGroupRef handleAttributeGroupRef(XmlSchema schema, Element attrGroupEl, Element schemaEl) {
        Element annotationEl;
        XmlSchemaAttributeGroupRef attrGroup = new XmlSchemaAttributeGroupRef();
        if (attrGroupEl.hasAttribute("ref")) {
            Object result;
            String ref = attrGroupEl.getAttribute("ref");
            String[] parts = Tokenizer.tokenize(ref, ":");
            String prefix = "";
            if (parts.length > 1) {
                prefix = parts[0];
            }
            if ((result = schema.namespaces.get(prefix)) == null) {
                throw new XmlSchemaException("No namespace found in given ref name");
            }
            ref = Tokenizer.lastToken(ref, ":")[1];
            attrGroup.refName = new QName(result.toString(), ref);
        }
        if (attrGroupEl.hasAttribute("id")) {
            attrGroup.id = attrGroupEl.getAttribute("id");
        }
        if ((annotationEl = DOMUtil.getFirstChildElementNS(attrGroupEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            attrGroup.setAnnotation(annotation);
        }
        return attrGroup;
    }

    private XmlSchemaSequence handleSequence(XmlSchema schema, Element sequenceEl, Element schemaEl) {
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        Element el = XDOMUtil.getFirstChildElementNS((Node)sequenceEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                XmlSchemaSequence seq = this.handleSequence(schema, el, schemaEl);
                sequence.items.add(seq);
            } else if (el.getLocalName().equals("element")) {
                XmlSchemaElement element = this.handleElement(schema, el, schemaEl, false);
                sequence.items.add(element);
            } else if (el.getLocalName().equals("group")) {
                XmlSchemaGroupRef group = this.handleGroupRef(schema, el, schemaEl);
                sequence.items.add(group);
            } else if (el.getLocalName().equals("choice")) {
                XmlSchemaChoice choice = this.handleChoice(schema, el, schemaEl);
                sequence.items.add(choice);
            } else if (el.getLocalName().equals("any")) {
                XmlSchemaAny any = this.handleAny(schema, el, schemaEl);
                sequence.items.add(any);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(el);
                sequence.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return sequence;
    }

    private XmlSchemaAny handleAny(XmlSchema schema, Element anyEl, Element schemaEl) {
        Element annotationEl;
        XmlSchemaAny any = new XmlSchemaAny();
        if (anyEl.hasAttribute("namespace")) {
            any.namespace = anyEl.getAttribute("namespace");
        }
        if (anyEl.hasAttribute("processContents")) {
            String processContent = this.getEnumString(anyEl, "processContents");
            any.processContent = new XmlSchemaContentProcessing(processContent);
        }
        if ((annotationEl = DOMUtil.getFirstChildElementNS(anyEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            any.setAnnotation(annotation);
        }
        any.minOccurs = this.getMinOccurs(anyEl);
        any.maxOccurs = this.getMaxOccurs(anyEl);
        return any;
    }

    private XmlSchemaChoice handleChoice(XmlSchema schema, Element choiceEl, Element schemaEl) {
        XmlSchemaChoice choice = new XmlSchemaChoice();
        if (choiceEl.hasAttribute("id")) {
            choice.id = choiceEl.getAttribute("id");
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)choiceEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                XmlSchemaSequence seq = this.handleSequence(schema, el, schemaEl);
                choice.items.add(seq);
            } else if (el.getLocalName().equals("element")) {
                XmlSchemaElement element = this.handleElement(schema, el, schemaEl, false);
                choice.items.add(element);
            } else if (el.getLocalName().equals("group")) {
                XmlSchemaGroupRef group = this.handleGroupRef(schema, el, schemaEl);
                choice.items.add(group);
            } else if (el.getLocalName().equals("choice")) {
                XmlSchemaChoice choiceItem = this.handleChoice(schema, el, schemaEl);
                choice.items.add(choiceItem);
            } else if (el.getLocalName().equals("any")) {
                XmlSchemaAny any = this.handleAny(schema, el, schemaEl);
                choice.items.add(any);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(el);
                choice.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return choice;
    }

    private XmlSchemaAll handleAll(XmlSchema schema, Element allEl, Element schemaEl) {
        XmlSchemaAll all = new XmlSchemaAll();
        Element el = XDOMUtil.getFirstChildElementNS((Node)allEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("element")) {
                XmlSchemaElement element = this.handleElement(schema, el, schemaEl, false);
                all.items.add(element);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation annotation = this.handleAnnotation(el);
                all.setAnnotation(annotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return all;
    }

    private XmlSchemaGroup handleGroup(XmlSchema schema, Element groupEl, Element schemaEl) {
        XmlSchemaGroup group = new XmlSchemaGroup();
        group.name = groupEl.getAttribute("name");
        Element el = XDOMUtil.getFirstChildElementNS((Node)groupEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("all")) {
                group.particle = this.handleAll(schema, el, schemaEl);
            } else if (el.getLocalName().equals("sequence")) {
                group.particle = this.handleSequence(schema, el, schemaEl);
            } else if (el.getLocalName().equals("choice")) {
                group.particle = this.handleChoice(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation groupAnnotation = this.handleAnnotation(el);
                group.setAnnotation(groupAnnotation);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return group;
    }

    private XmlSchemaAttributeGroup handleAttributeGroup(XmlSchema schema, Element groupEl, Element schemaEl) {
        XmlSchemaAttributeGroup attrGroup = new XmlSchemaAttributeGroup();
        if (groupEl.hasAttribute("name")) {
            attrGroup.name = groupEl.getAttribute("name");
        }
        if (groupEl.hasAttribute("id")) {
            attrGroup.id = groupEl.getAttribute("id");
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)groupEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("attribute")) {
                XmlSchemaAttribute attr = this.handleAttribute(schema, el, schemaEl);
                attrGroup.attributes.add(attr);
            } else if (el.getLocalName().equals("attributeGroup")) {
                XmlSchemaAttributeGroupRef attrGroupRef = this.handleAttributeGroupRef(schema, el, schemaEl);
                attrGroup.attributes.add(attrGroupRef);
            } else if (el.getLocalName().equals("anyAttribute")) {
                attrGroup.anyAttribute = this.handleAnyAttribute(schema, el, schemaEl);
            } else if (el.getLocalName().equals("annotation")) {
                XmlSchemaAnnotation ann = this.handleAnnotation(el);
                attrGroup.setAnnotation(ann);
            }
            el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
        }
        return attrGroup;
    }

    private XmlSchemaAnyAttribute handleAnyAttribute(XmlSchema schema, Element anyAttrEl, Element schemaEl) {
        Element annotationEl;
        XmlSchemaAnyAttribute anyAttr = new XmlSchemaAnyAttribute();
        if (anyAttrEl.hasAttribute("namespace")) {
            anyAttr.namespace = anyAttrEl.getAttribute("namespace");
        }
        if (anyAttrEl.hasAttribute("processContents")) {
            String contentProcessing = this.getEnumString(anyAttrEl, "processContents");
            anyAttr.processContent = new XmlSchemaContentProcessing(contentProcessing);
        }
        if (anyAttrEl.hasAttribute("id")) {
            anyAttr.id = anyAttrEl.getAttribute("id");
        }
        if ((annotationEl = DOMUtil.getFirstChildElementNS(anyAttrEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            anyAttr.setAnnotation(annotation);
        }
        return anyAttr;
    }

    private XmlSchemaGroupRef handleGroupRef(XmlSchema schema, Element groupEl, Element schemaEl) {
        XmlSchemaGroupRef group = new XmlSchemaGroupRef();
        Element annotationEl = DOMUtil.getFirstChildElementNS(groupEl, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (annotationEl != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            group.setAnnotation(annotation);
        }
        if (groupEl.hasAttribute("ref")) {
            Object result;
            String ref = groupEl.getAttribute("ref");
            String[] parts = Tokenizer.tokenize(ref, ":");
            String prefix = "";
            if (parts.length > 1) {
                prefix = parts[0];
            }
            if ((result = schema.namespaces.get(prefix)) == null) {
                throw new XmlSchemaException("No namespace found in given ref group");
            }
            ref = Tokenizer.lastToken(ref, ":")[1];
            group.refName = new QName(result.toString(), ref);
            return group;
        }
        Element el = XDOMUtil.getFirstChildElementNS((Node)groupEl, "http://www.w3.org/2001/XMLSchema");
        while (el != null) {
            if (el.getLocalName().equals("sequence")) {
                XmlSchemaSequence sequence = this.handleSequence(schema, el, schemaEl);
                group.particle = sequence;
            } else if (el.getLocalName().equals("all")) {
                XmlSchemaAll all = this.handleAll(schema, el, schemaEl);
                group.particle = all;
            } else if (el.getLocalName().equals("choice")) {
                XmlSchemaChoice choice = this.handleChoice(schema, el, schemaEl);
                group.particle = choice;
            }
            el = DOMUtil.getNextSiblingElement(el);
        }
        return group;
    }

    private XmlSchemaAttribute handleAttribute(XmlSchema schema, Element attrEl, Element schemaEl) {
        Element annotationEl;
        Element simpleTypeEl;
        String namespace;
        Object result;
        String name;
        XmlSchemaAttribute attr = new XmlSchemaAttribute();
        if (attrEl.hasAttribute("name")) {
            attr.name = name = attrEl.getAttribute("name");
            attr.qualifiedName = new QName(schema.targetNamespace, name);
        }
        if (attrEl.hasAttribute("type")) {
            name = attrEl.getAttribute("type");
            String[] type = Tokenizer.tokenize(name, ":");
            if (type.length > 1) {
                result = schema.namespaces.get(type[0]);
                if (result == null) {
                    throw new XmlSchemaException("No namespace found in given attribute type for " + type[0]);
                }
                namespace = result.toString();
            } else {
                namespace = schema.getNamespace("");
            }
            name = Tokenizer.lastToken(name, ":")[1];
            attr.schemaTypeName = new QName(namespace, name);
        }
        if (attrEl.hasAttribute("default")) {
            attr.defaultValue = attrEl.getAttribute("default");
        }
        if (attrEl.hasAttribute("fixed")) {
            attr.fixedValue = attrEl.getAttribute("fixed");
        }
        if (attrEl.hasAttribute("form")) {
            String formValue = this.getEnumString(attrEl, "form");
            attr.form = new XmlSchemaForm(formValue);
        }
        if (attrEl.hasAttribute("id")) {
            attr.id = attrEl.getAttribute("id");
        }
        if (attrEl.hasAttribute("use")) {
            String useType = this.getEnumString(attrEl, "use");
            attr.use = new XmlSchemaUse(useType);
        }
        if (attrEl.hasAttribute("ref")) {
            name = attrEl.getAttribute("ref");
            String[] namespaceFromEl = Tokenizer.tokenize(name, ":");
            if (namespaceFromEl.length > 1) {
                result = schema.namespaces.get(namespaceFromEl[0]);
                if (result == null && namespaceFromEl[0].equals("xml")) {
                    result = "http://www.w3.org/XML/1998/namespace";
                }
                if (result == null) {
                    throw new XmlSchemaException("No namespace found in given ref");
                }
                namespace = result.toString();
            } else {
                namespace = schema.targetNamespace;
            }
            name = Tokenizer.lastToken(name, ":")[1];
            attr.refName = new QName(namespace, name);
            attr.name = name;
        }
        if ((simpleTypeEl = DOMUtil.getFirstChildElementNS(attrEl, "http://www.w3.org/2001/XMLSchema", "simpleType")) != null) {
            attr.schemaType = this.handleSimpleType(schema, simpleTypeEl, schemaEl);
        }
        if ((annotationEl = DOMUtil.getFirstChildElementNS(attrEl, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            attr.setAnnotation(annotation);
        }
        NamedNodeMap attrNodes = attrEl.getAttributes();
        Vector<Attr> attrs = new Vector<Attr>();
        for (int i = 0; i < attrNodes.getLength(); ++i) {
            String prefix;
            String namespace2;
            Attr att = (Attr)attrNodes.item(i);
            if (att.getName().equals("name") || att.getName().equals("type") || att.getName().equals("default") || att.getName().equals("fixed") || att.getName().equals("form") || att.getName().equals("id") || att.getName().equals("use") || att.getName().equals("ref")) continue;
            attrs.add(att);
            String value = att.getValue();
            if (value.indexOf(":") <= -1 || (namespace2 = (String)schema.namespaces.get(prefix = value.substring(0, value.indexOf(":")))) == null) continue;
            Attr nsAttr = attrEl.getOwnerDocument().createAttribute("xmlns:" + prefix);
            nsAttr.setValue(namespace2);
            attrs.add(nsAttr);
        }
        if (attrs.size() > 0) {
            attr.setUnhandledAttributes(attrs.toArray(new Attr[0]));
        }
        return attr;
    }

    XmlSchemaElement handleElement(XmlSchema schema, Element el, Element schemaEl, boolean isGlobal) {
        String namespace;
        String[] args;
        Element annotationEl;
        String ns;
        XmlSchemaElement element = new XmlSchemaElement();
        if (el.getAttributeNode("name") != null) {
            element.name = el.getAttribute("name");
        }
        boolean isQualified = schema.getElementFormDefault().getValue().equals("qualified");
        if (el.hasAttribute("form")) {
            String formDef = el.getAttribute("form");
            element.form = new XmlSchemaForm(formDef);
            isQualified = formDef.equals("qualified");
        }
        String string = ns = isQualified || isGlobal ? schema.targetNamespace : null;
        if (element.name != null) {
            element.qualifiedName = new QName(ns, element.name);
        }
        if ((annotationEl = DOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "annotation")) != null) {
            XmlSchemaAnnotation annotation = this.handleAnnotation(annotationEl);
            element.setAnnotation(annotation);
        }
        if (el.getAttributeNode("type") != null) {
            QName typeQName;
            String typeName = el.getAttribute("type");
            args = Tokenizer.tokenize(typeName, ":");
            namespace = "";
            if (args.length > 1) {
                String result;
                HashMap elementNameSpaceMap = new HashMap();
                this.populateElementNamespaces(el, elementNameSpaceMap);
                Object elementNs = elementNameSpaceMap.get(args[0]);
                String string2 = result = elementNs != null ? elementNs.toString() : schema.getNamespace(args[0]);
                if (result == null) {
                    throw new XmlSchemaException("Couldn't map prefix '" + args[0] + "' to a namespace");
                }
                namespace = result;
            } else {
                namespace = schema.getNamespace("");
            }
            typeName = Tokenizer.lastToken(typeName, ":")[1];
            element.schemaTypeName = typeQName = new QName(namespace, typeName);
            XmlSchemaType type = this.collection.getTypeByQName(typeQName);
            if (type == null) {
                this.collection.addUnresolvedType(typeQName, element);
            }
            element.schemaType = type;
        } else if (el.getAttributeNode("ref") != null) {
            String refName = el.getAttribute("ref");
            args = Tokenizer.tokenize(refName, ":");
            if (args.length > 1) {
                Object result = schema.namespaces.get(args[0]);
                if (result == null) {
                    throw new XmlSchemaException("No namespace found ingiven ref");
                }
                namespace = result.toString();
            } else {
                namespace = schema.targetNamespace;
            }
            refName = Tokenizer.lastToken(refName, ":")[1];
            element.setRefName(new QName(namespace, refName));
            element.name = refName;
        }
        Element simpleTypeEl = DOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "simpleType");
        if (simpleTypeEl != null) {
            XmlSchemaSimpleType simpleType = this.handleSimpleType(schema, simpleTypeEl, schemaEl);
            element.schemaType = simpleType;
            element.schemaTypeName = simpleType.getQName();
        } else {
            Element complexTypeEl = DOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "complexType");
            if (complexTypeEl != null) {
                XmlSchemaComplexType complexType = this.handleComplexType(schema, complexTypeEl, schemaEl);
                element.schemaType = complexType;
            } else {
                Element keyEl = DOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "key");
                if (keyEl != null) {
                    XmlSchemaIdentityConstraint key = this.handleConstraint(schema, keyEl, schemaEl, "Key");
                    element.constraints.add(key);
                } else {
                    Element keyrefEl = DOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "keyref");
                    if (keyrefEl != null) {
                        XmlSchemaKeyref keyRef = (XmlSchemaKeyref)this.handleConstraint(schema, keyrefEl, schemaEl, "Keyref");
                        if (el.hasAttribute("refer")) {
                            String namespace2;
                            String name = el.getAttribute("refer");
                            String[] qName = Tokenizer.tokenize(name, ":");
                            if (qName.length > 1) {
                                Object result = schema.namespaces.get(qName[0]);
                                namespace2 = result.toString();
                            } else {
                                namespace2 = schema.targetNamespace;
                            }
                            name = Tokenizer.lastToken(name, ":")[1];
                            keyRef.refer = new QName(namespace2, name);
                        }
                        element.constraints.add(keyRef);
                    } else {
                        Element uniqueEl = DOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "unique");
                        if (uniqueEl != null) {
                            XmlSchemaIdentityConstraint unique = this.handleConstraint(schema, uniqueEl, schemaEl, "Unique");
                            element.constraints.add(unique);
                        }
                    }
                }
            }
        }
        if (el.hasAttribute("abstract")) {
            element.isAbstract = new Boolean(el.getAttribute("abstract"));
        }
        if (el.hasAttribute("block")) {
            element.block = this.getDerivation(el, "block");
        }
        if (el.hasAttribute("default")) {
            element.defaultValue = el.getAttribute("default");
        }
        if (el.hasAttribute("final")) {
            element.finalDerivation = this.getDerivation(el, "final");
        }
        if (el.hasAttribute("fixed")) {
            element.fixedValue = el.getAttribute("fixed");
        }
        if (el.hasAttribute("id")) {
            element.id = el.getAttribute("id");
        }
        if (el.hasAttribute("nillable")) {
            element.isNillable = new Boolean(el.getAttribute("nillable"));
        }
        element.minOccurs = this.getMinOccurs(el);
        element.maxOccurs = this.getMaxOccurs(el);
        return element;
    }

    private void populateElementNamespaces(Element el, Map elementNameSpaceMap) {
        NamedNodeMap attributes = el.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            if (!node.getNodeName().startsWith("xmlns:")) continue;
            elementNameSpaceMap.put(node.getLocalName(), node.getNodeValue());
        }
    }

    private XmlSchemaIdentityConstraint handleConstraint(XmlSchema schema, Element constraintEl, Element schemaEl, String type) {
        try {
            XmlSchemaIdentityConstraint constraint = (XmlSchemaIdentityConstraint)Class.forName("org.apache.ws.commons.schema.XmlSchema" + type).newInstance();
            if (constraintEl.hasAttribute("name")) {
                constraint.name = constraintEl.getAttribute("name");
            }
            if (constraintEl.hasAttribute("refer")) {
                String namespace;
                String name = constraintEl.getAttribute("refer");
                String[] namespaceFromEl = Tokenizer.tokenize(name, ":");
                if (namespaceFromEl.length > 1) {
                    Object result = schema.namespaces.get(namespaceFromEl[0]);
                    if (result == null) {
                        throw new XmlSchemaException("No namespace found in given base simple content type");
                    }
                    namespace = result.toString();
                } else {
                    namespace = schema.targetNamespace;
                }
                constraint.name = name = Tokenizer.lastToken(name, ":")[1];
                ((XmlSchemaKeyref)constraint).refer = new QName(namespace, name);
            }
            Element el = XDOMUtil.getFirstChildElementNS((Node)constraintEl, "http://www.w3.org/2001/XMLSchema");
            while (el != null) {
                XmlSchemaAnnotation annotation;
                Element annotationEl;
                if (el.getLocalName().equals("selector")) {
                    XmlSchemaXPath selectorXPath = new XmlSchemaXPath();
                    selectorXPath.xpath = el.getAttribute("xpath");
                    annotationEl = DOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "annotation");
                    if (annotationEl != null) {
                        annotation = this.handleAnnotation(annotationEl);
                        selectorXPath.setAnnotation(annotation);
                    }
                    constraint.selector = selectorXPath;
                } else if (el.getLocalName().equals("field")) {
                    XmlSchemaXPath fieldXPath = new XmlSchemaXPath();
                    fieldXPath.xpath = el.getAttribute("xpath");
                    constraint.fields.add(fieldXPath);
                    annotationEl = DOMUtil.getFirstChildElementNS(el, "http://www.w3.org/2001/XMLSchema", "annotation");
                    if (annotationEl != null) {
                        annotation = this.handleAnnotation(annotationEl);
                        fieldXPath.setAnnotation(annotation);
                    }
                } else if (el.getLocalName().equals("annotation")) {
                    XmlSchemaAnnotation constraintAnnotation = this.handleAnnotation(el);
                    constraint.setAnnotation(constraintAnnotation);
                }
                el = XDOMUtil.getNextSiblingElementNS((Node)el, "http://www.w3.org/2001/XMLSchema");
            }
            return constraint;
        }
        catch (ClassNotFoundException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new XmlSchemaException(e.getMessage());
        }
    }

    XmlSchemaImport handleImport(XmlSchema schema, Element importEl, Element schemaEl) {
        XmlSchemaImport schemaImport = new XmlSchemaImport();
        Element annotationEl = DOMUtil.getFirstChildElementNS(importEl, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (annotationEl != null) {
            XmlSchemaAnnotation importAnnotation = this.handleAnnotation(annotationEl);
            schemaImport.setAnnotation(importAnnotation);
        }
        schemaImport.namespace = importEl.getAttribute("namespace");
        schemaImport.schemaLocation = importEl.getAttribute("schemaLocation");
        if (schemaImport.schemaLocation != null && !schemaImport.schemaLocation.equals("")) {
            schemaImport.schema = schema.getSourceURI() != null ? this.resolveXmlSchema(schemaImport.namespace, schemaImport.schemaLocation, schema.getSourceURI()) : this.resolveXmlSchema(schemaImport.namespace, schemaImport.schemaLocation);
        }
        return schemaImport;
    }

    XmlSchemaInclude handleInclude(XmlSchema schema, Element includeEl, Element schemaEl) {
        XmlSchemaInclude include = new XmlSchemaInclude();
        Element annotationEl = DOMUtil.getFirstChildElementNS(includeEl, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (annotationEl != null) {
            XmlSchemaAnnotation includeAnnotation = this.handleAnnotation(annotationEl);
            include.setAnnotation(includeAnnotation);
        }
        include.schemaLocation = includeEl.getAttribute("schemaLocation");
        include.schema = schema.getSourceURI() != null ? this.resolveXmlSchema(null, include.schemaLocation, schema.getSourceURI()) : this.resolveXmlSchema(null, include.schemaLocation);
        XmlSchemaObjectCollection coll = include.schema.getItems();
        return include;
    }

    XmlSchemaAnnotation handleAnnotation(Element annotEl) {
        XmlSchemaObjectCollection content = new XmlSchemaObjectCollection();
        Element appinfo = DOMUtil.getFirstChildElementNS(annotEl, "http://www.w3.org/2001/XMLSchema", "appinfo");
        while (appinfo != null) {
            XmlSchemaAppInfo appInfoObj = this.handleAppInfo(appinfo);
            content.add(appInfoObj);
            appinfo = DOMUtil.getNextSiblingElementNS(appinfo, "http://www.w3.org/2001/XMLSchema", "appinfo");
        }
        Element documentation = DOMUtil.getFirstChildElementNS(annotEl, "http://www.w3.org/2001/XMLSchema", "documentation");
        while (documentation != null) {
            XmlSchemaDocumentation docsObj = this.handleDocumentation(documentation);
            content.add(docsObj);
            documentation = DOMUtil.getNextSiblingElementNS(documentation, "http://www.w3.org/2001/XMLSchema", "documentation");
        }
        XmlSchemaAnnotation annotation = new XmlSchemaAnnotation();
        annotation.items = content;
        return annotation;
    }

    XmlSchemaAppInfo handleAppInfo(Element content) {
        XmlSchemaAppInfo appInfo = new XmlSchemaAppInfo();
        NodeList markup = this.getChild(content);
        if (!content.hasAttribute("source") && markup.getLength() <= 0) {
            return null;
        }
        appInfo.setSource(this.getAttribute(content, "source"));
        appInfo.setMarkup(markup);
        return appInfo;
    }

    XmlSchemaDocumentation handleDocumentation(Element content) {
        XmlSchemaDocumentation documentation = new XmlSchemaDocumentation();
        NodeList markup = this.getChild(content);
        if (!(content.hasAttribute("source") || content.hasAttribute("xml:lang") || markup != null && markup.getLength() > 0)) {
            return null;
        }
        documentation.setSource(this.getAttribute(content, "source"));
        documentation.setLanguage(this.getAttribute(content, "xml:lang"));
        documentation.setMarkup(this.getChild(content));
        return documentation;
    }

    private String getAttribute(Element content, String attrName) {
        if (content.hasAttribute(attrName)) {
            return content.getAttribute(attrName);
        }
        return null;
    }

    private NodeList getChild(Element content) {
        NodeList childs = content.getChildNodes();
        if (childs.getLength() > 0) {
            return childs;
        }
        return null;
    }

    long getMinOccurs(Element el) {
        try {
            if (el.getAttributeNode("minOccurs") != null) {
                String value = el.getAttribute("minOccurs");
                if (value.equals("unbounded")) {
                    return Long.MAX_VALUE;
                }
                return new Long(value);
            }
            return 1L;
        }
        catch (NumberFormatException e) {
            return 1L;
        }
    }

    long getMaxOccurs(Element el) {
        try {
            if (el.getAttributeNode("maxOccurs") != null) {
                String value = el.getAttribute("maxOccurs");
                if (value.equals("unbounded")) {
                    return Long.MAX_VALUE;
                }
                return new Long(value);
            }
            return 1L;
        }
        catch (NumberFormatException e) {
            return 1L;
        }
    }

    XmlSchemaForm getFormDefault(Element el, String attrName) {
        if (el.getAttributeNode(attrName) != null) {
            String value = el.getAttribute(attrName);
            return new XmlSchemaForm(value);
        }
        return new XmlSchemaForm("unqualified");
    }

    XmlSchemaDerivationMethod getDerivation(Element el, String attrName) {
        if (el.hasAttribute(attrName) && !el.getAttribute(attrName).equals("")) {
            String derivationMethod = el.getAttribute(attrName).trim();
            if (derivationMethod.equals("#all")) {
                return new XmlSchemaDerivationMethod("all");
            }
            return new XmlSchemaDerivationMethod(derivationMethod);
        }
        return new XmlSchemaDerivationMethod("none");
    }

    String getEnumString(Element el, String attrName) {
        if (el.hasAttribute(attrName)) {
            return el.getAttribute(attrName).trim();
        }
        return "none";
    }

    XmlSchema resolveXmlSchema(String targetNamespace, String schemaLocation, String baseUri) {
        try {
            return this.collection.read(this.collection.schemaResolver.resolveEntity(targetNamespace, schemaLocation, baseUri), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    XmlSchema resolveXmlSchema(String targetNamespace, String schemaLocation) {
        return this.resolveXmlSchema(targetNamespace, schemaLocation, this.collection.baseUri);
    }
}

