/*
 * Copyright (C) 2007 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import java.net.MalformedURLException;
import java.net.URL;

import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;

/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: LocalPageHyperlinkProducerFactory.java 6837 2007-02-23 13:43:23Z lucian $
 */
public class JExcelApiHyperlinkProducerFactory extends JRHyperlinkProducerFactory
{
	public static final JExcelApiHyperlinkProducerFactory INSTANCE = new JExcelApiHyperlinkProducerFactory();

	private static final JRHyperlinkProducer PRODUCER =
		new JRHyperlinkProducer()
		{
			public String getHyperlink(JRPrintHyperlink link) 
			{
				String href = null;
	
				if (link.getHyperlinkType() == JRHyperlink.HYPERLINK_TYPE_REFERENCE)
				{
					href = link.getHyperlinkReference();
					if (href != null)
					{
						try
						{
							URL url = new URL(href);
						}
						catch (MalformedURLException e)
						{
							href = null;
						}
					}
				}
				
				return href;
			}
		};
	
	private JExcelApiHyperlinkProducerFactory()
	{
	}
	
	public JRHyperlinkProducer getHandler(String arg0) 
	{
		return PRODUCER;
	}

}
