/*
* Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved. 
* http://www.jaspersoft.com.
*
* Unless you have purchased a commercial license agreement from JasperSoft,
* the following license terms apply:
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as published by
* the Free Software Foundation.
*
* This program is distributed WITHOUT ANY WARRANTY; and without the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
* or write to:
*
* Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330,
* Boston, MA  USA  02111-1307
*/
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRJdbcQueryExecuter;

import org.quartz.TriggerUtils;

/**
 * @author Ionut Nedelcu (ionutned@users.sourceforge.net)
 * @version $Id
 */
public class JRTimezoneJdbcQueryExecuter extends JRJdbcQueryExecuter
{
	private static InheritableThreadLocal parentTimezone = new InheritableThreadLocal();

	public JRTimezoneJdbcQueryExecuter(JRDataset dataset, Map map)
	{
		super(dataset, map);
		TimeZone timezone = (TimeZone) getValueParameter(JRTimezoneJdbcQueryExecuterFactory.PARAMETER_TIMEZONE).getValue();
		if (timezone != null) {
			parentTimezone.set(timezone);
		}
	}


	protected JRValueParameter getValueParameter(String parameterName)
	{
		JRValueParameter param = super.getValueParameter(parameterName);

		if (param.getValue() instanceof Date)
		{
			TimeZone timezone = (TimeZone) parentTimezone.get();
			if (timezone != null) {
				Date initialDate = (Date) param.getValue();
				Date date = TriggerUtils.translateTime(initialDate, timezone, TimeZone.getTimeZone("GMT"));
				initialDate.setTime(date.getTime());
				return new JRBaseValueParameter(param, initialDate);
			}
		}
		return param;
	}

	public JRDataSource createDatasource() throws JRException
	{
		JRDataSource dataSource = super.createDatasource();
		TimeZone timezone = (TimeZone) parentTimezone.get();
		return new JRTimezoneResultSetDataSource(dataSource, timezone);
	}

}
