/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorsImpl;
import com.jaspersoft.jasperserver.api.common.service.ServletContextInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceValidator;
import com.jaspersoft.jasperserver.api.metadata.common.util.ValidationUtil;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;

/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: ResourceFactoryImpl.java 8408 2007-05-29 23:29:12Z melih $
 */
public class ReportUnitValidator implements ResourceValidator
{

	/**
	 * 
	 */
	private RepositoryService repository;
	private ServletContextInformation servletContextInformation;

	
	/**
	 * 
	 */
	public RepositoryService getRepositoryService() 
	{
		return repository;
	}

	
	/**
	 * 
	 */
	public void setRepositoryService(RepositoryService repository) 
	{
		this.repository = repository;
	}

	
	/**
	 * 
	 */
	public ServletContextInformation getServletContextInformation() 
	{
		return servletContextInformation;
	}

	
	/**
	 * 
	 */
	public void setServletContextInformation(ServletContextInformation servletContextInformation) 
	{
		this.servletContextInformation = servletContextInformation;
	}

	
	/**
	 * 
	 */
	public ValidationErrors validate(Resource resource, ValidationErrorFilter filter)
	{
		ValidationErrors errors = new ValidationErrorsImpl();
		ReportUnit report = (ReportUnit)resource;
		
		validateLabel(report, filter, errors);
		validateName(report, filter, errors);
		validateDescription(report, filter, errors);
		validateInputControlView(report, filter, errors);
		validateRenderingView(report, filter, errors);
		
		return errors;
	}

	
	private void validateLabel(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors)
	{
		if (filter == null || filter.matchErrorField("reportUnit.label"))
		{
			if (report.getLabel() == null || report.getLabel().trim().length() == 0) 
			{
				errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.not.empty", null, null, "reportUnit.label"));
			}
			else 
			{
				if (report.getLabel().length() > 100) 
				{
					errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.label"));
				}
			}
		}
	}


	private void validateName(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors)
	{
		if (filter == null || filter.matchErrorField("reportUnit.name"))
		{
			if (report.getName() == null || report.getName().trim().length() == 0) 
			{
				errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.not.empty", null, null, "reportUnit.name"));
			}
			else 
			{
				if (report.getName().length() > 100) 
				{
					errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.name"));
				}
				else if (!ValidationUtil.regExValidateName(report.getName()))
				{
					errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.invalid.chars", null, null, "reportUnit.name"));
				}
				else 
				{
//					if (ruWrapper.isNewMode()
//							&& ruWrapper.getExistingResources() != null) {
//						List res = ruWrapper.getExistingResources();
//						for (int i = 0; i < res.size(); i++) {
//							String preExtName = (String) res.get(i);
//							if (preExtName.equalsIgnoreCase(ru.getName().trim())) {
//								errors.rejectValue("reportUnit.name", "ReportDetailsValidator.error.duplicate");
//								break;
//							}
//						}
//					}

//					if (ruWrapper.isAloneNewMode()) 
					if (filter != null && filter.matchErrorCode("ReportDetailsValidator.error.duplicate")) 
					{
						if (getRepositoryService().repositoryPathExists(null, report.getURIString())) 
						{
							errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.duplicate", null, null, "reportUnit.name"));
						}
					}

				}
			}
		}
	}


	private void validateDescription(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors)
	{
		if (filter == null || filter.matchErrorField("reportUnit.description"))
		{
			if (report.getDescription() != null && report.getDescription().length() > 250)
			{
				errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.description"));
			}
		}
	}


	private void validateInputControlView(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) 
	{
		if (filter == null || filter.matchErrorField("reportUnit.inputControlRenderingView"))
		{
			String inputControlView = report.getInputControlRenderingView();
			if (inputControlView != null && inputControlView.length() > 0) 
			{
				if (inputControlView.length() > 100) 
				{
					errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.inputControlRenderingView"));
				}
				else if (!getServletContextInformation().jspExists(inputControlView)) 
				{
					errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.inexisting.jsp", null, null, "reportUnit.inputControlRenderingView"));
				}
			}
		}
	}


	private void validateRenderingView(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) 
	{
		if (filter == null || filter.matchErrorField("reportUnit.reportRenderingView"))
		{
			String reportRenderingView = report.getReportRenderingView();
			if (reportRenderingView != null && reportRenderingView.length() > 0) 
			{
				if (reportRenderingView.length() > 100) 
				{
					errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.reportRenderingView"));
				}
				else if (!getServletContextInformation().jspExists(reportRenderingView)) 
				{
					errors.add(new ValidationErrorImpl("ReportDetailsValidator.error.inexisting.jsp", null, null, "reportUnit.reportRenderingView"));
				}
			}
		}
	}

}
