/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;


/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: RepoFolder.java 8430 2007-05-30 13:18:32Z lucian $
 * 
 * @disabled_hibernate.class table="resource_folder"
 */
public class RepoFolder extends RepoResourceBase {
	
	private String uri;
	private boolean hidden;
	
	private Set children;
	private Set subFolders;
	
	public RepoFolder() {
		children = new HashSet();
	}

	/**
	 * @hibernate.property
	 * 		column="uri" type="string" length="200" not-null="true" unique="true"
	 */
	public String getURI()
	{
		return uri;
	}
	
	public void setURI(String newURIString)
	{
		uri = newURIString;
	}
	
	public void set(Folder folder, RepoFolder parent) {
		setName(folder.getName());
		setLabel(folder.getLabel());
		setDescription(folder.getDescription());
		setParent(parent);
		setHidden(false);
		setURI();
	}

	public void setURI() {
		setURI(getResourceURI());
	}

	public String getResourceURI() {
		if (parent == null && Folder.SEPARATOR.equals(name)) {
			return Folder.SEPARATOR;
		}

		return super.getResourceURI();
	}
	
	protected Class getClientItf() {
		return Folder.class;
	}

	/**
	 * @hibernate.set inverse="true" cascade="save-update,delete,delete-orphan"
	 * @hibernate.key column="parent_folder"
	 * @hibernate.one-to-many class="com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource"
	 */
	public Set getChildren() {
		return children;
	}

	public void setChildren(Set children) {
		this.children = children;
	}
	
	public void addChild(RepoResource resource) {
		resource.setParent(this);
		children.add(resource);
	}
	
	public boolean removeChild(RepoResource resource) {
		return children.remove(resource);
	}


	/**
	 * @hibernate.set inverse="true" cascade="delete"
	 * @hibernate.key column="parent_folder"
	 * @hibernate.one-to-many class="com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder"
	 */
	public Set getSubFolders() {
		return subFolders;
	}

	public void setSubFolders(Set subFolders) {
		this.subFolders = subFolders;
	}

	protected void filterChildren(Set newChildren) {
		if (newChildren == null) {
			children.clear();
		}
		else {
			for (Iterator it = children.iterator(); it.hasNext();) {
				RepoResource res = (RepoResource) it.next();
				if (!newChildren.contains(res)) {
					it.remove();
				}
			}
		}
	}

	/**
	 * @hibernate.property column="hidden" type="boolean"
	 */
	public boolean isHidden() {
		return hidden;
	}

	public void setHidden(boolean hidden) {
		this.hidden = hidden;
	}
	
	public boolean isRoot() {
		return getURI().equals(Folder.SEPARATOR);
	}
	
	public Folder toClient() {
		Folder folder = new FolderImpl();
		copyTo(folder);
		return folder;
	}
	
	protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
		throw new JSException("jsexception.resource.copyTo.not.implemented");
	}
	
	protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
		throw new JSException("jsexception.resource.copyFrom.not.implemented");
	}

	public boolean equals(Object obj) {
		if (!(obj instanceof RepoFolder)) {
			return false;
		}
		if (this == obj) {
			return true;
		}
		if (isNew()) {
			return false;
		}
		RepoFolder res = (RepoFolder) obj;
		return new EqualsBuilder().append(getId(), res.getId()).isEquals();
	}

	public int hashCode() {
		if (isNew()) {
			return super.hashCode();
		}
		return new HashCodeBuilder().append(getId()).toHashCode();
	}

	public String toString() {
		return getURI();
	}

}
